/*
 *  Copyright (c) 2004-2012 Gert Wollny <gw.fossdev@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  As an exception to this license, "NEC C&C Research Labs" may use
 *  this software under the terms of the GNU Lesser General Public License as
 *  published by the Free Software Foundation.
 *
 */

#ifndef __xmlio_h
#define __xmlio_h


#include <mialm/defines.h>
#include <libxml/parser.h>
#include <glib.h>

#define SAX_START   0

typedef struct _ParserState ParserState;

typedef struct _ParserStateStack ParserStateStack;

typedef void (*tag_start_callback) (ParserState * user_data,
				    const xmlChar ** attrs);
typedef void (*tag_ch_callback) (ParserState * user_data, const xmlChar * ch,
				 int len);
typedef void (*tag_end_callback) (ParserState * user_data, const gchar *property);


typedef struct _ParserTags ParserTags;
struct _ParserTags
{
	const gchar *tag_name;
	tag_start_callback start_callback;
	tag_ch_callback ch_callback;
	tag_end_callback end_callback;
	const ParserTags *parser_tags;
};

#define END_PARSER_TAGS {0,0,0,0,0}

struct _ParserState
{
	ParserStateStack *pss;
	gpointer data;
};

struct _ParserStateStack
{
	ParserStateStack *parent;
	gint tag_id;
	gint unknown_depth;
	GString *property;
	tag_ch_callback ch_callback;
	tag_end_callback end_callback;
	gint n_parser_tags;
	const ParserTags *parser_tags;
	GString *ch;
	gpointer data;
};

G_BEGIN_DECLS

void 
xmlio_end_string(ParserState * state, const gchar *property);

void xmlio_end_float(ParserState * state, const gchar *property);

void xmlio_get_string (ParserState * state, const xmlChar * ch,
		       int len);

void 
xmlio_end_vector_property(ParserState * state, const gchar *property);

void 
xmlio_end_quaternion_property(ParserState * state, const gchar *property);

gboolean
xml_write_float (xmlNodePtr root, xmlNsPtr ns, const gchar * tag, gfloat f);


int 
xml_sax_parse (const gchar * filename, const ParserTags * tags,
	       gpointer pdata);

G_END_DECLS

#endif


