/* NBD client library in userspace
 * WARNING: THIS FILE IS GENERATED FROM
 * generator/generator generator/states*.c
 * ANY CHANGES YOU MAKE TO THIS FILE WILL BE LOST.
 *
 * Copyright (C) 2013-2020 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#line 1 "generator/states-connect-socket-activation.c"
/* nbd client library in userspace: state machine
 * Copyright (C) 2013-2019 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* State machine related to connecting with systemd socket activation. */

#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <assert.h>
#include <sys/socket.h>
#include <sys/un.h>

#include "internal.h"

/* This is baked into the systemd socket activation API. */
#define FIRST_SOCKET_ACTIVATION_FD 3

/* == strlen ("LISTEN_PID=") | strlen ("LISTEN_FDS=") */
#define PREFIX_LENGTH 11

extern char **environ;

/* Prepare environment for calling execvp when doing systemd socket
 * activation.  Takes the current environment and copies it.  Removes
 * any existing LISTEN_PID or LISTEN_FDS and replaces them with new
 * variables.  env[0] is "LISTEN_PID=..." which is filled in by
 * CONNECT_SA.START, and env[1] is "LISTEN_FDS=1".
 */
static int
prepare_socket_activation_environment (string_vector *env)
{
  char *p;
  size_t i;

  assert (env->size == 0);

  /* Reserve slots env[0] and env[1]. */
  p = strdup ("LISTEN_PID=xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
  if (p == NULL)
    goto err;
  if (string_vector_append (env, p) == -1) {
    free (p);
    goto err;
  }
  p = strdup ("LISTEN_FDS=1");
  if (p == NULL)
    goto err;
  if (string_vector_append (env, p) == -1) {
    free (p);
    goto err;
  }

  /* Append the current environment, but remove LISTEN_PID, LISTEN_FDS. */
  for (i = 0; environ[i] != NULL; ++i) {
    if (strncmp (environ[i], "LISTEN_PID=", PREFIX_LENGTH) != 0 &&
        strncmp (environ[i], "LISTEN_FDS=", PREFIX_LENGTH) != 0) {
      char *copy = strdup (environ[i]);
      if (copy == NULL)
        goto err;
      if (string_vector_append (env, copy) == -1) {
        free (copy);
        goto err;
      }
    }
  }

  /* The environ must be NULL-terminated. */
  if (string_vector_append (env, NULL) == -1)
    goto err;

  return 0;

 err:
  set_error (errno, "malloc");
  return -1;
}


#line 1 "generator/states-connect.c"
/* nbd client library in userspace: state machine
 * Copyright (C) 2013-2019 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* State machines related to connecting to the server. */

#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <inttypes.h>
#include <stdbool.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <sys/types.h>
#include <sys/socket.h>

/* Disable Nagle's algorithm on the socket, but don't fail. */
static void
disable_nagle (int sock)
{
  const int flag = 1;

  setsockopt (sock, IPPROTO_TCP, TCP_NODELAY, &flag, sizeof flag);
}


#line 1 "generator/states-issue-command.c"
/* nbd client library in userspace: state machine
 * Copyright (C) 2013-2020 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* State machine for issuing commands (requests) to the server. */


#line 1 "generator/states-magic.c"
/* nbd client library in userspace: state machine
 * Copyright (C) 2013-2020 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* State machine for parsing the initial magic number from the server. */


#line 1 "generator/states-newstyle-opt-export-name.c"
/* nbd client library in userspace: state machine
 * Copyright (C) 2013-2020 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* State machine for ending newstyle handshake with NBD_OPT_EXPORT_NAME. */


#line 1 "generator/states-newstyle-opt-go.c"
/* nbd client library in userspace: state machine
 * Copyright (C) 2013-2020 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* State machine for ending fixed newstyle handshake with NBD_OPT_GO. */


#line 1 "generator/states-newstyle-opt-list.c"
/* nbd client library in userspace: state machine
 * Copyright (C) 2013-2020 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* State machine for sending NBD_OPT_LIST to list exports.
 *
 * This is only reached via nbd_opt_list during opt_mode.
 */


#line 1 "generator/states-newstyle-opt-meta-context.c"
/* nbd client library in userspace: state machine
 * Copyright (C) 2013-2020 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* State machine for negotiating NBD_OPT_SET/LIST_META_CONTEXT. */


#line 1 "generator/states-newstyle-opt-starttls.c"
/* nbd client library in userspace: state machine
 * Copyright (C) 2013-2020 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* State machine for sending NBD_OPT_STARTTLS. */


#line 1 "generator/states-newstyle-opt-structured-reply.c"
/* nbd client library in userspace: state machine
 * Copyright (C) 2013-2020 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* State machine for negotiating NBD_OPT_STRUCTURED_REPLY. */


#line 1 "generator/states-newstyle.c"
/* nbd client library in userspace: state machine
 * Copyright (C) 2013-2020 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <assert.h>

#include "internal.h"

/* Common code for parsing a reply to NBD_OPT_*. */
static int
prepare_for_reply_payload (struct nbd_handle *h, uint32_t opt)
{
  const size_t maxpayload = sizeof h->sbuf.or.payload;
  uint64_t magic;
  uint32_t option;
  uint32_t reply;
  uint32_t len;

  magic = be64toh (h->sbuf.or.option_reply.magic);
  option = be32toh (h->sbuf.or.option_reply.option);
  reply = be32toh (h->sbuf.or.option_reply.reply);
  len = be32toh (h->sbuf.or.option_reply.replylen);
  if (magic != NBD_REP_MAGIC || option != opt) {
    set_error (0, "handshake: invalid option reply magic or option");
    return -1;
  }

  /* Validate lengths that the state machine depends on. */
  switch (reply) {
  case NBD_REP_ACK:
    if (len != 0) {
      set_error (0, "handshake: invalid NBD_REP_ACK option reply length");
      return -1;
    }
    break;
  case NBD_REP_INFO:
    /* Can't enforce an upper bound, thanks to unknown INFOs */
    if (len < sizeof h->sbuf.or.payload.export.info) {
      set_error (0, "handshake: NBD_REP_INFO reply length too small");
      return -1;
    }
    break;
  case NBD_REP_META_CONTEXT:
    if (len <= sizeof h->sbuf.or.payload.context.context ||
        len > sizeof h->sbuf.or.payload.context) {
      set_error (0, "handshake: invalid NBD_REP_META_CONTEXT reply length");
      return -1;
    }
    break;
  }

  /* Read the following payload if it is short enough to fit in the
   * static buffer.  If it's too long, skip it.
   */
  len = be32toh (h->sbuf.or.option_reply.replylen);
  if (len > MAX_REQUEST_SIZE) {
    set_error (0, "handshake: invalid option reply length");
    return -1;
  }
  else if (len <= maxpayload)
    h->rbuf = &h->sbuf.or.payload;
  else
    h->rbuf = NULL;
  h->rlen = len;
  return 0;
}

/* Check an unexpected server reply. If it is an error, log any
 * message from the server and return 0; otherwise, return -1.
 */
static int
handle_reply_error (struct nbd_handle *h)
{
  uint32_t len;
  uint32_t reply;

  len = be32toh (h->sbuf.or.option_reply.replylen);
  reply = be32toh (h->sbuf.or.option_reply.reply);
  if (!NBD_REP_IS_ERR (reply)) {
    set_error (0, "handshake: unexpected option reply type %d", reply);
    return -1;
  }

  assert (NBD_MAX_STRING < sizeof h->sbuf.or.payload);
  if (len > NBD_MAX_STRING) {
    set_error (0, "handshake: option error string too long");
    return -1;
  }

  if (len > 0)
    debug (h, "handshake: server error message: %.*s", (int) len,
           h->sbuf.or.payload.err_msg);

  return 0;
}

/* State machine for parsing the fixed newstyle handshake. */


#line 1 "generator/states-oldstyle.c"
/* nbd client library in userspace: state machine
 * Copyright (C) 2013-2019 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* State machine for parsing the oldstyle handshake. */


#line 1 "generator/states-reply-simple.c"
/* nbd client library in userspace: state machine
 * Copyright (C) 2013-2019 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* State machine for parsing simple replies from the server. */


#line 1 "generator/states-reply-structured.c"
/* nbd client library in userspace: state machine
 * Copyright (C) 2013-2019 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* State machine for parsing structured replies from the server. */

#include <stdbool.h>
#include <stdint.h>
#include <inttypes.h>

/* Structured reply must be completely inside the bounds of the
 * requesting command.
 */
static bool
structured_reply_in_bounds (uint64_t offset, uint32_t length,
                            const struct command *cmd)
{
  if (offset < cmd->offset ||
      offset >= cmd->offset + cmd->count ||
      offset + length > cmd->offset + cmd->count) {
    set_error (0, "range of structured reply is out of bounds, "
               "offset=%" PRIu64 ", cmd->offset=%" PRIu64 ", "
               "length=%" PRIu32 ", cmd->count=%" PRIu32 ": "
               "this is likely to be a bug in the NBD server",
               offset, cmd->offset, length, cmd->count);
    return false;
  }

  return true;
}


#line 1 "generator/states-reply.c"
/* nbd client library in userspace: state machine
 * Copyright (C) 2013-2019 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <assert.h>

/* State machine for receiving reply messages from the server.
 *
 * Note that we never block while in this sub-group. If there is
 * insufficient data to finish parsing a reply, requiring us to block
 * until POLLIN, we instead track where in the state machine we left
 * off, then return to READY to actually block. Then, on entry to
 * REPLY.START, we can tell if this is the start of a new reply (rlen
 * is 0, stay put), a continuation of the preamble (reply_cmd is NULL,
 * resume with RECV_REPLY), or a continuation from any other location
 * (reply_cmd contains the state to jump to).
 */

static void
save_reply_state (struct nbd_handle *h)
{
  assert (h->reply_cmd);
  assert (h->rlen);
  h->reply_cmd->state = get_next_state (h);
}


#line 1 "generator/states.c"
/* nbd client library in userspace: state machine
 * Copyright (C) 2013-2020 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* This isn't "real" C code.  It is read by the generator, parsed, and
 * put into generated files.  Also it won't make much sense unless you
 * read the generator state machine and documentation in
 * generator/generator first.
 */

#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <inttypes.h>
#include <stdbool.h>
#include <string.h>
#include <unistd.h>
#include <assert.h>

#include "internal.h"

/* Uncomment this to dump received protocol packets to stderr. */
/*#define DUMP_PACKETS 1*/

static int
recv_into_rbuf (struct nbd_handle *h)
{
  ssize_t r;
  char buf[BUFSIZ];
  void *rbuf;
  size_t rlen;

  if (h->rlen == 0)
    return 0;                   /* move to next state */

  /* As a special case h->rbuf is allowed to be NULL, meaning
   * throw away the data.
   */
  if (h->rbuf) {
    rbuf = h->rbuf;
    rlen = h->rlen;
  }
  else {
    rbuf = &buf;
    rlen = h->rlen > sizeof buf ? sizeof buf : h->rlen;
  }

  r = h->sock->ops->recv (h, h->sock, rbuf, rlen);
  if (r == -1) {
    if (errno == EAGAIN || errno == EWOULDBLOCK)
      return 1;                 /* more data */
    /* sock->ops->recv called set_error already. */
    return -1;
  }
  if (r == 0) {
    set_error (0, "recv: server disconnected unexpectedly");
    return -1;
  }
#ifdef DUMP_PACKETS
  if (h->rbuf != NULL)
    nbd_internal_hexdump (h->rbuf, r, stderr);
#endif
  if (h->rbuf)
    h->rbuf += r;
  h->rlen -= r;
  if (h->rlen == 0)
    return 0;                   /* move to next state */
  else
    return 1;                   /* more data */
}

static int
send_from_wbuf (struct nbd_handle *h)
{
  ssize_t r;

  if (h->wlen == 0)
    goto next_state;
  r = h->sock->ops->send (h, h->sock, h->wbuf, h->wlen, h->wflags);
  if (r == -1) {
    if (errno == EAGAIN || errno == EWOULDBLOCK)
      return 1;                 /* more data */
    /* sock->ops->send called set_error already. */
    return -1;
  }
  h->wbuf += r;
  h->wlen -= r;
  if (h->wlen == 0)
    goto next_state;
  else
    return 1;                   /* more data */

 next_state:
  h->wflags = 0;                /* reset this when moving to next state */
  return 0;                     /* move to next state */
}

/* Forcefully fail any in-flight option */
static void
abort_option (struct nbd_handle *h)
{
  int err = nbd_get_errno () ? : ENOTCONN;

  CALL_CALLBACK (h->opt_cb.completion, &err);
  nbd_internal_free_option(h);
}

/* Forcefully fail any remaining in-flight commands in list */
void
nbd_internal_abort_commands (struct nbd_handle *h, struct command **list)
{
  struct command *next, *cmd;

  for (cmd = *list, *list = NULL; cmd != NULL; cmd = next) {
    bool retire = cmd->type == NBD_CMD_DISC;

    next = cmd->next;
    if (CALLBACK_IS_NOT_NULL (cmd->cb.completion)) {
      int error = cmd->error ? cmd->error : ENOTCONN;
      int r;

      assert (cmd->type != NBD_CMD_DISC);
      r = CALL_CALLBACK (cmd->cb.completion, &error);
      switch (r) {
      case -1:
        if (error)
          cmd->error = error;
        break;
      case 1:
        retire = true;
        break;
      }
    }
    if (cmd->error == 0)
      cmd->error = ENOTCONN;
    if (retire)
      nbd_internal_retire_and_free_command (cmd);
    else {
      cmd->next = NULL;
      if (h->cmds_done_tail)
        h->cmds_done_tail->next = cmd;
      else {
        assert (h->cmds_done == NULL);
        h->cmds_done = cmd;
      }
      h->cmds_done_tail = cmd;
    }
  }
}




#define SET_NEXT_STATE(s) (*blocked = false, *next_state = (s))
#define SET_NEXT_STATE_AND_BLOCK(s) (*next_state = (s))

/* START: Handle after being initially created */
static int
enter_STATE_START (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
  return 0;
}

int
nbd_internal_enter_STATE_START (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_START;

  r = enter_STATE_START (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "START",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* CONNECT.START: Initial call to connect(2) on the socket */
static int
enter_STATE_CONNECT_START (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 49 "generator/states-connect.c"

  sa_family_t family;
  int fd, r;

  assert (!h->sock);
  family = h->connaddr.ss_family;
  fd = socket (family, SOCK_STREAM|SOCK_NONBLOCK|SOCK_CLOEXEC, 0);
  if (fd == -1) {
    SET_NEXT_STATE (STATE_DEAD);
    set_error (errno, "socket");
    return 0;
  }
  h->sock = nbd_internal_socket_create (fd);
  if (!h->sock) {
    SET_NEXT_STATE (STATE_DEAD);
    return 0;
  }

  disable_nagle (fd);

  r = connect (fd, (struct sockaddr *) &h->connaddr, h->connaddrlen);
  if (r == 0 || (r == -1 && errno == EINPROGRESS))
    return 0;
  assert (r == -1);
#ifdef __linux__
  if (errno == EAGAIN && family == AF_UNIX) {
    /* This can happen on Linux when connecting to a Unix domain
     * socket, if the server's backlog is full.  Unfortunately there
     * is nothing good we can do on the client side when this happens
     * since any solution would involve sleeping or busy-waiting.  The
     * only solution is on the server side, increasing the backlog.
     * But at least improve the error message.
     * https://bugzilla.redhat.com/1925045
     */
    SET_NEXT_STATE (STATE_DEAD);
    set_error (errno, "connect: server backlog overflowed, "
               "see https://bugzilla.redhat.com/1925045");
    return 0;
  }
#endif
  SET_NEXT_STATE (STATE_DEAD);
  set_error (errno, "connect");
  return 0;

}

int
nbd_internal_enter_STATE_CONNECT_START (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_CONNECT_START;

  r = enter_STATE_CONNECT_START (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "CONNECT.START",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* CONNECT.CONNECTING: Connecting to the remote server */
static int
enter_STATE_CONNECT_CONNECTING (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 93 "generator/states-connect.c"

  int status;
  socklen_t len = sizeof status;

  if (getsockopt (h->sock->ops->get_fd (h->sock),
                  SOL_SOCKET, SO_ERROR, &status, &len) == -1) {
    SET_NEXT_STATE (STATE_DEAD);
    set_error (errno, "getsockopt: SO_ERROR");
    return 0;
  }
  /* This checks the status of the original connect call. */
  if (status == 0) {
    SET_NEXT_STATE (STATE_MAGIC_START);
    return 0;
  }
  else {
    SET_NEXT_STATE (STATE_DEAD);
    set_error (status, "connect");
    return 0;
  }

}

int
nbd_internal_enter_STATE_CONNECT_CONNECTING (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_CONNECT_CONNECTING;

  r = enter_STATE_CONNECT_CONNECTING (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "CONNECT.CONNECTING",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* CONNECT_TCP.START: Connect to a remote TCP server */
static int
enter_STATE_CONNECT_TCP_START (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 114 "generator/states-connect.c"

  int r;

  assert (h->hostname != NULL);
  assert (h->port != NULL);

  if (h->result) {
    freeaddrinfo (h->result);
    h->result = NULL;
  }

  h->connect_errno = 0;

  memset (&h->hints, 0, sizeof h->hints);
  h->hints.ai_family = AF_UNSPEC;
  h->hints.ai_socktype = SOCK_STREAM;
  h->hints.ai_flags = 0;
  h->hints.ai_protocol = 0;

  /* XXX Unfortunately getaddrinfo blocks.  getaddrinfo_a isn't
   * portable and in any case isn't an alternative because it can't be
   * integrated into a main loop.
   */
  r = getaddrinfo (h->hostname, h->port, &h->hints, &h->result);
  if (r != 0) {
    SET_NEXT_STATE (STATE_START);
    set_error (0, "getaddrinfo: %s:%s: %s",
               h->hostname, h->port, gai_strerror (r));
    return -1;
  }

  h->rp = h->result;
  SET_NEXT_STATE (STATE_CONNECT_TCP_CONNECT);
  return 0;

}

int
nbd_internal_enter_STATE_CONNECT_TCP_START (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_CONNECT_TCP_START;

  r = enter_STATE_CONNECT_TCP_START (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "CONNECT_TCP.START",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* CONNECT_TCP.CONNECT: Initial call to connect(2) on a TCP socket */
static int
enter_STATE_CONNECT_TCP_CONNECT (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 149 "generator/states-connect.c"

  int fd;

  assert (!h->sock);

  if (h->rp == NULL) {
    /* We tried all the results from getaddrinfo without success.
     * Save errno from most recent connect(2) call. XXX
     */
    SET_NEXT_STATE (STATE_START);
    set_error (h->connect_errno,
               "connect: %s:%s: could not connect to remote host",
               h->hostname, h->port);
    return -1;
  }

  fd = socket (h->rp->ai_family,
               h->rp->ai_socktype|SOCK_NONBLOCK|SOCK_CLOEXEC,
               h->rp->ai_protocol);
  if (fd == -1) {
    SET_NEXT_STATE (STATE_CONNECT_TCP_NEXT_ADDRESS);
    return 0;
  }
  h->sock = nbd_internal_socket_create (fd);
  if (!h->sock) {
    SET_NEXT_STATE (STATE_DEAD);
    return 0;
  }

  disable_nagle (fd);

  if (connect (fd, h->rp->ai_addr, h->rp->ai_addrlen) == -1) {
    if (errno != EINPROGRESS) {
      if (h->connect_errno == 0)
        h->connect_errno = errno;
      SET_NEXT_STATE (STATE_CONNECT_TCP_NEXT_ADDRESS);
      return 0;
    }
  }

  SET_NEXT_STATE (STATE_CONNECT_TCP_CONNECTING);
  return 0;

}

int
nbd_internal_enter_STATE_CONNECT_TCP_CONNECT (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_CONNECT_TCP_CONNECT;

  r = enter_STATE_CONNECT_TCP_CONNECT (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "CONNECT_TCP.CONNECT",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* CONNECT_TCP.CONNECTING: Connecting to the remote server over a TCP socket */
static int
enter_STATE_CONNECT_TCP_CONNECTING (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 192 "generator/states-connect.c"

  int status;
  socklen_t len = sizeof status;

  if (getsockopt (h->sock->ops->get_fd (h->sock),
                  SOL_SOCKET, SO_ERROR, &status, &len) == -1) {
    SET_NEXT_STATE (STATE_DEAD);
    set_error (errno, "getsockopt: SO_ERROR");
    return 0;
  }
  /* This checks the status of the original connect call. */
  if (status == 0)
    SET_NEXT_STATE (STATE_MAGIC_START);
  else {
    if (h->connect_errno == 0)
      h->connect_errno = status;
    SET_NEXT_STATE (STATE_CONNECT_TCP_NEXT_ADDRESS);
  }
  return 0;

}

int
nbd_internal_enter_STATE_CONNECT_TCP_CONNECTING (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_CONNECT_TCP_CONNECTING;

  r = enter_STATE_CONNECT_TCP_CONNECTING (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "CONNECT_TCP.CONNECTING",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* CONNECT_TCP.NEXT_ADDRESS: Connecting to the next address over a TCP socket */
static int
enter_STATE_CONNECT_TCP_NEXT_ADDRESS (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 212 "generator/states-connect.c"

  if (h->sock) {
    h->sock->ops->close (h->sock);
    h->sock = NULL;
  }
  if (h->rp)
    h->rp = h->rp->ai_next;
  SET_NEXT_STATE (STATE_CONNECT_TCP_CONNECT);
  return 0;

}

int
nbd_internal_enter_STATE_CONNECT_TCP_NEXT_ADDRESS (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_CONNECT_TCP_NEXT_ADDRESS;

  r = enter_STATE_CONNECT_TCP_NEXT_ADDRESS (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "CONNECT_TCP.NEXT_ADDRESS",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* CONNECT_COMMAND.START: Connect to a subprocess */
static int
enter_STATE_CONNECT_COMMAND_START (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 222 "generator/states-connect.c"

  int sv[2];
  pid_t pid;
  int flags;

  assert (!h->sock);
  assert (h->argv.ptr);
  assert (h->argv.ptr[0]);
  if (socketpair (AF_UNIX, SOCK_STREAM|SOCK_CLOEXEC, 0, sv) == -1) {
    SET_NEXT_STATE (STATE_DEAD);
    set_error (errno, "socketpair");
    return 0;
  }

  pid = fork ();
  if (pid == -1) {
    SET_NEXT_STATE (STATE_DEAD);
    set_error (errno, "fork");
    close (sv[0]);
    close (sv[1]);
    return 0;
  }
  if (pid == 0) {         /* child - run command */
    close (0);
    close (1);
    close (sv[0]);
    dup2 (sv[1], 0);
    dup2 (sv[1], 1);
    close (sv[1]);

    /* Restore SIGPIPE back to SIG_DFL. */
    signal (SIGPIPE, SIG_DFL);

    execvp (h->argv.ptr[0], h->argv.ptr);
    nbd_internal_fork_safe_perror (h->argv.ptr[0]);
    if (errno == ENOENT)
      _exit (127);
    else
      _exit (126);
  }

  /* Parent. */
  close (sv[1]);

  h->pid = pid;

  /* The socket must be set to non-blocking only in the parent,
   * because the child may not be expecting a non-blocking socket.
   */
  flags = fcntl (sv[0], F_GETFL, 0);
  if (flags == -1 ||
      fcntl (sv[0], F_SETFL, flags|O_NONBLOCK) == -1) {
    SET_NEXT_STATE (STATE_DEAD);
    close (sv[0]);
    return 0;
  }

  h->sock = nbd_internal_socket_create (sv[0]);
  if (!h->sock) {
    SET_NEXT_STATE (STATE_DEAD);
    close (sv[0]);
    return 0;
  }

  /* The sockets are connected already, we can jump directly to
   * receiving the server magic.
   */
  SET_NEXT_STATE (STATE_MAGIC_START);
  return 0;

}

int
nbd_internal_enter_STATE_CONNECT_COMMAND_START (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_CONNECT_COMMAND_START;

  r = enter_STATE_CONNECT_COMMAND_START (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "CONNECT_COMMAND.START",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* CONNECT_SA.START: Connect to a subprocess with systemd socket activation */
static int
enter_STATE_CONNECT_SA_START (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 98 "generator/states-connect-socket-activation.c"

  int s;
  struct sockaddr_un addr;
  string_vector env = empty_vector;
  pid_t pid;
  int flags;

  assert (!h->sock);
  assert (h->argv.ptr);
  assert (h->argv.ptr[0]);

  /* Use /tmp instead of TMPDIR because we must ensure the path is
   * short enough to store in the sockaddr_un.  On some platforms this
   * may cause problems so we may need to revisit it.  XXX
   */
  h->sa_tmpdir = strdup ("/tmp/libnbdXXXXXX");
  if (h->sa_tmpdir == NULL) {
    SET_NEXT_STATE (STATE_DEAD);
    set_error (errno, "strdup");
    return 0;
  }
  if (mkdtemp (h->sa_tmpdir) == NULL) {
    SET_NEXT_STATE (STATE_DEAD);
    set_error (errno, "mkdtemp");
    /* Avoid cleanup in nbd_close. */
    free (h->sa_tmpdir);
    h->sa_tmpdir = NULL;
    return 0;
  }

  if (asprintf (&h->sa_sockpath, "%s/sock", h->sa_tmpdir) == -1) {
    SET_NEXT_STATE (STATE_DEAD);
    set_error (errno, "strdup");
    return 0;
  }

  s = socket (AF_UNIX, SOCK_STREAM|SOCK_CLOEXEC, 0);
  if (s == -1) {
    SET_NEXT_STATE (STATE_DEAD);
    set_error (errno, "socket");
    return 0;
  }

  addr.sun_family = AF_UNIX;
  memcpy (addr.sun_path, h->sa_sockpath, strlen (h->sa_sockpath) + 1);
  if (bind (s, (struct sockaddr *) &addr, sizeof addr) == -1) {
    SET_NEXT_STATE (STATE_DEAD);
    set_error (errno, "bind: %s", h->sa_sockpath);
    close (s);
    return 0;
  }

  if (listen (s, 1) == -1) {
    SET_NEXT_STATE (STATE_DEAD);
    set_error (errno, "listen");
    close (s);
    return 0;
  }

  if (prepare_socket_activation_environment (&env) == -1) {
    SET_NEXT_STATE (STATE_DEAD);
    close (s);
    return 0;
  }

  pid = fork ();
  if (pid == -1) {
    SET_NEXT_STATE (STATE_DEAD);
    set_error (errno, "fork");
    close (s);
    string_vector_iter (&env, (void *) free);
    free (env.ptr);
    return 0;
  }
  if (pid == 0) {         /* child - run command */
    if (s != FIRST_SOCKET_ACTIVATION_FD) {
      dup2 (s, FIRST_SOCKET_ACTIVATION_FD);
      close (s);
    }
    else {
      /* We must unset CLOEXEC on the fd.  (dup2 above does this
       * implicitly because CLOEXEC is set on the fd, not on the
       * socket).
       */
      flags = fcntl (s, F_GETFD, 0);
      if (flags == -1) {
        nbd_internal_fork_safe_perror ("fcntl: F_GETFD");
        _exit (126);
      }
      if (fcntl (s, F_SETFD, flags & ~FD_CLOEXEC) == -1) {
        nbd_internal_fork_safe_perror ("fcntl: F_SETFD");
        _exit (126);
      }
    }

    char buf[32];
    const char *v =
      nbd_internal_fork_safe_itoa ((long) getpid (), buf, sizeof buf);
    strcpy (&env.ptr[0][PREFIX_LENGTH], v);

    /* Restore SIGPIPE back to SIG_DFL. */
    signal (SIGPIPE, SIG_DFL);

    environ = env.ptr;
    execvp (h->argv.ptr[0], h->argv.ptr);
    nbd_internal_fork_safe_perror (h->argv.ptr[0]);
    if (errno == ENOENT)
      _exit (127);
    else
      _exit (126);
  }

  /* Parent. */
  close (s);
  string_vector_iter (&env, (void *) free);
  free (env.ptr);
  h->pid = pid;

  h->connaddrlen = sizeof addr;
  memcpy (&h->connaddr, &addr, h->connaddrlen);
  SET_NEXT_STATE (STATE_CONNECT_START);
  return 0;
}

int
nbd_internal_enter_STATE_CONNECT_SA_START (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_CONNECT_SA_START;

  r = enter_STATE_CONNECT_SA_START (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "CONNECT_SA.START",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* MAGIC.START: Prepare to receive the magic identification from remote */
static int
enter_STATE_MAGIC_START (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 22 "generator/states-magic.c"

  h->rbuf = &h->sbuf;
  h->rlen = 16;
  SET_NEXT_STATE (STATE_MAGIC_RECV_MAGIC);
  return 0;

}

int
nbd_internal_enter_STATE_MAGIC_START (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_MAGIC_START;

  r = enter_STATE_MAGIC_START (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "MAGIC.START",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* MAGIC.RECV_MAGIC: Receive initial magic identification from remote */
static int
enter_STATE_MAGIC_RECV_MAGIC (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 28 "generator/states-magic.c"

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:  SET_NEXT_STATE (STATE_MAGIC_CHECK_MAGIC);
  }
  return 0;

}

int
nbd_internal_enter_STATE_MAGIC_RECV_MAGIC (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_MAGIC_RECV_MAGIC;

  r = enter_STATE_MAGIC_RECV_MAGIC (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "MAGIC.RECV_MAGIC",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* MAGIC.CHECK_MAGIC: Check magic and version sent by remote */
static int
enter_STATE_MAGIC_CHECK_MAGIC (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 35 "generator/states-magic.c"

  uint64_t version;

  if (be64toh (h->sbuf.new_handshake.nbdmagic) != NBD_MAGIC) {
    SET_NEXT_STATE (STATE_DEAD);
    set_error (0, "handshake: server did not send expected NBD magic");
    return 0;
  }

  version = be64toh (h->sbuf.new_handshake.version);
  if (version == NBD_NEW_VERSION) {
    assert (h->opt_current == 0);
    SET_NEXT_STATE (STATE_NEWSTYLE_START);
  }
  else if (version == NBD_OLD_VERSION)
    SET_NEXT_STATE (STATE_OLDSTYLE_START);
  else {
    SET_NEXT_STATE (STATE_DEAD);
    set_error (0, "handshake: server is not either an oldstyle or fixed newstyle NBD server");
    return 0;
  }
  return 0;

}

int
nbd_internal_enter_STATE_MAGIC_CHECK_MAGIC (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_MAGIC_CHECK_MAGIC;

  r = enter_STATE_MAGIC_CHECK_MAGIC (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "MAGIC.CHECK_MAGIC",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* OLDSTYLE.START: Prepare to receive remainder of oldstyle header */
static int
enter_STATE_OLDSTYLE_START (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 22 "generator/states-oldstyle.c"

  /* We've already read the first 16 bytes of the handshake, we must
   * now read the remainder.
   */
  h->rbuf = &h->sbuf.old_handshake;
  h->rlen = sizeof h->sbuf.old_handshake;
  h->rbuf += 16;
  h->rlen -= 16;
  SET_NEXT_STATE (STATE_OLDSTYLE_RECV_REMAINING);
  return 0;

}

int
nbd_internal_enter_STATE_OLDSTYLE_START (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_OLDSTYLE_START;

  r = enter_STATE_OLDSTYLE_START (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "OLDSTYLE.START",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* OLDSTYLE.RECV_REMAINING: Receive remainder of oldstyle header */
static int
enter_STATE_OLDSTYLE_RECV_REMAINING (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 33 "generator/states-oldstyle.c"

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:  SET_NEXT_STATE (STATE_OLDSTYLE_CHECK);
  }
  return 0;

}

int
nbd_internal_enter_STATE_OLDSTYLE_RECV_REMAINING (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_OLDSTYLE_RECV_REMAINING;

  r = enter_STATE_OLDSTYLE_RECV_REMAINING (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "OLDSTYLE.RECV_REMAINING",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* OLDSTYLE.CHECK: Check oldstyle header */
static int
enter_STATE_OLDSTYLE_CHECK (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 40 "generator/states-oldstyle.c"

  uint64_t exportsize;
  uint16_t gflags, eflags;

  /* We already checked the magic and version in MAGIC.CHECK_MAGIC. */
  exportsize = be64toh (h->sbuf.old_handshake.exportsize);
  gflags = be16toh (h->sbuf.old_handshake.gflags);
  eflags = be16toh (h->sbuf.old_handshake.eflags);

  /* Server is unable to upgrade to TLS.  If h->tls is not 'require' (2)
   * then we can continue unencrypted.
   */
  if (h->tls == LIBNBD_TLS_REQUIRE) {
    SET_NEXT_STATE (STATE_DEAD);
    set_error (ENOTSUP, "handshake: server is oldstyle, "
               "but handle TLS setting is 'require' (2)");
    return 0;
  }

  h->gflags = gflags;
  debug (h, "gflags: 0x%" PRIx16, gflags);
  if (gflags) {
    set_error (0, "handshake: oldstyle server should not set gflags");
    SET_NEXT_STATE (STATE_DEAD);
    return 0;
  }

  if (nbd_internal_set_size_and_flags (h, exportsize, eflags) == -1) {
    SET_NEXT_STATE (STATE_DEAD);
    return 0;
  }

  h->protocol = "oldstyle";

  SET_NEXT_STATE (STATE_READY);

  return 0;

}

int
nbd_internal_enter_STATE_OLDSTYLE_CHECK (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_OLDSTYLE_CHECK;

  r = enter_STATE_OLDSTYLE_CHECK (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "OLDSTYLE.CHECK",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.START: Prepare to receive newstyle gflags from remote */
static int
enter_STATE_NEWSTYLE_START (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 114 "generator/states-newstyle.c"

  if (h->opt_mode) {
    /* NEWSTYLE can be entered multiple times, from MAGIC.CHECK_MAGIC and
     * during various nbd_opt_* calls during NEGOTIATION.  Each previous
     * state has informed us what we still need to do.
     */
    switch (h->opt_current) {
    case NBD_OPT_GO:
    case NBD_OPT_INFO:
      if ((h->gflags & LIBNBD_HANDSHAKE_FLAG_FIXED_NEWSTYLE) == 0)
        SET_NEXT_STATE (STATE_NEWSTYLE_OPT_EXPORT_NAME_START);
      else
        SET_NEXT_STATE (STATE_NEWSTYLE_OPT_META_CONTEXT_START);
      return 0;
    case NBD_OPT_LIST:
      SET_NEXT_STATE (STATE_NEWSTYLE_OPT_LIST_START);
      return 0;
    case NBD_OPT_ABORT:
      if ((h->gflags & LIBNBD_HANDSHAKE_FLAG_FIXED_NEWSTYLE) == 0) {
        SET_NEXT_STATE (STATE_DEAD);
        set_error (ENOTSUP, "handshake: server is not using fixed newstyle");
        return 0;
      }
      SET_NEXT_STATE (STATE_NEWSTYLE_PREPARE_OPT_ABORT);
      return 0;
    case NBD_OPT_LIST_META_CONTEXT:
      SET_NEXT_STATE (STATE_NEWSTYLE_OPT_META_CONTEXT_START);
      return 0;
    case 0:
      break;
    default:
      abort ();
    }
  }
  h->rbuf = &h->sbuf;
  h->rlen = sizeof h->sbuf.gflags;
  SET_NEXT_STATE (STATE_NEWSTYLE_RECV_GFLAGS);
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_START (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_START;

  r = enter_STATE_NEWSTYLE_START (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.START",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.RECV_GFLAGS: Receive newstyle gflags from remote */
static int
enter_STATE_NEWSTYLE_RECV_GFLAGS (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 153 "generator/states-newstyle.c"

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:  SET_NEXT_STATE (STATE_NEWSTYLE_CHECK_GFLAGS);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_RECV_GFLAGS (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_RECV_GFLAGS;

  r = enter_STATE_NEWSTYLE_RECV_GFLAGS (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.RECV_GFLAGS",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.CHECK_GFLAGS: Check global flags sent by remote */
static int
enter_STATE_NEWSTYLE_CHECK_GFLAGS (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 160 "generator/states-newstyle.c"

  uint32_t cflags;

  h->gflags &= be16toh (h->sbuf.gflags);
  if ((h->gflags & LIBNBD_HANDSHAKE_FLAG_FIXED_NEWSTYLE) == 0 &&
      h->tls == LIBNBD_TLS_REQUIRE) {
    SET_NEXT_STATE (STATE_DEAD);
    set_error (ENOTSUP, "handshake: server is not using fixed newstyle, "
               "but handle TLS setting is 'require' (2)");
    return 0;
  }

  if ((h->gflags & LIBNBD_HANDSHAKE_FLAG_FIXED_NEWSTYLE) == 0)
    h->protocol = "newstyle";
  else
    h->protocol = "newstyle-fixed";

  cflags = h->gflags;
  h->sbuf.cflags = htobe32 (cflags);
  h->wbuf = &h->sbuf;
  h->wlen = 4;
  SET_NEXT_STATE (STATE_NEWSTYLE_SEND_CFLAGS);
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_CHECK_GFLAGS (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_CHECK_GFLAGS;

  r = enter_STATE_NEWSTYLE_CHECK_GFLAGS (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.CHECK_GFLAGS",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.SEND_CFLAGS: Send newstyle client flags to remote */
static int
enter_STATE_NEWSTYLE_SEND_CFLAGS (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 184 "generator/states-newstyle.c"

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    /* Start sending options. */
    if ((h->gflags & LIBNBD_HANDSHAKE_FLAG_FIXED_NEWSTYLE) == 0) {
      if (h->opt_mode)
        SET_NEXT_STATE (STATE_NEGOTIATING);
      else
        SET_NEXT_STATE (STATE_NEWSTYLE_OPT_EXPORT_NAME_START);
    }
    else
      SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STARTTLS_START);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_SEND_CFLAGS (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_SEND_CFLAGS;

  r = enter_STATE_NEWSTYLE_SEND_CFLAGS (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.SEND_CFLAGS",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_STARTTLS.START: Try to send newstyle NBD_OPT_STARTTLS to upgrade to TLS */
static int
enter_STATE_NEWSTYLE_OPT_STARTTLS_START (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 22 "generator/states-newstyle-opt-starttls.c"

  assert (h->gflags & LIBNBD_HANDSHAKE_FLAG_FIXED_NEWSTYLE);
  /* If TLS was not requested we skip this option and go to the next one. */
  if (h->tls == LIBNBD_TLS_DISABLE) {
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_START);
    return 0;
  }

  h->sbuf.option.version = htobe64 (NBD_NEW_VERSION);
  h->sbuf.option.option = htobe32 (NBD_OPT_STARTTLS);
  h->sbuf.option.optlen = 0;
  h->wbuf = &h->sbuf;
  h->wlen = sizeof (h->sbuf.option);
  SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STARTTLS_SEND);
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_STARTTLS_START (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_STARTTLS_START;

  r = enter_STATE_NEWSTYLE_OPT_STARTTLS_START (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_STARTTLS.START",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_STARTTLS.SEND: Send newstyle NBD_OPT_STARTTLS to upgrade to TLS */
static int
enter_STATE_NEWSTYLE_OPT_STARTTLS_SEND (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 38 "generator/states-newstyle-opt-starttls.c"

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    h->rbuf = &h->sbuf;
    h->rlen = sizeof (h->sbuf.or.option_reply);
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STARTTLS_RECV_REPLY);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_STARTTLS_SEND (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_STARTTLS_SEND;

  r = enter_STATE_NEWSTYLE_OPT_STARTTLS_SEND (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_STARTTLS.SEND",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_STARTTLS.RECV_REPLY: Receive newstyle NBD_OPT_STARTTLS reply */
static int
enter_STATE_NEWSTYLE_OPT_STARTTLS_RECV_REPLY (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 48 "generator/states-newstyle-opt-starttls.c"

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    if (prepare_for_reply_payload (h, NBD_OPT_STARTTLS) == -1) {
      SET_NEXT_STATE (STATE_DEAD);
      return 0;
    }
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STARTTLS_RECV_REPLY_PAYLOAD);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_STARTTLS_RECV_REPLY (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_STARTTLS_RECV_REPLY;

  r = enter_STATE_NEWSTYLE_OPT_STARTTLS_RECV_REPLY (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_STARTTLS.RECV_REPLY",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_STARTTLS.RECV_REPLY_PAYLOAD: Receive any newstyle NBD_OPT_STARTTLS reply payload */
static int
enter_STATE_NEWSTYLE_OPT_STARTTLS_RECV_REPLY_PAYLOAD (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 60 "generator/states-newstyle-opt-starttls.c"

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:  SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STARTTLS_CHECK_REPLY);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_STARTTLS_RECV_REPLY_PAYLOAD (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_STARTTLS_RECV_REPLY_PAYLOAD;

  r = enter_STATE_NEWSTYLE_OPT_STARTTLS_RECV_REPLY_PAYLOAD (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_STARTTLS.RECV_REPLY_PAYLOAD",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_STARTTLS.CHECK_REPLY: Check newstyle NBD_OPT_STARTTLS reply */
static int
enter_STATE_NEWSTYLE_OPT_STARTTLS_CHECK_REPLY (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 67 "generator/states-newstyle-opt-starttls.c"

  uint32_t reply;
  struct socket *new_sock;

  reply = be32toh (h->sbuf.or.option_reply.reply);
  switch (reply) {
  case NBD_REP_ACK:
    new_sock = nbd_internal_crypto_create_session (h, h->sock);
    if (new_sock == NULL) {
      SET_NEXT_STATE (STATE_DEAD);
      return 0;
    }
    h->sock = new_sock;
    if (nbd_internal_crypto_is_reading (h))
      SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STARTTLS_TLS_HANDSHAKE_READ);
    else
      SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STARTTLS_TLS_HANDSHAKE_WRITE);
    return 0;

  default:
    if (handle_reply_error (h) == -1) {
      SET_NEXT_STATE (STATE_DEAD);
      return 0;
    }

    /* Server refused to upgrade to TLS.  If h->tls is not 'require' (2)
     * then we can continue unencrypted.
     */
    if (h->tls == LIBNBD_TLS_REQUIRE) {
      SET_NEXT_STATE (STATE_NEWSTYLE_PREPARE_OPT_ABORT);
      set_error (ENOTSUP, "handshake: server refused TLS, "
                 "but handle TLS setting is 'require' (2)");
      return 0;
    }

    debug (h,
           "server refused TLS (%s), continuing with unencrypted connection",
           reply == NBD_REP_ERR_POLICY ? "policy" : "not supported");
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_START);
    return 0;
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_STARTTLS_CHECK_REPLY (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_STARTTLS_CHECK_REPLY;

  r = enter_STATE_NEWSTYLE_OPT_STARTTLS_CHECK_REPLY (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_STARTTLS.CHECK_REPLY",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_STARTTLS.TLS_HANDSHAKE_READ: TLS handshake (reading) */
static int
enter_STATE_NEWSTYLE_OPT_STARTTLS_TLS_HANDSHAKE_READ (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 110 "generator/states-newstyle-opt-starttls.c"

  int r;

  r = nbd_internal_crypto_handshake (h);
  if (r == -1) {
    SET_NEXT_STATE (STATE_DEAD);
    return 0;
  }
  if (r == 0) {
    /* Finished handshake. */
    h->tls_negotiated = true;
    nbd_internal_crypto_debug_tls_enabled (h);

    /* Continue with option negotiation. */
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_START);
    return 0;
  }
  /* Continue handshake. */
  if (nbd_internal_crypto_is_reading (h))
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STARTTLS_TLS_HANDSHAKE_READ);
  else
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STARTTLS_TLS_HANDSHAKE_WRITE);
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_STARTTLS_TLS_HANDSHAKE_READ (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_STARTTLS_TLS_HANDSHAKE_READ;

  r = enter_STATE_NEWSTYLE_OPT_STARTTLS_TLS_HANDSHAKE_READ (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_STARTTLS.TLS_HANDSHAKE_READ",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_STARTTLS.TLS_HANDSHAKE_WRITE: TLS handshake (writing) */
static int
enter_STATE_NEWSTYLE_OPT_STARTTLS_TLS_HANDSHAKE_WRITE (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 134 "generator/states-newstyle-opt-starttls.c"

  int r;

  r = nbd_internal_crypto_handshake (h);
  if (r == -1) {
    SET_NEXT_STATE (STATE_DEAD);
    return 0;
  }
  if (r == 0) {
    /* Finished handshake. */
    debug (h, "connection is using TLS");

    /* Continue with option negotiation. */
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_START);
    return 0;
  }
  /* Continue handshake. */
  if (nbd_internal_crypto_is_reading (h))
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STARTTLS_TLS_HANDSHAKE_READ);
  else
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STARTTLS_TLS_HANDSHAKE_WRITE);
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_STARTTLS_TLS_HANDSHAKE_WRITE (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_STARTTLS_TLS_HANDSHAKE_WRITE;

  r = enter_STATE_NEWSTYLE_OPT_STARTTLS_TLS_HANDSHAKE_WRITE (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_STARTTLS.TLS_HANDSHAKE_WRITE",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_STRUCTURED_REPLY.START: Try to negotiate newstyle NBD_OPT_STRUCTURED_REPLY */
static int
enter_STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_START (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 22 "generator/states-newstyle-opt-structured-reply.c"

  assert (h->gflags & LIBNBD_HANDSHAKE_FLAG_FIXED_NEWSTYLE);
  if (!h->request_sr) {
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_META_CONTEXT_START);
    return 0;
  }

  h->sbuf.option.version = htobe64 (NBD_NEW_VERSION);
  h->sbuf.option.option = htobe32 (NBD_OPT_STRUCTURED_REPLY);
  h->sbuf.option.optlen = htobe32 (0);
  h->wbuf = &h->sbuf;
  h->wlen = sizeof h->sbuf.option;
  SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_SEND);
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_START (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_START;

  r = enter_STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_START (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_STRUCTURED_REPLY.START",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_STRUCTURED_REPLY.SEND: Send newstyle NBD_OPT_STRUCTURED_REPLY negotiation request */
static int
enter_STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_SEND (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 37 "generator/states-newstyle-opt-structured-reply.c"

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    h->rbuf = &h->sbuf;
    h->rlen = sizeof h->sbuf.or.option_reply;
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_RECV_REPLY);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_SEND (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_SEND;

  r = enter_STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_SEND (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_STRUCTURED_REPLY.SEND",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_STRUCTURED_REPLY.RECV_REPLY: Receive newstyle NBD_OPT_STRUCTURED_REPLY option reply */
static int
enter_STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_RECV_REPLY (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 47 "generator/states-newstyle-opt-structured-reply.c"

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    if (prepare_for_reply_payload (h, NBD_OPT_STRUCTURED_REPLY) == -1) {
      SET_NEXT_STATE (STATE_DEAD);
      return 0;
    }
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_RECV_REPLY_PAYLOAD);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_RECV_REPLY (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_RECV_REPLY;

  r = enter_STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_RECV_REPLY (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_STRUCTURED_REPLY.RECV_REPLY",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_STRUCTURED_REPLY.RECV_REPLY_PAYLOAD: Receive any newstyle NBD_OPT_STRUCTURED_REPLY reply payload */
static int
enter_STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_RECV_REPLY_PAYLOAD (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 59 "generator/states-newstyle-opt-structured-reply.c"

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:  SET_NEXT_STATE (STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_CHECK_REPLY);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_RECV_REPLY_PAYLOAD (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_RECV_REPLY_PAYLOAD;

  r = enter_STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_RECV_REPLY_PAYLOAD (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_STRUCTURED_REPLY.RECV_REPLY_PAYLOAD",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_STRUCTURED_REPLY.CHECK_REPLY: Check newstyle NBD_OPT_STRUCTURED_REPLY option reply */
static int
enter_STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_CHECK_REPLY (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 66 "generator/states-newstyle-opt-structured-reply.c"

  uint32_t reply;

  reply = be32toh (h->sbuf.or.option_reply.reply);
  switch (reply) {
  case NBD_REP_ACK:
    debug (h, "negotiated structured replies on this connection");
    h->structured_replies = true;
    break;
  default:
    if (handle_reply_error (h) == -1) {
      SET_NEXT_STATE (STATE_DEAD);
      return 0;
    }

    debug (h, "structured replies are not supported by this server");
    h->structured_replies = false;
    break;
  }

  /* Next option. */
  if (h->opt_mode)
    SET_NEXT_STATE (STATE_NEGOTIATING);
  else
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_META_CONTEXT_START);
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_CHECK_REPLY (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_CHECK_REPLY;

  r = enter_STATE_NEWSTYLE_OPT_STRUCTURED_REPLY_CHECK_REPLY (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_STRUCTURED_REPLY.CHECK_REPLY",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_META_CONTEXT.START: Try to negotiate newstyle NBD_OPT_SET_META_CONTEXT */
static int
enter_STATE_NEWSTYLE_OPT_META_CONTEXT_START (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 22 "generator/states-newstyle-opt-meta-context.c"

  size_t i;
  uint32_t len, opt;

  /* If the server doesn't support SRs then we must skip this group.
   * Also we skip the group if the client didn't request any metadata
   * contexts, when doing SET (but an empty LIST is okay).
   */
  assert (h->gflags & LIBNBD_HANDSHAKE_FLAG_FIXED_NEWSTYLE);
  nbd_internal_reset_size_and_flags (h);
  if (h->opt_current == NBD_OPT_LIST_META_CONTEXT) {
    assert (h->opt_mode);
    assert (h->structured_replies);
    assert (CALLBACK_IS_NOT_NULL (h->opt_cb.fn.context));
    opt = h->opt_current;
  }
  else {
    assert (CALLBACK_IS_NULL (h->opt_cb.fn.context));
    opt = NBD_OPT_SET_META_CONTEXT;
    if (!h->structured_replies || h->request_meta_contexts.size == 0) {
      SET_NEXT_STATE (STATE_NEWSTYLE_OPT_GO_START);
      return 0;
    }
  }

  assert (h->meta_contexts == NULL);

  /* Calculate the length of the option request data. */
  len = 4 /* exportname len */ + strlen (h->export_name) + 4 /* nr queries */;
  for (i = 0; i < h->request_meta_contexts.size; ++i)
    len += 4 /* length of query */ + strlen (h->request_meta_contexts.ptr[i]);

  h->sbuf.option.version = htobe64 (NBD_NEW_VERSION);
  h->sbuf.option.option = htobe32 (opt);
  h->sbuf.option.optlen = htobe32 (len);
  h->wbuf = &h->sbuf;
  h->wlen = sizeof (h->sbuf.option);
  h->wflags = MSG_MORE;
  SET_NEXT_STATE (STATE_NEWSTYLE_OPT_META_CONTEXT_SEND);
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_META_CONTEXT_START (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_META_CONTEXT_START;

  r = enter_STATE_NEWSTYLE_OPT_META_CONTEXT_START (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_META_CONTEXT.START",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_META_CONTEXT.SEND: Send newstyle NBD_OPT_SET_META_CONTEXT */
static int
enter_STATE_NEWSTYLE_OPT_META_CONTEXT_SEND (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 63 "generator/states-newstyle-opt-meta-context.c"

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    h->sbuf.len = htobe32 (strlen (h->export_name));
    h->wbuf = &h->sbuf.len;
    h->wlen = sizeof h->sbuf.len;
    h->wflags = MSG_MORE;
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_EXPORTNAMELEN);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_META_CONTEXT_SEND (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_META_CONTEXT_SEND;

  r = enter_STATE_NEWSTYLE_OPT_META_CONTEXT_SEND (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_META_CONTEXT.SEND",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_META_CONTEXT.SEND_EXPORTNAMELEN: Send newstyle NBD_OPT_SET_META_CONTEXT export name length */
static int
enter_STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_EXPORTNAMELEN (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 75 "generator/states-newstyle-opt-meta-context.c"

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    h->wbuf = h->export_name;
    h->wlen = strlen (h->export_name);
    h->wflags = MSG_MORE;
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_EXPORTNAME);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_EXPORTNAMELEN (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_EXPORTNAMELEN;

  r = enter_STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_EXPORTNAMELEN (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_META_CONTEXT.SEND_EXPORTNAMELEN",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_META_CONTEXT.SEND_EXPORTNAME: Send newstyle NBD_OPT_SET_META_CONTEXT export name */
static int
enter_STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_EXPORTNAME (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 86 "generator/states-newstyle-opt-meta-context.c"

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    h->sbuf.nrqueries = htobe32 (h->request_meta_contexts.size);
    h->wbuf = &h->sbuf;
    h->wlen = sizeof h->sbuf.nrqueries;
    h->wflags = MSG_MORE;
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_NRQUERIES);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_EXPORTNAME (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_EXPORTNAME;

  r = enter_STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_EXPORTNAME (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_META_CONTEXT.SEND_EXPORTNAME",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_META_CONTEXT.SEND_NRQUERIES: Send newstyle NBD_OPT_SET_META_CONTEXT number of queries */
static int
enter_STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_NRQUERIES (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 98 "generator/states-newstyle-opt-meta-context.c"

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    h->querynum = 0;
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_META_CONTEXT_PREPARE_NEXT_QUERY);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_NRQUERIES (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_NRQUERIES;

  r = enter_STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_NRQUERIES (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_META_CONTEXT.SEND_NRQUERIES",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_META_CONTEXT.PREPARE_NEXT_QUERY: Prepare to send newstyle NBD_OPT_SET_META_CONTEXT query */
static int
enter_STATE_NEWSTYLE_OPT_META_CONTEXT_PREPARE_NEXT_QUERY (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 107 "generator/states-newstyle-opt-meta-context.c"

  if (h->querynum >= h->request_meta_contexts.size) {
    /* end of list of requested meta contexts */
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_META_CONTEXT_PREPARE_FOR_REPLY);
    return 0;
  }
  const char *query = h->request_meta_contexts.ptr[h->querynum];

  h->sbuf.len = htobe32 (strlen (query));
  h->wbuf = &h->sbuf.len;
  h->wlen = sizeof h->sbuf.len;
  h->wflags = MSG_MORE;
  SET_NEXT_STATE (STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_QUERYLEN);
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_META_CONTEXT_PREPARE_NEXT_QUERY (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_META_CONTEXT_PREPARE_NEXT_QUERY;

  r = enter_STATE_NEWSTYLE_OPT_META_CONTEXT_PREPARE_NEXT_QUERY (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_META_CONTEXT.PREPARE_NEXT_QUERY",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_META_CONTEXT.SEND_QUERYLEN: Send newstyle NBD_OPT_SET_META_CONTEXT query length */
static int
enter_STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_QUERYLEN (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 122 "generator/states-newstyle-opt-meta-context.c"

  const char *query = h->request_meta_contexts.ptr[h->querynum];

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    h->wbuf = query;
    h->wlen = strlen (query);
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_QUERY);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_QUERYLEN (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_QUERYLEN;

  r = enter_STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_QUERYLEN (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_META_CONTEXT.SEND_QUERYLEN",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_META_CONTEXT.SEND_QUERY: Send newstyle NBD_OPT_SET_META_CONTEXT query */
static int
enter_STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_QUERY (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 134 "generator/states-newstyle-opt-meta-context.c"

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    h->querynum++;
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_META_CONTEXT_PREPARE_NEXT_QUERY);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_QUERY (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_QUERY;

  r = enter_STATE_NEWSTYLE_OPT_META_CONTEXT_SEND_QUERY (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_META_CONTEXT.SEND_QUERY",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_META_CONTEXT.PREPARE_FOR_REPLY: Prepare to receive newstyle NBD_OPT_SET_META_CONTEXT option reply */
static int
enter_STATE_NEWSTYLE_OPT_META_CONTEXT_PREPARE_FOR_REPLY (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 143 "generator/states-newstyle-opt-meta-context.c"

  h->rbuf = &h->sbuf.or.option_reply;
  h->rlen = sizeof h->sbuf.or.option_reply;
  SET_NEXT_STATE (STATE_NEWSTYLE_OPT_META_CONTEXT_RECV_REPLY);
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_META_CONTEXT_PREPARE_FOR_REPLY (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_META_CONTEXT_PREPARE_FOR_REPLY;

  r = enter_STATE_NEWSTYLE_OPT_META_CONTEXT_PREPARE_FOR_REPLY (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_META_CONTEXT.PREPARE_FOR_REPLY",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_META_CONTEXT.RECV_REPLY: Receive newstyle NBD_OPT_SET_META_CONTEXT option reply */
static int
enter_STATE_NEWSTYLE_OPT_META_CONTEXT_RECV_REPLY (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 149 "generator/states-newstyle-opt-meta-context.c"

  uint32_t opt;

  if (h->opt_current == NBD_OPT_LIST_META_CONTEXT)
    opt = h->opt_current;
  else
    opt = NBD_OPT_SET_META_CONTEXT;

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    if (prepare_for_reply_payload (h, opt) == -1) {
      SET_NEXT_STATE (STATE_DEAD);
      return 0;
    }
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_META_CONTEXT_RECV_REPLY_PAYLOAD);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_META_CONTEXT_RECV_REPLY (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_META_CONTEXT_RECV_REPLY;

  r = enter_STATE_NEWSTYLE_OPT_META_CONTEXT_RECV_REPLY (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_META_CONTEXT.RECV_REPLY",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_META_CONTEXT.RECV_REPLY_PAYLOAD: Receive newstyle NBD_OPT_SET_META_CONTEXT option reply payload */
static int
enter_STATE_NEWSTYLE_OPT_META_CONTEXT_RECV_REPLY_PAYLOAD (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 168 "generator/states-newstyle-opt-meta-context.c"

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:  SET_NEXT_STATE (STATE_NEWSTYLE_OPT_META_CONTEXT_CHECK_REPLY);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_META_CONTEXT_RECV_REPLY_PAYLOAD (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_META_CONTEXT_RECV_REPLY_PAYLOAD;

  r = enter_STATE_NEWSTYLE_OPT_META_CONTEXT_RECV_REPLY_PAYLOAD (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_META_CONTEXT.RECV_REPLY_PAYLOAD",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_META_CONTEXT.CHECK_REPLY: Check newstyle NBD_OPT_SET_META_CONTEXT option reply */
static int
enter_STATE_NEWSTYLE_OPT_META_CONTEXT_CHECK_REPLY (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 175 "generator/states-newstyle-opt-meta-context.c"

  uint32_t reply;
  uint32_t len;
  const size_t maxpayload = sizeof h->sbuf.or.payload.context;
  struct meta_context *meta_context;
  uint32_t opt;
  int err = 0;

  if (h->opt_current == NBD_OPT_LIST_META_CONTEXT)
    opt = h->opt_current;
  else
    opt = NBD_OPT_SET_META_CONTEXT;

  reply = be32toh (h->sbuf.or.option_reply.reply);
  len = be32toh (h->sbuf.or.option_reply.replylen);
  switch (reply) {
  case NBD_REP_ACK:           /* End of list of replies. */
    if (opt == NBD_OPT_LIST_META_CONTEXT) {
      SET_NEXT_STATE (STATE_NEGOTIATING);
      CALL_CALLBACK (h->opt_cb.completion, &err);
      nbd_internal_free_option (h);
    }
    else
      SET_NEXT_STATE (STATE_NEWSTYLE_OPT_GO_START);
    break;
  case NBD_REP_META_CONTEXT:  /* A context. */
    if (len > maxpayload)
      debug (h, "skipping too large meta context");
    else {
      assert (len > sizeof h->sbuf.or.payload.context.context.context_id);
      meta_context = malloc (sizeof *meta_context);
      if (meta_context == NULL) {
        set_error (errno, "malloc");
        SET_NEXT_STATE (STATE_DEAD);
        return 0;
      }
      meta_context->context_id =
        be32toh (h->sbuf.or.payload.context.context.context_id);
      /* String payload is not NUL-terminated. */
      meta_context->name = strndup (h->sbuf.or.payload.context.str,
                                    len - sizeof meta_context->context_id);
      if (meta_context->name == NULL) {
        set_error (errno, "strdup");
        SET_NEXT_STATE (STATE_DEAD);
        free (meta_context);
        return 0;
      }
      debug (h, "negotiated %s with context ID %" PRIu32,
             meta_context->name, meta_context->context_id);
      if (opt == NBD_OPT_LIST_META_CONTEXT) {
        CALL_CALLBACK (h->opt_cb.fn.context, meta_context->name);
        free (meta_context->name);
        free (meta_context);
      }
      else {
        meta_context->next = h->meta_contexts;
        h->meta_contexts = meta_context;
      }
    }
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_META_CONTEXT_PREPARE_FOR_REPLY);
    break;
  default:
    /* Anything else is an error, ignore it for SET, report it for LIST */
    if (handle_reply_error (h) == -1) {
      SET_NEXT_STATE (STATE_DEAD);
      return 0;
    }

    if (opt == NBD_OPT_LIST_META_CONTEXT) {
      /* XXX Should we decode specific expected errors, like
       * REP_ERR_UNKNOWN to ENOENT or REP_ERR_TOO_BIG to ERANGE?
       */
      err = ENOTSUP;
      set_error (err, "unexpected response, possibly the server does not "
                 "support listing contexts");
      CALL_CALLBACK (h->opt_cb.completion, &err);
      nbd_internal_free_option (h);
      SET_NEXT_STATE (STATE_NEGOTIATING);
    }
    else {
      debug (h, "handshake: unexpected error from "
             "NBD_OPT_SET_META_CONTEXT (%" PRIu32 ")", reply);
      SET_NEXT_STATE (STATE_NEWSTYLE_OPT_GO_START);
    }
    break;
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_META_CONTEXT_CHECK_REPLY (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_META_CONTEXT_CHECK_REPLY;

  r = enter_STATE_NEWSTYLE_OPT_META_CONTEXT_CHECK_REPLY (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_META_CONTEXT.CHECK_REPLY",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_GO.START: Try to send newstyle NBD_OPT_GO to end handshake */
static int
enter_STATE_NEWSTYLE_OPT_GO_START (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 22 "generator/states-newstyle-opt-go.c"

  uint16_t nrinfos = h->full_info ? 3 : 1;

  assert (h->gflags & LIBNBD_HANDSHAKE_FLAG_FIXED_NEWSTYLE);
  if (h->opt_current == NBD_OPT_INFO)
    assert (h->opt_mode);
  else if (!h->opt_current) {
    assert (!h->opt_mode);
    assert(CALLBACK_IS_NULL(h->opt_cb.completion));
    h->opt_current = NBD_OPT_GO;
  }
  h->sbuf.option.version = htobe64 (NBD_NEW_VERSION);
  h->sbuf.option.option = htobe32 (h->opt_current);
  h->sbuf.option.optlen =
    htobe32 (/* exportnamelen */ 4 + strlen (h->export_name)
             + sizeof nrinfos + 2 * nrinfos);
  h->wbuf = &h->sbuf;
  h->wlen = sizeof h->sbuf.option;
  h->wflags = MSG_MORE;
  SET_NEXT_STATE (STATE_NEWSTYLE_OPT_GO_SEND);
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_GO_START (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_GO_START;

  r = enter_STATE_NEWSTYLE_OPT_GO_START (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_GO.START",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_GO.SEND: Send newstyle NBD_OPT_GO to end handshake */
static int
enter_STATE_NEWSTYLE_OPT_GO_SEND (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 44 "generator/states-newstyle-opt-go.c"

  const uint32_t exportnamelen = strlen (h->export_name);

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    h->sbuf.len = htobe32 (exportnamelen);
    h->wbuf = &h->sbuf;
    h->wlen = 4;
    h->wflags = MSG_MORE;
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_GO_SEND_EXPORTNAMELEN);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_GO_SEND (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_GO_SEND;

  r = enter_STATE_NEWSTYLE_OPT_GO_SEND (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_GO.SEND",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_GO.SEND_EXPORTNAMELEN: Send newstyle NBD_OPT_GO export name length */
static int
enter_STATE_NEWSTYLE_OPT_GO_SEND_EXPORTNAMELEN (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 58 "generator/states-newstyle-opt-go.c"

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    h->wbuf = h->export_name;
    h->wlen = strlen (h->export_name);
    h->wflags = MSG_MORE;
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_GO_SEND_EXPORT);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_GO_SEND_EXPORTNAMELEN (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_GO_SEND_EXPORTNAMELEN;

  r = enter_STATE_NEWSTYLE_OPT_GO_SEND_EXPORTNAMELEN (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_GO.SEND_EXPORTNAMELEN",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_GO.SEND_EXPORT: Send newstyle NBD_OPT_GO export name */
static int
enter_STATE_NEWSTYLE_OPT_GO_SEND_EXPORT (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 69 "generator/states-newstyle-opt-go.c"

  uint16_t nrinfos = h->full_info ? 3 : 1;

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    h->sbuf.nrinfos = htobe16 (nrinfos);
    h->wbuf = &h->sbuf;
    h->wlen = sizeof h->sbuf.nrinfos;
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_GO_SEND_NRINFOS);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_GO_SEND_EXPORT (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_GO_SEND_EXPORT;

  r = enter_STATE_NEWSTYLE_OPT_GO_SEND_EXPORT (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_GO.SEND_EXPORT",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_GO.SEND_NRINFOS: Send newstyle NBD_OPT_GO number of infos */
static int
enter_STATE_NEWSTYLE_OPT_GO_SEND_NRINFOS (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 82 "generator/states-newstyle-opt-go.c"

  uint16_t nrinfos = h->full_info ? 3 : 1;

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    h->sbuf.info[0] = htobe16 (NBD_INFO_BLOCK_SIZE);
    h->sbuf.info[1] = htobe16 (NBD_INFO_NAME);
    h->sbuf.info[2] = htobe16 (NBD_INFO_DESCRIPTION);
    h->wbuf = &h->sbuf;
    h->wlen = sizeof h->sbuf.info[0] * nrinfos;
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_GO_SEND_INFO);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_GO_SEND_NRINFOS (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_GO_SEND_NRINFOS;

  r = enter_STATE_NEWSTYLE_OPT_GO_SEND_NRINFOS (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_GO.SEND_NRINFOS",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_GO.SEND_INFO: Send newstyle NBD_OPT_GO request for NBD_INFO_BLOCK_SIZE */
static int
enter_STATE_NEWSTYLE_OPT_GO_SEND_INFO (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 97 "generator/states-newstyle-opt-go.c"

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    h->rbuf = &h->sbuf;
    h->rlen = sizeof h->sbuf.or.option_reply;
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_GO_RECV_REPLY);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_GO_SEND_INFO (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_GO_SEND_INFO;

  r = enter_STATE_NEWSTYLE_OPT_GO_SEND_INFO (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_GO.SEND_INFO",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_GO.RECV_REPLY: Receive newstyle NBD_OPT_GO reply */
static int
enter_STATE_NEWSTYLE_OPT_GO_RECV_REPLY (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 107 "generator/states-newstyle-opt-go.c"

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    if (prepare_for_reply_payload (h, h->opt_current) == -1) {
      SET_NEXT_STATE (STATE_DEAD);
      return 0;
    }
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_GO_RECV_REPLY_PAYLOAD);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_GO_RECV_REPLY (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_GO_RECV_REPLY;

  r = enter_STATE_NEWSTYLE_OPT_GO_RECV_REPLY (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_GO.RECV_REPLY",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_GO.RECV_REPLY_PAYLOAD: Receive newstyle NBD_OPT_GO reply payload */
static int
enter_STATE_NEWSTYLE_OPT_GO_RECV_REPLY_PAYLOAD (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 119 "generator/states-newstyle-opt-go.c"

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:  SET_NEXT_STATE (STATE_NEWSTYLE_OPT_GO_CHECK_REPLY);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_GO_RECV_REPLY_PAYLOAD (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_GO_RECV_REPLY_PAYLOAD;

  r = enter_STATE_NEWSTYLE_OPT_GO_RECV_REPLY_PAYLOAD (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_GO.RECV_REPLY_PAYLOAD",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_GO.CHECK_REPLY: Check newstyle NBD_OPT_GO reply */
static int
enter_STATE_NEWSTYLE_OPT_GO_CHECK_REPLY (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 126 "generator/states-newstyle-opt-go.c"

  uint32_t reply;
  uint32_t len;
  const size_t maxpayload = sizeof h->sbuf.or.payload;
  uint16_t info;
  uint64_t exportsize;
  uint16_t eflags;
  uint32_t min, pref, max;
  int err;

  reply = be32toh (h->sbuf.or.option_reply.reply);
  len = be32toh (h->sbuf.or.option_reply.replylen);

  switch (reply) {
  case NBD_REP_INFO:
    if (len > maxpayload /* see RECV_NEWSTYLE_OPT_GO_REPLY */)
      debug (h, "skipping large NBD_REP_INFO");
    else {
      assert (len >= sizeof h->sbuf.or.payload.export.info);
      info = be16toh (h->sbuf.or.payload.export.info);
      switch (info) {
      case NBD_INFO_EXPORT:
        if (len != sizeof h->sbuf.or.payload.export) {
          SET_NEXT_STATE (STATE_DEAD);
          set_error (0, "handshake: incorrect NBD_INFO_EXPORT option reply length");
          return 0;
        }
        exportsize = be64toh (h->sbuf.or.payload.export.exportsize);
        eflags = be16toh (h->sbuf.or.payload.export.eflags);
        if (nbd_internal_set_size_and_flags (h, exportsize, eflags) == -1) {
          SET_NEXT_STATE (STATE_DEAD);
          return 0;
        }
        break;
      case NBD_INFO_BLOCK_SIZE:
        if (len != sizeof h->sbuf.or.payload.block_size) {
          SET_NEXT_STATE (STATE_DEAD);
          set_error (0, "handshake: incorrect NBD_INFO_BLOCK_SIZE option reply length");
          return 0;
        }
        min = be32toh (h->sbuf.or.payload.block_size.minimum);
        pref = be32toh (h->sbuf.or.payload.block_size.preferred);
        max = be32toh (h->sbuf.or.payload.block_size.maximum);
        if (nbd_internal_set_block_size (h, min, pref, max) == -1) {
          SET_NEXT_STATE (STATE_DEAD);
          return 0;
        }
        break;
      case NBD_INFO_NAME:
        if (len > sizeof h->sbuf.or.payload.name_desc.info + NBD_MAX_STRING ||
            len < sizeof h->sbuf.or.payload.name_desc.info) {
          SET_NEXT_STATE (STATE_DEAD);
          set_error (0, "handshake: incorrect NBD_INFO_NAME option reply length");
          return 0;
        }
        free (h->canonical_name);
        h->canonical_name = strndup (h->sbuf.or.payload.name_desc.str, len - 2);
        if (h->canonical_name == NULL) {
          SET_NEXT_STATE (STATE_DEAD);
          set_error (errno, "strndup");
          return 0;
        }
        break;
      case NBD_INFO_DESCRIPTION:
        if (len > sizeof h->sbuf.or.payload.name_desc.info + NBD_MAX_STRING ||
            len < sizeof h->sbuf.or.payload.name_desc.info) {
          SET_NEXT_STATE (STATE_DEAD);
          set_error (0, "handshake: incorrect NBD_INFO_DESCRIPTION option reply length");
          return 0;
        }
        free (h->description);
        h->description = strndup (h->sbuf.or.payload.name_desc.str, len - 2);
        if (h->description == NULL) {
          SET_NEXT_STATE (STATE_DEAD);
          set_error (errno, "strndup");
          return 0;
        }
        break;
      default:
        debug (h, "skipping unknown NBD_REP_INFO type %d",
               be16toh (h->sbuf.or.payload.export.info));
        break;
      }
    }
    /* Server is allowed to send any number of NBD_REP_INFO, read next one. */
    h->rbuf = &h->sbuf;
    h->rlen = sizeof (h->sbuf.or.option_reply);
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_GO_RECV_REPLY);
    return 0;
  case NBD_REP_ERR_UNSUP:
    if (h->opt_current == NBD_OPT_GO) {
      debug (h, "server is confused by NBD_OPT_GO, continuing anyway");
      SET_NEXT_STATE (STATE_NEWSTYLE_OPT_EXPORT_NAME_START);
      return 0;
    }
    /* fallthrough */
  default:
    if (handle_reply_error (h) == -1) {
      SET_NEXT_STATE (STATE_DEAD);
      return 0;
    }
    /* Decode expected known errors into a nicer string */
    switch (reply) {
    case NBD_REP_ERR_UNSUP:
      assert (h->opt_current == NBD_OPT_INFO);
      set_error (ENOTSUP, "handshake: server lacks NBD_OPT_INFO support");
      break;
    case NBD_REP_ERR_POLICY:
    case NBD_REP_ERR_PLATFORM:
      set_error (0, "handshake: server policy prevents NBD_OPT_GO");
      break;
    case NBD_REP_ERR_INVALID:
    case NBD_REP_ERR_TOO_BIG:
      set_error (EINVAL, "handshake: server rejected NBD_OPT_GO as invalid");
      break;
    case NBD_REP_ERR_TLS_REQD:
      set_error (ENOTSUP, "handshake: server requires TLS encryption first");
      break;
    case NBD_REP_ERR_UNKNOWN:
      set_error (ENOENT, "handshake: server has no export named '%s'",
                 h->export_name);
      break;
    case NBD_REP_ERR_SHUTDOWN:
      set_error (ESHUTDOWN, "handshake: server is shutting down");
      break;
    case NBD_REP_ERR_BLOCK_SIZE_REQD:
      set_error (EINVAL, "handshake: server requires specific block sizes");
      break;
    default:
      set_error (0, "handshake: unknown reply from NBD_OPT_GO: 0x%" PRIx32,
                 reply);
    }
    nbd_internal_reset_size_and_flags (h);
    err = nbd_get_errno () ? : ENOTSUP;
    break;
  case NBD_REP_ACK:
    err = 0;
    break;
  }

  if (err == 0 && h->opt_current == NBD_OPT_GO)
    SET_NEXT_STATE (STATE_NEWSTYLE_FINISHED);
  else if (h->opt_mode)
    SET_NEXT_STATE (STATE_NEGOTIATING);
  else
    SET_NEXT_STATE (STATE_NEWSTYLE_PREPARE_OPT_ABORT);
  CALL_CALLBACK (h->opt_cb.completion, &err);
  nbd_internal_free_option (h);
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_GO_CHECK_REPLY (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_GO_CHECK_REPLY;

  r = enter_STATE_NEWSTYLE_OPT_GO_CHECK_REPLY (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_GO.CHECK_REPLY",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_EXPORT_NAME.START: Try to send newstyle NBD_OPT_EXPORT_NAME to end handshake */
static int
enter_STATE_NEWSTYLE_OPT_EXPORT_NAME_START (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 22 "generator/states-newstyle-opt-export-name.c"

  h->sbuf.option.version = htobe64 (NBD_NEW_VERSION);
  h->sbuf.option.option = htobe32 (NBD_OPT_EXPORT_NAME);
  h->sbuf.option.optlen = htobe32 (strlen (h->export_name));
  h->wbuf = &h->sbuf;
  h->wlen = sizeof h->sbuf.option;
  h->wflags = MSG_MORE;
  SET_NEXT_STATE (STATE_NEWSTYLE_OPT_EXPORT_NAME_SEND);
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_EXPORT_NAME_START (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_EXPORT_NAME_START;

  r = enter_STATE_NEWSTYLE_OPT_EXPORT_NAME_START (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_EXPORT_NAME.START",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_EXPORT_NAME.SEND: Send newstyle NBD_OPT_EXPORT_NAME to end handshake */
static int
enter_STATE_NEWSTYLE_OPT_EXPORT_NAME_SEND (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 32 "generator/states-newstyle-opt-export-name.c"

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    h->wbuf = h->export_name;
    h->wlen = strlen (h->export_name);
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_EXPORT_NAME_SEND_EXPORT);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_EXPORT_NAME_SEND (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_EXPORT_NAME_SEND;

  r = enter_STATE_NEWSTYLE_OPT_EXPORT_NAME_SEND (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_EXPORT_NAME.SEND",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_EXPORT_NAME.SEND_EXPORT: Send newstyle NBD_OPT_EXPORT_NAME export name */
static int
enter_STATE_NEWSTYLE_OPT_EXPORT_NAME_SEND_EXPORT (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 42 "generator/states-newstyle-opt-export-name.c"

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    h->rbuf = &h->sbuf;
    h->rlen = sizeof h->sbuf.export_name_reply;
    if ((h->gflags & LIBNBD_HANDSHAKE_FLAG_NO_ZEROES) != 0)
      h->rlen -= sizeof h->sbuf.export_name_reply.zeroes;
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_EXPORT_NAME_RECV_REPLY);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_EXPORT_NAME_SEND_EXPORT (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_EXPORT_NAME_SEND_EXPORT;

  r = enter_STATE_NEWSTYLE_OPT_EXPORT_NAME_SEND_EXPORT (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_EXPORT_NAME.SEND_EXPORT",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_EXPORT_NAME.RECV_REPLY: Receive newstyle NBD_OPT_EXPORT_NAME reply */
static int
enter_STATE_NEWSTYLE_OPT_EXPORT_NAME_RECV_REPLY (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 54 "generator/states-newstyle-opt-export-name.c"

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:  SET_NEXT_STATE (STATE_NEWSTYLE_OPT_EXPORT_NAME_CHECK_REPLY);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_EXPORT_NAME_RECV_REPLY (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_EXPORT_NAME_RECV_REPLY;

  r = enter_STATE_NEWSTYLE_OPT_EXPORT_NAME_RECV_REPLY (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_EXPORT_NAME.RECV_REPLY",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_EXPORT_NAME.CHECK_REPLY: Check newstyle NBD_OPT_EXPORT_NAME reply */
static int
enter_STATE_NEWSTYLE_OPT_EXPORT_NAME_CHECK_REPLY (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 61 "generator/states-newstyle-opt-export-name.c"

  uint64_t exportsize;
  uint16_t eflags;
  int err = 0;

  exportsize = be64toh (h->sbuf.export_name_reply.exportsize);
  eflags = be16toh (h->sbuf.export_name_reply.eflags);
  if (nbd_internal_set_size_and_flags (h, exportsize, eflags) == -1) {
    SET_NEXT_STATE (STATE_DEAD);
    return 0;
  }
  SET_NEXT_STATE (STATE_NEWSTYLE_FINISHED);
  CALL_CALLBACK (h->opt_cb.completion, &err);
  nbd_internal_free_option (h);
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_EXPORT_NAME_CHECK_REPLY (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_EXPORT_NAME_CHECK_REPLY;

  r = enter_STATE_NEWSTYLE_OPT_EXPORT_NAME_CHECK_REPLY (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_EXPORT_NAME.CHECK_REPLY",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_LIST.START: Start listing exports if in list mode. */
static int
enter_STATE_NEWSTYLE_OPT_LIST_START (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 25 "generator/states-newstyle-opt-list.c"

  assert (h->gflags & LIBNBD_HANDSHAKE_FLAG_FIXED_NEWSTYLE);
  assert (h->opt_mode && h->opt_current == NBD_OPT_LIST);
  assert (CALLBACK_IS_NOT_NULL (h->opt_cb.fn.list));
  h->sbuf.option.version = htobe64 (NBD_NEW_VERSION);
  h->sbuf.option.option = htobe32 (NBD_OPT_LIST);
  h->sbuf.option.optlen = 0;
  h->wbuf = &h->sbuf;
  h->wlen = sizeof (h->sbuf.option);
  SET_NEXT_STATE (STATE_NEWSTYLE_OPT_LIST_SEND);
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_LIST_START (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_LIST_START;

  r = enter_STATE_NEWSTYLE_OPT_LIST_START (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_LIST.START",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_LIST.SEND: Send newstyle NBD_OPT_LIST to begin listing exports */
static int
enter_STATE_NEWSTYLE_OPT_LIST_SEND (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 37 "generator/states-newstyle-opt-list.c"

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    h->rbuf = &h->sbuf;
    h->rlen = sizeof (h->sbuf.or.option_reply);
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_LIST_RECV_REPLY);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_LIST_SEND (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_LIST_SEND;

  r = enter_STATE_NEWSTYLE_OPT_LIST_SEND (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_LIST.SEND",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_LIST.RECV_REPLY: Receive NBD_REP_SERVER reply */
static int
enter_STATE_NEWSTYLE_OPT_LIST_RECV_REPLY (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 47 "generator/states-newstyle-opt-list.c"

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    if (prepare_for_reply_payload (h, NBD_OPT_LIST) == -1) {
      SET_NEXT_STATE (STATE_DEAD);
      return 0;
    }
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_LIST_RECV_REPLY_PAYLOAD);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_LIST_RECV_REPLY (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_LIST_RECV_REPLY;

  r = enter_STATE_NEWSTYLE_OPT_LIST_RECV_REPLY (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_LIST.RECV_REPLY",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_LIST.RECV_REPLY_PAYLOAD: Receive NBD_REP_SERVER reply payload */
static int
enter_STATE_NEWSTYLE_OPT_LIST_RECV_REPLY_PAYLOAD (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 59 "generator/states-newstyle-opt-list.c"

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:  SET_NEXT_STATE (STATE_NEWSTYLE_OPT_LIST_CHECK_REPLY);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_LIST_RECV_REPLY_PAYLOAD (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_LIST_RECV_REPLY_PAYLOAD;

  r = enter_STATE_NEWSTYLE_OPT_LIST_RECV_REPLY_PAYLOAD (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_LIST.RECV_REPLY_PAYLOAD",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.OPT_LIST.CHECK_REPLY: Check NBD_REP_SERVER reply */
static int
enter_STATE_NEWSTYLE_OPT_LIST_CHECK_REPLY (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 66 "generator/states-newstyle-opt-list.c"

  const size_t maxpayload = sizeof h->sbuf.or.payload.server;
  uint32_t reply;
  uint32_t len;
  uint32_t elen;
  const char *name;
  const char *desc;
  char *tmp;
  int err;

  reply = be32toh (h->sbuf.or.option_reply.reply);
  len = be32toh (h->sbuf.or.option_reply.replylen);
  switch (reply) {
  case NBD_REP_SERVER:
    /* Got one export. */
    if (len >= maxpayload)
      debug (h, "skipping too large export name reply");
    else {
      /* server.str is oversized for trailing NUL byte convenience */
      h->sbuf.or.payload.server.str[len - 4] = '\0';
      elen = be32toh (h->sbuf.or.payload.server.server.export_name_len);
      if (elen > len - 4 || elen > NBD_MAX_STRING ||
          len - 4 - elen > NBD_MAX_STRING) {
        set_error (0, "invalid export length");
        SET_NEXT_STATE (STATE_DEAD);
        return 0;
      }
      if (elen == len + 4) {
        tmp = NULL;
        name = h->sbuf.or.payload.server.str;
        desc = "";
      }
      else {
        tmp = strndup (h->sbuf.or.payload.server.str, elen);
        if (tmp == NULL) {
          set_error (errno, "strdup");
          SET_NEXT_STATE (STATE_DEAD);
          return 0;
        }
        name = tmp;
        desc = h->sbuf.or.payload.server.str + elen;
      }
      CALL_CALLBACK (h->opt_cb.fn.list, name, desc);
      free (tmp);
    }

    /* Wait for more replies. */
    h->rbuf = &h->sbuf;
    h->rlen = sizeof (h->sbuf.or.option_reply);
    SET_NEXT_STATE (STATE_NEWSTYLE_OPT_LIST_RECV_REPLY);
    return 0;

  case NBD_REP_ACK:
    /* Finished receiving the list. */
    err = 0;
    break;

  default:
    if (handle_reply_error (h) == -1) {
      SET_NEXT_STATE (STATE_DEAD);
      return 0;
    }
    err = ENOTSUP;
    set_error (err, "unexpected response, possibly the server does not "
               "support listing exports");
    break;
  }

  CALL_CALLBACK (h->opt_cb.completion, &err);
  nbd_internal_free_option (h);
  SET_NEXT_STATE (STATE_NEGOTIATING);
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_OPT_LIST_CHECK_REPLY (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_OPT_LIST_CHECK_REPLY;

  r = enter_STATE_NEWSTYLE_OPT_LIST_CHECK_REPLY (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.OPT_LIST.CHECK_REPLY",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.PREPARE_OPT_ABORT: Prepare to send NBD_OPT_ABORT */
static int
enter_STATE_NEWSTYLE_PREPARE_OPT_ABORT (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 200 "generator/states-newstyle.c"

  assert ((h->gflags & LIBNBD_HANDSHAKE_FLAG_FIXED_NEWSTYLE) != 0);
  h->sbuf.option.version = htobe64 (NBD_NEW_VERSION);
  h->sbuf.option.option = htobe32 (NBD_OPT_ABORT);
  h->sbuf.option.optlen = htobe32 (0);
  h->wbuf = &h->sbuf;
  h->wlen = sizeof h->sbuf.option;
  SET_NEXT_STATE (STATE_NEWSTYLE_SEND_OPT_ABORT);
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_PREPARE_OPT_ABORT (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_PREPARE_OPT_ABORT;

  r = enter_STATE_NEWSTYLE_PREPARE_OPT_ABORT (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.PREPARE_OPT_ABORT",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.SEND_OPT_ABORT: Send NBD_OPT_ABORT to end negotiation */
static int
enter_STATE_NEWSTYLE_SEND_OPT_ABORT (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 210 "generator/states-newstyle.c"

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:
    SET_NEXT_STATE (STATE_NEWSTYLE_SEND_OPTION_SHUTDOWN);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_SEND_OPT_ABORT (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_SEND_OPT_ABORT;

  r = enter_STATE_NEWSTYLE_SEND_OPT_ABORT (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.SEND_OPT_ABORT",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.SEND_OPTION_SHUTDOWN: Sending write shutdown notification to the remote server */
static int
enter_STATE_NEWSTYLE_SEND_OPTION_SHUTDOWN (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 218 "generator/states-newstyle.c"

  /* We don't care if the server replies to NBD_OPT_ABORT.  However,
   * unless we are in opt mode, we want to preserve the error message
   * from a failed OPT_GO by moving to DEAD instead.
   */
  if (h->sock->ops->shut_writes (h, h->sock)) {
    if (h->opt_mode)
      SET_NEXT_STATE (STATE_CLOSED);
    else
      SET_NEXT_STATE (STATE_DEAD);
  }
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_SEND_OPTION_SHUTDOWN (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_SEND_OPTION_SHUTDOWN;

  r = enter_STATE_NEWSTYLE_SEND_OPTION_SHUTDOWN (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.SEND_OPTION_SHUTDOWN",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEWSTYLE.FINISHED: Finish off newstyle negotiation */
static int
enter_STATE_NEWSTYLE_FINISHED (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 231 "generator/states-newstyle.c"

  SET_NEXT_STATE (STATE_READY);
  return 0;

}

int
nbd_internal_enter_STATE_NEWSTYLE_FINISHED (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEWSTYLE_FINISHED;

  r = enter_STATE_NEWSTYLE_FINISHED (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEWSTYLE.FINISHED",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* NEGOTIATING: Connection is ready to negotiate an NBD option */
static int
enter_STATE_NEGOTIATING (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
  return 0;
}

int
nbd_internal_enter_STATE_NEGOTIATING (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_NEGOTIATING;

  r = enter_STATE_NEGOTIATING (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "NEGOTIATING",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* READY: Connection is ready to process NBD commands */
static int
enter_STATE_READY (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 168 "generator/states.c"

  if (h->cmds_to_issue)
    SET_NEXT_STATE (STATE_ISSUE_COMMAND_START);
  else {
    assert (h->sock);
    if (h->sock->ops->pending && h->sock->ops->pending (h->sock))
      SET_NEXT_STATE (STATE_REPLY_START);
  }
  return 0;

}

int
nbd_internal_enter_STATE_READY (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_READY;

  r = enter_STATE_READY (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "READY",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* ISSUE_COMMAND.START: Begin issuing a command to the remote server */
static int
enter_STATE_ISSUE_COMMAND_START (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 22 "generator/states-issue-command.c"

  struct command *cmd;

  assert (h->cmds_to_issue != NULL);
  cmd = h->cmds_to_issue;

  /* Were we interrupted by reading a reply to an earlier command? If
   * so, we can only get back here after a non-blocking jaunt through
   * the REPLY engine, which means we are unlikely to be unblocked for
   * writes yet; we want to advance back to the correct state but
   * without trying a send_from_wbuf that will likely return 1.
   */
  if (h->in_write_shutdown)
    SET_NEXT_STATE_AND_BLOCK (STATE_ISSUE_COMMAND_SEND_WRITE_SHUTDOWN);
  else if (h->wlen) {
    if (h->in_write_payload)
      SET_NEXT_STATE_AND_BLOCK (STATE_ISSUE_COMMAND_SEND_WRITE_PAYLOAD);
    else
      SET_NEXT_STATE_AND_BLOCK (STATE_ISSUE_COMMAND_SEND_REQUEST);
    return 0;
  }

  h->request.magic = htobe32 (NBD_REQUEST_MAGIC);
  h->request.flags = htobe16 (cmd->flags);
  h->request.type = htobe16 (cmd->type);
  h->request.handle = htobe64 (cmd->cookie);
  h->request.offset = htobe64 (cmd->offset);
  h->request.count = htobe32 ((uint32_t) cmd->count);
  h->wbuf = &h->request;
  h->wlen = sizeof (h->request);
  if (cmd->type == NBD_CMD_WRITE || cmd->next)
    h->wflags = MSG_MORE;
  SET_NEXT_STATE (STATE_ISSUE_COMMAND_SEND_REQUEST);
  return 0;

}

int
nbd_internal_enter_STATE_ISSUE_COMMAND_START (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_ISSUE_COMMAND_START;

  r = enter_STATE_ISSUE_COMMAND_START (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "ISSUE_COMMAND.START",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* ISSUE_COMMAND.SEND_REQUEST: Sending a request to the remote server */
static int
enter_STATE_ISSUE_COMMAND_SEND_REQUEST (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 57 "generator/states-issue-command.c"

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:  SET_NEXT_STATE (STATE_ISSUE_COMMAND_PREPARE_WRITE_PAYLOAD);
  }
  return 0;

}

int
nbd_internal_enter_STATE_ISSUE_COMMAND_SEND_REQUEST (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_ISSUE_COMMAND_SEND_REQUEST;

  r = enter_STATE_ISSUE_COMMAND_SEND_REQUEST (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "ISSUE_COMMAND.SEND_REQUEST",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* ISSUE_COMMAND.PAUSE_SEND_REQUEST: Interrupt send request to receive an earlier command's reply */
static int
enter_STATE_ISSUE_COMMAND_PAUSE_SEND_REQUEST (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 64 "generator/states-issue-command.c"

  assert (h->wlen);
  assert (h->cmds_to_issue != NULL);
  h->in_write_payload = false;
  SET_NEXT_STATE (STATE_REPLY_START);
  return 0;

}

int
nbd_internal_enter_STATE_ISSUE_COMMAND_PAUSE_SEND_REQUEST (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_ISSUE_COMMAND_PAUSE_SEND_REQUEST;

  r = enter_STATE_ISSUE_COMMAND_PAUSE_SEND_REQUEST (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "ISSUE_COMMAND.PAUSE_SEND_REQUEST",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* ISSUE_COMMAND.PREPARE_WRITE_PAYLOAD: Prepare the write payload to send to the remote server */
static int
enter_STATE_ISSUE_COMMAND_PREPARE_WRITE_PAYLOAD (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 71 "generator/states-issue-command.c"

  struct command *cmd;

  assert (h->cmds_to_issue != NULL);
  cmd = h->cmds_to_issue;
  assert (cmd->cookie == be64toh (h->request.handle));
  if (cmd->type == NBD_CMD_WRITE) {
    h->wbuf = cmd->data;
    h->wlen = cmd->count;
    if (cmd->next && cmd->count < 64 * 1024)
      h->wflags = MSG_MORE;
    SET_NEXT_STATE (STATE_ISSUE_COMMAND_SEND_WRITE_PAYLOAD);
  }
  else if (cmd->type == NBD_CMD_DISC) {
    h->in_write_shutdown = true;
    SET_NEXT_STATE (STATE_ISSUE_COMMAND_SEND_WRITE_SHUTDOWN);
  }
  else
    SET_NEXT_STATE (STATE_ISSUE_COMMAND_FINISH);
  return 0;

}

int
nbd_internal_enter_STATE_ISSUE_COMMAND_PREPARE_WRITE_PAYLOAD (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_ISSUE_COMMAND_PREPARE_WRITE_PAYLOAD;

  r = enter_STATE_ISSUE_COMMAND_PREPARE_WRITE_PAYLOAD (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "ISSUE_COMMAND.PREPARE_WRITE_PAYLOAD",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* ISSUE_COMMAND.SEND_WRITE_PAYLOAD: Sending the write payload to the remote server */
static int
enter_STATE_ISSUE_COMMAND_SEND_WRITE_PAYLOAD (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 92 "generator/states-issue-command.c"

  switch (send_from_wbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 0:  SET_NEXT_STATE (STATE_ISSUE_COMMAND_FINISH);
  }
  return 0;

}

int
nbd_internal_enter_STATE_ISSUE_COMMAND_SEND_WRITE_PAYLOAD (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_ISSUE_COMMAND_SEND_WRITE_PAYLOAD;

  r = enter_STATE_ISSUE_COMMAND_SEND_WRITE_PAYLOAD (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "ISSUE_COMMAND.SEND_WRITE_PAYLOAD",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* ISSUE_COMMAND.PAUSE_WRITE_PAYLOAD: Interrupt write payload to receive an earlier command's reply */
static int
enter_STATE_ISSUE_COMMAND_PAUSE_WRITE_PAYLOAD (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 99 "generator/states-issue-command.c"

  assert (h->wlen);
  assert (h->cmds_to_issue != NULL);
  h->in_write_payload = true;
  SET_NEXT_STATE (STATE_REPLY_START);
  return 0;

}

int
nbd_internal_enter_STATE_ISSUE_COMMAND_PAUSE_WRITE_PAYLOAD (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_ISSUE_COMMAND_PAUSE_WRITE_PAYLOAD;

  r = enter_STATE_ISSUE_COMMAND_PAUSE_WRITE_PAYLOAD (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "ISSUE_COMMAND.PAUSE_WRITE_PAYLOAD",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* ISSUE_COMMAND.SEND_WRITE_SHUTDOWN: Sending write shutdown notification to the remote server */
static int
enter_STATE_ISSUE_COMMAND_SEND_WRITE_SHUTDOWN (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 106 "generator/states-issue-command.c"

  if (h->sock->ops->shut_writes (h, h->sock))
    SET_NEXT_STATE (STATE_ISSUE_COMMAND_FINISH);
  return 0;

}

int
nbd_internal_enter_STATE_ISSUE_COMMAND_SEND_WRITE_SHUTDOWN (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_ISSUE_COMMAND_SEND_WRITE_SHUTDOWN;

  r = enter_STATE_ISSUE_COMMAND_SEND_WRITE_SHUTDOWN (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "ISSUE_COMMAND.SEND_WRITE_SHUTDOWN",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* ISSUE_COMMAND.PAUSE_WRITE_SHUTDOWN: Interrupt write shutdown to receive an earlier command's reply */
static int
enter_STATE_ISSUE_COMMAND_PAUSE_WRITE_SHUTDOWN (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 111 "generator/states-issue-command.c"

  assert (h->in_write_shutdown);
  SET_NEXT_STATE (STATE_REPLY_START);
  return 0;

}

int
nbd_internal_enter_STATE_ISSUE_COMMAND_PAUSE_WRITE_SHUTDOWN (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_ISSUE_COMMAND_PAUSE_WRITE_SHUTDOWN;

  r = enter_STATE_ISSUE_COMMAND_PAUSE_WRITE_SHUTDOWN (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "ISSUE_COMMAND.PAUSE_WRITE_SHUTDOWN",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* ISSUE_COMMAND.FINISH: Finish issuing a command */
static int
enter_STATE_ISSUE_COMMAND_FINISH (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 116 "generator/states-issue-command.c"

  struct command *cmd;

  assert (!h->wlen);
  assert (h->cmds_to_issue != NULL);
  cmd = h->cmds_to_issue;
  assert (cmd->cookie == be64toh (h->request.handle));
  h->cmds_to_issue = cmd->next;
  if (h->cmds_to_issue_tail == cmd)
    h->cmds_to_issue_tail = NULL;
  cmd->next = h->cmds_in_flight;
  h->cmds_in_flight = cmd;
  SET_NEXT_STATE (STATE_READY);
  return 0;

}

int
nbd_internal_enter_STATE_ISSUE_COMMAND_FINISH (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_ISSUE_COMMAND_FINISH;

  r = enter_STATE_ISSUE_COMMAND_FINISH (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "ISSUE_COMMAND.FINISH",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* REPLY.START: Prepare to receive a reply from the remote server */
static int
enter_STATE_REPLY_START (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 42 "generator/states-reply.c"

  /* If rlen is non-zero, we are resuming an earlier reply cycle. */
  if (h->rlen > 0) {
    if (h->reply_cmd) {
      assert (nbd_internal_is_state_processing (h->reply_cmd->state));
      SET_NEXT_STATE (h->reply_cmd->state);
    }
    else
      SET_NEXT_STATE (STATE_REPLY_RECV_REPLY);
    return 0;
  }

  /* This state is entered when a read notification is received in the
   * READY state.  Therefore we know the socket is readable here.
   * Reading a zero length now would indicate that the socket has been
   * closed by the server and so we should jump to the CLOSED state.
   * However recv_into_rbuf will fail in this case, so test it as a
   * special case.
   */
  ssize_t r;

  /* We read all replies initially as if they are simple replies, but
   * check the magic in CHECK_SIMPLE_OR_STRUCTURED_REPLY below.
   * This works because the structured_reply header is larger.
   */
  assert (h->reply_cmd == NULL);
  assert (h->rlen == 0);

  h->rbuf = &h->sbuf;
  h->rlen = sizeof h->sbuf.simple_reply;

  r = h->sock->ops->recv (h, h->sock, h->rbuf, h->rlen);
  if (r == -1) {
    /* This should never happen because when we enter this state we
     * should have notification that the socket is ready to read.
     * However if for some reason it does happen, ignore it - we will
     * reenter this same state again next time the socket is ready to
     * read.
     */
    if (errno == EAGAIN || errno == EWOULDBLOCK)
      return 0;

    /* sock->ops->recv called set_error already. */
    SET_NEXT_STATE (STATE_DEAD);
    return 0;
  }
  if (r == 0) {
    SET_NEXT_STATE (STATE_CLOSED);
    return 0;
  }
#ifdef DUMP_PACKETS
  if (h->rbuf != NULL)
    nbd_internal_hexdump (h->rbuf, r, stderr);
#endif

  h->rbuf += r;
  h->rlen -= r;
  SET_NEXT_STATE (STATE_REPLY_RECV_REPLY);
  return 0;

}

int
nbd_internal_enter_STATE_REPLY_START (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_REPLY_START;

  r = enter_STATE_REPLY_START (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "REPLY.START",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* REPLY.RECV_REPLY: Receive a reply from the remote server */
static int
enter_STATE_REPLY_RECV_REPLY (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 102 "generator/states-reply.c"

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 1: SET_NEXT_STATE (STATE_READY); return 0;
  case 0: SET_NEXT_STATE (STATE_REPLY_CHECK_SIMPLE_OR_STRUCTURED_REPLY);
  }
  return 0;

}

int
nbd_internal_enter_STATE_REPLY_RECV_REPLY (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_REPLY_RECV_REPLY;

  r = enter_STATE_REPLY_RECV_REPLY (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "REPLY.RECV_REPLY",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* REPLY.CHECK_SIMPLE_OR_STRUCTURED_REPLY: Check if the reply is a simple or structured reply */
static int
enter_STATE_REPLY_CHECK_SIMPLE_OR_STRUCTURED_REPLY (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 110 "generator/states-reply.c"

  struct command *cmd;
  uint32_t magic;
  uint64_t cookie;

  magic = be32toh (h->sbuf.simple_reply.magic);
  if (magic == NBD_SIMPLE_REPLY_MAGIC) {
    SET_NEXT_STATE (STATE_REPLY_SIMPLE_REPLY_START);
  }
  else if (magic == NBD_STRUCTURED_REPLY_MAGIC) {
    SET_NEXT_STATE (STATE_REPLY_STRUCTURED_REPLY_START);
  }
  else {
    SET_NEXT_STATE (STATE_DEAD); /* We've probably lost synchronization. */
    set_error (0, "invalid reply magic");
    return 0;
  }

  /* NB: This works for both simple and structured replies because the
   * handle (our cookie) is stored at the same offset.
   */
  cookie = be64toh (h->sbuf.simple_reply.handle);
  /* Find the command amongst the commands in flight. */
  for (cmd = h->cmds_in_flight; cmd != NULL; cmd = cmd->next) {
    if (cmd->cookie == cookie)
      break;
  }
  if (cmd == NULL) {
    /* An unexpected structured reply could be skipped, since it
     * includes a length; similarly an unexpected simple reply can be
     * skipped if we assume it was not a read. However, it's more
     * likely we've lost synchronization with the server.
     */
    SET_NEXT_STATE (STATE_DEAD);
    set_error (0, "no matching cookie found for server reply, "
               "this is probably a bug in the server");
    return 0;
  }
  h->reply_cmd = cmd;
  return 0;

}

int
nbd_internal_enter_STATE_REPLY_CHECK_SIMPLE_OR_STRUCTURED_REPLY (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_REPLY_CHECK_SIMPLE_OR_STRUCTURED_REPLY;

  r = enter_STATE_REPLY_CHECK_SIMPLE_OR_STRUCTURED_REPLY (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "REPLY.CHECK_SIMPLE_OR_STRUCTURED_REPLY",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* REPLY.SIMPLE_REPLY.START: Parse a simple reply from the server */
static int
enter_STATE_REPLY_SIMPLE_REPLY_START (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 22 "generator/states-reply-simple.c"

  struct command *cmd = h->reply_cmd;
  uint32_t error;
  uint64_t cookie;

  error = be32toh (h->sbuf.simple_reply.error);
  cookie = be64toh (h->sbuf.simple_reply.handle);

  assert (cmd);
  assert (cmd->cookie == cookie);

  if (cmd->type == NBD_CMD_READ && h->structured_replies) {
    set_error (0, "server sent unexpected simple reply for read");
    SET_NEXT_STATE(STATE_DEAD);
    return 0;
  }

  cmd->error = nbd_internal_errno_of_nbd_error (error);
  if (cmd->error == 0 && cmd->type == NBD_CMD_READ) {
    h->rbuf = cmd->data;
    h->rlen = cmd->count;
    cmd->data_seen = true;
    SET_NEXT_STATE (STATE_REPLY_SIMPLE_REPLY_RECV_READ_PAYLOAD);
  }
  else {
    SET_NEXT_STATE (STATE_REPLY_FINISH_COMMAND);
  }
  return 0;

}

int
nbd_internal_enter_STATE_REPLY_SIMPLE_REPLY_START (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_REPLY_SIMPLE_REPLY_START;

  r = enter_STATE_REPLY_SIMPLE_REPLY_START (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "REPLY.SIMPLE_REPLY.START",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* REPLY.SIMPLE_REPLY.RECV_READ_PAYLOAD: Receiving the read payload for a simple reply */
static int
enter_STATE_REPLY_SIMPLE_REPLY_RECV_READ_PAYLOAD (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 51 "generator/states-reply-simple.c"

  struct command *cmd = h->reply_cmd;

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 1:
    save_reply_state (h);
    SET_NEXT_STATE (STATE_READY);
    return 0;
  case 0:
    /* guaranteed by START */
    assert (cmd);
    if (CALLBACK_IS_NOT_NULL (cmd->cb.fn.chunk)) {
      int error = 0;

      assert (cmd->error == 0);
      if (CALL_CALLBACK (cmd->cb.fn.chunk,
                         cmd->data, cmd->count,
                         cmd->offset, LIBNBD_READ_DATA,
                         &error) == -1)
        cmd->error = error ? error : EPROTO;
    }

    SET_NEXT_STATE (STATE_REPLY_FINISH_COMMAND);
  }
  return 0;

}

int
nbd_internal_enter_STATE_REPLY_SIMPLE_REPLY_RECV_READ_PAYLOAD (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_REPLY_SIMPLE_REPLY_RECV_READ_PAYLOAD;

  r = enter_STATE_REPLY_SIMPLE_REPLY_RECV_READ_PAYLOAD (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "REPLY.SIMPLE_REPLY.RECV_READ_PAYLOAD",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* REPLY.STRUCTURED_REPLY.START: Prepare to receive the remaining part of a structured reply */
static int
enter_STATE_REPLY_STRUCTURED_REPLY_START (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 47 "generator/states-reply-structured.c"

  /* We've only read the simple_reply.  The structured_reply is longer,
   * so read the remaining part.
   */
  if (!h->structured_replies) {
    set_error (0, "server sent unexpected structured reply");
    SET_NEXT_STATE(STATE_DEAD);
    return 0;
  }
  h->rbuf = &h->sbuf;
  h->rbuf += sizeof h->sbuf.simple_reply;
  h->rlen = sizeof h->sbuf.sr.structured_reply;
  h->rlen -= sizeof h->sbuf.simple_reply;
  SET_NEXT_STATE (STATE_REPLY_STRUCTURED_REPLY_RECV_REMAINING);
  return 0;

}

int
nbd_internal_enter_STATE_REPLY_STRUCTURED_REPLY_START (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_REPLY_STRUCTURED_REPLY_START;

  r = enter_STATE_REPLY_STRUCTURED_REPLY_START (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "REPLY.STRUCTURED_REPLY.START",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* REPLY.STRUCTURED_REPLY.RECV_REMAINING: Receiving the remaining part of a structured reply */
static int
enter_STATE_REPLY_STRUCTURED_REPLY_RECV_REMAINING (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 63 "generator/states-reply-structured.c"

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 1:
    save_reply_state (h);
    SET_NEXT_STATE (STATE_READY);
    return 0;
  case 0:  SET_NEXT_STATE (STATE_REPLY_STRUCTURED_REPLY_CHECK);
  }
  return 0;

}

int
nbd_internal_enter_STATE_REPLY_STRUCTURED_REPLY_RECV_REMAINING (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_REPLY_STRUCTURED_REPLY_RECV_REMAINING;

  r = enter_STATE_REPLY_STRUCTURED_REPLY_RECV_REMAINING (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "REPLY.STRUCTURED_REPLY.RECV_REMAINING",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* REPLY.STRUCTURED_REPLY.CHECK: Parse a structured reply from the server */
static int
enter_STATE_REPLY_STRUCTURED_REPLY_CHECK (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 74 "generator/states-reply-structured.c"

  struct command *cmd = h->reply_cmd;
  uint16_t flags, type;
  uint64_t cookie;
  uint32_t length;

  flags = be16toh (h->sbuf.sr.structured_reply.flags);
  type = be16toh (h->sbuf.sr.structured_reply.type);
  cookie = be64toh (h->sbuf.sr.structured_reply.handle);
  length = be32toh (h->sbuf.sr.structured_reply.length);

  assert (cmd);
  assert (cmd->cookie == cookie);

  /* Reject a server that replies with too much information, but don't
   * reject a single structured reply to NBD_CMD_READ on the largest
   * size we were willing to send. The most likely culprit is a server
   * that replies with block status with way too many extents, but any
   * oversized reply is going to take long enough to resync that it is
   * not worth keeping the connection alive.
   */
  if (length > MAX_REQUEST_SIZE + sizeof h->sbuf.sr.payload.offset_data) {
    set_error (0, "invalid server reply length");
    SET_NEXT_STATE (STATE_DEAD);
    return 0;
  }

  if (NBD_REPLY_TYPE_IS_ERR (type)) {
    if (length < sizeof h->sbuf.sr.payload.error.error) {
      SET_NEXT_STATE (STATE_DEAD);
      set_error (0, "too short length in structured reply error");
      return 0;
    }
    h->rbuf = &h->sbuf.sr.payload.error.error;
    h->rlen = sizeof h->sbuf.sr.payload.error.error;
    SET_NEXT_STATE (STATE_REPLY_STRUCTURED_REPLY_RECV_ERROR);
    return 0;
  }
  else if (type == NBD_REPLY_TYPE_NONE) {
    if (length != 0) {
      SET_NEXT_STATE (STATE_DEAD);
      set_error (0, "invalid length in NBD_REPLY_TYPE_NONE");
      return 0;
    }
    if (!(flags & NBD_REPLY_FLAG_DONE)) {
      SET_NEXT_STATE (STATE_DEAD);
      set_error (0, "NBD_REPLY_FLAG_DONE must be set in NBD_REPLY_TYPE_NONE");
      return 0;
    }
    SET_NEXT_STATE (STATE_REPLY_STRUCTURED_REPLY_FINISH);
    return 0;
  }
  else if (type == NBD_REPLY_TYPE_OFFSET_DATA) {
    /* The spec states that 0-length requests are unspecified, but
     * 0-length replies are broken. Still, it's easy enough to support
     * them as an extension, so we use < instead of <=.
     */
    if (cmd->type != NBD_CMD_READ) {
      SET_NEXT_STATE (STATE_DEAD);
      set_error (0, "invalid command for receiving offset-data chunk, "
                 "cmd->type=%" PRIu16 ", "
                 "this is likely to be a bug in the server",
                 cmd->type);
      return 0;
    }
    if (length < sizeof h->sbuf.sr.payload.offset_data) {
      SET_NEXT_STATE (STATE_DEAD);
      set_error (0, "too short length in NBD_REPLY_TYPE_OFFSET_DATA");
      return 0;
    }
    h->rbuf = &h->sbuf.sr.payload.offset_data;
    h->rlen = sizeof h->sbuf.sr.payload.offset_data;
    SET_NEXT_STATE (STATE_REPLY_STRUCTURED_REPLY_RECV_OFFSET_DATA);
    return 0;
  }
  else if (type == NBD_REPLY_TYPE_OFFSET_HOLE) {
    if (cmd->type != NBD_CMD_READ) {
      SET_NEXT_STATE (STATE_DEAD);
      set_error (0, "invalid command for receiving offset-hole chunk, "
                 "cmd->type=%" PRIu16 ", "
                 "this is likely to be a bug in the server",
                 cmd->type);
      return 0;
    }
    if (length != sizeof h->sbuf.sr.payload.offset_hole) {
      SET_NEXT_STATE (STATE_DEAD);
      set_error (0, "invalid length in NBD_REPLY_TYPE_OFFSET_HOLE");
      return 0;
    }
    h->rbuf = &h->sbuf.sr.payload.offset_hole;
    h->rlen = sizeof h->sbuf.sr.payload.offset_hole;
    SET_NEXT_STATE (STATE_REPLY_STRUCTURED_REPLY_RECV_OFFSET_HOLE);
    return 0;
  }
  else if (type == NBD_REPLY_TYPE_BLOCK_STATUS) {
    if (cmd->type != NBD_CMD_BLOCK_STATUS) {
      SET_NEXT_STATE (STATE_DEAD);
      set_error (0, "invalid command for receiving block-status chunk, "
                 "cmd->type=%" PRIu16 ", "
                 "this is likely to be a bug in the server",
                 cmd->type);
      return 0;
    }
    /* XXX We should be able to skip the bad reply in these two cases. */
    if (length < 12 || ((length-4) & 7) != 0) {
      SET_NEXT_STATE (STATE_DEAD);
      set_error (0, "invalid length in NBD_REPLY_TYPE_BLOCK_STATUS");
      return 0;
    }
    if (CALLBACK_IS_NULL (cmd->cb.fn.extent)) {
      SET_NEXT_STATE (STATE_DEAD);
      set_error (0, "not expecting NBD_REPLY_TYPE_BLOCK_STATUS here");
      return 0;
    }
    /* We read the context ID followed by all the entries into a
     * single array and deal with it at the end.
     */
    free (h->bs_entries);
    h->bs_entries = malloc (length);
    if (h->bs_entries == NULL) {
      SET_NEXT_STATE (STATE_DEAD);
      set_error (errno, "malloc");
      return 0;
    }
    h->rbuf = h->bs_entries;
    h->rlen = length;
    SET_NEXT_STATE (STATE_REPLY_STRUCTURED_REPLY_RECV_BS_ENTRIES);
    return 0;
  }
  else {
    SET_NEXT_STATE (STATE_DEAD);
    set_error (0, "unknown structured reply type (%" PRIu16 ")", type);
    return 0;
  }

}

int
nbd_internal_enter_STATE_REPLY_STRUCTURED_REPLY_CHECK (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_REPLY_STRUCTURED_REPLY_CHECK;

  r = enter_STATE_REPLY_STRUCTURED_REPLY_CHECK (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "REPLY.STRUCTURED_REPLY.CHECK",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* REPLY.STRUCTURED_REPLY.RECV_ERROR: Receive a structured reply error header */
static int
enter_STATE_REPLY_STRUCTURED_REPLY_RECV_ERROR (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 209 "generator/states-reply-structured.c"

  uint32_t length, msglen;

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 1:
    save_reply_state (h);
    SET_NEXT_STATE (STATE_READY);
    return 0;
  case 0:
    length = be32toh (h->sbuf.sr.structured_reply.length);
    msglen = be16toh (h->sbuf.sr.payload.error.error.len);
    if (msglen > length - sizeof h->sbuf.sr.payload.error.error ||
        msglen > sizeof h->sbuf.sr.payload.error.msg) {
      SET_NEXT_STATE (STATE_DEAD);
      set_error (0, "error message length too large");
      return 0;
    }

    h->rbuf = h->sbuf.sr.payload.error.msg;
    h->rlen = msglen;
    SET_NEXT_STATE (STATE_REPLY_STRUCTURED_REPLY_RECV_ERROR_MESSAGE);
  }
  return 0;

}

int
nbd_internal_enter_STATE_REPLY_STRUCTURED_REPLY_RECV_ERROR (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_REPLY_STRUCTURED_REPLY_RECV_ERROR;

  r = enter_STATE_REPLY_STRUCTURED_REPLY_RECV_ERROR (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "REPLY.STRUCTURED_REPLY.RECV_ERROR",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* REPLY.STRUCTURED_REPLY.RECV_ERROR_MESSAGE: Receive a structured reply error message */
static int
enter_STATE_REPLY_STRUCTURED_REPLY_RECV_ERROR_MESSAGE (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 234 "generator/states-reply-structured.c"

  uint32_t length, msglen;
  uint16_t type;

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 1:
    save_reply_state (h);
    SET_NEXT_STATE (STATE_READY);
    return 0;
  case 0:
    length = be32toh (h->sbuf.sr.structured_reply.length);
    msglen = be16toh (h->sbuf.sr.payload.error.error.len);
    type = be16toh (h->sbuf.sr.structured_reply.type);

    length -= sizeof h->sbuf.sr.payload.error.error + msglen;

    if (msglen)
      debug (h, "structured error server message: %.*s", (int) msglen,
             h->sbuf.sr.payload.error.msg);

    /* Special case two specific errors; ignore the tail for all others */
    h->rbuf = NULL;
    h->rlen = length;
    switch (type) {
    case NBD_REPLY_TYPE_ERROR:
      if (length != 0) {
        SET_NEXT_STATE (STATE_DEAD);
        set_error (0, "error payload length too large");
        return 0;
      }
      break;
    case NBD_REPLY_TYPE_ERROR_OFFSET:
      if (length != sizeof h->sbuf.sr.payload.error.offset) {
        SET_NEXT_STATE (STATE_DEAD);
        set_error (0, "invalid error payload length");
        return 0;
      }
      h->rbuf = &h->sbuf.sr.payload.error.offset;
      break;
    }
    SET_NEXT_STATE (STATE_REPLY_STRUCTURED_REPLY_RECV_ERROR_TAIL);
  }
  return 0;

}

int
nbd_internal_enter_STATE_REPLY_STRUCTURED_REPLY_RECV_ERROR_MESSAGE (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_REPLY_STRUCTURED_REPLY_RECV_ERROR_MESSAGE;

  r = enter_STATE_REPLY_STRUCTURED_REPLY_RECV_ERROR_MESSAGE (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "REPLY.STRUCTURED_REPLY.RECV_ERROR_MESSAGE",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* REPLY.STRUCTURED_REPLY.RECV_ERROR_TAIL: Receive a structured reply error tail */
static int
enter_STATE_REPLY_STRUCTURED_REPLY_RECV_ERROR_TAIL (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 279 "generator/states-reply-structured.c"

  struct command *cmd = h->reply_cmd;
  uint32_t error;
  uint64_t offset;
  uint16_t type;

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 1:
    save_reply_state (h);
    SET_NEXT_STATE (STATE_READY);
    return 0;
  case 0:
    error = be32toh (h->sbuf.sr.payload.error.error.error);
    type = be16toh (h->sbuf.sr.structured_reply.type);

    assert (cmd); /* guaranteed by CHECK */
    error = nbd_internal_errno_of_nbd_error (error);

    /* The spec requires the server to send a non-zero error */
    if (error == NBD_SUCCESS) {
      debug (h, "server forgot to set error; using EINVAL");
      error = NBD_EINVAL;
    }
    error = nbd_internal_errno_of_nbd_error (error);

    /* Sanity check that any error offset is in range, then invoke
     * user callback if present.
     */
    if (type == NBD_REPLY_TYPE_ERROR_OFFSET) {
      offset = be64toh (h->sbuf.sr.payload.error.offset);
      if (! structured_reply_in_bounds (offset, 0, cmd)) {
        SET_NEXT_STATE (STATE_DEAD);
        return 0;
      }
      if (cmd->type == NBD_CMD_READ &&
          CALLBACK_IS_NOT_NULL (cmd->cb.fn.chunk)) {
        int scratch = error;

        /* Different from successful reads: inform the callback about the
         * current error rather than any earlier one. If the callback fails
         * without setting errno, then use the server's error below.
         */
        if (CALL_CALLBACK (cmd->cb.fn.chunk,
                           cmd->data + (offset - cmd->offset),
                           0, offset, LIBNBD_READ_ERROR,
                           &scratch) == -1)
          if (cmd->error == 0)
            cmd->error = scratch;
      }
    }

    /* Preserve first error encountered */
    if (cmd->error == 0)
      cmd->error = error;

    SET_NEXT_STATE(STATE_REPLY_STRUCTURED_REPLY_FINISH);
  }
  return 0;

}

int
nbd_internal_enter_STATE_REPLY_STRUCTURED_REPLY_RECV_ERROR_TAIL (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_REPLY_STRUCTURED_REPLY_RECV_ERROR_TAIL;

  r = enter_STATE_REPLY_STRUCTURED_REPLY_RECV_ERROR_TAIL (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "REPLY.STRUCTURED_REPLY.RECV_ERROR_TAIL",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* REPLY.STRUCTURED_REPLY.RECV_OFFSET_DATA: Receive a structured reply offset-data header */
static int
enter_STATE_REPLY_STRUCTURED_REPLY_RECV_OFFSET_DATA (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 339 "generator/states-reply-structured.c"

  struct command *cmd = h->reply_cmd;
  uint64_t offset;
  uint32_t length;

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 1:
    save_reply_state (h);
    SET_NEXT_STATE (STATE_READY);
    return 0;
  case 0:
    length = be32toh (h->sbuf.sr.structured_reply.length);
    offset = be64toh (h->sbuf.sr.payload.offset_data.offset);

    assert (cmd); /* guaranteed by CHECK */

    assert (cmd->data && cmd->type == NBD_CMD_READ);
    cmd->data_seen = true;

    /* Length of the data following. */
    length -= 8;

    /* Is the data within bounds? */
    if (! structured_reply_in_bounds (offset, length, cmd)) {
      SET_NEXT_STATE (STATE_DEAD);
      return 0;
    }
    /* Now this is the byte offset in the read buffer. */
    offset -= cmd->offset;

    /* Set up to receive the data directly to the user buffer. */
    h->rbuf = cmd->data + offset;
    h->rlen = length;
    SET_NEXT_STATE (STATE_REPLY_STRUCTURED_REPLY_RECV_OFFSET_DATA_DATA);
  }
  return 0;

}

int
nbd_internal_enter_STATE_REPLY_STRUCTURED_REPLY_RECV_OFFSET_DATA (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_REPLY_STRUCTURED_REPLY_RECV_OFFSET_DATA;

  r = enter_STATE_REPLY_STRUCTURED_REPLY_RECV_OFFSET_DATA (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "REPLY.STRUCTURED_REPLY.RECV_OFFSET_DATA",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* REPLY.STRUCTURED_REPLY.RECV_OFFSET_DATA_DATA: Receive a structured reply offset-data block of data */
static int
enter_STATE_REPLY_STRUCTURED_REPLY_RECV_OFFSET_DATA_DATA (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 377 "generator/states-reply-structured.c"

  struct command *cmd = h->reply_cmd;
  uint64_t offset;
  uint32_t length;

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 1:
    save_reply_state (h);
    SET_NEXT_STATE (STATE_READY);
    return 0;
  case 0:
    length = be32toh (h->sbuf.sr.structured_reply.length);
    offset = be64toh (h->sbuf.sr.payload.offset_data.offset);

    assert (cmd); /* guaranteed by CHECK */
    if (CALLBACK_IS_NOT_NULL (cmd->cb.fn.chunk)) {
      int error = cmd->error;

      if (CALL_CALLBACK (cmd->cb.fn.chunk, cmd->data + (offset - cmd->offset),
                         length - sizeof offset, offset,
                         LIBNBD_READ_DATA, &error) == -1)
        if (cmd->error == 0)
          cmd->error = error ? error : EPROTO;
    }

    SET_NEXT_STATE (STATE_REPLY_STRUCTURED_REPLY_FINISH);
  }
  return 0;

}

int
nbd_internal_enter_STATE_REPLY_STRUCTURED_REPLY_RECV_OFFSET_DATA_DATA (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_REPLY_STRUCTURED_REPLY_RECV_OFFSET_DATA_DATA;

  r = enter_STATE_REPLY_STRUCTURED_REPLY_RECV_OFFSET_DATA_DATA (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "REPLY.STRUCTURED_REPLY.RECV_OFFSET_DATA_DATA",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* REPLY.STRUCTURED_REPLY.RECV_OFFSET_HOLE: Receive a structured reply offset-hole header */
static int
enter_STATE_REPLY_STRUCTURED_REPLY_RECV_OFFSET_HOLE (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 407 "generator/states-reply-structured.c"

  struct command *cmd = h->reply_cmd;
  uint64_t offset;
  uint32_t length;

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 1:
    save_reply_state (h);
    SET_NEXT_STATE (STATE_READY);
    return 0;
  case 0:
    offset = be64toh (h->sbuf.sr.payload.offset_hole.offset);
    length = be32toh (h->sbuf.sr.payload.offset_hole.length);

    assert (cmd); /* guaranteed by CHECK */

    assert (cmd->data && cmd->type == NBD_CMD_READ);
    cmd->data_seen = true;

    /* Is the data within bounds? */
    if (! structured_reply_in_bounds (offset, length, cmd)) {
      SET_NEXT_STATE (STATE_DEAD);
      return 0;
    }
    /* Now this is the byte offset in the read buffer. */
    offset -= cmd->offset;

    /* The spec states that 0-length requests are unspecified, but
     * 0-length replies are broken. Still, it's easy enough to support
     * them as an extension, and this works even when length == 0.
     */
    memset (cmd->data + offset, 0, length);
    if (CALLBACK_IS_NOT_NULL (cmd->cb.fn.chunk)) {
      int error = cmd->error;

      if (CALL_CALLBACK (cmd->cb.fn.chunk,
                         cmd->data + offset, length,
                         cmd->offset + offset,
                         LIBNBD_READ_HOLE, &error) == -1)
        if (cmd->error == 0)
          cmd->error = error ? error : EPROTO;
    }

    SET_NEXT_STATE(STATE_REPLY_STRUCTURED_REPLY_FINISH);
  }
  return 0;

}

int
nbd_internal_enter_STATE_REPLY_STRUCTURED_REPLY_RECV_OFFSET_HOLE (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_REPLY_STRUCTURED_REPLY_RECV_OFFSET_HOLE;

  r = enter_STATE_REPLY_STRUCTURED_REPLY_RECV_OFFSET_HOLE (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "REPLY.STRUCTURED_REPLY.RECV_OFFSET_HOLE",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* REPLY.STRUCTURED_REPLY.RECV_BS_ENTRIES: Receive a structured reply block-status payload */
static int
enter_STATE_REPLY_STRUCTURED_REPLY_RECV_BS_ENTRIES (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 455 "generator/states-reply-structured.c"

  struct command *cmd = h->reply_cmd;
  uint32_t length;
  size_t i;
  uint32_t context_id;
  struct meta_context *meta_context;

  switch (recv_into_rbuf (h)) {
  case -1: SET_NEXT_STATE (STATE_DEAD); return 0;
  case 1:
    save_reply_state (h);
    SET_NEXT_STATE (STATE_READY);
    return 0;
  case 0:
    length = be32toh (h->sbuf.sr.structured_reply.length);

    assert (cmd); /* guaranteed by CHECK */
    assert (cmd->type == NBD_CMD_BLOCK_STATUS);
    assert (CALLBACK_IS_NOT_NULL (cmd->cb.fn.extent));
    assert (h->bs_entries);
    assert (length >= 12);

    /* Need to byte-swap the entries returned, but apart from that we
     * don't validate them.
     */
    for (i = 0; i < length/4; ++i)
      h->bs_entries[i] = be32toh (h->bs_entries[i]);

    /* Look up the context ID. */
    context_id = h->bs_entries[0];
    for (meta_context = h->meta_contexts;
         meta_context;
         meta_context = meta_context->next)
      if (context_id == meta_context->context_id)
        break;

    if (meta_context) {
      /* Call the caller's extent function. */
      int error = cmd->error;

      if (CALL_CALLBACK (cmd->cb.fn.extent,
                         meta_context->name, cmd->offset,
                         &h->bs_entries[1], (length-4) / 4,
                         &error) == -1)
        if (cmd->error == 0)
          cmd->error = error ? error : EPROTO;
    }
    else
      /* Emit a debug message, but ignore it. */
      debug (h, "server sent unexpected meta context ID %" PRIu32,
             context_id);

    SET_NEXT_STATE(STATE_REPLY_STRUCTURED_REPLY_FINISH);
  }
  return 0;

}

int
nbd_internal_enter_STATE_REPLY_STRUCTURED_REPLY_RECV_BS_ENTRIES (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_REPLY_STRUCTURED_REPLY_RECV_BS_ENTRIES;

  r = enter_STATE_REPLY_STRUCTURED_REPLY_RECV_BS_ENTRIES (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "REPLY.STRUCTURED_REPLY.RECV_BS_ENTRIES",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* REPLY.STRUCTURED_REPLY.FINISH: Finish receiving a structured reply */
static int
enter_STATE_REPLY_STRUCTURED_REPLY_FINISH (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 511 "generator/states-reply-structured.c"

  uint16_t flags;

  flags = be16toh (h->sbuf.sr.structured_reply.flags);
  if (flags & NBD_REPLY_FLAG_DONE) {
    SET_NEXT_STATE (STATE_REPLY_FINISH_COMMAND);
  }
  else {
    h->reply_cmd = NULL;
    SET_NEXT_STATE (STATE_READY);
  }
  return 0;

}

int
nbd_internal_enter_STATE_REPLY_STRUCTURED_REPLY_FINISH (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_REPLY_STRUCTURED_REPLY_FINISH;

  r = enter_STATE_REPLY_STRUCTURED_REPLY_FINISH (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "REPLY.STRUCTURED_REPLY.FINISH",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* REPLY.FINISH_COMMAND: Finish receiving a command */
static int
enter_STATE_REPLY_FINISH_COMMAND (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 151 "generator/states-reply.c"

  struct command *prev_cmd, *cmd;
  uint64_t cookie;
  bool retire;

  /* NB: This works for both simple and structured replies because the
   * handle (our cookie) is stored at the same offset.
   */
  cookie = be64toh (h->sbuf.simple_reply.handle);
  /* Find the command amongst the commands in flight. */
  for (cmd = h->cmds_in_flight, prev_cmd = NULL;
       cmd != NULL;
       prev_cmd = cmd, cmd = cmd->next) {
    if (cmd->cookie == cookie)
      break;
  }
  assert (cmd != NULL);
  assert (h->reply_cmd == cmd);
  h->reply_cmd = NULL;
  retire = cmd->type == NBD_CMD_DISC;

  /* Notify the user */
  if (CALLBACK_IS_NOT_NULL (cmd->cb.completion)) {
    int error = cmd->error;
    int r;

    assert (cmd->type != NBD_CMD_DISC);
    r = CALL_CALLBACK (cmd->cb.completion, &error);
    switch (r) {
    case -1:
      if (error)
        cmd->error = error;
      break;
    case 1:
      retire = true;
      break;
    }
  }

  /* Move it to the end of the cmds_done list. */
  if (prev_cmd != NULL)
    prev_cmd->next = cmd->next;
  else
    h->cmds_in_flight = cmd->next;
  cmd->next = NULL;
  if (retire)
    nbd_internal_retire_and_free_command (cmd);
  else {
    if (h->cmds_done_tail != NULL)
      h->cmds_done_tail = h->cmds_done_tail->next = cmd;
    else {
      assert (h->cmds_done == NULL);
      h->cmds_done = h->cmds_done_tail = cmd;
    }
  }
  h->in_flight--;
  assert (h->in_flight >= 0);

  SET_NEXT_STATE (STATE_READY);
  return 0;

}

int
nbd_internal_enter_STATE_REPLY_FINISH_COMMAND (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_REPLY_FINISH_COMMAND;

  r = enter_STATE_REPLY_FINISH_COMMAND (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "REPLY.FINISH_COMMAND",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* DEAD: Connection is in an unrecoverable error state, can only be closed */
static int
enter_STATE_DEAD (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 178 "generator/states.c"

  /* The caller should have used set_error() before reaching here */
  assert (nbd_get_error ());
  abort_option (h);
  nbd_internal_abort_commands (h, &h->cmds_to_issue);
  nbd_internal_abort_commands (h, &h->cmds_in_flight);
  h->in_flight = 0;
  if (h->sock) {
    h->sock->ops->close (h->sock);
    h->sock = NULL;
  }
  return -1;

}

int
nbd_internal_enter_STATE_DEAD (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_DEAD;

  r = enter_STATE_DEAD (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "DEAD",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}

/* CLOSED: Connection is closed */
static int
enter_STATE_CLOSED (struct nbd_handle *h,
             enum state *next_state,
             bool *blocked)
{
#line 191 "generator/states.c"

  abort_option (h);
  nbd_internal_abort_commands (h, &h->cmds_to_issue);
  nbd_internal_abort_commands (h, &h->cmds_in_flight);
  h->in_flight = 0;
  if (h->sock) {
    h->sock->ops->close (h->sock);
    h->sock = NULL;
  }
  return 0;

}

int
nbd_internal_enter_STATE_CLOSED (struct nbd_handle *h, bool *blocked)
{
  int r;
  enum state next_state = STATE_CLOSED;

  r = enter_STATE_CLOSED (h, &next_state, blocked);
  if (get_next_state (h) != next_state) {
    debug (h, "transition: %s -> %s",
           "CLOSED",
           nbd_internal_state_short_string (next_state));
    set_next_state (h, next_state);
  }
  return r;
}
