######################################################################
package Net::Amazon::Validate::Type;
######################################################################
use warnings;
use strict;

use Data::Dumper;
use Log::Log4perl qw(:easy);

use warnings; 
use strict;

##################################################
sub factory {
##################################################
    my(%options) = @_;

    die "'operation' is a mandatory parameter!\n" unless defined $options{operation};

    #DEBUG(sub {"Validate::Type factory options=" . Data::Dumper::Dumper(\%options) . "\n"});

# NOTE: if you want to validate different versions of the WSDL add this back in.
#     # Transform 2005-10-05 into V2005_10_05 to ensure its a valid module name.
#     my $ver = "V$options{version}";
#     $ver =~ s|-|_|g;
#
#    my $class = 'Net::Amazon::Validate::Type::'.$ver.'::'.$options{operation};

    my $class = 'Net::Amazon::Validate::Type::'.$options{operation};

    eval "require $class";	
    
    my $obj = $class->new();

    return $obj;
}

1;

__END__

=head1 NAME

Net::Amazon::Validate - Validate user supplied options against known valid
options.

=head1 SYNOPSIS

  use Net::Amazon::Validate;

  # ...
	
  my $valid = Net::Amazon::Validate::factory(operation => 'ResponseGroup',
                                            );

  $valid->ResponseGroup([qw(Small Request)]);
  $valid->ResponseGroup('Large');

=head1 DESCRIPTION

=head2 METHODS

=over 4

=item Asin()

The item's ASIN number.

=back

Please check the subclasses of C<Net::Amazon::Validate> for specialized 
methods.

=head1 TODO

I should probably add a function to dispatch calls automatically, that way the
user doesn't have to explicity call a function to verify an option.  It would
make it very easy to write loops to validate input.

=head1 BUGS

This library was designed to validate ResponseGroup requests only.  Support for
other parameters were autogenerated but not verified.  The biggest problems are
with the intrepration of 'Integers 1 to 30', 'A Merchant ID', or 'Amazon (the
default value)'.

=head1 SEE ALSO

=head1 AUTHOR

Christopher Boumenot, E<lt>boumenot@gmail.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2006 by Christopher Boumenot E<lt>boumenot@gmail.comE<gt>

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself. 

=cut
