//
// Matrix.hh
//
// Made by Samuel Pasquier
// Login   <pasqui_s@newton.dubito.net>
//
// Started on  Sun May 19 16:44:42 2002 Samuel Pasquier
// Last update Tue May 28 23:40:05 2002 Samuel Pasquier
//

#ifndef   	MATRIX_HH_
# define   	MATRIX_HH_

template <class TypeName>
class Matrix
{
public:
  // Definition of all constructors
  Matrix() {};
  Matrix(int lines, int rows);
  Matrix(const Matrix<TypeName>& ref);
  Matrix(const std::vector<std::vector<TypeName> >& ref);
  Matrix(const std::vector<TypeName, std::allocator<TypeName> >& ref);
  ~Matrix();

  //Operators Overloading
  Matrix<TypeName> operator -(const Matrix& rhs) const;
  Matrix<TypeName> operator +(const Matrix& rhs) const;
  Matrix<TypeName> operator *(const Matrix& rhs) const;
  Matrix<TypeName> operator *(TypeName t) const;
  Matrix<TypeName>& operator +=(const Matrix& rhs);
  Matrix<TypeName>& operator -=(const Matrix& rhs);
  Matrix<TypeName>& operator *=(const Matrix& rhs);
  Matrix<TypeName>& operator *=(TypeName t);
  Matrix<TypeName>& operator =(const Matrix& rhs);
  const TypeName operator ()(int x, int y) const;
  void set_data(int x, int y, const TypeName& value);
  Matrix& insert(int x, int y, const Matrix<TypeName>& m);

  std::ostream& print(std::ostream& os) const;


  //Matrix operations
  Matrix<TypeName> transpose() const;
  Matrix<TypeName>& identity();
  Matrix<TypeName> abs() const;
  Matrix<double> inverse() const;
  TypeName trace() const;
  Matrix<float> center();
  Matrix<float> reduce(Matrix<float>& moy);
  Matrix<float> get_varcov() const;
  float trace_of_varcov() const;

  int get_nb_lines() const;
  int get_nb_cols() const;
  Matrix<TypeName> get_line(int line) const;
  Matrix<TypeName> get_lines(int nb_lines) const;
  Matrix<TypeName> get_col(int col) const;
  Matrix<TypeName> get_cols(int nb_cols) const;

  void clone_same_size(const Matrix<TypeName>& ref);

  TypeName norme() const;
  TypeName norme(const Matrix& rhs) const;

  void		prepare_next_eigen_vector(Matrix<TypeName>& current_q,
					  double current_lambda);
  Matrix<TypeName> get_eigen_vector(unsigned int i, Matrix<float>& x,
				    float epsilon) const;
  Matrix<TypeName> get_max_eigen_vector() const;
  Matrix<TypeName> get_eigen_value(Matrix<TypeName>& eigenvector) const;
  Matrix<TypeName> get_max_eigen_vector_deflation() const;

private:
  Matrix<TypeName>& alloc_data(int lines, int cols);
  Matrix<TypeName>& release_data();
  int	_lines;
  int	_cols;
  TypeName **_data;

protected:
};

#include "Matrix.hxx"

#endif	    /* !MATRIX_HH_ */
