#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <limits.h>
#include <libnjb.h>
#include <unistd.h>

extern int njb_error;

int main (int argc, char **argv)
{
	njb_t njbs[NJB_MAX_DEVICES], *njb;
	int n, debug;
	playlist_t *playlist;
	extern char *optarg;
	int opt;

	debug= 0;
	while ( (opt= getopt(argc, argv, "D:")) != -1 ) {
		switch (opt) {
		case 'D':
			debug= atoi(optarg);
			break;
		default:
			fprintf(stderr, "usage: playlists [ -D debuglvl ]\n");
			return 1;
		}
	}

	if ( debug ) NJB_Set_Debug(debug);

	if ( NJB_Discover(njbs, 0, &n) == -1 ) njb_error_dump(stderr);
	if ( n == 0 ) {
		fprintf(stderr, "no NJB devices found\n");
		return 0;
	} 

	njb= njbs;

	if ( NJB_Open(njb) == -1 ) {
		njb_error_dump(stderr);
		return 1;
	}

	if ( NJB_Capture(njb) == -1 ) {
		njb_error_dump(stderr);
		return 1;
	}

	NJB_Reset_Get_Playlist(njb);
	while ( (playlist= NJB_Get_Playlist(njb)) ) {
		playlist_dump(playlist, stdout);
		printf("----------------------------------\n");
	}
	if ( njb_error != EO_EOM ) njb_error_dump(stderr);

	NJB_Release(njb);

	NJB_Close(njb);
	return 0;
}

