#include "../config.h"
#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/uio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "libnjb.h"
#include "defs.h"
#include "base.h"
#include "ioutil.h"

extern int __sub_depth;

ssize_t Read(int d, void *buf, size_t nbytes, size_t maxblock)
{
	__dsub= "Read";
	size_t bremain= nbytes;
	size_t toread;
	char *bp= (char *) buf;
	ssize_t bread;
/*
	int status;
	fd_set read_fds[FD_SETSIZE];
*/

	__enter;

	if ( ! maxblock ) maxblock= nbytes;

	while ( bremain ) {
/*
		FD_ZERO(read_fds);
		FD_SET(d, read_fds);

		timeout.tv_sec= 1;
		timeout.tv_usec= 0;

s_retry:	if ( (status= select(d+1, read_fds, NULL, NULL, &timeout))
			== -1 ) {

			if ( errno == EINTR ) goto s_retry;
			__leave;
			return -1;
		} else if ( ! status ) {
			errno= ETIMEDOUT;
			__leave;
			return -1;
		}
*/

		toread= ( bremain > maxblock ) ? maxblock : bremain; 

r_retry:	if ( (bread= read(d, bp, toread)) == -1 ) {
			if ( errno == EINTR ) goto r_retry;
			__leave;
			return -1;
		}

		if ( bread == 0 ) {
			__leave;
			return (nbytes-bremain);
		}

		bremain-= bread;
		bp+= bread;
	}

	__leave;
	return nbytes;
}

void data_dump (FILE *f, void *buf, size_t n)
{
	__dsub= "data_dump";
	unsigned char *bp= (unsigned char *) buf;
	size_t i;

	for (i= 0; i< n; i++) {
		fprintf(f, "%02x ", *bp);
		bp++;
	}
	fprintf(f, "\n");
}

void data_dump_ascii (FILE *f, void *buf, size_t n, size_t dump_boundry)
{
	__dsub= "data_dump_ascii";
	size_t remain= n;
	size_t ln, lc;
	int i;
	unsigned char *bp= (unsigned char *) buf;

	lc= 0;
	while (remain) {
		fprintf(f, "\t%04x:", dump_boundry);

		ln= ( remain > 16 ) ? 16 : remain;

		for (i= 0; i< ln; i++) {
			if ( ! (i%2) ) fprintf(f, " ");
			fprintf(f, "%02x", bp[16*lc+i]);
		}

		if ( ln < 16 ) {
			int width= ((16-ln)/2)*5 + (2*(ln%2));
			fprintf(f, "%*.*s", width, width, "");
		}

		fprintf(f, "\t");
		for (i= 0; i< ln; i++) {
			unsigned char ch= bp[16*lc+i];
			fprintf(f, "%c", ( ch >= 0x20 && ch <= 0x7e ) ? 
				ch : '.');
		}
		fprintf(f, "\n");

		lc++;
		remain-= ln;
		dump_boundry+= ln;
	}
}

ssize_t Write(int d, void *buf, size_t nbytes, size_t maxblock)
{
	__dsub= "Write";
	size_t bremain= nbytes;
	size_t towrite;
	char *bp= (char *) buf;
	ssize_t bwritten;
	int status;
	fd_set write_fds[FD_SETSIZE];
	struct timeval timeout;

	__enter;

	if ( ! maxblock ) maxblock= nbytes;

	while ( bremain ) {
		FD_ZERO(write_fds);
		FD_SET(d, write_fds);

		timeout.tv_sec= 1;
		timeout.tv_usec= 0;

s_retry:	if ( (status= select(d+1, NULL, write_fds, NULL, &timeout))
			== -1 ) {

			if ( errno == EINTR ) goto s_retry;
			__leave;
			return -1;
		} else if ( ! status ) {
			errno= ETIMEDOUT;
			__leave;
			return -1;
		}

		towrite= ( bremain > maxblock ) ? maxblock : bremain; 

r_retry:	if ( (bwritten= write(d, bp, towrite)) == -1 ) {
			if ( errno == EINTR ) goto r_retry;
			__leave;
			return -1;
		}

		if ( bwritten == 0 ) {
			__leave;
			return (nbytes-bremain);
		}
		bremain-= bwritten;
		bp+= bwritten;
	}

	__leave;
	return nbytes;
}

int Move (const char *from, const char *to)
{
	__dsub= "Move";

	__enter;

	if ( rename(from, to) == -1 ) {
		if ( errno == EXDEV ) {
			if ( Copy(from, to) == -1 ) {
				__leave;
				return -1;
			}
			unlink(from);
			__leave;
			return 0;
		}
		__leave;
		return -1;
	}

	__leave;
	return 0;
}

int Copy (const char *from, const char *to)
{
	__dsub= "Copy";
	struct stat st;
	int ffd, tfd;
	off_t remain;
	ssize_t bread, bwritten;
	void *buf;
	u_int32_t blksize, block;

	__enter;

	if ( stat(to, &st) == 0 ) {
		printf("mode= %x\n", st.st_mode);
		printf("S_IFREG %x\n", S_IFREG);
		printf("mode & S_IFREG %x\n", st.st_mode & S_IFREG);
		if ( (st.st_mode & S_IFREG) != S_IFREG ) {
			errno= EINVAL;
			__leave;
			return -1;
		}
	}

	if ( stat(from, &st) == -1 ) {
		__leave;
		return -1;
	}

	if ( (ffd= open(from, O_RDONLY)) == -1 ) {
		__leave;
		return -1;
	}
	if ( (tfd= open(to, O_CREAT|O_TRUNC|O_WRONLY,
		S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH)) == -1 ) {

		close(ffd);
		__leave;
		return -1;
	}

	remain= st.st_size;
	blksize= st.st_blksize;

	buf= malloc(blksize);
	while ( remain ) {
		block= ( remain > (off_t) blksize ) ? blksize :
			(u_int32_t) remain;

		if ( (bread= Read(ffd, buf, block, 0)) == -1 ) {
			unlink(to);
			close(ffd);
			close(tfd);
			__leave;
			return -1;
		}

		if ( (bwritten= Write(tfd, buf, bread, 0)) == -1 ) {
			unlink(to);
			close(ffd);
			close(tfd);
			__leave;
			return -1;
		}

		remain-= bread;
	}

	unlink(from);
	close(ffd);
	close(tfd);
	__leave;
	return 0;
}

