#!/usr/local/bin/ruby
require 'reqnora'
require 'benchmark'
require 'web/writebuffer'
include Benchmark

def do_func(buf,str,n)
  n.times do
    buf << str << str << str << str << str << str << str << str << str << str
    buf << str << str << str << str << str << str << str << str << str << str
    buf << str << str << str << str << str << str << str << str << str << str
    buf << str << str << str << str << str << str << str << str << str << str
    buf << str << str << str << str << str << str << str << str << str << str
    buf << str << str << str << str << str << str << str << str << str << str
    buf << str << str << str << str << str << str << str << str << str << str
    buf << str << str << str << str << str << str << str << str << str << str
    buf << str << str << str << str << str << str << str << str << str << str
    buf << str << str << str << str << str << str << str << str << str << str
  end
end


benchmark(" "*7 + CAPTION, 10, FMTSTR) do |x|
  
  str = "a"
  x.report("WriteBuffer 1024    1*1000000 ") {
    buf = Web::WriteBuffer.new(1024,1024)
    do_func(buf, str, 10000)
  }
  GC.start
  
  str = "abcdefghij"
  x.report("WriteBuffer 1024    10*1000000 ") {
    buf = Web::WriteBuffer.new(1024,1024)
    do_func(buf, str, 10000)
  }
  GC.start
  
  str = "abcdefghij"*10
  x.report("WriteBuffer 1024    100*1000000") {
    100.times do
      buf = Web::WriteBuffer.new(1024,1024)
      do_func(buf, str, 100)
    end
  }
  GC.start
  
  str = "a"
  x.report("WriteBuffer 4096    1*1000000 ") {
    buf = Web::WriteBuffer.new(4096,4096)
    do_func(buf, str, 10000)
  }
  GC.start
  
  str = "abcdefghij"
  x.report("WriteBuffer 4096    10*1000000 ") {
    buf = Web::WriteBuffer.new(4096,4096)
    do_func(buf, str, 10000)
  }
  GC.start
  
  str = "abcdefghij"*10
  x.report("WriteBuffer 4096    100*1000000") {
    buf = Web::WriteBuffer.new(4096,4096)
    100.times do
      buf = Web::WriteBuffer.new(1024,1024)
      do_func(buf, str, 100)
    end
  }
  GC.start
  
  str = "a"
  x.report("WriteBuffer 65536    1*1000000 ") {
    buf = Web::WriteBuffer.new(65536,65536)
    do_func(buf, str, 10000)
  }
  GC.start
  
  str = "abcdefghij"
  x.report("WriteBuffer 65536    10*1000000 ") {
    buf = Web::WriteBuffer.new(65536,65536)
    do_func(buf, str, 10000)
  }
  GC.start
 
  str = "abcdefghij"*10
  x.report("WriteBuffer 65536    100*1000000") {
    buf = Web::WriteBuffer.new(65536,65536)
    100.times do
      buf = Web::WriteBuffer.new(1024,1024)
      do_func(buf, str, 100)
    end
  }
  GC.start

  init_size = 16*1024*1024
  next_size = 16*1024*1024
  str = "a"
  x.report("WriteBuffer 16M    1*1000000 ") {
    buf = Web::WriteBuffer.new(init_size,next_size)
    do_func(buf, str, 10000)
  }
  GC.start
  
  str = "abcdefghij"
  x.report("WriteBuffer 16M    10*1000000 ") {
    buf = Web::WriteBuffer.new(init_size,next_size)
    do_func(buf, str, 10000)
  }
  GC.start
  
  str = "abcdefghij"*10
  x.report("WriteBuffer 16M    100*1000000") {
    buf = Web::WriteBuffer.new(init_size,next_size)
    100.times do
      buf = Web::WriteBuffer.new(1024,1024)
      do_func(buf, str, 100)
    end
  }
  GC.start
  
  str = "a"
  x.report("String         1*1000000 ") {
    buf = ''
    do_func(buf, str, 10000)
  }
  GC.start
  
  str = "abcdefghij"
  x.report("String         10*1000000 ") {
    buf = ''
    do_func(buf, str, 10000)
  }
  GC.start
  
  str = "abcdefghij"*10
  x.report("String         100*1000000") {
    buf = ''
    do_func(buf, str, 10000)
  }
  GC.start
end

