/*
    $Id: lib.h,v 1.28 2002/10/07 19:18:06 gmorin Exp $
    $Source: /cvsroot/nss-mysql/nss-mysql/src/lib.h,v $
    $Date: 2002/10/07 19:18:06 $
    $Author: gmorin $
*/


#ifndef _NSS_MYSQL_LIB_H_
#define _NSS_MYSQL_LIB_H_ 1

#include <mysql.h>
#include <syslog.h>
#include "passwd.h"
#include "nss-mysql.h"

extern int _nss_mysql_isempty(char * str);
extern long _nss_mysql_strtol(char * str, long fallback, int * error);
extern void _nss_mysql_log(int err, const char *format, ...);
extern void _nss_mysql_db_close (MYSQL **);
extern int _nss_mysql_db_connect (struct mysql_auth *,
                struct connection_options *);
extern char * _nss_mysql_sqlprintf(const char * format, ...);
extern char * _nss_mysql_copy_to_buffer(char ** buffer,size_t * buflen, const
                char * string); 
extern int _nss_mysql_check_connection(struct mysql_auth *, 
                struct connection_options * options);
void _nss_mysql_set_fork_handler(int * isset,pthread_mutex_t * mutex,
                void (*prepare)(void),
                void (*parent)(void),
                void (*child)(void),
                void (*atexit)(void));

NSS_STATUS _nss_mysql_send_query(struct mysql_auth * auth,char * query,
                MYSQL_RES ** result, int * errnop);

char * _nss_mysql_escape_string(const char * string, struct mysql_auth * m, 
                char * buffer, size_t len, int * call_free);

#define s_free(x) if (x) {free(x); x = NULL;}

#endif /* _NSS_MYSQL_LIB_H_ 1 */
