/*
  File autogenerated by gengetopt version 2.10
  generated with the following command:
  gengetopt --unamed-opts 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "getopt.h"

#include "cmdline.h"

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
  "  prints to stdout the created OFX file based on the options you pass it. currently it will only create a statement request file.  you can POST this to an OFX server to request a statement from that financial institution for that account.\n"
  "\n"
  "Usage: %s [OPTIONS]... [FILES]...\n", CMDLINE_PARSER_PACKAGE);
  printf("   -h         --help                 Print help and exit\n");
  printf("   -V         --version              Print version and exit\n");
  printf("              --fipid=STRING         FI partner identifier (looks up fid, org & url from partner server)\n");
  printf("              --fid=STRING           FI identifier\n");
  printf("              --org=STRING           FI org tag\n");
  printf("              --bank=STRING          IBAN bank identifier\n");
  printf("              --broker=STRING        Broker identifier\n");
  printf("              --user=STRING          User name\n");
  printf("              --pass=STRING          Password\n");
  printf("              --acct=STRING          Account ID\n");
  printf("              --type=INT             Account Type 1=checking 2=invest 3=ccard\n");
  printf("              --past=LONG            How far back to look from today (in days)\n");
  printf("              --url=STRING           Url to POST the data to (otherwise goes to stdout)\n");
  printf("              --trid=INT             Transaction id\n");
  printf("\n");
  printf("   Group: command\n");
  printf("   -s         --statement-req        Request for a statement\n");
  printf("   -a         --accountinfo-req      Request for a list of accounts\n");
  printf("   -p         --payment-req          Request to make a payment\n");
  printf("   -i         --paymentinquiry-req   Request to inquire about the status of a payment\n");
  printf("   -b         --bank-list            List all known banks\n");
  printf("   -f         --bank-fipid           List all fipids for a given bank\n");
  printf("   -v         --bank-services        List supported services for a given fipid\n");
  printf("              --allsupport           List all banks which support online banking\n");
}


static char *gengetopt_strdup (const char *s);

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;
  int command_group_counter = 0;
  

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->fipid_given = 0 ;
  args_info->fid_given = 0 ;
  args_info->org_given = 0 ;
  args_info->bank_given = 0 ;
  args_info->broker_given = 0 ;
  args_info->user_given = 0 ;
  args_info->pass_given = 0 ;
  args_info->acct_given = 0 ;
  args_info->type_given = 0 ;
  args_info->past_given = 0 ;
  args_info->url_given = 0 ;
  args_info->trid_given = 0 ;
  args_info->statement_req_given = 0 ;
  args_info->accountinfo_req_given = 0 ;
  args_info->payment_req_given = 0 ;
  args_info->paymentinquiry_req_given = 0 ;
  args_info->bank_list_given = 0 ;
  args_info->bank_fipid_given = 0 ;
  args_info->bank_services_given = 0 ;
  args_info->allsupport_given = 0 ;
#define clear_args() { \
  args_info->fipid_arg = NULL; \
  args_info->fid_arg = NULL; \
  args_info->org_arg = NULL; \
  args_info->bank_arg = NULL; \
  args_info->broker_arg = NULL; \
  args_info->user_arg = NULL; \
  args_info->pass_arg = NULL; \
  args_info->acct_arg = NULL; \
  args_info->url_arg = NULL; \
}

  clear_args();

  args_info->inputs = NULL;
  args_info->inputs_num = 0;

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "fipid",	1, NULL, 0 },
        { "fid",	1, NULL, 0 },
        { "org",	1, NULL, 0 },
        { "bank",	1, NULL, 0 },
        { "broker",	1, NULL, 0 },
        { "user",	1, NULL, 0 },
        { "pass",	1, NULL, 0 },
        { "acct",	1, NULL, 0 },
        { "type",	1, NULL, 0 },
        { "past",	1, NULL, 0 },
        { "url",	1, NULL, 0 },
        { "trid",	1, NULL, 0 },
        { "statement-req",	0, NULL, 's' },
        { "accountinfo-req",	0, NULL, 'a' },
        { "payment-req",	0, NULL, 'p' },
        { "paymentinquiry-req",	0, NULL, 'i' },
        { "bank-list",	0, NULL, 'b' },
        { "bank-fipid",	0, NULL, 'f' },
        { "bank-services",	0, NULL, 'v' },
        { "allsupport",	0, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVsapibfv", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          clear_args ();
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          clear_args ();
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 's':	/* Request for a statement.  */
          if (args_info->statement_req_given)
            {
              fprintf (stderr, "%s: `--statement-req' (`-s') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->statement_req_given = 1;
          command_group_counter += 1;
        break;

        case 'a':	/* Request for a list of accounts.  */
          if (args_info->accountinfo_req_given)
            {
              fprintf (stderr, "%s: `--accountinfo-req' (`-a') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->accountinfo_req_given = 1;
          command_group_counter += 1;
        break;

        case 'p':	/* Request to make a payment.  */
          if (args_info->payment_req_given)
            {
              fprintf (stderr, "%s: `--payment-req' (`-p') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->payment_req_given = 1;
          command_group_counter += 1;
        break;

        case 'i':	/* Request to inquire about the status of a payment.  */
          if (args_info->paymentinquiry_req_given)
            {
              fprintf (stderr, "%s: `--paymentinquiry-req' (`-i') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->paymentinquiry_req_given = 1;
          command_group_counter += 1;
        break;

        case 'b':	/* List all known banks.  */
          if (args_info->bank_list_given)
            {
              fprintf (stderr, "%s: `--bank-list' (`-b') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->bank_list_given = 1;
          command_group_counter += 1;
        break;

        case 'f':	/* List all fipids for a given bank.  */
          if (args_info->bank_fipid_given)
            {
              fprintf (stderr, "%s: `--bank-fipid' (`-f') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->bank_fipid_given = 1;
          command_group_counter += 1;
        break;

        case 'v':	/* List supported services for a given fipid.  */
          if (args_info->bank_services_given)
            {
              fprintf (stderr, "%s: `--bank-services' (`-v') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->bank_services_given = 1;
          command_group_counter += 1;
        break;


        case 0:	/* Long option with no short option */
          /* FI partner identifier (looks up fid, org & url from partner server).  */
          if (strcmp (long_options[option_index].name, "fipid") == 0)
          {
            if (args_info->fipid_given)
              {
                fprintf (stderr, "%s: `--fipid' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->fipid_given = 1;
            args_info->fipid_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* FI identifier.  */
          else if (strcmp (long_options[option_index].name, "fid") == 0)
          {
            if (args_info->fid_given)
              {
                fprintf (stderr, "%s: `--fid' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->fid_given = 1;
            args_info->fid_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* FI org tag.  */
          else if (strcmp (long_options[option_index].name, "org") == 0)
          {
            if (args_info->org_given)
              {
                fprintf (stderr, "%s: `--org' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->org_given = 1;
            args_info->org_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* IBAN bank identifier.  */
          else if (strcmp (long_options[option_index].name, "bank") == 0)
          {
            if (args_info->bank_given)
              {
                fprintf (stderr, "%s: `--bank' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->bank_given = 1;
            args_info->bank_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Broker identifier.  */
          else if (strcmp (long_options[option_index].name, "broker") == 0)
          {
            if (args_info->broker_given)
              {
                fprintf (stderr, "%s: `--broker' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->broker_given = 1;
            args_info->broker_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* User name.  */
          else if (strcmp (long_options[option_index].name, "user") == 0)
          {
            if (args_info->user_given)
              {
                fprintf (stderr, "%s: `--user' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->user_given = 1;
            args_info->user_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Password.  */
          else if (strcmp (long_options[option_index].name, "pass") == 0)
          {
            if (args_info->pass_given)
              {
                fprintf (stderr, "%s: `--pass' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->pass_given = 1;
            args_info->pass_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Account ID.  */
          else if (strcmp (long_options[option_index].name, "acct") == 0)
          {
            if (args_info->acct_given)
              {
                fprintf (stderr, "%s: `--acct' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->acct_given = 1;
            args_info->acct_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Account Type 1=checking 2=invest 3=ccard.  */
          else if (strcmp (long_options[option_index].name, "type") == 0)
          {
            if (args_info->type_given)
              {
                fprintf (stderr, "%s: `--type' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->type_given = 1;
            args_info->type_arg = strtol (optarg,&stop_char,0);
            break;
          }
          
          /* How far back to look from today (in days).  */
          else if (strcmp (long_options[option_index].name, "past") == 0)
          {
            if (args_info->past_given)
              {
                fprintf (stderr, "%s: `--past' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->past_given = 1;
            args_info->past_arg = strtol (optarg,&stop_char,0);
            break;
          }
          
          /* Url to POST the data to (otherwise goes to stdout).  */
          else if (strcmp (long_options[option_index].name, "url") == 0)
          {
            if (args_info->url_given)
              {
                fprintf (stderr, "%s: `--url' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->url_given = 1;
            args_info->url_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Transaction id.  */
          else if (strcmp (long_options[option_index].name, "trid") == 0)
          {
            if (args_info->trid_given)
              {
                fprintf (stderr, "%s: `--trid' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->trid_given = 1;
            args_info->trid_arg = strtol (optarg,&stop_char,0);
            break;
          }
          
          /* List all banks which support online banking.  */
          else if (strcmp (long_options[option_index].name, "allsupport") == 0)
          {
            if (args_info->allsupport_given)
              {
                fprintf (stderr, "%s: `--allsupport' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->allsupport_given = 1; command_group_counter += 1;
          
            break;
          }
          

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", CMDLINE_PARSER_PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */

  if ( command_group_counter > 1)
    {
      fprintf (stderr, "%s: %d options of group command were given. At most one is required\n", CMDLINE_PARSER_PACKAGE, command_group_counter);
      missing_required_options = 1;
    }
  

  if ( missing_required_options )
    exit (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
  
      args_info->inputs_num = argc - optind ;
      args_info->inputs = 
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ; 
    }
  
  return 0;
}
