(**
   A simple boolean button with a selected and an unselected state.
**)

MODULE VO:Bool;

(*
    Implements a bool gadget.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT G  := VO:Object,
       S  := VO:State,
       V  := VO:VecImage;

TYPE
  Prefs*     = POINTER TO PrefsDesc;

  (**
    In this class all preferences stuff of the button is stored.
  **)

  PrefsDesc* = RECORD (G.PrefsDesc)
                 image* : LONGINT; (* the frame to use for the button *)
               END;

  Bool*     = POINTER TO BoolDesc;

 (**
   Implementation of a bool gadget.
 **)

  BoolDesc* = RECORD (S.StateDesc)
              END;

VAR
  prefs* : Prefs;

  PROCEDURE (b : Bool) Init*;

  BEGIN
    b.Init^;

    b.SetPrefs(prefs);

    b.SetImage(b.prefs(Prefs).image);
  END Init;

  PROCEDURE (p : Prefs) Init*;

  BEGIN
    p.Init^;
    p.image:=V.checkmark;
  END Init;

  PROCEDURE CreateBool*(): Bool;

  VAR
    bool : Bool;

  BEGIN
    NEW(bool);
    bool.Init;

    RETURN bool;
  END CreateBool;

BEGIN
  NEW(prefs);
  prefs.Init;

END VO:Bool.