(**
  Just a plain area with a given color. Usefull for a buttonimage, when you
  want some kind of palette button.
**)

MODULE VO:ColorArea;

(*
    Implements a colored area.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D := VO:Base:Display,

       O := VO:Object;

TYPE
  Prefs*         = POINTER TO PrefsDesc;

  (**
    In this class all preferences stuff of the button is stored.
  **)

  PrefsDesc*     = RECORD (O.PrefsDesc)
                   END;


  ColorArea*     = POINTER TO ColorAreaDesc;
  ColorAreaDesc* = RECORD (O.ImageDesc)
                     color : D.Color;
                   END;

VAR
  prefs : Prefs;

  PROCEDURE (c : ColorArea) Init*;

  BEGIN
    c.Init^;

    c.color:=D.textColor;
  END Init;

  (**
    The the color of the color area.
  **)

  PROCEDURE (c : ColorArea) SetColor*(color : D.Color);

  BEGIN
    c.color:=color;
    IF c.visible THEN
      c.Redraw;
    END;
  END SetColor;

  PROCEDURE (c : ColorArea) CalcSize*;

  BEGIN
    c.width:=4;
    c.height:=4;
    c.minWidth:=c.width;
    c.minHeight:=c.height;

    c.CalcSize^;
  END CalcSize;

  PROCEDURE (c : ColorArea) Draw* (x,y,w,h : LONGINT);

  VAR
    draw : D.DrawInfo;

  BEGIN
    c.Draw^(x,y,w,h);

    IF ~c.Intersect(x,y,w,h) THEN
      RETURN;
    END;

    draw:=c.GetDrawInfo();

    draw.PushForeground(c.color);
    draw.FillRectangle(c.x,c.y,c.width,c.height);
    draw.PopForeground;
  END Draw;

  PROCEDURE (c :  ColorArea) Hide*;

  BEGIN
    IF c.visible THEN
      c.DrawHide;
      c.Hide^;
    END;
  END Hide;

  PROCEDURE CreateColorArea*():ColorArea;

  VAR
    colorArea : ColorArea;

  BEGIN
    NEW(colorArea);
    colorArea.Init;

    RETURN colorArea;
  END CreateColorArea;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:ColorArea.