MODULE VO:CyclePrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT ISD := VO:Dlg:ImgSel,

       VM  := VO:Model:Value,

       PG  := VO:Prefs:GUI,
       PP  := VO:Prefs:Parser,

       B   := VO:Button,
       BO  := VO:Bool,
       C   := VO:Cycle,
       FG  := VO:FrameGroup,
       G   := VO:Object,
       GP  := VO:ObjectPrefs,
       L   := VO:Label,
       P   := VO:Panel,
       S   := VO:Space,
       T   := VO:Text,
       TA  := VO:Tab,
       V   := VO:VecImage;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (GP.PrefsItemDesc)
                imgSelDlg  : ISD.ImgSelDlg;
                image      : V.VecImage;
                imageRight : VM.BoolModel;
                highlight  : VM.BoolModel;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Cycle";

    d.SetPrefs(C.prefs);

    NEW(d.imgSelDlg);
    d.imgSelDlg.Init;
  END Init;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    bool   : BO.Bool;
    button : B.Button;
    frame  : FG.FrameGroup;
    label  : L.Label;
    panel  : P.Panel;
    space  : S.Space;
    object : G.Object;
    tab    : TA.Tab;

  BEGIN
    d.imgSelDlg.SetDisplay(d.display);

    object:=d.GetObject^();
    tab:=object(TA.Tab);

    panel:=P.CreateVPanel();

      frame:=FG.CreateFrameGroup();
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Image");

       button:=PG.CreateImageButton(d.image,d.display,d.imgSelDlg,
                                    d.window.keyHandler,"Select image");
      frame.Add(button);
    panel.Add(frame);

      space:=S.CreateVSpace();
    panel.Add(space);

      frame:=FG.CreateFrameGroup();
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Options");

        label:=L.CreateLabel();
                
          d.imageRight:=VM.CreateBoolModel();
          d.imageRight.SetBoolean(C.prefs.imageRight);

          bool:=BO.CreateBool();
          bool.SetModel(d.imageRight);
          d.window.AddFocusObject(bool);
        label.AddTextLabel("Image on right side",bool);

          d.highlight:=VM.CreateBoolModel();
          d.highlight.SetBoolean(C.prefs.highlight);

          bool:=BO.CreateBool();
          bool.SetModel(d.highlight);
          d.window.AddFocusObject(bool);
        label.AddTextLabel("Highlight label",bool);
      frame.Add(label);
    panel.Add(frame);

    tab.AddTab(T.MakeCenterText(d.name),panel);

    RETURN tab;
  END GetObject;

  PROCEDURE (p : Item) Refresh*;

  BEGIN
    p.Refresh^;

    p.imgSelDlg.SetImage(C.prefs.image);
    p.image.Set(C.prefs.image);
    p.imageRight.SetBoolean(C.prefs.imageRight);
    p.highlight.SetBoolean(C.prefs.highlight);
 END Refresh;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    p.Apply^;

    C.prefs.imageRight:=p.imageRight.GetBoolean();
    C.prefs.highlight:=p.highlight.GetBoolean();
  END Apply;

  PROCEDURE (p : Item) LoadPrefs*(top : PP.Item);

  VAR
    buffer : ARRAY 256 OF CHAR;
    pos    : LONGINT;

  BEGIN
    p.LoadPrefs^(top);

    IF top.GetStringEntry("image",buffer) THEN
      pos:=V.GetImageEntry(buffer);
      IF pos>=0 THEN
        C.prefs.image:=pos;
      ELSE
        p.ErrorWrongData("image",buffer);
      END;
    END;

    C.prefs.imageRight:=top.GetBoolEntry("imageRight",C.prefs.imageRight);
    C.prefs.highlight:=top.GetBoolEntry("highlight",C.prefs.highlight);
  END LoadPrefs;

  PROCEDURE (p : Item) SavePrefs*(block : PP.BlockItem);

  BEGIN
    p.SavePrefs^(block);

    block.AddItemValue("image",V.images[C.prefs.image]);
    block.AddItemBool("imageRight",C.prefs.imageRight);
    block.AddItemBool("highlight",C.prefs.highlight);
  END SavePrefs;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:CyclePrefs.