(**
  A dialog to select one of the internal images.
**)

MODULE VO:Dlg:ImgSel;

(*
    A dialog to select one of the internal images.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT Z  := VO:Base:Size,

       TM := VO:Model:Table,

       C  := VO:Combo,
       PL := VO:Plate,
       TB := VO:Table,
       V  := VO:VecImage;

TYPE
  ImgSelCombo*     = POINTER TO ImgSelComboDesc;
  ImgSelComboDesc* = RECORD (C.ComboDesc)
                       image : V.VecImage;
                     END;

  PROCEDURE (c : ImgSelCombo) Init*;

  VAR
    image : V.VecImage;
    model : TM.LTableModel;
    plate : PL.Plate;
    x     : LONGINT;

  BEGIN
    c.Init^;

    plate:=PL.CreatePlate();
      c.image:=V.CreateVecImage();
      c.image.SetMinWidth(Z.unit,4);
      c.image.SetMinHeight(Z.unit,4);
    plate.Add(c.image);
    c.SetValueObject(plate);

    NEW(model);
    model.Init;
    model.SetSelectionType(TM.singleLineSelect);
    model.SetColumnString(1,"Image");
    model.SetColumnWidth(1,30);
    model.SetColumnString(2,"Name");
    model.SetColumnWidth(2,150);

    FOR x:=0 TO V.imageCount-1 DO
      plate:=PL.CreatePlate();
        image:=V.CreateVecImage();
        image.SetMinWidth(Z.unit,4);
        image.SetMinHeight(Z.unit,4);
        image.Set(x);
      plate.Add(image);
      model.AppendEntry;
      model.SetObject(1,model.GetRows(),plate);
      model.SetString(2,model.GetRows(),V.images[x]);
    END;

    c.SetTableModel(model);
  END Init;

  PROCEDURE (c : ImgSelCombo) InitTable*(table : TB.Table);

  BEGIN
    table.SetMinWidth(Z.unit,30);
    table.table.SetRowHeight(30);
  END InitTable;

  PROCEDURE (c : ImgSelCombo) CopySelection*(row : LONGINT);

  BEGIN
    c.CopySelection^(row);

    IF row>0 THEN
      c.image.Set(row-1);
    END;
  END CopySelection;

  PROCEDURE CreateImgSelCombo*():ImgSelCombo;

  VAR
    combo : ImgSelCombo;

  BEGIN
    NEW(combo);
    combo.Init;

    RETURN combo;
  END CreateImgSelCombo;

END VO:Dlg:ImgSel.