(**
  A model for date and time.
**)

(*
    A model for date and time.
    Copyright (C) 2001  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

MODULE VO:Model:DateTime;

IMPORT O   := VO:Base:Object,

       SC  := SysClock;

TYPE
  DateTime*     = POINTER TO DateTimeDesc;
  DateTimeDesc* = RECORD (O.ModelDesc)
                    dateTime- : SC.DateTime;
                  END;

  PROCEDURE (d : DateTime) Init*;

  BEGIN
    d.Init^;

    SC.GetClock(d.dateTime);
  END Init;

  (**
  **)

  PROCEDURE (d : DateTime) SetDateTime*(dateTime : SC.DateTime);

  BEGIN
    d.dateTime:=dateTime;
    d.Notify(NIL);
  END SetDateTime;
  
  PROCEDURE CreateDateTime*():DateTime;
  
  VAR
    model : DateTime;
  
  BEGIN
    NEW(model);
    model.Init;
    
    RETURN model;
  END CreateDateTime;  

END VO:Model:DateTime.