/***************************************************************************
 $RCSfile: cmdlineoptions.h,v $
                             -------------------
    cvs         : $Id: cmdlineoptions.h,v 1.7 2002/08/02 09:56:43 cstim Exp $
    begin       : Sat Dec 15 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/




/*
 */


#ifndef C_CMDLINEOPTIONS_H
#define C_CMDLINEOPTIONS_H


#define CLO_FLAGS_HAS_ARGUMENT 0x00000001
#define CLO_FLAGS_MULTIPLE     0x00000002
#define CLO_FLAGS_LAST         0x80000000

/* Make this header able to be included by both C++ and C. First the
   class definition for the C++ library. */
#ifdef __cplusplus
#include <string>
#endif

#include <openhbci/error.h>

#ifdef __cplusplus
#include <openhbci/conf.h>
#include <openhbci/simpleconfig.h>
#endif

/**
 * @short Describes an option used in CmdLineOptions
 */
typedef struct DLLIMPORT s_CmdLineOptionDescr {
    const char* name;
    unsigned int flags;
    const char* longOption;
    const char* shortOption;
    const char* description;
} s_CmdLineOptionDescr;


#ifdef __cplusplus

namespace HBCI {

/**
 * @short Helper Class to make handling of command line options simple.
 */
class DLLIMPORT CmdLineOptions: public SimpleConfig {
private:
  string _cmdname;
public:
    CmdLineOptions();
    ~CmdLineOptions();

    Error parseOptions(int argc, char **argv, s_CmdLineOptionDescr *od);
    string usage(s_CmdLineOptionDescr *od);

};
} /* namespace HBCI */

typedef struct HBCI::CmdLineOptions HBCI_CmdLineOptions;
#else /* __cplusplus */
typedef struct HBCI_CmdLineOptions HBCI_CmdLineOptions;
#endif /* __cplusplus */

#ifdef __cplusplus
extern "C" {
#endif

    /**
     * C wrapper for the constructor.
     * @author Christian Stimming <stimming@tuhh.de>
     */
    DLLIMPORT HBCI_CmdLineOptions* HBCI_CmdLineOptions_new();

    /**
     * C wrapper for the member function. The Error* pointer 
     * should be free'd by the callee. 
     * @author Christian Stimming <stimming@tuhh.de>
     */
    DLLIMPORT  HBCI_Error*
    HBCI_CmdLineOptions_parseOptions(HBCI_CmdLineOptions* c, 
				  int argc, 
				  char **argv,
				  s_CmdLineOptionDescr *od);
    
    /**
     * C wrapper for the combination of those two member functions, 
     * both of the base class. path is assumed to be root().
     * @author Christian Stimming <stimming@tuhh.de>
     */
    DLLIMPORT  int
    HBCI_CmdLineOptions_findVariableIsValid(HBCI_CmdLineOptions* c, 
					 const char* path);
    
    /**
     * C wrapper for member function of the base class. 
     * path is assumed to be root().
     * @author Christian Stimming <stimming@tuhh.de>
     */
    DLLIMPORT  int HBCI_CmdLineOptions_getIntVariable(HBCI_CmdLineOptions* c,
					       const char* name, 
					       int defval);

    /**
     * C wrapper for member function of the base class. The const
     * char* pointer should be free'd by the callee. path is assumed
     * to be root().  
     * @author Christian Stimming <stimming@tuhh.de>
     */
    DLLIMPORT  char*
    HBCI_CmdLineOptions_getStringVariable(HBCI_CmdLineOptions* c,
                                       const char* name,
                                       const char* defval);

    /**
     * C wrapper for member function of the base class. The const
     * char* pointer should be free'd by the callee. 
     * @author Christian Stimming <stimming@tuhh.de>
     */
    DLLIMPORT  char* HBCI_CmdLineOptions_usage(HBCI_CmdLineOptions* c,
                                          s_CmdLineOptionDescr *od);

#ifdef __cplusplus
}

#endif


#endif
