/***************************************************************************
 $RCSfile: auth.h,v $
                             -------------------
    cvs         : $Id: auth.h,v 1.4 2003/04/19 15:05:00 aquamaniac Exp $
    begin       : Thu Jan 24 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef HBCIAUTH_H
#define HBCIAUTH_H

/** @file auth.h
 *
 * @short Definition of HBCI::Auth. No C wrapper. */

#ifdef __cplusplus
#include <string>
#include <openhbci/dllimport.h>
#include <openhbci/error.h>
#include <openhbci/pointer.h>
namespace HBCI {
  class Auth;
}
#include <openhbci/user.h>
#include <openhbci/hbci.h>

namespace HBCI {
/** 
 * This class provides a method to retrieve a secret (e.g. a pin). The
 * default implementation calls @ref
 * Interactor::msgInputPin(). You may inherit this class to
 * introduce new retrieving mechanisms.
 *
 * @short Interface class to provide a method to retrieve a PIN.
 * @author Martin Preuss<openhbci@aquamaniac.de> */
class DLLIMPORT Auth {
private:
    Hbci *_hbci;
public:
    /**
     * Constructor.
     * @author Martin Preuss<openhbci@aquamaniac.de>
     * @param hbci pointer to central HBCI object
     */
    Auth(Hbci *hbci);

    virtual ~Auth();

    /** 
     * This method retrieves a PIN and writes it into the string
     * reference argument 'secret'.
     *
     * The default implementation calls @ref
     * Interactor::msgInputPin().  If you want to retrieve the PIN
     * by any other means, you can provide your own derivation of
     * Auth and override this method.  You may use the given token
     * to identify the secret.
     *
     * @author Martin Preuss<openhbci@aquamaniac.de>
     *
     * @return returns a Error object to show the result. Call
     * "isOk()" on it, to see if any error occurred.
     *
     * @param user pointer to the user for whom the secret is to be retrieved
     * From this user object you can get all information you might need to
     * show an explanatory dialog.
     *
     * @param token A string providing additional information to
     * identify the PIN OpenHBCI is asking for. When a MediumDDV
     * (chip card) asks for a pin, it shows here the "cardnumber",
     * whereas a MediumRDH presents the "path/filename" of the
     * medium to be accessed.
     *
     * @param secret reference to a string to receive the secret
     * (e.g. the pin).
     *
     * @param createSecret if true then a new secret is to be created.
     * In this case the user should be asked to enter the pin twice.  */
    virtual Error getSecret(Pointer<User> user,
			    const string &token,
			    string &secret,
			    bool createSecret=false);
};
} /* namespace */
#endif /* __cplusplus */


#endif



