/***************************************************************************
 $RCSfile: interactor.cpp,v $
                             -------------------
    cvs         : $Id: interactor.cpp,v 1.11 2004/06/09 16:46:38 aquamaniac Exp $
    begin       : Sat Jun 08 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif


#include <string>
#include <stdio.h>
#include <list>
#include "assert.h"

#include "error.h"
#include "pointer.h"
//#include "auth.h"
//#include "interactor.h"
//#include "date.h"
//#include "value.h"
//#include "hbcistring.h"
//#include "hbci.h"
#include "interactor.h"


namespace HBCI {

Interactor::Interactor()
    :_aborted(false)
{
}


Interactor::~Interactor(){
}


bool Interactor::msgInputPin(Pointer<User> user,
                             string &pin,
                             int minsize,
                             bool newPin){
    return false;
}

void Interactor::msgStartInputPinViaKeypad(Pointer<User> user){
}


void Interactor::msgFinishedInputPinViaKeypad(Pointer<User> user){
}


bool Interactor::msgInsertMediumOrAbort(Pointer<User>,
                                        MediumType){
    return false;
}


bool Interactor::msgInsertCorrectMediumOrAbort(Pointer<User>,
                                               MediumType){
    return false;
}


void Interactor::msgStateResponse(const string&){
}


bool Interactor::keepAlive(){
    if (Hbci::debugLevel()>5)
	fprintf(stderr,"KeepAlive: returning %d\n",!_aborted);
    return !_aborted;
}


} // namespace  HBCI
void HBCI_Interactor_msgStateResponse(HBCI_Interactor *i,
				      const char *msg)
{
    assert(i);
    i->msgStateResponse(string(msg ? msg : ""));
}
void HBCI_Interactor_abort(HBCI_Interactor *i, int a)
{
    assert(i);
    i->abort(a);
}
int HBCI_Interactor_aborted(const HBCI_Interactor *i)
{
    assert(i);
    return i->aborted();
}


int HBCI_Interactor_keepAlive(HBCI_Interactor *i)
{
  assert(i);
  return i->keepAlive()!=false;
}

