/* listwrappers.cpp

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "assert.h"

#include "listwrappers.h"



void list_int_delete(list_int *l)
{
    delete l;
}
void list_int_iter_delete(list_int_iter *l)
{
    delete l;
}
int list_int_size(const list_int *l)
{
    assert(l);
    return l->size();
}
list_int_iter* list_int_begin(const list_int *l)
{
    assert(l);
    return new list_int_iter(l->begin());
}
list_int_iter* list_int_end(const list_int *l)
{
    assert(l);
    return new list_int_iter(l->end());
}
int list_int_iter_get(const list_int_iter *l)
{
    assert(l);
    return (**l);
}
void list_int_iter_next(list_int_iter *l)
{
    assert(l);
    l->operator++();
}
int list_int_iter_equal(const list_int_iter *l1, 
			   const list_int_iter *l2)
{
    assert(l1);
    assert(l2);
    return (*l1) == (*l2);
}
void *list_int_foreach (const list_int *list, 
			list_int_cb func,
			void *user_data)
{
    assert(list);
    assert(func);
    list_int_iter iter, end;
    void *ret = 0l;

    end = list->end();
    for ( iter = list->begin(); iter != end; iter++ ) {
	ret = (*func)( (*iter), user_data);
	if (ret)
	    break;
    }
    return ret;
}
