/***************************************************************************
 $RCSfile: mediumrdhbase.cpp,v $
                             -------------------
    cvs         : $Id: mediumrdhbase.cpp,v 1.6 2003/04/25 01:45:54 aquamaniac Exp $
    begin       : Tue Aug 27 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#include <typeinfo> // for the bad_cast exception 

#include "assert.h"

#include "mediumrdhbase.h"
#include "hbcistring.h"

namespace HBCI {

const unsigned int MediumRDHBase::minPinSize = 4;

MediumRDHBase::MediumRDHBase(const Hbci *hbci)
    :Medium(hbci)
{
}



MediumRDHBase::~MediumRDHBase(){
}


Error MediumRDHBase::changePIN(){
  return Error("MediumRDHBase::changePIN",
	       ERROR_LEVEL_NORMAL,
	       HBCI_ERROR_CODE_UNSUPPORTED,
	       ERROR_ADVISE_ABORT,
	       "method not supported by base class");
}


Error MediumRDHBase::changeContext(int context, int country,
				   const string instcode,
				   const string userid,
				   const string custid,
				   const string server){
  return Error("MediumRDHBase::changeContext",
	       ERROR_LEVEL_NORMAL,
	       HBCI_ERROR_CODE_UNSUPPORTED,
	       ERROR_ADVISE_ABORT,
	       "method not supported by base class");
}




} // namespace HBCI


HBCI_Medium *HBCI_MediumRDHBase_Medium(HBCI_MediumRDHBase *h)
{
  return (h);
}
HBCI_MediumRDHBase *HBCI_Medium_MediumRDHBase(HBCI_Medium *h)
{
  try {
    return dynamic_cast<HBCI_MediumRDHBase*>(h);
  }
  catch (bad_cast) {
    fprintf(stderr,
	    "HBCI_Medium_MediumRDHBase: Caught bad_cast exception.\n");
    return 0l;
  }
}
int HBCI_MediumRDHBase_hasInstSignKey(const HBCI_MediumRDHBase *h)
{
  assert(h);
  return (h->hasInstSignKey());
}
char *
HBCI_MediumRDHBase_getInstIniLetterExponent(const HBCI_MediumRDHBase *h,
					    int usecrypt)
{
  assert(h);
  return hbci_strdup(h->getInstIniLetterExponent(usecrypt));
}
char *
HBCI_MediumRDHBase_getInstIniLetterHash(const HBCI_MediumRDHBase *h,
					int usecrypt)
{
  assert(h);
  return hbci_strdup(h->getInstIniLetterHash(usecrypt));
}
char *
HBCI_MediumRDHBase_getInstIniLetterModulus(const HBCI_MediumRDHBase *h,
					   int usecrypt)
{
  assert(h);
  return hbci_strdup(h->getInstIniLetterModulus(usecrypt));
}
int HBCI_MediumRDHBase_getInstKeyNumber(const HBCI_MediumRDHBase *h,
					int usecrypt)
{
  assert(h);
  return h->getInstKeyNumber(usecrypt);
}
int HBCI_MediumRDHBase_getInstKeyVersion(const HBCI_MediumRDHBase *h,
					 int usecrypt)
{
  assert(h);
  return h->getInstKeyVersion(usecrypt);
}
char *
HBCI_MediumRDHBase_getUserIniLetterExponent(const HBCI_MediumRDHBase *h)
{
  assert(h);
  return hbci_strdup(h->getUserIniLetterExponent());
}
char *
HBCI_MediumRDHBase_getUserIniLetterHash(const HBCI_MediumRDHBase *h)
{
  assert(h);
  return hbci_strdup(h->getUserIniLetterHash());
}
char *
HBCI_MediumRDHBase_getUserIniLetterModulus(const HBCI_MediumRDHBase *h)
{
  assert(h);
  return hbci_strdup(h->getUserIniLetterModulus());
}
int HBCI_MediumRDHBase_getUserKeyNumber(const HBCI_MediumRDHBase *h)
{
  assert(h);
  return h->getUserKeyNumber();
}
int HBCI_MediumRDHBase_getUserKeyVersion(const HBCI_MediumRDHBase *h)
{
  assert(h);
  return h->getUserKeyVersion();
}

