/***************************************************************************
 $RCSfile: updjob.cpp,v $
                             -------------------
    cvs         : $Id: updjob.cpp,v 1.4 2003/01/31 19:13:29 derzach Exp $
    begin       : Sat Jun 08 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/



#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif

#include "updjob.h"
#include "hbcistring.h"


namespace HBCI {

updJob::updJob()
    :_minSigCount(0)
    ,_limitType(0)
    ,_limitDays(0)
{
}


updJob::updJob(const string &s)
:_minSigCount(0)
,_limitType(0)
,_limitDays(0)
{
    _fromString(s);
}


updJob::~updJob() {
}

const Limit updJob::limit() const {
  LimitType type;

  switch (limitType()) {
  case 'T': type = LIMIT_DAY;
	break;
  case 'E': type = LIMIT_JOB;
	break;
  case 'W': type = LIMIT_WEEK;
	break;
  case 'M': type = LIMIT_MONTH;
	break;
  case 'Z': type = LIMIT_TIME;
	break;
  default: type = NO_LIMIT;
	break;
  }

  return Limit(limitValue(),
			   type,
			   limitDays());
}

void updJob::_fromString(const string &deg) {
    unsigned int spos;
    string el;

    spos=0;
    // segment code
    _segmentCode=String::nextDEG(deg, spos);
    spos+=String::nextDEG(deg,spos).length() + 1;
    // number of signatures needed
    _minSigCount=atoi(String::nextDEG(deg,spos).c_str());
    spos+=String::nextDEG(deg,spos).length() + 1;
    // read limit
    el=String::nextDEG(deg,spos);
    spos+=String::nextDEG(deg,spos).length() + 1;
    if (el=="E" || el=="T" || el=="W" || el=="M" || el=="Z") {
        _limitType=el.at(0);
        _limitValue=Value(String::nextDEG(deg, spos));
        spos+=String::nextDEG(deg, spos).length() + 1;
        if (_limitType=='Z')
            _limitDays=atoi(String::nextDEG(deg, spos).c_str());
    }
}

} // namespace HBCI
