/***************************************************************************
 $RCSfile: updjob.h,v $
                             -------------------
    cvs         : $Id: updjob.h,v 1.8 2003/01/31 19:13:29 derzach Exp $
    begin       : Sat Jun 08 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef UPDJOB_H
#define UPDJOB_H

#include <string>

#include <openhbci/value.h>
#include <openhbci/limit.h>

namespace HBCI {

/**
 * @short Internal data that describes a job concerning userParams
 *
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT updJob {
private:
    string _segmentCode;
    int _minSigCount;
    char _limitType;
    Value _limitValue;
    int _limitDays;

    void _fromString(const string &s);

public:
    updJob();
    updJob(const string &s);
    ~updJob();

	const Limit limit() const;

    const string &segmentCode() const { return _segmentCode;};
    void setSegmentCode(const string &s) { _segmentCode=s;};

    int minSigCount() const { return _minSigCount;};
    void setMinSigCount(int i) { _minSigCount=i;};

    char limitType() const { return _limitType;};
    void setLimitType(char c) { _limitType=c;};

    const Value &limitValue() const { return _limitValue;};
    void setLimitValue(const Value &v) { _limitValue=v;};

    int limitDays() const { return _limitDays;};
    void setLimitDays(int i) { _limitDays=i;};

    string dump() const;

};

} /* namespace HBCI */

#endif


