/***************************************************************************
  $RCSfile: mediumpluginlist.cpp,v $
  -------------------
  cvs         : $Id: mediumpluginlist.cpp,v 1.5 2003/06/03 15:00:22 aquamaniac Exp $
  begin       : Thu Apr 24 2003
  copyright   : (C) 2003 by Martin Preuss
  email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif

#include "mediumpluginlist.h"
#include <openhbci/mediumpluginfile.h>
#include <assert.h>



namespace HBCI {


MediumPluginList::MediumPluginList(){
}


MediumPluginList::~MediumPluginList() {
  _plugins.clear();
  _files.clear();
}


const list<Pointer<MediumPlugin> > &MediumPluginList::plugins() const{
  return _plugins;
}


bool MediumPluginList::addPlugin(const API *api,
				 Pointer<MediumPlugin> p){
  list<Pointer<MediumPlugin> >::iterator it;

  for (it=_plugins.begin(); it!=_plugins.end(); it++) {
    if (Hbci::debugLevel()>1)
      fprintf(stderr,
	      "Check: \"%s\" == \"%s\" ?\n",
	      p.ref().mediumTypeName().c_str(),
	      (*it).ref().mediumTypeName().c_str());
    if ((*it).ref().mediumTypeName()==p.ref().mediumTypeName()) {
      // don't add plugins we already have
      if (Hbci::debugLevel()>1)
	fprintf(stderr,
		"Plugin \"%s\" already exists, not added\n",
		p.ref().mediumTypeName().c_str());
      return false;
    }
    else {
      if (Hbci::debugLevel()>1)
	fprintf(stderr, " does not match\n");
    }
  } // for
  _plugins.push_back(p);
  if (Hbci::debugLevel()>1)
    fprintf(stderr,
	    "Plugin \"%s\" added to list\n",
	    p.ref().mediumTypeName().c_str());
  return true;
}


Error MediumPluginList::addPluginFile(const API *api,
				      Pointer<MediumPluginFile> pf){
  Pointer<MediumPlugin> p;

  try {
    p=pf.ref().createMediumPlugin(api);
  }
  catch (Error xerr) {
    return Error("MediumPluginList::addPluginFile", xerr);
  }
  if (addPlugin(api, p))
    _files.push_back(pf);

  return Error();
}


}; // namespace HBCI

void HBCI_MediumPluginList_delete(HBCI_MediumPluginList *l)
{
    delete (l);
}
unsigned int HBCI_MediumPluginList_size(const HBCI_MediumPluginList *l)
{
    assert(l);
    return l->plugins().size();
}
void *HBCI_MediumPluginList_foreach(const HBCI_MediumPluginList *l,
				    HBCI_MediumPluginList_cb func,
				    void *user_data)
{
    assert(l);
    assert(func);
    void *ret = NULL;

    typedef std::list<HBCI::Pointer<HBCI::MediumPlugin> > list_type;
    const list_type& list = l->plugins();
    list_type::const_iterator iter, end;

    end = list.end();
    for ( iter = list.begin(); iter != end; iter++ ) {
	ret = (*func)( iter->ptr(), user_data);
	if (ret)
	    break;
    }
    return ret;
}








