/***************************************************************************
  $RCSfile: pluginfile.cpp,v $
  -------------------
  cvs         : $Id: pluginfile.cpp,v 1.4 2003/05/11 16:56:09 aquamaniac Exp $
  begin       : Mon Apr 14 2003
  copyright   : (C) 2003 by Martin Preuss
  email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif


#include "api.h"
#include "pluginfile.h"


namespace HBCI {



PluginFile::PluginFile(const string &name, const string &prefix)
  :LibLoader(name, prefix)
{
  Error err;

  err=openLibrary();
  if (!err.isOk())
    throw Error("PluginFile::PluginFile", err);

  // Check plugin interface version
  int *interface_version = 
    reinterpret_cast<int*>(resolve("openhbci_plugin_interface_version"));
  if ((interface_version == NULL) ||
      (*interface_version != OPENHBCI_PLUGIN_INTERFACE_VERSION)) {
    fprintf(stderr,
	    "Wrong plugin interface version in plugin %s\n",
            name.c_str());
    throw Error("PluginFile::PluginFile()",
		ERROR_LEVEL_NORMAL,
		HBCI_ERROR_CODE_LIBRARY,
		ERROR_ADVISE_ABORT,
		"Wrong plugin interface version");
  }

  // This is our known interface where we lookup this symbol. 

  // This is basically a reinterpret_cast<REGISTER_YOURSELF_PTR>() but
  // ISO C++ will generate still generate warnings. So we have to
  // resort to the C-style cast.
  _registerYourSelf = (REGISTER_YOURSELF_PTR)(resolve("registerYourSelf"));
  if (_registerYourSelf==0)
    throw Error("PluginFile::PluginFile()",
		ERROR_LEVEL_NORMAL,
		HBCI_ERROR_CODE_LIBRARY,
		ERROR_ADVISE_ABORT,
		"error resolving symbol");
}


PluginFile::~PluginFile(){
}


Error PluginFile::registerYourSelf(API *api){
  return (_registerYourSelf)(api);
}







}; // namespace





