/* progressmonitorcb.cpp
    copyright   : (C) 2002 by Christian Stimming
    email       : stimming@tuhh.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#include "progressmonitorcb.h"

namespace HBCI {

/*ProgressMonitorCB::ProgressMonitorCB(void *user_data) :
    _destrCB(0),
    _transStartedCB(0),
    _transFinCB(0),
    _jobStartedCB(0),
    _jobFinCB(0),
    _actStartedCB(0),
    _actFinCB(0),
    _logMessageCB(0),
    _user_data(user_data)
{
}*/
ProgressMonitorCB::ProgressMonitorCB(VoidFuncTyp destrCB,
				     TransStartedFuncTyp transStartedCB,
				     VoidFuncTyp transFinCB,
				     JobStartedFuncTyp jobStartedCB,
				     VoidFuncTyp jobFinCB,
				     ActStartedFuncTyp actStartedCB,
				     VoidFuncTyp actFinCB,
				     LoggingFuncTyp logMessageCB,
				     void *user_data) :
    _destrCB(destrCB),
    _transStartedCB(transStartedCB),
    _transFinCB(transFinCB),
    _jobStartedCB(jobStartedCB),
    _jobFinCB(jobFinCB),
    _actStartedCB(actStartedCB),
    _actFinCB(actFinCB),
    _logMessageCB(logMessageCB),
    _user_data(user_data)
{
}


ProgressMonitorCB::~ProgressMonitorCB()
{
    if (_destrCB)
	(*_destrCB)(_user_data);
}

void ProgressMonitorCB::transactionStarted(TransProgressType type,
					   string const &descr, 
					   int jobs)
{
    if (_transStartedCB)
	(*_transStartedCB)(type, jobs, _user_data);
    else
	ProgressMonitor::transactionStarted(type, descr, jobs);
}
void ProgressMonitorCB::transactionFinished()
{
    if (_transFinCB)
	(*_transFinCB)(_user_data);
    else
	ProgressMonitor::transactionFinished();
}

void ProgressMonitorCB::jobStarted(JobProgressType type,
				   const string &descr, 
				   int actions)
{
    if (_jobStartedCB)
	(*_jobStartedCB)(type, actions, _user_data);
    else
	ProgressMonitor::jobStarted(type, descr, actions);
}
void ProgressMonitorCB::jobFinished()
{
    if (_jobFinCB)
	(*_jobFinCB)(_user_data);
    else
	ProgressMonitor::jobFinished();
}
void ProgressMonitorCB::actionStarted(ActionProgressType type,
				      const string &descr)
{
    if (_actStartedCB)
	(*_actStartedCB)(type, _user_data);
    else
	ProgressMonitor::actionStarted(type, descr);
}
void ProgressMonitorCB::actionFinished()
{
    if (_actFinCB)
	(*_actFinCB)(_user_data);
    else
	ProgressMonitor::actionFinished();
}
void ProgressMonitorCB::logMessage(const string &msg)
{
    if (_logMessageCB)
	(*_logMessageCB)(msg.c_str(), _user_data);
    else
	ProgressMonitor::logMessage(msg);
}

} // namespace HBCI


/*HBCI_ProgressMonitorCB *HBCI_ProgressMonitorCB_new(void *user_data)
{
    return new HBCI_ProgressMonitorCB(user_data);
}*/
HBCI_ProgressMonitorCB *
HBCI_ProgressMonitorCB_new(VoidFuncTyp destrCB,
			       TransStartedFuncTyp transStartedCB,
			       VoidFuncTyp transFinCB,
			       JobStartedFuncTyp jobStartedCB,
			       VoidFuncTyp jobFinCB,
			       ActStartedFuncTyp actStartedCB,
			       VoidFuncTyp actFinCB,
			       LoggingFuncTyp logMessageCB,
			       void *user_data)
{
    return new HBCI_ProgressMonitorCB(destrCB,
				      transStartedCB,
				      transFinCB,
				      jobStartedCB,
				      jobFinCB,
				      actStartedCB,
				      actFinCB,
				      logMessageCB,
				      user_data);
}

HBCI_ProgressMonitor *
HBCI_ProgressMonitorCB_ProgressMonitor(HBCI_ProgressMonitorCB *p)
{
    return p;
}

    
/*void 
HBCI_ProgressMonitorCB_setDestr(HBCI_ProgressMonitorCB *p, 
				VoidFuncTyp destrCB)
{
    assert(p);
    p->setDestr(destrCB);
}
void 
HBCI_ProgressMonitorCB_setTransStarted(HBCI_ProgressMonitorCB *p, 
				  TransStartedFuncTyp transStartedCB)
{
    assert(p);
    p->setTransStarted(transStartedCB);
}
void 
HBCI_ProgressMonitorCB_setTransFin(HBCI_ProgressMonitorCB *p, 
			      VoidFuncTyp transFinCB)
{
    assert(p);
    p->setTransFin(transFinCB);
}
void 
HBCI_ProgressMonitorCB_setJobStarted(HBCI_ProgressMonitorCB *p, 
				     JobStartedFuncTyp jobStartedCB)
{
    assert(p);
    p->setJobStarted(jobStartedCB);
}
void 
HBCI_ProgressMonitorCB_setJobFin(HBCI_ProgressMonitorCB *p, 
				 VoidFuncTyp jobFinCB)
{
    assert(p);
    p->setJobFin(jobFinCB);
}
void 
HBCI_ProgressMonitorCB_setActStarted(HBCI_ProgressMonitorCB *p, 
				     ActStartedFuncTyp actStartedCB)
{
    assert(p);
    p->setActStarted(actStartedCB);
}
void 
HBCI_ProgressMonitorCB_setActFin(HBCI_ProgressMonitorCB *p, 
				 VoidFuncTyp actFinCB)
{
    assert(p);
    p->setActFin(actFinCB);
}
void 
HBCI_ProgressMonitorCB_setLogMessage(HBCI_ProgressMonitorCB *p, 
				     LoggingFuncTyp logMessageCB)
{
    assert(p);
    p->setLogMessage(logMessageCB);
}*/
