/* bookInMemory.cc
 */
#include "osl/record/opening/bookInMemory.h"
#include "osl/record/opening/openingBook.h"
#include "osl/state/numEffectState.h"
#include "osl/oslConfig.h"
#include <boost/foreach.hpp>

osl::record::opening::
BookInMemory::BookInMemory()
{
  readAll();
}

osl::record::opening::
BookInMemory::~BookInMemory()
{
}

int osl::record::opening::
BookInMemory::readRecursive(const HashKey& key, int index, WeightedBook& book, int depth, int /*parent_visit*/)
{
  const int depth_threshold = 60, visit_threshold = 4, scale = 16;
  if (depth > depth_threshold || table.find(key) != table.end())
    return 0;
  const int visit = book.getBlackWinCount(index)+book.getWhiteWinCount(index);
  if (visit < visit_threshold)
    return 0;
  const vector<record::opening::WMove>& moves = book.getMoves(index);
  FixedCapacityVector<std::pair<int, Move>, 40> children;
  BOOST_FOREACH(WMove move, moves)
  {
    const HashKey child = key.newMakeMove(move.getMove());
    const int cv = readRecursive(child, move.getStateIndex(), book, depth+1, visit);
    if (cv < visit_threshold || cv*scale < visit)
      continue;
    children.push_back(std::make_pair(cv, move.getMove()));
    if (children.size() == children.capacity())
      break;
  }
  std::sort(children.begin(), children.end());
  std::reverse(children.begin(), children.end());
  if (! children.empty()) {
    moves_t& store = table[key];
    store.fill(Move());
    for (size_t i=0; i<children.size(); ++i) {
      store[i] = children[i].second;
      if (i+1 == store.size())
	break;
    }
  }
  return visit;
}

void osl::record::opening::
BookInMemory::readAll()
{
  WeightedBook book(OslConfig::openingBook());
  int index = book.getStartState();
  const NumEffectState state;
  readRecursive(HashKey(state), index, book, 0, 0);
}

void osl::record::opening::
BookInMemory::find(const HashKey& key, MoveVector& out) const
{
  table_t::const_iterator p = table.find(key);
  if (p == table.end())
    return;
  BOOST_FOREACH(Move move, p->second)
    if (move.isNormal())
      out.push_back(move);
}

const osl::record::opening::BookInMemory&
osl::record::opening::
BookInMemory::instance()
{
  static BookInMemory book;
  return book;
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
