#include "osl/record/record.h"
#include "osl/record/csa.h"
#include "osl/record/csaString.h"

#include "osl/effect_util/neighboring25Direct.h"
#include "osl/move_classifier/attackDefenceAroundKing.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;

class AttackDefenceAroundKingTest : public CppUnit::TestFixture 
#if OSL_WORDSIZE == 32
		      , public osl::misc::Align16New
#endif
{
  NumEffectState state;
  CPPUNIT_TEST_SUITE (AttackDefenceAroundKingTest);
  CPPUNIT_TEST (test25White);
  CPPUNIT_TEST (test25Black);
  CPPUNIT_TEST (testAttackBlackKing);
  CPPUNIT_TEST (testAttackWhiteKing);
  CPPUNIT_TEST (testDefenceBlackKing);
  CPPUNIT_TEST (testDefenceWhiteKing);
  CPPUNIT_TEST_SUITE_END ();
  void setup ();
public:
  AttackDefenceAroundKingTest() : state((SimpleState(HIRATE)))
  {
  }
  void test25White ();
  void test25Black ();
  void testAttackBlackKing ();
  void testAttackWhiteKing ();
  void testDefenceBlackKing ();
  void testDefenceWhiteKing ();
};

void
AttackDefenceAroundKingTest::setup ()
{
}

void
AttackDefenceAroundKingTest::test25White ()
{
  state=CsaString(
"P1+NY+RY *  *  * -FU-OU-KE-KY\n"
"P2 *  *  *  *  * -GI-KI *  *\n"
"P3 * -FU *  *  *  * -KI-FU-FU\n"
"P4 * +FU * -FU *  *  *  *  *\n"
"P5 *  * -KE * +FU *  * +FU *\n"
"P6+KE * -FU * +GI *  *  * +FU\n"
"P7 *  * -UM *  *  *  *  *  *\n"
"P8 *  * +FU *  *  *  *  *  * \n"
"P9+OU *  * -GI * -KA *  * -NG\n"
"P+00HI00KI00KE00KY00FU00FU00FU00FU00FU\n"
"P-00KI00KY00FU00FU\n"
"P-00AL\n"
"-\n"
).getInitialState();

  // Attack to Black King
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, PBISHOP),
				  Square(7,7),Square(9,9)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, BISHOP),
				   Square(6,7),Square(9,9)));
  CPPUNIT_ASSERT (!Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, BISHOP),
				   Square(4,9),Square(9,9)));
  CPPUNIT_ASSERT (!Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, ROOK),
				   Square(5,9),Square(9,9)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, KNIGHT),
				   Square(8,7),Square(9,9)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, KNIGHT),
				   Square(7,6),Square(9,9)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, KNIGHT),
				   Square(7,5),Square(9,9)));
  CPPUNIT_ASSERT (!Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, KNIGHT),
				   Square(7,4),Square(9,9)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, KNIGHT),
				   Square(7,5),Square(9,9)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, GOLD),
				   Square(8,7),Square(9,9)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, GOLD),
				   Square(8,6),Square(9,9)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, GOLD),
		  Square(8,6),Square(9,9)));

  // Defence for White King
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, GOLD),
		  Square(2,2),Square(4,1)));

  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, GOLD),
		  Square(2,2),Square(4,1)));

  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, GOLD),
		  Square(4,4),Square(4,1)));
  
  // Defence for Black King
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (BLACK, GOLD),
				   Square(8,7),Square(9,9)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (BLACK, GOLD),
				   Square(8,6),Square(9,9)));
  CPPUNIT_ASSERT (!Neighboring25Direct::
		  hasEffect (state,newPtypeO (BLACK, GOLD),
				   Square(6,6),Square(9,9)));
  
  // Attack for White King
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (BLACK, GOLD),
				  Square(4,4),Square(4,1)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (BLACK, BISHOP),
				  Square(6,5),Square(4,1)));
}

void
AttackDefenceAroundKingTest::test25Black ()
{
  state=CsaString(
"P1+NY+RY *  *  * -FU-OU-KE-KY\n"
"P2 *  *  *  *  * -GI-KI *  *\n"
"P3 * -FU *  *  *  * -KI-FU-FU\n"
"P4 * +FU * -FU *  *  *  *  *\n"
"P5 *  * -KE * +FU *  * +FU *\n"
"P6+KE *  * +FU+GI *  *  * +FU\n"
"P7 *  * -UM *  *  *  *  *  *\n"
"P8 *  * +FU *  *  *  *  *  * \n"
"P9 * +OU * -GI * -KA *  * -NG\n"
"P+00HI00KI00KE00KY00FU00FU00FU00FU00FU\n"
"P-00KI00KY00FU00FU\n"
"+\n"
).getInitialState();

  // Attack to Black King
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, PBISHOP),
				  Square(7,7),Square(9,9)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, BISHOP),
				   Square(6,7),Square(9,9)));
  CPPUNIT_ASSERT (!Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, BISHOP),
				   Square(4,9),Square(9,9)));
  CPPUNIT_ASSERT (!Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, ROOK),
				   Square(5,9),Square(9,9)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, KNIGHT),
				   Square(8,7),Square(9,9)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, KNIGHT),
				   Square(7,6),Square(9,9)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, KNIGHT),
				   Square(7,5),Square(9,9)));
  CPPUNIT_ASSERT (!Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, KNIGHT),
				   Square(7,4),Square(9,9)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, KNIGHT),
				   Square(7,5),Square(9,9)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, GOLD),
				   Square(8,7),Square(9,9)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, GOLD),
				   Square(8,6),Square(9,9)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, GOLD),
		  Square(8,6),Square(9,9)));

  // Defence for White King
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, GOLD),
		  Square(2,2),Square(4,1)));

  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, GOLD),
		  Square(2,2),Square(4,1)));

  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (WHITE, GOLD),
		  Square(4,4),Square(4,1)));
  
  // Defence for Black King
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (BLACK, GOLD),
				   Square(8,7),Square(9,9)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (BLACK, GOLD),
				   Square(8,6),Square(9,9)));
  CPPUNIT_ASSERT (!Neighboring25Direct::
		  hasEffect (state,newPtypeO (BLACK, GOLD),
				   Square(6,6),Square(9,9)));
  
  // Attack for White King
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (BLACK, GOLD),
				  Square(4,4),Square(4,1)));
  CPPUNIT_ASSERT (Neighboring25Direct::
		  hasEffect (state,newPtypeO (BLACK, BISHOP),
				  Square(6,5),Square(4,1)));
}

using namespace osl::move_classifier;

void
AttackDefenceAroundKingTest::testAttackBlackKing ()
{
  state=CsaString(
"P1+NY+RY *  *  * -FU-OU-KE-KY\n"
"P2 *  *  *  *  * -GI-KI *  *\n"
"P3 * -FU *  *  *  * -KI-FU-FU\n"
"P4 * +FU * +FU *  *  *  *  *\n"
"P5 *  * -KE * +FU *  * +FU *\n"
"P6+KE *  * -FU+GI *  *  * +FU\n"
"P7 *  * -UM *  *  *  *  *  *\n"
"P8 *  * +FU *  *  *  *  *  * \n"
"P9 * +OU * -GI * -KA *  * -NG\n"
"P+00HI00KI00KE00KY00FU00FU00FU00FU00FU\n"
"P-00KI00KY00FU00FU\n"
"-\n"
).getInitialState();

  Move move1 = Move (Square (6,7),Square (7,7),
			PBISHOP, PTYPE_EMPTY, false, WHITE);
  CPPUNIT_ASSERT(AttackDefenceAroundKing<BLACK>::isMember(state, move1));

  Move move2 = Move (Square (6,6),Square (6,7),
			PAWN, PTYPE_EMPTY, true, WHITE);
  CPPUNIT_ASSERT(AttackDefenceAroundKing<BLACK>::isMember(state, move2));

  Move move3 = Move (Square (1,9),Square (2,9),
			PSILVER, PTYPE_EMPTY, false, WHITE);
  CPPUNIT_ASSERT(!AttackDefenceAroundKing<BLACK>::isMember(state, move3));

  Move move4 = Move (Square (8,6), GOLD, WHITE);
  CPPUNIT_ASSERT(AttackDefenceAroundKing<BLACK>::isMember(state, move4));

  Move move5 = Move (Square (8,5), GOLD, WHITE);
  CPPUNIT_ASSERT(!AttackDefenceAroundKing<BLACK>::isMember(state, move5));
}

void
AttackDefenceAroundKingTest::testAttackWhiteKing ()
{
  state=CsaString(
"P1+NY+RY *  *  * -FU-OU-KE-KY\n"
"P2 *  *  *  *  * -GI-KI *  *\n"
"P3 * -FU *  *  *  * -KI-FU-FU\n"
"P4 * +FU * +FU *  *  *  *  *\n"
"P5 *  * -KE * +FU *  * +FU *\n"
"P6+KE *  * -FU+GI *  *  * +FU\n"
"P7 *  * -UM *  *  *  *  *  *\n"
"P8 *  * +FU *  *  *  *  *  * \n"
"P9 * +OU * -GI * -KA *  * -NG\n"
"P+00HI00KI00KE00KY00FU00FU00FU00FU00FU\n"
"P-00KI00KY00FU00FU\n"
"+\n"
).getInitialState();

  Move move1 = Move (Square (2,5),Square (2,4),
			PAWN, PTYPE_EMPTY, false, BLACK);
  CPPUNIT_ASSERT(AttackDefenceAroundKing<WHITE>::isMember(state, move1));

  Move move2 = Move (Square (8,1),Square (4,1),
			PROOK, PAWN, false, BLACK);
  CPPUNIT_ASSERT(AttackDefenceAroundKing<WHITE>::isMember(state, move2));

  Move move3 = Move (Square (5,6),Square (4,5),
			SILVER, PTYPE_EMPTY, false, BLACK);
  CPPUNIT_ASSERT(!AttackDefenceAroundKing<WHITE>::isMember(state, move3));

  Move move4 = Move (Square (2,2), GOLD, BLACK);
  CPPUNIT_ASSERT(AttackDefenceAroundKing<WHITE>::isMember(state, move4));

  Move move5 = Move (Square (1,8), ROOK, BLACK);
  CPPUNIT_ASSERT(!AttackDefenceAroundKing<WHITE>::isMember(state, move5));

}

void
AttackDefenceAroundKingTest::testDefenceBlackKing ()
{
  state=CsaString(
"P1+NY+RY *  *  * -FU-OU-KE-KY\n"
"P2 *  *  *  *  * -GI-KI *  *\n"
"P3 * -FU *  *  *  * -KI-FU-FU\n"
"P4 * +FU * +FU *  *  *  *  *\n"
"P5 *  * -KE * +FU *  * +FU *\n"
"P6+KE *  * -FU+GI *  *  * +FU\n"
"P7 *  * -UM *  *  *  *  *  *\n"
"P8 *  * +FU *  *  *  *  *  * \n"
"P9 * +OU * -GI * -KA *  * -NG\n"
"P+00HI00KI00KE00KY00FU00FU00FU00FU00FU\n"
"P-00KI00KY00FU00FU\n"
"+\n"
).getInitialState();

  Move move1 = Move (Square (5,6),Square (6,7),
			SILVER, PTYPE_EMPTY, false, BLACK);
  CPPUNIT_ASSERT(AttackDefenceAroundKing<BLACK>::isMember(state, move1));

  Move move2 = Move (Square (6,6),Square (6,7),
			PAWN, PTYPE_EMPTY, false, BLACK);
  CPPUNIT_ASSERT(!AttackDefenceAroundKing<BLACK>::isMember(state, move2));

  Move move3 = Move (Square (8,8), GOLD, BLACK);
  CPPUNIT_ASSERT(AttackDefenceAroundKing<BLACK>::isMember(state, move3));

  Move move4 = Move (Square (8,8), LANCE, BLACK);
  CPPUNIT_ASSERT(AttackDefenceAroundKing<BLACK>::isMember(state, move4));

  Move move5 = Move (Square (9,7), LANCE, BLACK);
  CPPUNIT_ASSERT(!AttackDefenceAroundKing<BLACK>::isMember(state, move5));
}

void
AttackDefenceAroundKingTest::testDefenceWhiteKing ()
{
  state=CsaString(
"P1+NY+RY *  *  * -FU-OU-KE-KY\n"
"P2 *  *  *  *  * -GI-KI *  *\n"
"P3 * -FU *  *  *  * -KI-FU-FU\n"
"P4 * +FU * +FU *  *  *  *  *\n"
"P5 *  * -KE * +FU *  * +FU *\n"
"P6+KE *  * -FU+GI *  *  * +FU\n"
"P7 *  * -UM *  *  *  *  *  *\n"
"P8 *  * +FU *  *  *  *  *  * \n"
"P9 * +OU * -GI * -KA *  * -NG\n"
"P+00HI00KI00KE00KY00FU00FU00FU00FU00FU\n"
"P-00KI00KY00FU00FU\n"
"-\n"
).getInitialState();

  Move move1 = Move (Square (1,1),Square (1,2),
			LANCE, PTYPE_EMPTY, false, WHITE);
  CPPUNIT_ASSERT(AttackDefenceAroundKing<WHITE>::isMember(state, move1));

  Move move2 = Move (Square (3,3),Square (4,3),
			GOLD, PTYPE_EMPTY, false, WHITE);
  CPPUNIT_ASSERT(AttackDefenceAroundKing<WHITE>::isMember(state, move2));

  Move move3 = Move (Square (1,3),Square (1,4),
			PAWN, PTYPE_EMPTY, false, WHITE);
  CPPUNIT_ASSERT(!AttackDefenceAroundKing<WHITE>::isMember(state, move3));

  Move move4 = Move (Square (4,3), GOLD, WHITE);
  CPPUNIT_ASSERT(AttackDefenceAroundKing<WHITE>::isMember(state, move4));

  // for open moves
  //Move move5 = Move (Square (7,1), GOLD, WHITE);
  //CPPUNIT_ASSERT(AttackDefenceAroundKing<WHITE>::isMember(state, move5));
}

CPPUNIT_TEST_SUITE_REGISTRATION(AttackDefenceAroundKingTest);
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
