/* otflist.c -- List OpenType fonts.

Copyright (C) 2003, 2004
  National Institute of Advanced Industrial Science and Technology (AIST)
  Registration Number H15PRO167

This file is part of libotf.

Libotf is free software; you can redistribute it and/or modify it
under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation; either version 2.1 of the License, or
(at your option) any later version.

Libotf is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library, in a file named COPYING; if not,
write to the Free Software Foundation, Inc., 59 Temple Place, Suite
330, Boston, MA 02111-1307, USA.  */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <dirent.h>

#include <ft2build.h>
#include FT_FREETYPE_H

int
filter (const struct dirent *direntry)
{
  int len = strlen (direntry->d_name);
  const char *ext = direntry->d_name + (len - 4);

  return (len >= 5
	  && (! strncmp (ext, ".ttf", 4)
	      || ! strncmp (ext, ".TTF", 4)
	      || ! strncmp (ext, ".otf", 4)
	      || ! strncmp (ext, ".OTF", 4)
	      || ! strncmp (ext, ".PFA", 4)
	      || ! strncmp (ext, ".pfa", 4)
	      || ! strncmp (ext, ".PFB", 4)
	      || ! strncmp (ext, ".pfb", 4)));
}

int
main (int argc, char **argv)
{ 
  struct dirent **namelist;
  int n;
  int i, j;
  FT_Library ft_library;
  FT_Face face;

  if (FT_Init_FreeType (&ft_library))
    exit (1);

  if (argc == 2)
    chdir (argv[1]);
  n = scandir (".", &namelist, filter, alphasort);

  for (i = 0; i < n; i++)
    if (! FT_New_Face (ft_library, namelist[i]->d_name, 0, &face))
      {
	char *name = alloca (strlen (namelist[i]->d_name)
			     + strlen (face->family_name)
			     + 4);
	sprintf (name, "%s (%s)", namelist[i]->d_name, face->family_name);
	printf ("%-40s %s", name, face->style_name);
	for (j = 0; j < face->num_charmaps; j++)
	  printf (" %d-%d", face->charmaps[j]->platform_id,
		  face->charmaps[j]->encoding_id);
	printf ("\n");
      }
    else
      {
	printf ("%s fail to open\n", namelist[i]->d_name);
      }
  exit (0);
}
