#pragma once

#include <QDebug>
#include <pappsomspp/msfile/msfileaccessor.h>
#include <pappsomspp/pappsoexception.h>
#include <iostream>
#include <iomanip>
#include <odsstream/odsdocwriter.h>

using namespace pappso;

MassSpectrum
readMgf(const QString &filename)
{
  try
    {
      qDebug() << __FILE__ << "@" << __LINE__ << __FUNCTION__ << "()";
      MsFileAccessor accessor(filename, "msrun");
      qDebug() << __FILE__ << "@" << __LINE__ << __FUNCTION__ << "()";
      MsRunReaderSPtr reader =
        accessor.msRunReaderSp(accessor.getMsRunIds().front());
      qDebug() << __FILE__ << "@" << __LINE__ << __FUNCTION__ << "()"
               << accessor.getMsRunIds().front().get()->getXmlId();
      std::cout << __FILE__ << " " << __FUNCTION__ << " " << __LINE__ << " "
                << reader->spectrumListSize() << std::endl;
      MassSpectrumSPtr spectrum_sp = reader->massSpectrumSPtr(0);
      std::cout << __FILE__ << " " << __FUNCTION__ << " " << __LINE__ << " "
                << spectrum_sp.get()->size() << std::endl;
      spectrum_sp.get()->debugPrintValues();
      spectrum_sp.get()->sortMz();
      return *(spectrum_sp.get());
    }
  catch(pappso::PappsoException &error)
    {
      std::cout << __FILE__ << " " << __FUNCTION__ << " " << __LINE__
                << QString("ERROR reading file %1 :")
                     .arg(filename)
                     .toStdString()
                     .c_str()
                << " " << error.what();
      throw error;
    }
}

QualifiedMassSpectrum
readQualifiedMassSpectrumMgf(const QString &filename)
{
  try
    {
      qDebug();
      MsFileAccessor accessor(filename, "msrun");
      qDebug();
      MsRunReaderSPtr reader =
        accessor.msRunReaderSp(accessor.getMsRunIds().front());
      qDebug() << accessor.getMsRunIds().front().get()->getXmlId();
      std::cout << reader->spectrumListSize() << std::endl;
      QualifiedMassSpectrum spectrum_sp =
        reader->qualifiedMassSpectrum(0, true);
      return spectrum_sp;
    }
  catch(pappso::PappsoException &error)
    {
      std::cout << __FILE__ << " " << __FUNCTION__ << " " << __LINE__
                << QString("ERROR reading file %1 : %2")
                     .arg(filename)
                     .arg(error.qwhat())
                     .toStdString()
                     .c_str();
      throw error;
    }
}




class XicOdsWriter
{
  public:
  XicOdsWriter(CalcWriterInterface &output) : _output(output)
  {
    _output.writeCell("rt");
    _output.writeCell("intensity");
    _output.writeLine();
  };

  void
  write(const Trace &xic)
  {
    auto it = xic.begin();
    while(it != xic.end())
      {

        _output.writeCell(it->x);
        _output.writeCell(it->y);
        _output.writeLine();
        it++;
      }
  };

  private:
  CalcWriterInterface &_output;
};
