
// File: test_timsdata_reader_memory.cpp
// Created by: Olivier Langella
// Created on: 12/2/2021
//
/*******************************************************************************
 * Copyright (c) 2021 Olivier Langella
 *<olivier.langella@universite-paris-saclay.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

// make test ARGS="-V -I 1,1"

// ./tests/catch2-only-tests [MemTimsData] -s


#include <catch2/catch.hpp>

#include <QDebug>

#include <pappsomspp/processing/tandemwrapper/tandemwrapperrun.h>
#include "config.h"


using namespace pappso;

TEST_CASE("Check memory usage of timsdata reader.", "[MemTimsData]")
{
  qSetMessagePattern(QString("%{file}@%{line}, %{function}(): %{message}"));
#if USEPAPPSOTREE == 1


  QTextStream errorStream(stderr, QIODevice::WriteOnly);
  QTextStream outputStream(stdout, QIODevice::WriteOnly);

  TandemWrapperRun run_tandem("/usr/bin/tandem", "/tmp");


  for(int i = 0; i < 5; i++)
    {
      INFO(QString("run %1").arg(i).toStdString());
      run_tandem.run(QString("%1/tests/data/tandem/tandem_run_params.xml")
                       .arg(CMAKE_SOURCE_DIR),
                     outputStream,
                     errorStream);
    }
#elif USEPAPPSOTREE == 1

  cout << endl << "..:: NO test TIMS TDF parsing ::.." << endl;

#endif
}

