/*

Copyright (C) 2004 Christian Kreibich

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include <stdio.h>
#include <stdlib.h>
#include <pcapnav.h>

char pcap_errbuf[PCAP_ERRBUF_SIZE];

int
main(int argn, char **argv)
{
  pcap_t *pcap;
  pcap_dumper_t *dumper;
  int i;

  pcapnav_init();
  pcapnav_runtime_options.debug = 1;

  if (argn < 3)
    {
      printf("Usage: %s <FILE1> <FILE2> [FILES]\n"
	     "%s appends the packets of FILE2 and any other traces\n"
	     "given to the end of FILE1. CAUTION: FILE2 is modified.\n",
	     argv[0], argv[0]);
      exit(-1);
    }  

  for (i = 2; i < argn; i++)
    {
      if (! (pcap = pcap_open_offline(argv[i], pcap_errbuf)))
	{
	  printf("Pcap error: %s\n", pcap_errbuf);
	  exit(-1);
	}
      
      if (! (dumper = pcapnav_dump_open(pcap, argv[1],PCAPNAV_DUMP_APPEND_SAFE)))
	{
	  printf("Error appending to file %s: %s.\n", argv[1], pcap_geterr(pcap));
	  exit(-1);
	}

      if (pcap_loop(pcap, -1, pcap_dump, (u_char *) dumper) != 0)
	{
	  printf("%s\n", pcap_geterr(pcap));
	  exit(-1);
	}

      pcap_dump_close(dumper);
      pcap_close(pcap);
    }
}
