/*
 *   File: interfacekit-test.c
 * Author: Jason Watson <jason.watson@agrios.net>
 *   Date: 16-SEP-2004
 *
 * ChangeLog: 16-SEP-2004 - jdw - Initial version
 *            Cloned quadservo-calibrate.c as a starting point
*/
                                                                                
#include <phidgets/interfacekit.h>
#include <stdio.h>

#include <math.h>
#include <string.h>

PhidgetInterfaceKit* init(unsigned short const productid, unsigned int const serial);
void fail_cleanup(PhidgetInterfaceKit* ik, int r);
void cleanup(PhidgetInterfaceKit* ik);

void usage(char** argv)
{
  fprintf(stderr, "\n");
  fprintf(stderr, "usage: %s <iktype> <serial> <action>\n", argv[0]);
  fprintf(stderr, "\n");
  fprintf(stderr, "  iktype is the type of InterfaceKit, one of:\n");
  fprintf(stderr, "    ik-0-0-4\n");
  fprintf(stderr, "    ik-0-16-16\n");
  fprintf(stderr, "    ik-8-8-8\n");
  fprintf(stderr, "    ik-0-5-7\n");
  fprintf(stderr, "    ik-0-8-8\n");
  fprintf(stderr, "\n");
  fprintf(stderr, "  serial is the integer serial number of the InterfaceKit\n");
  fprintf(stderr, "\n");
  fprintf(stderr, "  action is one of:\n");
  fprintf(stderr, "    analoginput-read\n");
  fprintf(stderr, "    digitalinput-read\n");
  fprintf(stderr, "    digitaloutput-allon\n");
  fprintf(stderr, "    digitaloutput-alloff\n");
  fprintf(stderr, "    digitaloutput-on-#\n");
  fprintf(stderr, "    digitaloutput-off-#  (# is a digit from 0 to max_out)\n");
  fprintf(stderr, "\n");
  exit(-1);
}

int main (int argc, char** argv)
{
  if ( (argc == 4) && (atoi(argv[2])>0) )
  {
    // get the productid
    unsigned short productid;
    if ( strncmp(argv[1], "ik-0-0-4", 64)==0 )
    {
      productid=PHIDGETS_USB_PRODUCTID_INTERFACEKIT_0_0_4;
    }
    else if ( strncmp(argv[1], "ik-0-16-16", 64)==0 )
    {
      productid=PHIDGETS_USB_PRODUCTID_INTERFACEKIT_0_16_16;
    }
    else if ( strncmp(argv[1], "ik-8-8-8", 64)==0 )
    {
      productid=PHIDGETS_USB_PRODUCTID_INTERFACEKIT_8_8_8;
    }
    else if ( strncmp(argv[1], "ik-0-5-7", 64)==0 )
    {
      productid=PHIDGETS_USB_PRODUCTID_INTERFACEKIT_0_5_7;
    }
    else if ( strncmp(argv[1], "ik-0-8-8", 64)==0 )
    {
      productid=PHIDGETS_USB_PRODUCTID_INTERFACEKIT_0_8_8;
    }
    else
    {
      usage(argv);
    }

    // get the serial
    unsigned int serial;
    serial=atoi(argv[2]);

    // connect to Phidget
    PhidgetInterfaceKit* ik;
    ik = init(productid, serial);

    // get the action
    if ( strncmp(argv[3],      "analoginput-read", 16)==0 )
    {
      phidget_interfacekit_analoginputs_getcurrentstate(ik);
      int i;
      for (i=0; i < ik->numAnalogInputs; i++)
      {
        printf("digitalin #%.2d = %d\n", i, ik->analogInput[i]);
      }
    }
    else if ( strncmp(argv[3], "digitalinput-read", 17)==0 )
    {
      phidget_interfacekit_digitalinputs_getcurrentstate(ik);
      int i;
      for (i=0; i < ik->numDigitalInputs; i++)
      {
        printf("digitalin #%.2d = %d\n", i, ik->digitalInput[i]);
      }
    }
    else if ( strncmp(argv[3], "digitaloutput-allon", 19)==0 )
    {
      phidget_interfacekit_digitaloutputs_set_all(ik, true);
    }
    else if ( strncmp(argv[3], "digitaloutput-alloff", 20)==0 )
    {
      phidget_interfacekit_digitaloutputs_set_all(ik, false);
    }
    else if ( strncmp(argv[3], "digitaloutput-on-", 17)==0 )
    {
      phidget_interfacekit_digitaloutputs_set_one(ik, atoi(argv[3]+17), true);
    }
    else if ( strncmp(argv[3], "digitaloutput-off-", 18)==0 )
    {
      phidget_interfacekit_digitaloutputs_set_one(ik, atoi(argv[3]+18), true);
    }
    else
    {
      cleanup(ik);
      usage(argv);
    }

  }
  else
  {
    usage(argv);
  }

  return 0;
}

PhidgetInterfaceKit* init(unsigned short const productid, unsigned int const serial)
{
  //phidget_set_debug( PHIDGET_DEBUG_ALL );
  phidget_set_debug( PHIDGET_DEBUG_NOTRACES );
  phidget_set_debug_stream( stderr );

  /*
  hid_set_debug( HID_DEBUG_ALL );
  hid_set_debug_stream( stderr );

  hid_set_usb_debug( 9 );

  ret = hid_dump_tree(stdout, ik->phidget->hid_iface);
  */

  phidget_return ret = phidget_init();
  PhidgetInterfaceKit* ik = phidget_new_PhidgetInterfaceKit();

  ret = phidget_interfacekit_open(ik, productid, serial, 3);

  if (ret != PHIDGET_RET_SUCCESS)
  {
    fprintf(stderr, "failed to open InterfaceKit with serial %d.\n", serial);
    fail_cleanup(ik, 1);
  }

  return ik;
}

void fail_cleanup(PhidgetInterfaceKit* ik, const int r)
{
  cleanup(ik);
  exit(r);
}

void cleanup(PhidgetInterfaceKit* ik)
{
  phidget_interfacekit_close(ik);
  phidget_delete_PhidgetInterfaceKit(&ik);
  phidget_cleanup();
  if (ik) { free ((void *) ik); ik = 0; }
}

/* COPYRIGHT --
 *
 * This file is part of libphidgets, a user-space library for phidgets.
 * libphidgets is (c) 2003-2004 Martin F. Krafft <krafft@ailab.ch>
 * and distributed under the terms of the Artistic Licence.
 * See the ./COPYING file in the source tree root for more information.
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
