#include <phidgets/led64.h>
#include <stdio.h>

#include <string.h>
#include <unistd.h>
#include <time.h>


void usage(void) {
	fprintf(stderr, "Usage: test_libphidgets_led64 serial\n");
}

void cleanup(PhidgetLED64* led64) {
	phidget_led64_close(led64);
	phidget_delete_PhidgetLED64(&led64);
	phidget_cleanup();
}

void fail_cleanup(PhidgetLED64* led64, const int r)
{
	cleanup(led64);
	exit(r);
}


phidget_return fade_in_test(PhidgetLED64* led64)
{

        int i, j;
	phidget_return ret;
	
	fprintf(stderr, "turning on LEDs (%i)...", PHIDGETS_LED64_NUMLEDS);
	for (i = 0; i < 100; i+=5) {
	  for (j = 0; j < PHIDGETS_LED64_NUMLEDS; j++) {
	    /*fprintf(stderr, "setting LED %i...", j);*/
	    ret = phidget_led64_set_level(led64, j, i);
	    if(ret != PHIDGET_RET_SUCCESS) {
	      fprintf(stderr, "couldn't set LED %i (error %i)", i, ret);
	      return ret;
	    }
	  }
	}


	
	fprintf(stderr, "turning off LEDs (%i)...", PHIDGETS_LED64_NUMLEDS);
	for (i = 100; i >= 0; i-=5) {
	  for (j = 0; j < PHIDGETS_LED64_NUMLEDS; j++) {
	    /*fprintf(stderr, "setting LED %i...", j);*/
	    ret = phidget_led64_set_level(led64, j, i);
	    if(ret != PHIDGET_RET_SUCCESS) {
	      fprintf(stderr, "couldn't set LED %i (error %i)", i, ret);
	      return ret;
	    }
	  }
	}

	return PHIDGET_RET_SUCCESS;

}


phidget_return blink_test(PhidgetLED64* led64)
{
        int i, j, count;
	phidget_return ret;

	fprintf(stderr, "blinking LEDs (%i): ", PHIDGETS_LED64_NUMLEDS);
	for (count = 0; count < 20; count++) {
	
	  fprintf(stderr, "HIGH");
	  for (j = 0; j < PHIDGETS_LED64_NUMLEDS; j++) {
	    /*fprintf(stderr, "setting LED %i...", j);*/
	    ret = phidget_led64_set_level(led64, j, 100);
	    if(ret != PHIDGET_RET_SUCCESS) {
	      fprintf(stderr, "couldn't set LED %i (error %i)", i, ret);
	      return ret;
	    }
	  }

	  sleep(0.25);

	  fprintf(stderr, " LOW...");
	  for (j = 0; j < PHIDGETS_LED64_NUMLEDS; j++) {
	    /*fprintf(stderr, "setting LED %i...", j);*/
	    ret = phidget_led64_set_level(led64, j, 0);
	    if(ret != PHIDGET_RET_SUCCESS) {
	      fprintf(stderr, "couldn't set LED %i (error %i)", i, ret);
	      return ret;
	    }
	  }

	}

	fprintf(stderr, "setting LEDs OFF (%i)...", PHIDGETS_LED64_NUMLEDS);
	for (j = 0; j < PHIDGETS_LED64_NUMLEDS; j++) {
	  /*fprintf(stderr, "setting LED %i...", j);*/
	  ret = phidget_led64_set_level(led64, j, 0);
	  if(ret != PHIDGET_RET_SUCCESS) {
	    fprintf(stderr, "couldn't set LED %i (error %i)", i, ret);
	    return ret;
	  }
	}

	return PHIDGET_RET_SUCCESS;

}


int main(int argc, char * argv[]) {
	PhidgetLED64 *led64;
	phidget_return ret;
	
	if(argc != 2) {
		usage();
		return 1;
	}
	
	int serial = atoi(argv[1]);
	
	phidget_set_debug(PHIDGET_DEBUG_ERRORS);
	phidget_set_debug_stream(stderr);
	hid_set_debug(HID_DEBUG_ERRORS);
	hid_set_debug_stream(stderr);

	ret = phidget_init();
	if(ret != PHIDGET_RET_SUCCESS) {
		fprintf(stderr, "failed to init phidgets.\n");
		phidget_cleanup();
		return 1;
	}
	
	led64 = phidget_new_PhidgetLED64();

	ret = phidget_led64_open(led64, serial, 3);
	if(ret != PHIDGET_RET_SUCCESS)
	{
		fprintf(stderr, "failed to open LED64.\n");
		fail_cleanup(led64, 1);
	}

	if (fade_in_test(led64) != PHIDGET_RET_SUCCESS)
	{
		fprintf(stderr, "failed fade in test.\n");
		fail_cleanup(led64, 1);
	}

	if (blink_test(led64) != PHIDGET_RET_SUCCESS)
	{
		fprintf(stderr, "failed blink test.\n");
		fail_cleanup(led64, 1);
	}


	/*
	fprintf(stdout, "sleeping...");
	for (i = 0; i < 600000; i++) {
	  fprintf(stdout, "%i", i % 9);
	  
	}
	*/


	fprintf(stdout, "done.\n");

	cleanup(led64);		
}


