/* a simple driver program to test the macros for libppd */
/* this is a simple proof of concept, NOT a rigorous test suite. */

#include <stdio.h>
#include <glib.h>
#include "ppd.h"

int main(int argc __attribute__ ((unused)), char *argv[]
	 __attribute__ ((unused)))
{
  PpdChoice *choice;
  PpdOption *option;
  PpdGroup *group;
  int return_code = 0;

  if (!(group = ppd_group_new()))
    return_code++;
  if (!(option = ppd_option_new(group, "Choice name")))
    return_code++;
  if (!(choice = ppd_choice_new(option, "Choice name", "Text of choice")))
    return_code++;

  if (PPD_IS_CHOICE(choice))
    printf("Macros say 'choice' is of type PpdChoice\n");
  else {
    printf("Macros say 'choice' is NOT of type PpdChoice\n");
    return_code++;
  }

  if (PPD_IS_OPTION(choice)) {
    printf("Macros say 'choice' is of type PpdOption\n");
    return_code++;
  } else
    printf("Macros say 'choice' is NOT of type PpdOption\n");

  if (PPD_IS_OPTION(option))
    printf("Macros say 'option' is of type PpdOption\n");
  else {
    printf("Macros say 'option' is NOT of type PpdOption\n");
    return_code++;
  }

  if (PPD_IS_CHOICE(option)) {
    printf("Macros say 'option' is of type PpdChoice\n");
    return_code++;
  } else
    printf("Macros say 'option' is NOT of type PpdChoice\n");

  printf("Value of 'choice' before cast == %p\n", choice);

  if (choice = PPD_CHOICE(option))
    return_code++;

  printf("Value of 'choice' after cast == %p\n", choice);

  if(return_code) {
	  printf("testmacros had %d errors.", return_code);
	  return(1);
  }
  return(0);
}
