/****************************************************************************

 Copyright (C) 2002-2013 Gilles Debunne. All rights reserved.

 This file is part of the QGLViewer library version 2.5.2.

 http://www.libqglviewer.com - contact@libqglviewer.com

 This file may be used under the terms of the GNU General Public License 
 versions 2.0 or 3.0 as published by the Free Software Foundation and
 appearing in the LICENSE file included in the packaging of this file.
 In addition, as a special exception, Gilles Debunne gives you certain 
 additional rights, described in the file GPL_EXCEPTION in this package.

 libQGLViewer uses dual licensing. Commercial/proprietary software must
 purchase a libQGLViewer Commercial License.

 This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

*****************************************************************************/

#include "standardCamera.h"
#include "viewer.h"
#include "cameraViewer.h"

#include <QApplication>
#include <QGLViewer/manipulatedCameraFrame.h>

int main(int argc, char** argv)
{
  QApplication application(argc,argv);

  // Instantiate the two viewers.
  StandardCamera* sc = new StandardCamera();
  Viewer viewer(sc);
  CameraViewer cviewer(sc);

  // Make sure every v camera movement updates the camera viewer
  QObject::connect(viewer.camera()->frame(), SIGNAL(manipulated()), &cviewer, SLOT(updateGL()));
  QObject::connect(viewer.camera()->frame(), SIGNAL(spun()), &cviewer, SLOT(updateGL()));
  // Also update on camera change (type or mode)
  QObject::connect(&viewer, SIGNAL(cameraChanged()), &cviewer, SLOT(updateGL()));

  viewer.setWindowTitle("standardCamera");
  cviewer.setWindowTitle("Camera viewer");

  cviewer.show();
  viewer.show();

  return application.exec();
}
