#include <quicktime/lqt.h>
#include <quicktime/colormodels.h>
#include <funcprotos.h>

#include <string.h>

#include "cinepak.h"

typedef struct
  {
  char * work_buffer;
  int work_buffer_size;
  void * decode_handle;
  int decoder_initialized;

  unsigned char * temp_pixels;
  unsigned char ** temp_pixels_rows;
  
  
  int i_width;
  int i_height;

  int o_x;
  int o_y;
  int o_width;
  int o_height;
  } cinepak_decoder_t;

static int delete_codec(quicktime_video_map_t *vtrack)
  {
  cinepak_decoder_t *codec =
    (cinepak_decoder_t *)(((quicktime_codec_t*)vtrack->codec)->priv);
  
  if(codec->work_buffer) free(codec->work_buffer);
  
  if(codec->decode_handle) free(codec->decode_handle);

  if(codec->temp_pixels) free(codec->temp_pixels);
  if(codec->temp_pixels_rows) free(codec->temp_pixels_rows);
  
  free(codec);
  return 0;
  }

static int decode(quicktime_t *file, unsigned char **row_pointers, int track)
  {
  int compressed_size, result, bpp, i, use_temp;

  quicktime_video_map_t *vtrack = &(file->vtracks[track]);
  quicktime_trak_t *trak = vtrack->track;
  cinepak_decoder_t *codec = ((quicktime_codec_t*)vtrack->codec)->priv;

  if(!codec->decoder_initialized)
    {
    codec->decode_handle = decode_cinepak_init();

    codec->i_width = quicktime_video_width(file, track);
    codec->i_height = quicktime_video_height(file, track);
    codec->decoder_initialized = 1;
    }

  quicktime_set_video_position(file, vtrack->current_position, track);
  compressed_size =
    quicktime_frame_size(file, vtrack->current_position, track);

  if(codec->work_buffer_size < compressed_size)
    {
    codec->work_buffer = realloc(codec->work_buffer, compressed_size);
    codec->work_buffer_size = compressed_size;
    }
  result = !quicktime_read_data(file, codec->work_buffer, compressed_size);
  if(!result)
    {
    use_temp = ((file->color_model != BC_BGR888) && (file->color_model != BC_BGR8888))||
      (file->in_x != 0) ||
      (file->in_y != 0) ||
      (file->in_w != codec->i_width) ||
      (file->in_h != codec->i_height) ||
      (file->out_w != codec->i_width) ||
      (file->out_h != codec->i_height);

    if(!codec->temp_pixels)
      codec->temp_pixels = malloc(codec->i_width * codec->i_height * 4 * sizeof(char));
    
    if(use_temp)
      {
      if(!codec->temp_pixels_rows)
        {
        codec->temp_pixels_rows = malloc(codec->i_height * sizeof(char*));
        for(i = 0; i < codec->i_height; i++)
          codec->temp_pixels_rows[i] = &(codec->temp_pixels[i*codec->i_width*4]);
        }
      decode_cinepak(codec->decode_handle, codec->work_buffer, compressed_size,
                     codec->temp_pixels, codec->i_width, codec->i_height,
                     32, (int)(codec->temp_pixels_rows[1] - codec->temp_pixels_rows[0]));
      cmodel_transfer(row_pointers, 
                      codec->temp_pixels_rows,
                      row_pointers[0],
                      row_pointers[1],
                      row_pointers[2],
                      0,
                      0,
                      0,
                      file->in_x, 
                      file->in_y, 
                      file->in_w, 
                      file->in_h,
                      0, 
                      0, 
                      file->out_w, 
                      file->out_h,
                      BC_BGR8888, 
                      file->color_model,
                      0,
                      codec->i_width * 4,
                      file->out_w);
      }
    else if(file->color_model == BC_BGR888)
      {
      decode_cinepak(codec->decode_handle, codec->work_buffer, compressed_size,
                     codec->temp_pixels, codec->i_width, codec->i_height,
                     24, codec->i_width * 4);
      for(i = 0; i < codec->i_height; i++)
        {
        memcpy(row_pointers[i], &(codec->temp_pixels[i*codec->i_width * 4]),
               codec->i_width * 3);
        }
      }
    else if(file->color_model == BC_BGR8888)
      {
      /*      fprintf(stderr, "Decode BGR32\n"); */
      decode_cinepak(codec->decode_handle, codec->work_buffer, compressed_size,
                     codec->temp_pixels, codec->i_width, codec->i_height,
                     32, codec->i_width * 4);
      for(i = 0; i < codec->i_height; i++)
        {
        memcpy(row_pointers[i], &(codec->temp_pixels[i*codec->i_width * 4]),
               codec->i_width * 4);
        }
      }
    }
  return result;
  }

static int reads_colormodel(quicktime_t *file, 
                            int colormodel, 
                            int track)
  {
  return ((colormodel == BC_BGR888) ||
          (colormodel == BC_BGR8888) ||
          (colormodel == BC_RGB888));
  }

void init_codec_cinepak(quicktime_video_map_t *vtrack)
  {
  cinepak_decoder_t *codec = calloc(1, sizeof(cinepak_decoder_t));

  /* Init public items */
  ((quicktime_codec_t*)vtrack->codec)->priv = codec;
  ((quicktime_codec_t*)vtrack->codec)->delete_vcodec = delete_codec;
  ((quicktime_codec_t*)vtrack->codec)->decode_video = decode;
  ((quicktime_codec_t*)vtrack->codec)->reads_colormodel = reads_colormodel;
  }
