/*****************************************************************

  lqt_svq.c

  Copyright (c) 2002 by Burkhard Plaum - plaum@ipf.uni-stuttgart.de

  http://libquicktime.sourceforge.net

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

*****************************************************************/

#include <quicktime/lqt.h>
#include <quicktime/lqt_codecapi.h>
#include <quicktime/colormodels.h>
#include "svq1.h"

extern void quicktime_init_codec_svq1(quicktime_video_map_t *vtrack);


static char * fourccs_svq1[]  = { "SVQ1", (char*)0 };

static int encoding_colormodels_divx[] =
  {
    BC_YUV420P,
    LQT_COLORMODEL_NONE
  };

static lqt_codec_info_static_t codec_info_svq1 =
  {
    name:        "svq1",
    long_name:   "Sorenson SVQ1",       /* Long name of the codec */
    description: "Taken from xine (http://xine.sourceforge.net)",     /* Description            */
    fourccs:     fourccs_svq1,
    type:        LQT_CODEC_VIDEO,
    direction:   LQT_DIRECTION_DECODE,
    encoding_parameters: (lqt_parameter_info_static_t*)0,
    decoding_parameters: (lqt_parameter_info_static_t*)0,
    encoding_colormodels: (int*)0,
    decoding_colormodel: BC_YUV420P
  };

/* These are called from the plugin loader */

extern int get_num_codecs() { return 1; }

extern lqt_codec_info_static_t * get_codec_info(int index)
  {
  if(!index)
    return &codec_info_svq1;
  return (lqt_codec_info_static_t*)0;
  }
     

/*
 *   Return the actual codec constructor
 */

extern lqt_init_video_codec_func_t get_video_codec(int index)
  {
  if(index == 0)
    return quicktime_init_codec_svq1;
  return (lqt_init_video_codec_func_t)0;
  }
