// This is a roxen module. (c) Martin Baehr 1999

// The calendar module. 
// parses the <calender> container, and creates a calendar with events 

//  This code is (c) 1999 Martin Baehr, and can be used, modified and
//  redistributed freely under the terms of the GNU General Public License,
//  version 2.
//  This code comes on a AS-IS basis, with NO WARRANTY OF ANY KIND, either
//  implicit or explicit. Use at your own risk.
//  You can modify this code as you wish, but in this case please
//  - state that you changed the code in the modified version
//  - do not remove my name from it
//  - send me a copy of the modified version or a patch, so that
//    I can include it in the 'official' release.
//  If you find this code useful, please e-mail me. It would definitely
//  boost my ego :)
//  
//  For risks and side-effects please read the code or ask your local 
//  unix or roxen-guru.

constant cvs_version="$Id: calendar.pike,v 1.1 1999/05/06 02:28:00 mb Exp $";

#include <module.h>
inherit "module";
inherit "roxenlib";

static private string doc()
{
  return "The displayed month can be changed with the attributes:\n"
         "<dl>\n"
         "<dt><b>year</b>= <tt>[+|-]number</tt> (optional)\n"
         "<dd>will display the current or given month of the given year.\n"
         "if the number is preceded with + or - it will be added/subtracted "
         "from the current month\n"
         "<dt><b>month</b>= <tt>[+|-]number</tt> (optional)\n"
         "<dd>will display the given month of the current or given year.\n"
         "if the number is preceded with + or - it will be added/subtracted "
         "from the current year\n"
         "<dt><b>type</b>=<tt>string</tt> (optional)\n"
         "<dd>this will select a different subclass from pikes Calendar\n"
         "class for the calendar. Thanks to the great Calendar class\n"
         "no changes needed to be made to support different, even way\n"
         "nonstandard calendars (as long as the concepts Day, Week, Month\n"
         "and Year are present). The default for this can be changed\n"
         "in the admin interface.<br>\n"
         "please note that, even if you use a different calendar type,\n"
         "the events still need to be entered using the gregorian calendar.\n"
         "the event-datess are stored with a unique number, identical"
         "across all calendars, so that any event can be displayed with any\n"
         "calendar type.\n"
         "</dl><p>\n"
         "The contents of the container are first RXML parsed, to\n"
         "allow you to provide your own methods to get events\n"
         "(ie: using <tt>&lt;insert&gt;)<p>\n"
         "The <tt>&lt;calendar&gt;&lt;/calendar&gt;</tt> container\n"
         "understands the <tt>&lt;event&gt;&lt;/event&gt;</tt> container\n"
         "which can be used to display an event description at the given\n"
         "date.\n"
         "<dl>\n"
         "<dt><b>day</b>=<tt>number</tt> (mandatory)\n"
         "<dd>if missing the current day will be used which is probably "
         "not what you want.\n"
         "<dt><b>month</b>=<tt>number</tt> (optional)\n"
         "<dd>if missing the current month will be used.\n"
         "<dt><b>year</b>=<tt>number</tt> (optional)\n"
         "<dd>if missing the current year will be used.\n"
         "</dl>\n"
         "The <tt>&lt;event&gt;&lt;/event&gt;</tt> container may contain\n"
         "anything that you may put into the <tt>&lt;td&gt;&lt;/td&gt; "
         "container.\n";
}

array register_module()
{
  return ({ MODULE_PARSER, "Calendar",
            "Defines the <tt>&lt;calendar&gt;&lt;/calendar&gt;</tt> "
            "container, which produces a calendarpage of the current "
            "month.<br>\nHelp can be displayed with "
            "<tt>&lt;calendar help&gt;&lt;/calendar&gt;</tt><p>\n\n"+doc()
            ,0,1 });
}

int type_is_not_other()
{
  return QUERY(type) != "other";
}

void create()
{
  defvar("type", "ISO", "Type of Calendar to use as default",
         TYPE_STRING_LIST,
         "Select, which subclass from the calendar class you want to "
         "use. Currently available are Austrian, Julian, Swedish, Gregorian, "
         "Orthodox and ISO. Select other if you provide your own class",
         ({ "Austrian", "Julian", "Swedish", "Gregorian", "Orthodox", "ISO", "other" }));

  defvar("typeother", "", "Customn calendar",
         TYPE_STRING,
         "If you have a nonstandard calendar class, put it here",
         0,
         type_is_not_other);
}

string write_month(object m, mapping dates)
{
   object w;
   object today;
   string out="";
   //array(array(string)) month[8][7]; // to bad, this doesn't work :-(
   array month = ({ ({ "","","","","","","" }),({ "","","","","","","" }),
                    ({ "","","","","","","" }),({ "","","","","","","" }),
                    ({ "","","","","","","" }),({ "","","","","","","" }),
                    ({ "","","","","","","" }),({ "","","","","","","" }) });
   int i,j;

   today=function_object(object_program(m))->Day();

   month[0][0]="<td></td>\n";
   
   w=m->day(1)->week();

   i=1;
   foreach (Array.map(w->days(),w->day)->week_day_name(),string n)
   {
      month[i][0]=sprintf("<td valign=top align=right width=\"2%%\" height=\"70\"><font size=\"-1\">%2s</font></td>",Simulate.capitalize(n[0..1]));
      i++;
   }

   j=1;
   do
   {
      array a;
      object d;
      a=Array.map(Array.map(w->days(),w->day),
		  lambda(object d,object m) 
		  { if (d->month()!=m) return 0; else return d; },m);

      month[0][j]=sprintf("<td valign=top align=right><font size=\"-1\">%3s</font></td>\n",w->name());
      i=1;
      foreach (a,d)
      {
	 if (d)
         {
	    month[i][j]=sprintf("<td valign=top align=left width=\"16%%\" bgcolor=\"#cccccc\"><font color=%s size=\"+1\"><b>%2d</b></font><br>%s</td>\n",((d==today)?"blue":(dates[d->julian_day()]?"red":"white")),d->month_day(),(dates[d->julian_day()]?dates[d->julian_day()]:""));
         }
	 else 
         {
             month[i][j]="<td valign=top align=left  width=\"16%%\" bgcolor=\"#808080\">&nbsp;</td>\n";
         }
         i++;
      }
      w++;j++;
   }
   while (w->day(0)->month()==m);

   out="<table border=0 cellspacing=3 cellpadding=2 width=\"98%%\">\n";
   out+=sprintf("<tr><td></td><td colspan=3><font size=\"+1\"><b>%s</b></font></td></tr>\n",
             Simulate.capitalize(m->name())+" "+m->year()->name());

   for(i=0; i<=7; i++)
   {
      out+="<tr>\n";
      for(j=0; j<=6; j++)
      {
         out+=month[i][j];
      }
      out+="</tr>";
   }
   out+="</table>";

   return out;
}

void icontainer_event(string container,
                         mapping arguments,
                         string contents,
                         mapping dates)
{
  string date = Calendar.ISO.Year((arguments->year?(int)arguments->year:Calendar.ISO.Year()->number()))->month((arguments->month?(int)arguments->month:Calendar.ISO.Month()))->day((arguments->day?(int)arguments->day:Calendar.ISO.Day()))->julian_day();

  if (dates[date]) dates[date] = dates[date]+"<br>\n"+contents;
  else dates[date] = contents;
  return;
}

/* A container gets the contents as the third 
* argument. Example: <body Bar=Gazonk>Hi!</body> --> 
* container_body("body", (["bar":"Gazonk"]), 
* "Hi!", ...); 
* Note the lowercasing of Bar. 
*/ 
string container_calendar(string tag_name, 
                     mapping arguments, 
                     string contents, 
                     object request_id, 
                     mapping defines) 
{
  string out="";
  mapping dates=([]);
  string type;
  int month, year;

  contents = parse_rxml(contents, request_id);

  if(type_is_not_other())
    type = QUERY(type);
  else
    type = QUERY(typeother);

  if(arguments->type)
    type=arguments->type; 
  
  year = Calendar[type]["Year"]()->number();
  month = Calendar[type]["Month"]()->number();

  if(arguments->month)
  {
    if((arguments->month)[0] == '-' || (arguments->month)[0] == '+')
      month+=(int)arguments->month; 
    else
      month=(int)arguments->month; 
  }
  if(arguments->year)
  {
    if((arguments->year)[0] == '-' || (arguments->year)[0] == '+')
      year+=(int)arguments->year; 
    else
      year=(int)arguments->year; 
  }
  
  object calendar=Calendar[type]["Year"]();
  parse_html(contents, ([]), ([ "event":icontainer_event ]), dates);

  if(arguments->help)
    out += "<obox><title>The <tt>&lt;calendar&gt;&lt;/calendar&gt;</tt> container</title>\n"+doc()+"</obox>";

  out += write_month(function_object(object_program(calendar))->Year(year)->month(month), dates);

  return out;
}

mapping query_container_callers()
{
  return ([ "calendar":container_calendar, ]);
}
