#!NOMODULE

// xml.pike 
// a set of utility functions for xml-modules

//  This code is (c) 1999 Martin Baehr, and can be used, modified and
//  redistributed freely under the terms of the GNU General Public License,
//  version 2.


constant cvs_version="$Id: xmlutils.pike,v 1.4 2000/07/17 07:40:12 pit Exp $";

#include <module.h>
#include <stdio.h>
inherit "module";
inherit "roxenlib";



static string make_xml_tag_attributes(mapping in) {
  array a=indices(in), b=values(in);
  for(int i=0; i<sizeof(a); i++)
    if(lower_case(b[i]) != a[i])
      if(is_safe_string(b[i]))
        a[i]+="=\""+b[i]+"\"";
  else
    a[i]+="=\""+replace(b[i], ({ "\"", "<", ">", "&" }) ,
			({ "&quot;", "&lt;", "&gt;", "&amp;" }))+"\"";
  return a*" ";
}

static string make_xml_tag(string s,mapping in) {
  string q = make_xml_tag_attributes(in);
  return "<"+s+(strlen(q)?" "+q:"")+"/>";
}

static string make_xml_container(string name,mapping args, string contents) {
  string q = make_xml_tag_attributes(args);
  return "<"+name+(strlen(q)?" "+q:"")+">"+contents+"</"+name+">";
}

mixed callback(string type, string name, mapping attributes, string|array data, mixed ... extra_args) {                        
  mapping out;
    
  if(type=="error") return 0;
  
  if(name) {
    out = ([ "name":name ]);
    if(type) out += ([ "type":type ]);
    if(attributes && sizeof(attributes) > 0) out += ([ "attributes":attributes ]);
    if(data && data == ({}) ) out += ([ "data":({ "" }) ]);
    else out += ([ "data":data ]);
    return out;
  } else {
    return data;
  }
  return 0;
}


string data_to_xml(array data, object id) {
  string out="";
  int i;
  
  for(i=0; i<sizeof(data); i++) { 
    if(mappingp(data[i]) && data[i]->name) {
      if(data[i]->data) {
	out +=  make_xml_container(data[i]->name, data[i]->attributes||([]), data_to_xml(data[i]->data, id));
      } else {
	out +=  make_xml_tag(data[i]->name, data[i]->attributes||([]));
      }
    } else {
      out += replace(data[i],
		     ({ "<", ">", "&" }) ,
		     ({ "&lt;", "&gt;", "&amp;" }));
    }
  }
  return out;
}
 
















/*
class doParse {
  inherit Parser.HTML;

  mapping(string:string|function) m_tags, m_containers;

  void create (mapping(string:string|function) tags,
               mapping(string:string|function) containers,
               mixed... extra) {
    m_tags = tags;
    m_containers = containers;
    add_containers (mkmapping (
			       indices (m_containers),
                               ({compat_call_container}) * sizeof (m_containers)
			       )
		    );
    _set_tag_callback (compat_call_tag);
    set_extra (@extra);
    case_insensitive_tag (1);
    lazy_entity_end (1);
    match_tag (0);
    ignore_unknown (1);
  }
}

static int|string|array(string) compat_call_container 
  (Parser.HTML p, mapping(string:string) args, string content, mixed... extra) {
  
  string name = lower_case (p->tag_name());
  if (string|function container = p->m_containers[name])
    if (stringp (container)) return ({container});
    else return container (name, args, content, @extra);
  else
    // The container has disappeared from the mapping.
    p->add_container (name, 0);
  return 1;
}

static int|string|array(string) compat_call_tag 
  (Parser.HTML p, string str, mixed... extra) {
  
  string name = lower_case (p->tag_name());
  if (string|function tag = p->m_tags[name])
    if (stringp (tag))
      return ({[string]tag});
    else 
      return ([function(string,mapping,mixed...:string|array(string))]tag) (name, p->tag_args(), @extra);
  else if (string|function container = p->m_containers[name])
    // A container has been added.
    p->add_container (name, compat_call_container);
  return 1;
}


string parse_template (string data, mapping tags, mapping containers, mixed... args) {
  return doParse (tags, containers, @args)->finish (data)->read();
}
*/
