#!/usr/bin/env pike

void main(int argc,array argv) {
  if(argc != 3) {
    write("Usage: "+argv[0]+" imho.pike imho_somelang.pike\n");
    return;
  }

  array imho = Stdio.read_bytes(argv[1])/"\n";
  string layout = Stdio.read_bytes(argv[2]);
  int idx1 = search(imho,"// BEGIN MESSAGES");
  int idx2 = search(imho,"// END MESSAGES");

  if(idx1 != -1 && idx2 != -1 && idx2 > idx1) {
    array messages = ({ });
    string s;
    foreach(imho[idx1+1..idx2-1], string line) {
      s = 0;
      sscanf(line,"#define%*[ \t]M_%s%*[ \t]",s);
      if(s)
	messages += ({ s });
    }
    string langfile = Stdio.read_bytes(argv[2]);
    
    foreach( messages, string message) 
      if(search(langfile, "M_" + message) == -1)
	write("Missing message: M_" + message + "\n");
    
  }
}
    
    
