/*
  imho_portuguese.pike v0.1 for IMHO v0.96.3
  
  Copyright  
  Luis Furquim <vuco@prr4.gov.br> 1999
  
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  See the file "LICENSE" for details.

*/

// Messages
//
//login
#define M_LOGIN 1
#define M_PASSWORD 2
#define M_NOLOGIN 3
#define M_IMAPERROR 10
#define M_SMTPERROR 11
#define M_SAVEDUSERINTERFACE 12
#define M_USERINTERFACE 13
#define M_LOGIN_OK 14
// page header
#define M_NEWMAIL 50
#define M_MAILBOX 51
#define M_MAILBOXES 52
#define M_FILES 53
#define M_PREFS 54
#define M_LOGOUT 55
#define M_CURRMAILBOX 56
#define M_CHECKACTIVEMAILBOXES 57
// compose
#define M_SEND 100
#define M_CANCELSEND 101
#define M_SENDMOREFILES 102
#define M_COMPOSEMAIL 103
#define M_SPELLCHECK 104
#define M_DONTSAVEMAIL 105
#define M_ADDFILEASATTACHMENT 106
#define M_NOATTACHMENTS 107
#define M_ADDATTACHMENT 108
#define M_REMOVEMARKEDATTACHMENTS 109
#define M_UPLOADATTACHMENT 110
#define M_ADDMARKEDTOATTACHMENTS 111
#define M_UPLOADTOATTACHMENTS 112
#define M_BACKTOCOMPOSE 113
#define M_NOATTACHFILES 114
#define M_ATTACHMENTSHEADER 115
#define M_SENDSAVEFAILED 116
#define M_SENDNORECV 117
// mailindex
#define M_DELETEMARKED 200
#define M_MOVEMARKED 201
#define M_SELECTMBOX 202
#define M_CHECKNEWMAIL 203
#define M_MAILSHOWN 204
#define M_BACKN 205
#define M_FORWARDN 206
#define M_NUMBER 207
#define M_DELETEMARKEDP 208
#define M_DELETEMARKEDNONE 209
#define M_CHANGESORTORDER 210
#define M_MOVETOTRASH 211
#define M_DELETEALLTRASH 212
#define M_NOMAILS 213
// mailboxlist
#define M_MBOXNAME 300
#define M_DELETEMARKEDMBOX 301
#define M_CREATEMBOX 302
#define M_NEWMBOXNAME 303
#define M_MBOXREMOVEP 350
#define M_MBOXMARKONE 351
#define M_NEWMBOXNONAME 352
#define M_CREATEMBOXERROR 353
#define M_INBOX 354
#define M_PREVIOUS_LEVEL 355
#define M_FOLDER_PATH 356
// files
#define M_FILENAME 400
#define M_SIZE 401
#define M_MIMETYPE 402
#define M_DELETEMARKEDFILES 403
#define M_UPLOAD 404
#define M_AVAILSPACE 405
#define M_WINDOWSBUG 406
#define M_NOFILES 407
// preferences
#define M_PNAME 500
#define M_PMAILADDRESS 501
#define M_PMAILPATH 502
#define M_PINCLUDEMAIL 503
#define M_PQUOTEPREFIX 504
#define M_PSIGNATURE 505
#define M_PINACTIVELOGOUT 506
#define M_PSAVEANDUSE 550
#define M_PVISIBLEMESSAGES 507
#define M_PSORTORDER 508
#define M_PSORTORDERS 509
#define M_PTRASHFOLDER 510
#define M_PSENTFOLDER 511
#define M_PDEFAULTBCC 512
#define M_PSAVEATTACHMENTS 513
#define M_PLANGUAGE 514
#define M_PUSERINTERFACE 515
#define M_PINBOXES 516
#define M_PCOMMASEPARATED 517
// logout
#define M_LOGOUTMSG 600
#define M_LOGGEDOUT 601
// dialog
#define M_QUESTION 700
#define M_INFO 701
// readmail
#define M_REPLY 800
#define M_READPREV 801
#define M_READNEXT 802
#define M_ATTACHMENTLINK 803
#define M_MAILMISSING 804
#define M_MAILMISSINGBACK 805
#define M_DELETE 806
#define M_FORWARD 807
#define M_MAIL 808
#define M_SHOWFULLHEADERS 809
#define M_HIDEFULLHEADERS 810
#define M_MAILTOOBIG 811
//spellcheck
#define M_SPELLDONE 900
#define M_SPELLPREV 901
#define M_SPELLNEXT 902
#define M_SPELLCHANGETO 903
#define M_SPELLSUGGESTIONS 904
// mailheaders
#define M_FROM 1000
#define M_TO 1001
#define M_CC 1002
#define M_BCC 1003
#define M_SUBJECT 1004
#define M_ATTACHMENTS 1005
#define M_TIME 1006
#define M_DATE 1007
// table heads
#define M_MARKFLAG 1100
#define M_NEWFLAG 1101
#define M_ANSWEREDFLAG 1102
// address book
#define M_ADDRESSBOOKTITLE 1200
#define M_ADDRESSBOOK 1201
#define M_INDEXNAMERECIPIENT 1202
#define M_INDEXNAMEEDIT 1203
#define M_ADDRESS 1204
#define M_NOADDRESSES 1205
#define M_NEWADDRESS 1206
#define M_EDITADDRESS 1207
#define M_ADDADDRESS 1208
#define M_INDEXNAME 1209
#define M_ADDRESSFORMAT 1210
#define M_SAVEADDRESS 1211
#define M_DELETEADDRESS 1212
#define M_CANCELADDRESS 1213
#define M_CANNOTIMPORT 1214
#define M_IMPORTADDRESSBOOKTITLE 1215
#define M_UPLOADADDRESSBOOK 1216
#define M_PINELOCATION 1217
#define M_UPLOADANDIMPORT 1218
#define M_IMPORTADDRESSBOOK 1219
//ldap support
#define M_LDAPTITLE 1300
#define M_LDAP 1301
#define M_SEARCHLDAP 1302
#define M_NAMECONT 1303
// general
#define M_YES 2000
#define M_NO 2001
#define M_DIALOGOK 2002
#define M_DIALOGCANCEL 2003

string imho_lang() {
  return "portugues";
}

string imho_lang_short() {
  return "pt";
}

string imho_lang_charset() {
  return "iso-8859-1";
}

string msg(object sessobj,int m,array arg) {
  switch(m) {
    
    // Login page
    
  case M_LOGIN:
    //return "Login:";
    return "Usurio:";
  case M_PASSWORD:
    //return "Password:";
    return "Senha:";
  case M_NOLOGIN:
    //return "<b>Could not log in:</b> Wrong login or password. Try again. ";
    return "<b>No conseguiu logar em:</b> Senha ou usurio errado. Tente novamente. ";
  case M_IMAPERROR:
    //return "There was a problem talking to the mail (IMAP) server. Please contact the administrator.";
    return "Ocorreu um problema contactando o servidor (IMAP). Contacte o administrador do sistema.";
  case M_SMTPERROR:
    //return "There was a problem talking to the outgoing mail (SMTP) server. The recipient of the mail might not exist.";
    return "Ocorreu um problema contactando o servidor (SMTP). O destinatrio do mail pode no existir.";
  case M_SAVEDUSERINTERFACE:
    //return "From preferences";
    return "Das Preferncias";
  case M_USERINTERFACE:
    //return "User interface:";
    return "Interface de usurio:";
  case M_LOGIN_OK:
    //return "OK";
    return "OK";

  case M_NEWMAIL:
    //return "New mail";
    return "Nova Mensagem";
  case M_MAILBOX:
    //return sprintf("Mailbox: %s",@arg);
    return sprintf("Caixa Postal: %s",@arg);
  case M_MAILBOXES:
    //return "Mailboxes";
    return "Caixas Postais";
  case M_FILES:
    //return "Files";
    return "Arquivos";
  case M_PREFS:
    //return "Preferences";
    return "Preferncias";
  case M_LOGOUT:
    //return "Logout";
    return "Logout";
  case M_CURRMAILBOX:
    // return "Current Mailbox";
    return "Caixa Postal Atual";
  case M_CHECKACTIVEMAILBOXES:
    // return "Check active mailboxes";
    return "Verificar caixas postais ativas";

  case M_FROM:
    //return "From";
    return "De";
  case M_TO:
    //return "To";
    return "Para";
  case M_CC:
    //return "Cc";
    return "Cc";
  case M_BCC:
    //return "Bcc";
    return "Bcc";
  case M_SUBJECT:
    //return "Subject";
    return "Assunto";
  case M_ATTACHMENTS:
    //return "Attachments";
    return "Anexos";
  case M_TIME:
    //return "Time";
    return "Hora";
  case M_DATE:
    //return "Date";
    return "Data";
    
  case  M_MARKFLAG:
    //return "M";
    return "M";
  case M_NEWFLAG:
    //return "N";
    return "N";
  case M_ANSWEREDFLAG:
    //return "A";
    return "R";
    
    
  case M_SEND:
    //return "Send";
    return "Enviar";
  case M_CANCELSEND:
    //return "Cancel";
    return "Cancelar";
  case M_SENDMOREFILES:
    //return "Select files to send. Press 'Ctrl' to toggle-select multiple files.";
    return "Selecione arquivos para enviar. Pressione 'Ctrl' para mudar a seleo de mltiplos arquivos.";
  case M_COMPOSEMAIL:
    //return "Compose mail";
    return "Composio de Mensagem";
  case M_SPELLCHECK:
    return "Verificao de Ortografia";
  case M_DONTSAVEMAIL:
    //return "Do not save this mail.";
    return "No salve esta mensagem.";
  case M_ADDFILEASATTACHMENT:
    //return "Add file as attachment";
    return "Acrescentar arquivo como anexo";
  case M_NOATTACHMENTS:
    //return "No attachments";
    return "Sem anexos";
  case M_ADDATTACHMENT:
    //return "Add attachment...";
    return "Acrescente anexos...";
  case M_REMOVEMARKEDATTACHMENTS:
    //return "Remove marked attachments";
    return "Remover anexos marcados";
  case M_UPLOADATTACHMENT:
    //return "Upload attachment";
    return "Upload anexo";
  case M_ADDMARKEDTOATTACHMENTS:
    //return "Add marked to attachments";
    return "Acrescentar anexos marcados";
  case M_UPLOADTOATTACHMENTS:
    //return "Upload to attachments";
    return "Upload para anexos";
  case M_BACKTOCOMPOSE:
    //return "Back to compose";
    return "Retorna a composio de mensagem";
  case M_NOATTACHFILES:
    //return "No files";
    return "Nenhum arquivo";
  case  M_ATTACHMENTSHEADER:
    return "Cabealho do anexo";
  case M_SENDSAVEFAILED:
    //return "Mail was sent successfully, but save in folder failed.";
    return "Mensagem enviada com sucesso, mas no conseguiu salvar na pasta.";
  case M_SENDNORECV:
    //return "You must specify a recipient of the mail.";
    return "Voce tem que especificar um destinatrio para a mensagem.";

  case M_DELETEMARKED:
    //return "Delete marked";
    return "Excluir marcados";
  case M_MOVEMARKED:
    //return "Move marked to";
    return "Mover marcados para";
  case M_SELECTMBOX:
    //return "(Select a mailbox)";
    return "(Selecione uma caixa postal)";
  case M_CHECKNEWMAIL:
    //return "Check for new mail";
    return "Checar Novas Mensagens";
  case M_MAILSHOWN:
    // return sprintf("Mail %d-%d of %d", @arg);
    return sprintf("Mensagem %d-%d de %d", @arg);
  case M_BACKN:
    //return sprintf("[<< Prev %d]", @arg);
    return sprintf("[<< Anterior %d]", @arg);
  case M_FORWARDN:
    // return sprintf("[Next %d >>]", @arg);
    return sprintf("[Prximo %d >>]", @arg);
  case M_NUMBER:
    return "N&ordm;";
  case M_DELETEMARKEDP:
    //sprintf("Are you sure you want to delete the %d marked message(s)?", 
    return sprintf("Voc tem certeza que quer excluir a(s) %d mensagem(ens) marcada(s)?", @arg);
  case M_DELETEMARKEDNONE:
    //return "Please mark some messages first.";
    return "Marque alguma mensagem primeiro.";
  case M_CHANGESORTORDER:
    //return "Change sort order";
    return "Mudar ordenao";
  case M_MOVETOTRASH:
    //return "Move marked to trash";
    return "Mover mensagens marcadas para trash";
  case M_DELETEALLTRASH:
    //return "Delete ALL trash";
    return "Excluir TUDO em trash";
  case M_NOMAILS:
    // return "[No mails]";
    return "[Nenhuma mensagem]";

  case M_MBOXNAME:
    //return "Mailbox";
    return "Caixa Postal";
  case M_DELETEMARKEDMBOX:
    //return "Delete marked";
    return "Excluir marcados";
  case M_CREATEMBOX:
    //return "Create a new mailbox";
    return "Criar uma nova pasta";
  case M_NEWMBOXNAME:
    //return "(Name)";
    return "(Nome)";

  case M_MBOXREMOVEP:
    //return "Are you sure you want to delete the following mailboxes?";
    return "Tem certeza que voc quer excluir as seguintes caixas postais?";
  case M_MBOXMARKONE:
    //return "Mark at least one mailbox.";
    return "Marque pelo menos uma caixa postal.";    
  case M_NEWMBOXNONAME:
    // return "Type in a name first.";
    return "Digite um nome primeiro.";
  case M_CREATEMBOXERROR:
    //return "Failed to create mailbox. The name may be illegal or the mailbox may exist.";
    return "Falha na criao de caixa postal. O nome pode ser ilegal ou a caixa postal j existe.";
  case M_INBOX:
    //return "Inbox";
    return "Inbox";
  case M_PREVIOUS_LEVEL:
    //return "[Previuos level]";
    return "[Nvel anterior]";
  case M_FOLDER_PATH:
    //return "Path:";
    return "Caminho:";
	
  case M_FILENAME:
    //return "Filename";
    return "Nome do arquivo";
  case M_SIZE:
    //return "Size";
    return "Tamanho";
  case M_MIMETYPE:
    //return "Type";
    return "Tipo";
  case M_DELETEMARKEDFILES:
    //return "Delete marked";
    return "Excluir marcados";
  case M_UPLOAD:
    //return "Upload";
    return "Upload";
  case M_AVAILSPACE:
    //return sprintf("You have %d Kb available for upload.",@arg);
    return sprintf("Voc tem %d Kb disponveis para upload.",@arg);
  case M_WINDOWSBUG :
    //return "Windowsusers: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.";
    return "Usurios Windows: Devido a um bug em alguns navegadores. nomes de arquivos podem perder caracteres.  Evite isto modificando as ocorrncias de '\\' por '\\\\' antes de clicar 'Upload'.";
  case M_NOFILES:
    //return "You have no uploades files.";
    return "Voc no realizou nenhum upload.";

  case M_PNAME:
    //return "Name";
    return "Nome";
  case M_PMAILADDRESS:
    //return "Mail address";
    return "E-Mail";
  case M_PMAILPATH:
    //return "Mail searchpath";
    return "Diretrio de e-mail";

  case M_PINCLUDEMAIL:
    //return "Include mail when replying";
    return "Incluir mail quando responder";
  case M_PQUOTEPREFIX :
    //return "Prefix";
    return "Prefixo";
  case M_PSIGNATURE:
    //return "Signature";
    return "Assinatura";
  case M_PINACTIVELOGOUT:
    //return "Inactive logout (minutes)";
    return "Logout inativo (minutos)";
  case M_PSAVEANDUSE:
    //return "Save and use";
    return "Salvar e usar";
  case M_PVISIBLEMESSAGES:
    //return "Messages shown in mailbox";
    return "Mensagens na caixa postal";
  case M_PSORTORDER:
    //return "Mail sort order";
    return "Ordenao de mensagens";
  case M_PSORTORDERS:
    //return ([ "forward": "forward", "backward":"backward"])[arg[0]];
    return ([ "avanar": "avanar", "retornar":"retornar"])[arg[0]];
  case M_PTRASHFOLDER:
    //return "Trash folder";
    return "Pasta Trash";
  case M_PSENTFOLDER:
    //return "Sent mail folder";
    return "Pasta Sent";
  case M_PDEFAULTBCC:
    //return "Default Bcc address";
    return "Endereo Bcc padro";
  case M_PSAVEATTACHMENTS:
    //return "Save attachments";
    return "Salvar anexos";
  case M_PLANGUAGE:
    //return "Language";
    return "Lngua";
  case M_PUSERINTERFACE:
    //return "User interface";
    return "Interface de usurio";

  case M_PINBOXES:
    //return "Inboxes";
    return "Inboxes";
  case M_PCOMMASEPARATED: 
    //return "(Comma separated list of mailboxes)";
    return "(Lista de caixas postais separada por vrgulas)";

  case M_SPELLDONE:
    //return "Done";
    return "Feito";
  case M_SPELLPREV:
    //return "Previous";
    return "Anterior";
  case M_SPELLNEXT:
    //return "Next";
    return "Prximo";
  case  M_SPELLCHANGETO:
    //return "Change to";
    return "Trocar para";
  case M_SPELLSUGGESTIONS:
    //return "Suggestions";
    return "Sugestes";

  case M_LOGOUTMSG:
    //return "You are logged out. Close this browser window to make sure no one can read your mails.<br><br>Reload this page to login.";
    return "Voc est desconectado. Feche esta janela do navegador para ter certeza que ningum possa ler suas mensagens.<br><br>Pressione Reload para fazer nova conexo";
  case M_LOGGEDOUT:
    //return "Logged out";
    return "Desconectado";

  case M_QUESTION:
    //return "Question"; 
    return "Pergunta";
  case M_INFO:
    //return "Info"; 
    return "Informao";

  case M_REPLY:
    //return "Reply";
    return "Responder";

  case M_READPREV:
    //return "Read previous";
    return "Ler anterior";
  case M_READNEXT:
    //return "Read next";
    return "Ler prximo";
  case M_ATTACHMENTLINK:
    //return sprintf("%sattachment of type %s",@arg);
    return sprintf("%sanexo do tipo %s",@arg);
  case M_MAILMISSING:
    //return "<b>Error:</b> Failed to fetch mail. Try again. <br>";
    return "<b>Erro:</b> Falha na busca da mensagem. Tente novamente.<br>";
  case M_MAILMISSINGBACK:
    //return "Back";
    return "Retorno";
  case M_DELETE:
    //return "Delete";
    return "Exclui";
  case M_FORWARD:
    //return "Forward";
    return "Encaminhar";
  case M_MAIL:
    // return "Mail";
    return "Mensagem";
  case M_SHOWFULLHEADERS:
    //return "Show full headers";
    return "Mostrar cabealhos completos";
  case M_HIDEFULLHEADERS:
    //return "Hide full headers";
    return "Esconder cabealhos completos";
  case M_MAILTOOBIG:
    // return "Mail is too big to be shown. Click here to download it.";
    return "Mensagem muito grande para ser visualizada. Clique aqui para iniciar download.";

  case M_ADDRESSBOOKTITLE: 
    //return("Address Book");         
    return("Livro de endereos");
  case M_ADDRESSBOOK:
    //return("Address book...");
    return("Livro de endereos...");
  case M_INDEXNAMERECIPIENT:
    //return("Intex name (click to add as recipient)");
    return("Nome (Clique para acrescentar destinatrio)");
  case M_INDEXNAMEEDIT:
    //return("Index name (click to edit)");
    return("Nome (Clique para editar)");
  case M_ADDRESS:
    //return("Address");
    return("Endereo");
  case M_NOADDRESSES:
    //return("No addresses");
    return("Nenhum endereo");
  case M_NEWADDRESS:
    //return("New address...");
    return("Novo endereo...");
  case M_EDITADDRESS:
    //return("Edit address");
    return("Editar endereo");
  case M_ADDADDRESS:
    //return("Add to address book");
    return("Acrescentar ao livro de endereos");
  case M_INDEXNAME:
    //return("Index name");
    return("Nome");
  case M_ADDRESSFORMAT:
    //return("Address(es), comma separated");
    return("Endereo(s), Lista separada por vrgulas");
  case M_SAVEADDRESS:
    //return("Save and use");
    return("Gravar e usar");
  case M_DELETEADDRESS:
    //return("Delete address");
    return("Excluir endereo");
  case M_CANCELADDRESS:
    //return("Cancel");
    return("Cancelar");
  case M_CANNOTIMPORT:
    //return("Cannot import this addressbook, since its\nformat is not recognized.");
    return("No conseguiu importar o livro de endereos,\nformato desconhecido.");
  case M_IMPORTADDRESSBOOKTITLE:
    //return("Import address book");
    return("Importar livro de endereos");
  case M_UPLOADADDRESSBOOK:
    //return("Upload a Pine or exported Netscape (.ldif) address book");
    return("Upload de livro de endereos do Pine ou exportado do Netscape (.ldif)");
  case M_PINELOCATION:
    //return("The Pine address book is often in ~/.addressbook");
    return("O livro de endereos do Pine est, freqentemente, em  ~/.addressbook");
  case M_UPLOADANDIMPORT:
    //return("Upload and import");
    return("Upload e importao");
  case M_IMPORTADDRESSBOOK:
    // return("Import address book...");
    return("Importar livro de endereos...");

  case M_LDAPTITLE:
    //return("LDAP addresses");
    return("Endereo LDAP");
  case M_LDAP:
    //return("LDAP");
    return("LDAP");
  case M_SEARCHLDAP:
    //return("Search LDAP");
    return("Procurar LDAP");
  case M_NAMECONT:
    //return("Search name containing:");
    return("Procurar nome contendo:");

  case M_YES:
    //return "Yes";
    return "Sim";
  case M_NO:
    //return "No";
    return "No";
  case M_DIALOGOK:
    // return "OK";
    return "OK";
  case M_DIALOGCANCEL:
    // return "Cancel";
    return "Cancelar";

  }
  return 0;
}





