//
// Kiwilogger.pike
//
// (C)Copyright  1997,1998,1999, Xavier Beaudouin <kiwi@oav.net>
//
// This code is (c) 1997-1999 Xavier BEAUDOUIN and can be used, modified
// redistributed freely under the terms of the GNU General Public License,
// version 2.
// This code comes on a AS-IS basis, with NO WARRANTY OF ANY KIND, either
// implicit or explicit. Use at your own risk.
// You can modifiy this code as you wish, but in this case please
// - state that you changed the code in the modified version
// - do not remove my name and email from it
// - send me a cope of the modified version or a path, so that I can
//   include it in the 'official' release.
// If you find this code useful, please email me, send pizza, postcard or
// anything that can definitely boost my ege ;-)
//
// For risks and side-effects please read the code or ask your local unix
// or roxen guru ;-)

string cvs_version = "$Id: kiwilogger.pike,v 1.3 1999/05/21 13:39:37 kiwi Exp $";

#include <module.h>
#include <stdio.h>    // This is needed for Roxen 1.1.1, Roxen IPP and Roxen 1.2
inherit "module";
inherit "roxenlib";
int pid;
array register_module()
{
  return ({ MODULE_LOGGER, 
	      "Kiwi\'s HTTPD simulated logger", 
	      "This logger simulater HTTPD log file format <b>with</b> the query string"
	  });
}

void create()
{
  defvar("logfile","/var/log/httpd/httpd.log","Log file",
         TYPE_STRING,
         "This is the file where is logged all clients accesses.\n");
}

// This is a pointer to the method 'log' in the file object. For speed.
function logf;

void start()
{
  object c;
  logf=0; // Reset the old value, if any..

  if(!(c=open(query("logfile"), "wca")))
    report_error("Clientlogger: Cannot open logfile.\n");
  else
    logf = c->write;
}

/*
 * function log,
 *
 * This function log the access from client according to his request id
 *
 * The logfile format is :
 * 'host name or host ip' - 'referer or direct' - ['date in cern http format'] 'raw url with query' 'http code' 'size'
 *
 */ 
void log(object id, mapping file) 
{
// Was last form of log file
// logf && logf(roxen->quick_ip_to_host(id->remoteaddr) + " - " + id->referer*"" + " - ["+  cern_http_date(id->time) + "]  \"" + id->method + " " + id->raw_url + " " + id->clientprot  + "\" " + (file->error||200) + " " + file->len +"\n");

 logf && logf(roxen->quick_ip_to_host(id->remoteaddr)  + " " + (sizeof(id->referer)?id->referer[0]:"-") + " - ["+  cern_http_date(id->time) + "] \"" + id->method + " " + id->raw_url + " " + id->clientprot + "\" " + (file->error||200) + " " + file->len +"\n");
}
