// This is a roxen module.
// $Id: meta.pike,v 1.4 2000/01/07 13:52:21 jee Exp $
// jee@alcom.aland.fi

#include <module.h>
inherit "module";
inherit "roxenlib";
import String;
import Stdio;

// This module is thread safe
constant thread_safe=1;

void create()
{
  defvar("metaext", "meta", "Metafile extension", TYPE_STRING,
	 "Extension of metafiles, eg the metafile of <i>foo.html</i> would be "
	 "<i>foo.html.meta</i> if extension is set to <i>meta</i>." );
  defvar("extensions", ( { "gif", "jpg" } ), 
	 "Sourcefile extensions", TYPE_STRING_LIST,
	 "Files ending with one of these extensions will be subject to "
	 "processing." );
}

mixed *register_module()
{
  return ({ 
    MODULE_FILTER,
    "Meta header module", 
    ("Allows you to create metafiles containing HTTP header information that "
     "will be appended to the headers of the file being served. Particularly "
     "useful for setting expiretimes on images and other binary files that "
     "otherwise is subject to browser proprietary caching settings. See "
     "<a href='http://www.w3.org/Daemon/User/Config/General.html#MetaSuffix'>"
     "http://www.w3.org/Daemon/User/Config/General.html#MetaSuffix</a> and "
     "<a href='http://www.roxen.com/documentation/challenger1.2/"
     "appendix.html#appendixC'>HTTP header response lines</a> "
     "for additional info. "
     "<BR><b>$Id: meta.pike,v 1.4 2000/01/07 13:52:21 jee Exp $</b><br>"
     "<i>This module is distributed under GPL.</i><br>"
     "Suggestions and comments to <i>jee@alcom.aland.fi</i>"),
    0,
    0
  });
}

// The name of this instance of the module
string query_name()
{
  return( "Meta header - <I>" + query("metaext") + "</I>" );
}


// The main function
mapping filter( mapping result, object id )
{
  string ext = query("metaext");
  array (string) extensions = query("extensions");
  mapping heads = ([]);
  string metafilename;
  string filename;
  string data;
  string lval;
  string rval;

  // Are we interested in this file?
  filename = id->not_query;
  if( search( extensions, extension(filename) ) < 0 )
    return( 0 );

  // Check if metafile exists, if so open it
  metafilename = id->conf->real_file(filename + "." + ext, id );
  if( !metafilename )
    return( 0 );

  // On failure to open the file, there should probably be a log message or
  // something generated. HTTP error result is not a good idea since it 
  // might disrupt an otherwise deliverable page.
  object metafile = Stdio.File( metafilename, "r" );
  if( metafile->errno() )
    return( 0 );

  // Read metafile, parse all headers
  data = metafile->read(0x7ffffff);
  while( sscanf( data, "%[^\n:]:%[^\n]%*[\n]%s", lval, rval, data ) == 4 )
    heads += ([ lval:rval ]);

  return( result + ([ "extra_heads":heads ]) );
}
