#ifndef funtxt_SERIALIZER_H_INCLUDED
#define funtxt_SERIALIZER_H_INCLUDED 1

////////////////////////////////////////////////////////////////////////
// data_node_serializers.h: some file parsers for the s11n framework
//
// License: Public Domain
// Author: stephan@s11n.net
////////////////////////////////////////////////////////////////////////

#define MAGIC_COOKIE_FUNTXT "#SerialTree 1"

#define TAB(LEVEL,ECHO) indent = ""; for( size_t i = 0; i < depth + LEVEL; i++ ) { indent += '\t'; if(ECHO) dest << '\t'; }

namespace S11N_NS {
	namespace io {
                namespace sharing {
                        /**
                           Sharing context used by funtxt_serializer.
                         */
                        struct funtxt_sharing_context {};

                }

                /**
                   The entity translations map used by funtxt_serializer.
                 */
                entity_translation_map & funtxt_serializer_translations();


                /**
                   De/serializes objects from/to this class' config-file-like grammar.
                */
                template <typename NodeType>
                class funtxt_serializer : public tree_builder_lexer<NodeType,sharing::funtxt_sharing_context>
                {
                public:
                        typedef NodeType node_type;

                        typedef funtxt_serializer<node_type> this_type; // convenience typedef
                        typedef tree_builder_lexer<node_type,sharing::funtxt_sharing_context> parent_type; // convenience typedef

                        funtxt_serializer() : parent_type( "funtxt_data_nodeFlexLexer" ), m_depth(0)
                        {
                                this->magic_cookie( MAGIC_COOKIE_FUNTXT );
                        }

                        virtual ~funtxt_serializer() {}

                        /**
                           Reimplemented to return this type's entity
                           translation map.
                         */
                        virtual const entity_translation_map & entity_translations() const
                        {
                                return funtxt_serializer_translations();
                        }


                        /**
                           Writes src out to dest.
                        */
                        virtual bool serialize( const node_type & src, std::ostream & dest )
                        {
                                size_t depth = this->m_depth++;
                                if ( 0 == depth )
                                {
                                        dest << this->magic_cookie() << '\n';
                                }

                                std::string nname = src.name();
                                std::string impl = src.impl_class();
                                std::string indent;
                                std::string quote =
                                        (std::string::npos != src.impl_class().find('<'))
                                        ? "\""
                                        : "";

                                dest << nname << " class=" << quote << impl << quote <<"\n";
                                TAB(0,1);
                                dest <<"{\n";
                                std::string propval;
                                std::string key;

                                TAB(1,0);
                                std::for_each(src.begin(),
                                              src.end(),
                                              key_value_serializer<node_type>(
                                                                              &(this->entity_translations()),
                                                                              dest,
                                                                              indent,
                                                                              " ",
                                                                              "\n" )
                                              );

                                TAB(1,0);
                                std::for_each( src.children().begin(),
                                               src.children().end(),
                                               node_child_simple_formatter<this_type>( *this,
                                                                                 dest,
                                                                                 indent,
                                                                                 "" )
                                               );

                                TAB(0,1);
                                dest << "}\n";
                                if( 0 == depth )
                                {
                                        dest.flush();
                                        // if we don't do this then the client is possibly forced to flush() the stream :/
                                }
                                --this->m_depth;
                                return true;
                        }

                private:
                        size_t m_depth;
                };





	} // namespace io
} // namespace S11N_NS
#undef TAB
#endif // funtxt_SERIALIZER_H_INCLUDED
