#!/do/not/bash
# toc_run_description = looking for ssh and scp
# toc_begin_help =
#
# Looks for ssh and scp in ${PATH}. Optionally accepts these
# configure arguments:
#	--with-ssh=/path/to/ssh
#	--with-scp=/path/to/scp
#
# The search path may optionally be passed in as $1.
#
# Returns non-zero if either of them is not found, and zero
# if both are found.
# It calls toc_export for the following vars:
#
#	SCP_BIN=/path/to/scp
#	SSH_BIN=/path/to/ssh
#	SCP_MAKE=/path/to/SCP.make (a toc helper snippet)
#
# = toc_end_help

path="${1-${PATH}}"

err=0

SSH_BIN=
SCP_BIN=


err1=0
err2=0

toc_find ${configure_with_ssh-ssh} ${path} && SSH_BIN=${TOC_FIND_RESULT} || {
    err1=$?
    echo "ssh not found. Try using --with-ssh=/path/to/ssh"
}
toc_export SSH_BIN=${SSH_BIN}

toc_find ${configure_with_scp-scp} ${path} && SCP_BIN=${TOC_FIND_RESULT} || {
    err2=$?
    echo "scp not found. Try using --with-scp=/path/to/scp"
}
toc_export SCP_BIN=${SCP_BIN}

toc_find SCP.make ${TOC_HOME}/make
toc_export SCP_MAKE=${TOC_FIND_RESULT}

test x0 = "x$err1" -a x0 = "x$err2"
return $?

