#define yyFlexLexer funtxt_data_nodeFlexLexer
#define yywrap funtxt_data_nodewrap

/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /home/daffy/u0/vern/flex/RCS/flex.skl,v 2.91 96/09/10 16:58:48 vern Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5



/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <iostream>
#include <unistd.h>

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int yy_size_t;


struct yy_buffer_state
	{
	std::istream* yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};


/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer



static void *yy_flex_alloc YY_PROTO(( yy_size_t ));
static void *yy_flex_realloc YY_PROTO(( void *, yy_size_t ));
static void yy_flex_free YY_PROTO(( void * ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)

typedef unsigned char YY_CHAR;
#define yytext_ptr yytext

#include <s11n/FlexLexer.h>


/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 16
#define YY_END_OF_BUFFER 17
static yyconst short int yy_accept[103] =
    {   0,
        0,    0,    0,    0,    0,    0,   17,   15,   15,    6,
       15,   15,    6,   15,   15,    8,    9,   11,   13,   11,
       11,    4,    3,    4,    3,    3,    4,   15,    6,    0,
        6,    0,    0,    0,    1,   14,    0,    0,    0,    0,
       10,   12,    0,    3,    2,    0,    0,   14,    0,    0,
        1,    0,    0,    0,   10,    5,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    7,    0,    0,    0,
        7,    0,    0,    7,    0,    0,    7,    0,    0,    7,
        0,    0,    0,    0,    0,    0,    7,    7,    0,    0,
        0,    0,    7,    0,    0,    7,    0,    0,    0,    7,

        0,    0
    } ;

static yyconst int yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    1,    5,    6,    1,    1,    1,    7,    1,
        1,    8,    9,   10,    9,   11,   12,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   14,    6,   15,
       16,   17,    1,    1,   18,   19,   18,   19,   20,   21,
       19,   19,   19,   19,   19,   19,   19,   19,   22,   18,
       19,   19,   18,   19,   19,   19,   19,   19,   19,   19,
        1,   23,    1,    1,   19,    1,   24,   19,   25,   19,

       26,   19,   19,   19,   19,   19,   19,   27,   19,   19,
       19,   19,   19,   19,   28,   19,   19,   19,   19,   19,
       19,   19,   29,    1,   30,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst int yy_meta[31] =
    {   0,
        1,    2,    3,    4,    5,    2,    6,    7,    1,    8,
        1,    2,    9,    8,    8,    1,    8,   10,    9,   10,
        9,    9,    1,    9,    9,    9,    9,    9,    7,    7
    } ;

static yyconst short int yy_base[124] =
    {   0,
        0,    0,   28,   30,   51,   79,  179,  518,   33,    0,
       25,  165,  169,  108,   29,  518,  518,  518,  518,  173,
       39,  167,  166,   36,  164,   38,  518,   60,    0,   61,
        0,  158,  135,  160,  162,   54,   50,    0,    0,   48,
       48,   73,  157,  160,  518,  146,   81,   82,   79,   80,
      158,  138,  150,  147,   92,  518,  101,  146,  109,  134,
      129,  128,  136,   93,   95,  109,  110,  115,  118,  100,
      518,   81,    0,  126,    0,  183,   76,   61,  197,   87,
        0,  126,  211,  225,   51,  239,  128,  253,  130,  267,
      281,  295,  309,   30,  323,  136,    0,  137,  337,  351,

        0,  518,  368,  378,  387,  397,  405,  411,  421,  431,
      433,  435,  442,  449,  451,  458,  465,  472,  479,  486,
      493,  500,  507
    } ;

static yyconst short int yy_def[124] =
    {   0,
      102,    1,  103,  103,  104,  104,  102,  102,  105,  106,
      102,  102,  106,  102,   14,  102,  102,  102,  102,  102,
      102,  102,  107,  102,  107,  107,  102,  105,  106,  105,
      106,  102,  102,  102,  106,  102,   34,   14,   15,   15,
      102,  102,  102,  107,  102,  102,  102,  102,  102,  102,
      106,  102,  102,   15,  102,  102,  102,  102,  102,  102,
      102,  102,  102,  108,  109,  110,  108,  109,  109,  110,
      102,  102,  111,  109,  112,  113,  112,  114,  113,  114,
      115,  114,  116,  117,  118,  116,  118,  117,  118,  119,
      120,  121,  120,  122,  121,  122,   86,  122,  123,  123,

       95,    0,  102,  102,  102,  102,  102,  102,  102,  102,
      102,  102,  102,  102,  102,  102,  102,  102,  102,  102,
      102,  102,  102
    } ;

static yyconst short int yy_nxt[549] =
    {   0,
        8,    9,    8,    9,    8,   10,    8,    8,   11,    8,
       12,   13,   14,    8,    8,    8,    8,   15,   15,   15,
       15,   15,    8,   15,   15,   15,   15,   15,   16,   17,
       19,   21,   19,   21,   28,   32,   28,   33,   29,  102,
       42,   39,   42,   43,   29,   43,   96,   45,   39,   55,
       20,   55,   20,   23,   39,   36,   53,   36,   24,   46,
       54,   28,   47,   28,   47,   29,  102,   87,   25,   49,
       26,   29,  102,   27,   42,   49,   42,   80,   52,   25,
       25,   23,   47,   48,   47,   48,   24,   53,   58,   72,
       81,   57,   59,   55,   75,   55,   25,   65,   26,   66,

       82,   27,   48,   80,   48,   52,   71,   25,   25,   36,
       48,   36,   48,   57,  102,   71,  102,   69,   37,   71,
       38,   59,   74,   72,   73,   39,   39,   40,   39,   39,
       71,   39,   39,   40,   39,   39,   48,   69,   48,   84,
       69,   89,   80,   91,   87,   37,   87,   33,   69,   98,
       99,   64,   96,   96,   49,   63,   62,   61,   59,   54,
       49,   48,   57,   48,   60,   51,   56,  102,   45,   51,
       34,   43,   34,   43,   43,   41,   35,   34,  102,   50,
      102,  102,  102,  102,  102,   50,   78,  102,  102,  102,
      102,  102,   78,  102,  102,  102,   78,   78,  102,   80,

       78,  102,  102,  102,  102,  102,   78,  102,  102,  102,
       78,   78,  102,   80,   85,  102,  102,  102,  102,  102,
       85,  102,  102,  102,   85,   85,  102,   87,   78,  102,
      102,  102,  102,  102,   78,  102,  102,  102,   78,   78,
      102,   80,   85,  102,  102,  102,  102,  102,   85,  102,
      102,  102,   85,   85,  102,   87,   78,  102,  102,  102,
      102,  102,   78,  102,  102,  102,   82,   90,  102,   80,
       78,  102,  102,  102,  102,  102,   78,  102,  102,  102,
       78,   78,  102,   80,   85,  102,  102,  102,  102,  102,
       85,  102,  102,  102,   85,   85,  102,   87,   94,  102,

      102,  102,  102,  102,   94,  102,  102,  102,   94,   94,
      102,   96,   85,  102,  102,  102,  102,  102,   85,  102,
      102,  102,   89,   97,  102,   87,   94,  102,  102,  102,
      102,  102,   94,  102,  102,  102,   94,   94,  102,   96,
       94,  102,  102,  102,  102,  102,   94,  102,  102,  102,
       94,   94,  102,   96,   94,  102,  102,  102,  102,  102,
       94,  102,  102,  102,   98,  101,  102,   96,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   22,   22,
       22,   22,   22,   22,   22,   22,   22,   22,   30,  102,
       30,  102,  102,  102,  102,   30,   30,   31,   31,  102,

       31,   31,   31,   31,   31,   31,   31,   44,  102,  102,
      102,   44,  102,  102,   44,   67,   67,  102,  102,   67,
       67,   68,   68,   68,   68,  102,   68,   68,   68,   68,
       68,   70,   70,   70,   70,   70,   70,   70,   70,   70,
       70,   76,   76,   77,   77,   79,  102,  102,  102,   79,
       79,   79,   78,  102,  102,  102,   78,   78,   78,   83,
       83,   86,  102,  102,  102,   86,   86,   86,   88,  102,
      102,  102,   88,   88,   88,   85,  102,  102,  102,   85,
       85,   85,   92,  102,  102,  102,   92,   92,   92,   93,
      102,  102,  102,   93,   93,   93,   95,  102,  102,  102,

       95,   95,   95,   94,  102,  102,  102,   94,   94,   94,
      100,  102,  102,  102,  100,  100,  100,    7,  102,  102,
      102,  102,  102,  102,  102,  102,  102,  102,  102,  102,
      102,  102,  102,  102,  102,  102,  102,  102,  102,  102,
      102,  102,  102,  102,  102,  102,  102,  102
    } ;

static yyconst short int yy_chk[549] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        3,    4,    4,    4,    9,   11,    9,   11,    9,   15,
       21,   15,   21,   24,    9,   26,   94,   24,   15,   41,
        3,   41,    4,    5,   15,   36,   40,   36,    5,   26,
       40,   28,   30,   28,   30,   28,   30,   85,    5,   37,
        5,   28,   30,    5,   42,   37,   42,   78,   36,    5,
        5,    6,   47,   48,   47,   48,    6,   49,   50,   77,
       77,   49,   50,   55,   72,   55,    6,   64,    6,   64,

       80,    6,   57,   80,   57,   47,   70,    6,    6,   14,
       59,   14,   59,   57,   67,   66,   67,   65,   14,   68,
       14,   59,   69,   67,   67,   14,   14,   14,   14,   14,
       74,   14,   14,   14,   14,   14,   33,   68,   33,   82,
       69,   87,   82,   89,   87,   33,   89,   33,   74,   96,
       98,   63,   96,   98,   33,   62,   61,   60,   58,   54,
       33,   34,   53,   34,   52,   51,   46,   44,   43,   35,
       32,   25,   34,   23,   22,   20,   13,   12,    7,   34,
        0,    0,    0,    0,    0,   34,   76,    0,    0,    0,
        0,    0,   76,    0,    0,    0,   76,   76,    0,   76,

       79,    0,    0,    0,    0,    0,   79,    0,    0,    0,
       79,   79,    0,   79,   83,    0,    0,    0,    0,    0,
       83,    0,    0,    0,   83,   83,    0,   83,   84,    0,
        0,    0,    0,    0,   84,    0,    0,    0,   84,   84,
        0,   84,   86,    0,    0,    0,    0,    0,   86,    0,
        0,    0,   86,   86,    0,   86,   88,    0,    0,    0,
        0,    0,   88,    0,    0,    0,   88,   88,    0,   88,
       90,    0,    0,    0,    0,    0,   90,    0,    0,    0,
       90,   90,    0,   90,   91,    0,    0,    0,    0,    0,
       91,    0,    0,    0,   91,   91,    0,   91,   92,    0,

        0,    0,    0,    0,   92,    0,    0,    0,   92,   92,
        0,   92,   93,    0,    0,    0,    0,    0,   93,    0,
        0,    0,   93,   93,    0,   93,   95,    0,    0,    0,
        0,    0,   95,    0,    0,    0,   95,   95,    0,   95,
       99,    0,    0,    0,    0,    0,   99,    0,    0,    0,
       99,   99,    0,   99,  100,    0,    0,    0,    0,    0,
      100,    0,    0,    0,  100,  100,    0,  100,  103,  103,
      103,  103,  103,  103,  103,  103,  103,  103,  104,  104,
      104,  104,  104,  104,  104,  104,  104,  104,  105,    0,
      105,    0,    0,    0,    0,  105,  105,  106,  106,    0,

      106,  106,  106,  106,  106,  106,  106,  107,    0,    0,
        0,  107,    0,    0,  107,  108,  108,    0,    0,  108,
      108,  109,  109,  109,  109,    0,  109,  109,  109,  109,
      109,  110,  110,  110,  110,  110,  110,  110,  110,  110,
      110,  111,  111,  112,  112,  113,    0,    0,    0,  113,
      113,  113,  114,    0,    0,    0,  114,  114,  114,  115,
      115,  116,    0,    0,    0,  116,  116,  116,  117,    0,
        0,    0,  117,  117,  117,  118,    0,    0,    0,  118,
      118,  118,  119,    0,    0,    0,  119,  119,  119,  120,
        0,    0,    0,  120,  120,  120,  121,    0,    0,    0,

      121,  121,  121,  122,    0,    0,    0,  122,  122,  122,
      123,    0,    0,    0,  123,  123,  123,  102,  102,  102,
      102,  102,  102,  102,  102,  102,  102,  102,  102,  102,
      102,  102,  102,  102,  102,  102,  102,  102,  102,  102,
      102,  102,  102,  102,  102,  102,  102,  102
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "funtxt_data_node.flex"
#define INITIAL 0
#line 3 "funtxt_data_node.flex"


namespace { // to get doxygen to ignore these comments :/
    /**
       my first lex :)

       This code is for parsing Rusty Ballinger's "text mode
       serialization format" (or "funtxt", as we call it).

       Here's a rough sample of it's supported format:

       nodename class=ClassName
       {
           property1_name property1_value
           property2_name "value with spaces"
           propertyN_name 'or single quotes'
           foo this \
           	line is split \
                with backslashes. Literal backslashes must be \
                escaped, c-style, like this: \\
           # comment lines
           nodename class=SomeClass
           {
           ...
           }
       }

       Extensions to the original format, probably not tolerated by
       older code and should probably be left out:

       - comment lines can start with ; or # or //

       - C++-style comment blocks are supported.


     Known problems:

     - If node_depth() is non-zero when this code starts parsing then it
     does not work properly at all. In practice this has never happened.

    - add syntax extension:
        nodename class=SomeClass N
      where N is a number. That is, the node is replicated N times into the
      output.

    - add syntax extension:
       # nodename class=Foo
      will comment out the whole class block.


    */

} // namespace

#define YY_SKIP_YYWRAP 1
int yywrap() { return 1; }


#ifdef NDEBUG
#  undef NDEBUG // force assert()
#endif

#include <iostream>
#include <string>
#include <deque>
#include <cassert>

#include <s11n/key_value_parser.h>


#include <s11n/string_util.h> // translate_entities()
#include <s11n/data_node_format.h> // node_tree_builder, parens_serializer, etc.
#include <s11n/funtxt_serializer.h> // funtext_sharing_context
#include <s11n/debuggering_macros.h> // CERR

#define LEXCERR if( 0 ) CERR << "funtxt lexer: "

#include <s11n/class_loader.h>
class funtxt_data_nodeFlexLexer;
s11n_CLASSLOADER_REGISTER(FlexLexer,funtxt_data_nodeFlexLexer);


using std::cin;
using std::cerr;
using std::cout;
using std::endl;




namespace  funtxt
{

        /**
           Runs key_value_parser::parse(str) and saves the result in the
           lexer's kvp object.  If this function returns false then
           kvp is in an undefined state, otherwise kvp holds a key and
           value parsed from str.

           Accepted formats:

           key value value value ...

           key = value value value ...

           key

           todo: return a std::pair instead of using key_value_parser
           (it's usage is legacy stuff).

        */
        bool parseKVP( const std::string & str, s11n::key_value_parser & kvp )
        { // todo: clean this shit up!!!
                LEXCERR << "parseKVP(["<<str<<"])\n";
                std::string delim = " \t";

                std::string::size_type pos;
                pos = str.find_first_of( delim );
                std::string key = str.substr( 0, pos );
                s11n::trim_string( key );
                kvp.key( key );
                if( std::string::npos == pos )
                {
                        kvp.value( "" );
                        return true;
                }

                std::string val = str.substr( pos+1 ); // s11n::trim_string(  );
                s11n::translate_entities( val, s11n::io::funtxt_serializer_translations(), true );
                LEXCERR << "prop ["<<key<<"]=["<<val<<"]"<<std::endl;
                kvp.value( val );
                return true;
        }
};


namespace {
	typedef s11n::io::tree_builder_context<
                s11n::io::sharing::funtxt_sharing_context
        > BuilderContext;
}
#define METADATA(PROP) BuilderContext::metadata(this).PROP

// QUOTED_STRING: doesn't yet handle escaped quotes-in-quotes. Need to use
//# separate states for that, i think. 
// CLASSNAME_CPP_NORMAL	((({WORD}\:\:)+)?({WORD}))
// CLASSNAME_CPP_TEMPLATE	(([a-zA-Z_])([a-zA-Z0-9_\.\:<>,])*)
// ESCAPED_MULTILINE	((.*\$)/[^(\\\n)]*)
// ESCAPED_MULTILINE	([.]+([^\\]\n$))
// {ESCAPED_MULTILINE}|
// PROPERTY_TYPES		({ESCAPED_MULTILINE})
//UNTIL_SEMICOLON		.+\;{SPACE}*$
//PROPERTY_VALUE		({NUMBER}|{ALMOST_A_WORD}|{QUOTED_STRING}|{WORD_WITH_PUNCTUATION}|{RGB_COLOR})
// WORD_WITH_PUNCTUATION	[#.\!\?\-_a-zA-Z0-9]+
//UNTIL_EOL		([.\n]+[^\\]$)
//ESCAPED_LINES		((.+([\\]\n))+[^\\]\n)
// COMMON_DEFINITIONS: See common_flex_definitions.at
#define READ_PROPERTY_VALUE 1

#define IN_COMMENT_BLOCK 2


/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO(( void ));
#else
extern int yywrap YY_PROTO(( void ));
#endif
#endif


#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO(( char *, yyconst char *, int ));
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YY_PROTO(( yyconst char * ));
#endif

#ifndef YY_NO_INPUT
#endif

#if YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
#define ECHO LexerOutput( yytext, yyleng )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( (result = LexerInput( (char *) buf, max_size )) < 0 ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) LexerError( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int yyFlexLexer::yylex()
#endif

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		yy_current_buffer->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

YY_DECL
	{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;

#line 207 "funtxt_data_node.flex"



	if ( yy_init )
		{
		yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yy_start )
			yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = &std::cin;

		if ( ! yyout )
			yyout = &std::cout;

		if ( ! yy_current_buffer )
			yy_current_buffer =
				yy_create_buffer( yyin, YY_BUF_SIZE );

		yy_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start;
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yy_last_accepting_state = yy_current_state;
				yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 103 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 102 );
		yy_cp = yy_last_accepting_cpos;
		yy_current_state = yy_last_accepting_state;

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yy_hold_char;
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 209 "funtxt_data_node.flex"
{ // (* comment blocks *)
	BEGIN IN_COMMENT_BLOCK;
	/********************************************************************************
        // there is apparently an endless loop caused in some cases with this :/
        // c++-style comments. Code mostly taken from the flex info pages.
             int c;
             while((c = yyinput()) != 0)
             {
                     if(c == '*')
                     {
                             c = yyinput();
                             if( 0 == c || '/' == c ) break;
                     }
             }
             continue; //return 1;
	********************************************************************************/
        }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 228 "funtxt_data_node.flex"
{ /* this match isn't 100% correct.*/ BEGIN 0; }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 229 "funtxt_data_node.flex"
{ continue;}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 230 "funtxt_data_node.flex"
{ continue;}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 231 "funtxt_data_node.flex"
{
        LEXCERR << "hit EOF in a (*comment block*)." << std::endl;
        return 0;
	}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 237 "funtxt_data_node.flex"
{ continue; /* single-line comment */ }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 240 "funtxt_data_node.flex"
{ // e.g.: nodename class=foo::Bar
	std::string foo = YYText();
        s11n::trim_string( foo );
        LEXCERR << "class dec token=["<<foo<<"]"<<endl;
        std::string nodename = foo.substr( 0, foo.find_first_of( " \t" ) );
        std::string nodeclass = foo.substr( foo.find( "=" ) + 1 );
        assert( ! nodeclass.empty() );
        if( ('\"' == nodeclass[0]) || ('\'' == nodeclass[0]) )
        { // remove quotes from class name
                nodeclass.erase(0,1);
                nodeclass.resize(nodeclass.size()-1); // chop trailing quote
        }

        int ret = BuilderContext::open_node( this, nodeclass, nodename ) ? 1 : -1;
        if( (ret == -1) )
        {
                LEXCERR << "open_node("<<nodeclass<<","<<nodename<<") failed. Token="<<foo << std::endl;
                return 0;
        }
        continue; // return ret;
   }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 262 "funtxt_data_node.flex"
{ // node's opening brace
        ++METADATA(internaldepth);
        // nothing.
        continue;
   }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 268 "funtxt_data_node.flex"
{ // node's closing brace
        size_t & bracedepth = METADATA(internaldepth);
        if( bracedepth == BuilderContext::node_depth(this) )
        {
                // avoid closing node when open_node() fails
                LEXCERR << bracedepth-1<<" closing node"<<std::endl;
                BuilderContext::close_node(this);
        }
        --bracedepth;
        size_t nd = BuilderContext::node_depth(this);
        if( 0 == nd )
        {
                // return once we close the first top-level node.
                return 0;
        }
        LEXCERR << "node depth="<<nd<<" brace_depth="<<bracedepth<<std::endl;
   }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 287 "funtxt_data_node.flex"
{;}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 288 "funtxt_data_node.flex"
{
        METADATA(property) += YYText();
	}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 291 "funtxt_data_node.flex"
{;} // swallow it
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 292 "funtxt_data_node.flex"
{ // end of line
        s11n::key_value_parser kvp;
        const std::string & property = METADATA(property);
        if( ! funtxt::parseKVP( property, kvp ) ) {
                LEXCERR << "failed parsing key/value pair from property token ["<<property<<"]"<<endl;
        }
        BuilderContext::add_property( this, kvp.key(), kvp.value() );
        LEXCERR << "add_property(["<<kvp.key()<<"],["<<kvp.value()<<"])"<<std::endl;
        BEGIN INITIAL;
	}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 304 "funtxt_data_node.flex"
{ // property_name prop_val...
	if( METADATA(internaldepth) != BuilderContext::node_depth(this) ) { return 1; }
	METADATA(property) = YYText();
        BEGIN READ_PROPERTY_VALUE;
	}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 310 "funtxt_data_node.flex"
{;}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 312 "funtxt_data_node.flex"
ECHO;
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(READ_PROPERTY_VALUE):
case YY_STATE_EOF(IN_COMMENT_BLOCK):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yy_n_chars = yy_current_buffer->yy_n_chars;
			yy_current_buffer->yy_input_file = yyin;
			yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yy_last_accepting_cpos;
				yy_current_state = yy_last_accepting_state;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yy_did_buffer_switch_on_eof = 0;

				if ( yywrap() )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yy_c_buf_p =
					yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yy_c_buf_p =
				&yy_current_buffer->yy_ch_buf[yy_n_chars];

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of yylex */

yyFlexLexer::yyFlexLexer( std::istream* arg_yyin, std::ostream* arg_yyout )
	{
	yyin = arg_yyin;
	yyout = arg_yyout;
	yy_c_buf_p = 0;
	yy_init = 1;
	yy_start = 0;
	yy_flex_debug = 0;
	yylineno = 1;	// this will only get updated if %option yylineno

	yy_did_buffer_switch_on_eof = 0;

	yy_looking_for_trail_begin = 0;
	yy_more_flag = 0;
	yy_more_len = 0;
	yy_more_offset = yy_prev_more_offset = 0;

	yy_start_stack_ptr = yy_start_stack_depth = 0;
	yy_start_stack = 0;

	yy_current_buffer = 0;

#ifdef YY_USES_REJECT
	yy_state_buf = new yy_state_type[YY_BUF_SIZE + 2];
#else
	yy_state_buf = 0;
#endif
	}

yyFlexLexer::~yyFlexLexer()
	{
	delete yy_state_buf;
	yy_delete_buffer( yy_current_buffer );
	}

void yyFlexLexer::switch_streams( std::istream* new_in, std::ostream* new_out )
	{
	if ( new_in )
		{
		yy_delete_buffer( yy_current_buffer );
		yy_switch_to_buffer( yy_create_buffer( new_in, YY_BUF_SIZE ) );
		}

	if ( new_out )
		yyout = new_out;
	}

#ifdef YY_INTERACTIVE
int yyFlexLexer::LexerInput( char* buf, int /* max_size */ )
#else
int yyFlexLexer::LexerInput( char* buf, int max_size )
#endif
	{
	if ( yyin->eof() || yyin->fail() )
		return 0;

#ifdef YY_INTERACTIVE
	yyin->get( buf[0] );

	if ( yyin->eof() )
		return 0;

	if ( yyin->bad() )
		return -1;

	return 1;

#else
	(void) yyin->read( buf, max_size );

	if ( yyin->bad() )
		return -1;
	else
		return yyin->gcount();
#endif
	}

void yyFlexLexer::LexerOutput( const char* buf, int size )
	{
	(void) yyout->write( buf, size );
	}

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

int yyFlexLexer::yy_get_next_buffer()
	{
	register char *dest = yy_current_buffer->yy_ch_buf;
	register char *source = yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( yy_current_buffer->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		yy_current_buffer->yy_n_chars = yy_n_chars = 0;

	else
		{
		int num_to_read =
			yy_current_buffer->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = yy_current_buffer;

			int yy_c_buf_p_offset =
				(int) (yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yy_flex_realloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = yy_current_buffer->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
			yy_n_chars, num_to_read );

		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	if ( yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			yy_current_buffer->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	yy_n_chars += number_to_move;
	yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yytext_ptr = &yy_current_buffer->yy_ch_buf[0];

	return ret_val;
	}


/* yy_get_previous_state - get the state just before the EOB char was reached */

yy_state_type yyFlexLexer::yy_get_previous_state()
	{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = yy_start;
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yy_last_accepting_state = yy_current_state;
			yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 103 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */

yy_state_type yyFlexLexer::yy_try_NUL_trans( yy_state_type yy_current_state )
	{
	register int yy_is_jam;
	register char *yy_cp = yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 103 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 102);

	return yy_is_jam ? 0 : yy_current_state;
	}


void yyFlexLexer::yyunput( int c, register char* yy_bp )
	{
	register char *yy_cp = yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yy_hold_char;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = yy_n_chars + 2;
		register char *dest = &yy_current_buffer->yy_ch_buf[
					yy_current_buffer->yy_buf_size + 2];
		register char *source =
				&yy_current_buffer->yy_ch_buf[number_to_move];

		while ( source > yy_current_buffer->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		yy_current_buffer->yy_n_chars =
			yy_n_chars = yy_current_buffer->yy_buf_size;

		if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;


	yytext_ptr = yy_bp;
	yy_hold_char = *yy_cp;
	yy_c_buf_p = yy_cp;
	}


int yyFlexLexer::yyinput()
	{
	int c;

	*yy_c_buf_p = yy_hold_char;

	if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			/* This was really a NUL. */
			*yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yy_c_buf_p - yytext_ptr;
			++yy_c_buf_p;

			switch ( yy_get_next_buffer() )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/* fall through */

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap() )
						return EOF;

					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yy_c_buf_p = yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yy_c_buf_p;	/* cast for 8-bit char's */
	*yy_c_buf_p = '\0';	/* preserve yytext */
	yy_hold_char = *++yy_c_buf_p;

	yy_current_buffer->yy_at_bol = (c == '\n');

	return c;
	}


void yyFlexLexer::yyrestart( std::istream* input_file )
	{
	if ( ! yy_current_buffer )
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_init_buffer( yy_current_buffer, input_file );
	yy_load_buffer_state();
	}


void yyFlexLexer::yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
	{
	if ( yy_current_buffer == new_buffer )
		return;

	if ( yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*yy_c_buf_p = yy_hold_char;
		yy_current_buffer->yy_buf_pos = yy_c_buf_p;
		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	yy_current_buffer = new_buffer;
	yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yy_did_buffer_switch_on_eof = 1;
	}


void yyFlexLexer::yy_load_buffer_state()
	{
	yy_n_chars = yy_current_buffer->yy_n_chars;
	yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
	yyin = yy_current_buffer->yy_input_file;
	yy_hold_char = *yy_c_buf_p;
	}


YY_BUFFER_STATE yyFlexLexer::yy_create_buffer( std::istream* file, int size )
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yy_flex_alloc( b->yy_buf_size + 2 );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
	}


void yyFlexLexer::yy_delete_buffer( YY_BUFFER_STATE b )
	{
	if ( ! b )
		return;

	if ( b == yy_current_buffer )
		yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yy_flex_free( (void *) b->yy_ch_buf );

	yy_flex_free( (void *) b );
	}


extern "C" int isatty YY_PROTO(( int ));
void yyFlexLexer::yy_init_buffer( YY_BUFFER_STATE b, std::istream* file )

	{
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

	b->yy_is_interactive = 0;
	}


void yyFlexLexer::yy_flush_buffer( YY_BUFFER_STATE b )
	{
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == yy_current_buffer )
		yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#endif


#ifndef YY_NO_SCAN_STRING
#endif


#ifndef YY_NO_SCAN_BYTES
#endif


#ifndef YY_NO_PUSH_STATE
void yyFlexLexer::yy_push_state( int new_state )
	{
	if ( yy_start_stack_ptr >= yy_start_stack_depth )
		{
		yy_size_t new_size;

		yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = yy_start_stack_depth * sizeof( int );

		if ( ! yy_start_stack )
			yy_start_stack = (int *) yy_flex_alloc( new_size );

		else
			yy_start_stack = (int *) yy_flex_realloc(
					(void *) yy_start_stack, new_size );

		if ( ! yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	yy_start_stack[yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
void yyFlexLexer::yy_pop_state()
	{
	if ( --yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
int yyFlexLexer::yy_top_state()
	{
	return yy_start_stack[yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif


void yyFlexLexer::LexerError( yyconst char msg[] )
	{
	std::cerr << msg << '\n';
	exit( YY_EXIT_FAILURE );
	}


/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void yy_flex_strncpy( char *s1, yyconst char *s2, int n )
#else
static void yy_flex_strncpy( s1, s2, n )
char *s1;
yyconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int yy_flex_strlen( yyconst char *s )
#else
static int yy_flex_strlen( s )
yyconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef YY_USE_PROTOS
static void *yy_flex_alloc( yy_size_t size )
#else
static void *yy_flex_alloc( size )
yy_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *yy_flex_realloc( void *ptr, yy_size_t size )
#else
static void *yy_flex_realloc( ptr, size )
void *ptr;
yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void yy_flex_free( void *ptr )
#else
static void yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	yylex();
	return 0;
	}
#endif
#line 312 "funtxt_data_node.flex"


#undef METADATA
