/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbcext;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public abstract class ClientConnectionSapDB
    implements Connection
{
    /**
     * Gets the real connection that is underneath this
     * connection.
     */
    public abstract Connection getPhysicalConnection()
        throws SQLException;

    /**
     * This callback will be called on any exception that is omitted
     * from a call. 
     * @param sqlEx the exception about to be thrown.
     */
    public abstract void exceptionOccurred(SQLException sqlEx);
    
    public void setReadOnly(boolean param1) throws SQLException
    {
        try {
            getPhysicalConnection().setReadOnly(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean isReadOnly() throws SQLException
    {
        try {
            return getPhysicalConnection().isReadOnly();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void close() throws SQLException
    {
        try {
            getPhysicalConnection().close();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
        
    }

    public boolean isClosed() throws SQLException
    {
        try {
            return getPhysicalConnection().isClosed();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Statement createStatement(int param1, int param2, int param3) throws SQLException
    {
        try {
            Statement tmp=getPhysicalConnection().createStatement(param1, param2, param3);
            return tmp==null 
                ? null
                : new ClientStatementSapDB(tmp, this);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Statement createStatement() throws SQLException
    {
        try {
            Statement tmp=getPhysicalConnection().createStatement();
            return tmp==null 
                ? null
                : new ClientStatementSapDB(tmp, this);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    
    }

    public Statement createStatement(int param1, int param2) throws SQLException
    {
        try {
            Statement tmp=getPhysicalConnection().createStatement(param1, param2);
            return tmp==null 
                ? null
                : new ClientStatementSapDB(tmp, this);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public PreparedStatement prepareStatement(String param1, int param2) throws SQLException
    {
        try {
            PreparedStatement tmp = getPhysicalConnection().prepareStatement(param1, param2);
            return tmp==null 
                ? null
                : new ClientPreparedStatementSapDB(tmp, this);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }

    }

    public PreparedStatement prepareStatement(String param1, String[] param2) throws SQLException
    {
        try {
            PreparedStatement tmp = getPhysicalConnection().prepareStatement(param1, param2);
            return tmp==null 
                ? null
                : new ClientPreparedStatementSapDB(tmp, this);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public PreparedStatement prepareStatement(String param1, int param2, int param3, int param4) throws SQLException
    {
        try {
            PreparedStatement tmp = getPhysicalConnection().prepareStatement(param1, param2, param3, param4);
            return tmp==null 
                ? null
                : new ClientPreparedStatementSapDB(tmp, this);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public PreparedStatement prepareStatement(String param1) throws SQLException
    {
        try {
            PreparedStatement tmp = getPhysicalConnection().prepareStatement(param1);
            return tmp==null 
                ? null
                : new ClientPreparedStatementSapDB(tmp, this);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public PreparedStatement prepareStatement(String param1, int[] param2) throws SQLException
    {
        try {
            PreparedStatement tmp = getPhysicalConnection().prepareStatement(param1, param2);
            return tmp==null 
                ? null
                : new ClientPreparedStatementSapDB(tmp, this);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public PreparedStatement prepareStatement(String param1, int param2, int param3) throws SQLException
    {
        try {
            PreparedStatement tmp = getPhysicalConnection().prepareStatement(param1, param2, param3);
            return tmp==null 
                ? null
                : new ClientPreparedStatementSapDB(tmp, this);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public CallableStatement prepareCall(String param1, int param2, int param3) throws SQLException
    {
        try {
            return getPhysicalConnection().prepareCall(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public CallableStatement prepareCall(String param1) throws SQLException
    {
        try {
            return getPhysicalConnection().prepareCall(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public CallableStatement prepareCall(String param1, int param2, int param3, int param4) throws SQLException
    {
        try {
            return getPhysicalConnection().prepareCall(param1, param2, param3, param4);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String nativeSQL(String param1) throws SQLException
    {
        try {
            return getPhysicalConnection().nativeSQL(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setAutoCommit(boolean param1) throws SQLException
    {
        try {
            getPhysicalConnection().setAutoCommit(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean getAutoCommit() throws SQLException
    {
        try {
            return getPhysicalConnection().getAutoCommit();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }

    }

    public void commit() throws SQLException
    {
        try {
            getPhysicalConnection().commit();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void rollback(Savepoint param1) throws SQLException
    {
        try {
            ClientSavepointSapDB.rollback(getPhysicalConnection(), param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void rollback() throws SQLException
    {
        try {
            getPhysicalConnection().rollback();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException
    {
        try {
            return getPhysicalConnection().getMetaData();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setCatalog(String param1) throws SQLException
    {
        try {
            getPhysicalConnection().setCatalog(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getCatalog() throws SQLException
    {
        try {
            return getPhysicalConnection().getCatalog();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setTransactionIsolation(int param1) throws SQLException
    {
        try {
            getPhysicalConnection().setTransactionIsolation(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getTransactionIsolation() throws SQLException
    {
        try {
            return getPhysicalConnection().getTransactionIsolation();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public SQLWarning getWarnings() throws SQLException
    {
        try {
            return getPhysicalConnection().getWarnings();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void clearWarnings() throws SQLException
    {
        try {
            getPhysicalConnection().clearWarnings();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Map getTypeMap() throws SQLException
    {
        try {
            return getPhysicalConnection().getTypeMap();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setTypeMap(Map param1) throws SQLException
    {
        try {
            getPhysicalConnection().setTypeMap(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setHoldability(int param1) throws SQLException
    {
        try {
            getPhysicalConnection().setHoldability(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getHoldability() throws SQLException
    {
        try {
            return getPhysicalConnection().getHoldability();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Savepoint setSavepoint() throws SQLException
    {
        try {
            return ClientSavepointSapDB.setSavepoint(this);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Savepoint setSavepoint(String param1) throws SQLException
    {
        try {
            return ClientSavepointSapDB.setSavepoint(param1, this);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void releaseSavepoint(Savepoint param1) throws SQLException
    {
        try {
            ClientSavepointSapDB.releaseSavepoint(getPhysicalConnection(), param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }
}
