using System;
using System.Runtime.InteropServices;
 
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html Parent class for SBML <em>rules</em> in libSBML.
 *
 * In SBML, @em rules provide additional ways to define the values of
 * variables in a model, their relationships, and the dynamical behaviors
 * of those variables.  They enable encoding relationships that cannot be
 * expressed using Reaction nor InitialAssignment objects alone.
 *
 * The libSBML implementation of rules mirrors the SBML Level&nbsp;3
 * definition (which is in turn is very similar to the
 * Level&nbsp;2 Version&nbsp;4 definition), with Rule being the parent
 * class of three subclasses as explained below.  The Rule class itself
 * cannot be instantiated by user programs and has no constructor; only the
 * subclasses AssignmentRule, AlgebraicRule and RateRule can be
 * instantiated directly.
 *
 *
 * @section rules-general General summary of SBML rules
 *
 * In SBML Level&nbsp;3 as well as Level&nbsp;2, rules are separated into three
 * subclasses for the benefit of model analysis software.  The three
 * subclasses are based on the following three different possible functional
 * forms (where <em>x</em> is a variable, <em>f</em> is some arbitrary
 * function returning a numerical result, <b><em>V</em></b> is a vector of
 * variables that does not include <em>x</em>, and <b><em>W</em></b> is a
 * vector of variables that may include <em>x</em>):
 *
 * <table border='0' cellpadding='0' class='centered' style='font-size: small'>
 * <tr><td width='120px'><em>Algebraic:</em></td><td width='250px'>left-hand side is zero</td><td><em>0 = f(<b>W</b>)</em></td></tr>
 * <tr><td><em>Assignment:</em></td><td>left-hand side is a scalar:</td><td><em>x = f(<b>V</b>)</em></td></tr>
 * <tr><td><em>Rate:</em></td><td>left-hand side is a rate-of-change:</td><td><em>dx/dt = f(<b>W</b>)</em></td></tr>
 * </table>
 *
 * In their general form given above, there is little to distinguish
 * between <em>assignment</em> and <em>algebraic</em> rules.  They are treated as
 * separate cases for the following reasons:
 *
 * @li <em>Assignment</em> rules can simply be evaluated to calculate
 * intermediate values for use in numerical methods.  They are statements
 * of equality that hold at all times.  (For assignments that are only
 * performed once, see InitialAssignment.)

 * @li SBML needs to place restrictions on assignment rules, for example
 * the restriction that assignment rules cannot contain algebraic loops.
 *
 * @li Some simulators do not contain numerical solvers capable of solving
 * unconstrained algebraic equations, and providing more direct forms such
 * as assignment rules may enable those simulators to process models they
 * could not process if the same assignments were put in the form of
 * general algebraic equations;
 *
 * @li Those simulators that <em>can</em> solve these algebraic equations make a
 * distinction between the different categories listed above; and
 *
 * @li Some specialized numerical analyses of models may only be applicable
 * to models that do not contain <em>algebraic</em> rules.
 *
 * The approach taken to covering these cases in SBML is to define an
 * abstract Rule structure containing a subelement, 'math', to hold the
 * right-hand side expression, then to derive subtypes of Rule that add
 * attributes to distinguish the cases of algebraic, assignment and rate
 * rules.  The 'math' subelement must contain a MathML expression defining the
 * mathematical formula of the rule.  This MathML formula must return a
 * numerical value.  The formula can be an arbitrary expression referencing
 * the variables and other entities in an SBML model.
 *
 * Each of the three subclasses of Rule (AssignmentRule, AlgebraicRule,
 * RateRule) inherit the the 'math' subelement and other fields from SBase.
 * The AssignmentRule and RateRule classes add an additional attribute,
 * 'variable'.  See the definitions of AssignmentRule, AlgebraicRule and
 * RateRule for details about the structure and interpretation of each one.
 *
 * @section rules-restrictions Additional restrictions on SBML rules
 *
 * An important design goal of SBML rule semantics is to ensure that a
 * model's simulation and analysis results will not be dependent on when or
 * how often rules are evaluated.  To achieve this, SBML needs to place two
 * restrictions on rule use.  The first concerns algebraic loops in the system
 * of assignments in a model, and the second concerns overdetermined systems.
 *
 * @subsection rules-no-loops A model must not contain algebraic loops
 *
 * The combined set of InitialAssignment, AssignmentRule and KineticLaw
 * objects in a model constitute a set of assignment statements that should be
 * considered as a whole.  (A KineticLaw object is counted as an assignment
 * because it assigns a value to the symbol contained in the 'id' attribute of
 * the Reaction object in which it is defined.)  This combined set of
 * assignment statements must not contain algebraic loops---dependency
 * chains between these statements must terminate.  To put this more formally,
 * consider a directed graph in which nodes are assignment statements and
 * directed arcs exist for each occurrence of an SBML species, compartment or
 * parameter symbol in an assignment statement's 'math' subelement.  Let the
 * directed arcs point from the statement assigning the symbol to the
 * statements that contain the symbol in their 'math' subelement expressions.
 * This graph must be acyclic.
 *
 * Similarly, the combined set of RateRule and Reaction objects constitute 
 * a set of definitions for the rates of change of various model entities 
 * (namely, the objects identified by the values of the 'variable' attributes 
 * of the RateRule objects, and the 'species' attributes of the SpeciesReference 
 * objects in each Reaction).  In SBML Level&nbsp;3 Version&nbsp;2, these rates 
 * of change may be referenced directly 
 * using the <em>rateOf</em> csymbol, but may not thereby contain algebraic 
 * loops---dependency chains between these statements must terminate.  More 
 * formally, consider a directed graph in which the nodes are the definitions 
 * of different variables' rates of change, and directed arcs exist for each 
 * occurrence of a variable referenced by a <em>rateOf</em> csymbol from any 
 * RateRule or KineticLaw object in the model.  Let the directed arcs point 
 * from the variable referenced by the <em>rateOf</em> csymbol (call it 
 * <em>x</em>) to the variable(s) determined by the 'math' expression in which
 * <em>x</em> appears.  This graph must be acyclic.
 *
 * SBML does not specify when or how often rules should be evaluated.
 * Eliminating algebraic loops ensures that assignment statements can be
 * evaluated any number of times without the result of those evaluations
 * changing.  As an example, consider the set of equations <em>x = x + 1</em>,
 * <em>y = z + 200</em> and <em>z = y + 100</em>.  If this set of equations
 * were interpreted as a set of assignment statements, it would be invalid
 * because the rule for <em>x</em> refers to <em>x</em> (exhibiting one type
 * of loop), and the rule for <em>y</em> refers to <em>z</em> while the rule
 * for <em>z</em> refers back to <em>y</em> (exhibiting another type of loop).
 * Conversely, the following set of equations would constitute a valid set of
 * assignment statements: <em>x = 10</em>, <em>y = z + 200</em>, and <em>z = x
 * + 100</em>.
 *
 * @subsection rules-not-overdetermined A model must not be overdetermined
 *
 * An SBML model must not be overdetermined; that is, a model must not
 * define more equations than there are unknowns in a model.  A valid SBML model
 * that does not contain AlgebraicRule structures cannot be overdetermined.
 *
 * LibSBML implements the static analysis procedure described in
 * Appendix&nbsp;B of the SBML Level&nbsp;3
 * specification for assessing whether a model is overdetermined.
 *
 * (In summary, assessing whether a given continuous, deterministic,
 * mathematical model is overdetermined does not require dynamic analysis; it
 * can be done by analyzing the system of equations created from the model.
 * One approach is to construct a bipartite graph in which one set of vertices
 * represents the variables and the other the set of vertices represents the
 * equations.  Place edges between vertices such that variables in the system
 * are linked to the equations that determine them.  For algebraic equations,
 * there will be edges between the equation and each variable occurring in the
 * equation.  For ordinary differential equations (such as those defined by
 * rate rules or implied by the reaction rate definitions), there will be a
 * single edge between the equation and the variable determined by that
 * differential equation.  A mathematical model is overdetermined if the
 * maximal matchings of the bipartite graph contain disconnected vertexes
 * representing equations.  If one maximal matching has this property, then
 * all the maximal matchings will have this property; i.e., it is only
 * necessary to find one maximal matching.)
 *
 * @section RuleType_t Rule types for SBML Level 1
 *
 * SBML Level 1 uses a different scheme than SBML Level 2 and Level 3 for
 * distinguishing rules; specifically, it uses an attribute whose value is
 * drawn from an enumeration of 3 values.  LibSBML supports this using methods
 * that work @if clike a libSBML enumeration type,
 * @link Rule::RuleType_t RuleType_t@endlink, whose values
 * are @else with the enumeration values @endif listed below.
 *
 * @li @link libsbml#RULE_TYPE_RATE RULE_TYPE_RATE@endlink: Indicates
 * the rule is a 'rate' rule.
 * @li @link libsbml#RULE_TYPE_SCALAR RULE_TYPE_SCALAR@endlink:
 * Indicates the rule is a 'scalar' rule.
 * @li @link libsbml#RULE_TYPE_INVALID RULE_TYPE_INVALID@endlink:
 * Indicates the rule type is unknown or not yet set.
 *
 *
 *
 *
 * 
 */

public class Rule : SBase {
	private HandleRef swigCPtr;
	
	internal Rule(IntPtr cPtr, bool cMemoryOwn) : base(libsbmlPINVOKE.Rule_SWIGUpcast(cPtr), cMemoryOwn)
	{
		//super(libsbmlPINVOKE.RuleUpcast(cPtr), cMemoryOwn);
		swigCPtr = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(Rule obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (Rule obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~Rule() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_Rule(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  
/**
   * Copy constructor; creates a copy of this Rule.
   *
   * @param orig the object to copy.
   */ public
 Rule(Rule orig) : this(libsbmlPINVOKE.new_Rule(Rule.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates and returns a deep copy of this Rule object.
   *
   * @return the (deep) copy of this Rule object.
   */ public new
 Rule clone() {
        Rule ret = (Rule) libsbml.DowncastSBase(libsbmlPINVOKE.Rule_clone(swigCPtr), true);
	return ret;
}

  
/**
   * Returns the mathematical expression of this Rule in text-string form.
   *
   * The text string is produced by
   * @if java <code><a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'>libsbml.formulaToString()</a></code>@else libsbml.formulaToString()@endif; please consult
   * the documentation for that function to find out more about the format
   * of the text-string formula.
   * 
   * @return the formula text string for this Rule.
   *
   * @note The attribute 'formula' is specific to SBML Level&nbsp;1; in
   * higher Levels of SBML, it has been replaced with a subelement named
   * 'math'.  However, libSBML provides a unified interface to the
   * underlying math expression and this method can be used for models
   * of all Levels of SBML.
   *
   * @see getMath()
   */ public
 string getFormula() {
    string ret = libsbmlPINVOKE.Rule_getFormula(swigCPtr);
    return ret;
  }

  
/**
   * Get the mathematical formula of this Rule as an ASTNode tree.
   *
   * @return an ASTNode, the value of the 'math' subelement of this Rule,
   * or null if the math is not set.
   *
   * @note The subelement 'math' is present in SBML Levels&nbsp;2
   * and&nbsp;3.  In SBML Level&nbsp;1, the equivalent construct is the
   * attribute named 'formula'.  LibSBML provides a unified interface to
   * the underlying math expression and this method can be used for models
   * of all Levels of SBML.
   *
   * @see getFormula()
   */ public new
 ASTNode getMath() {
    IntPtr cPtr = libsbmlPINVOKE.Rule_getMath(swigCPtr);
    ASTNode ret = (cPtr == IntPtr.Zero) ? null : new ASTNode(cPtr, false);
    return ret;
  }

  
/**
   * Get the value of the 'variable' attribute of this Rule object.
   *
   *
 * 
 * In SBML Level&nbsp;1, the different rule types each have a different
 * name for the attribute holding the reference to the object constituting
 * the left-hand side of the rule.  (E.g., for SBML Level&nbsp;1's
 * SpeciesConcentrationRule the attribute is 'species', for
 * CompartmentVolumeRule it is 'compartment', etc.)  In SBML Levels&nbsp;2
 * and&nbsp;3, the only two types of Rule objects with a left-hand side
 * object reference are AssignmentRule and RateRule, and both of them use the
 * same name for attribute: 'variable'.  In order to make it easier for
 * application developers to work with all Levels of SBML, libSBML uses a
 * uniform name for all such attributes, and it is 'variable', regardless of
 * whether Level&nbsp;1 rules or Level&nbsp;2&ndash;3 rules are being used.
 *
   * 
   * The 'variable' attribute of a Rule indicates the element which
   * the results of the 'math' are to be applied.  An AlgebraicRule has
   * no 'variable', and will always return an empty string.
   *
   * @return the identifier string stored as the 'variable' attribute value
   * in this Rule, or @c null if this object is an AlgebraicRule object, or if 
   * the attribute is unset.
   */ public
 string getVariable() {
    string ret = libsbmlPINVOKE.Rule_getVariable(swigCPtr);
    return ret;
  }

  
/**
   * Returns the units for the
   * mathematical formula of this Rule.
   * 
   * @return the identifier of the units for the expression of this Rule.
   *
   * @note The attribute 'units' exists on SBML Level&nbsp;1 ParameterRule
   * objects only.  It is not present in SBML Levels&nbsp;2 and&nbsp;3.
   */ public
 string getUnits() {
    string ret = libsbmlPINVOKE.Rule_getUnits(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Rule's mathematical expression is
   * set.
   * 
   * This method is equivalent to isSetMath().  This version is present for
   * easier compatibility with SBML Level&nbsp;1, in which mathematical
   * formulas were written in text-string form.
   * 
   * @return @c true if the mathematical formula for this Rule is
   * set, @c false otherwise.
   *
   * @note The attribute 'formula' is specific to SBML Level&nbsp;1; in
   * higher Levels of SBML, it has been replaced with a subelement named
   * 'math'.  However, libSBML provides a unified interface to the
   * underlying math expression and this method can be used for models
   * of all Levels of SBML.
   *
   * @see isSetMath()
   */ public
 bool isSetFormula() {
    bool ret = libsbmlPINVOKE.Rule_isSetFormula(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Rule's mathematical expression is
   * set.
   *
   * This method is equivalent to isSetFormula().
   * 
   * @return @c true if the formula (or equivalently the math) for this
   * Rule is set, @c false otherwise.
   *
   * @note The subelement 'math' is present in SBML Levels&nbsp;2
   * and&nbsp;3.  In SBML Level&nbsp;1, the equivalent construct is the
   * attribute named 'formula'.  LibSBML provides a unified interface to
   * the underlying math expression and this method can be used for models
   * of all Levels of SBML.
   *
   * @see isSetFormula()
   */ public
 bool isSetMath() {
    bool ret = libsbmlPINVOKE.Rule_isSetMath(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Rule's 'variable' attribute is set.
   *
   *
 * 
 * In SBML Level&nbsp;1, the different rule types each have a different
 * name for the attribute holding the reference to the object constituting
 * the left-hand side of the rule.  (E.g., for SBML Level&nbsp;1's
 * SpeciesConcentrationRule the attribute is 'species', for
 * CompartmentVolumeRule it is 'compartment', etc.)  In SBML Levels&nbsp;2
 * and&nbsp;3, the only two types of Rule objects with a left-hand side
 * object reference are AssignmentRule and RateRule, and both of them use the
 * same name for attribute: 'variable'.  In order to make it easier for
 * application developers to work with all Levels of SBML, libSBML uses a
 * uniform name for all such attributes, and it is 'variable', regardless of
 * whether Level&nbsp;1 rules or Level&nbsp;2&ndash;3 rules are being used.
 *
   * 
   * @return @c true if the 'variable' attribute value of this Rule is
   * set, @c false otherwise.
   */ public
 bool isSetVariable() {
    bool ret = libsbmlPINVOKE.Rule_isSetVariable(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Rule's 'units' attribute is set.
   *
   * @return @c true if the units for this Rule is set, @c false
   * otherwise.
   *
   * @note The attribute 'units' exists on SBML Level&nbsp;1 ParameterRule
   * objects only.  It is not present in SBML Levels&nbsp;2 and&nbsp;3.
   */ public
 bool isSetUnits() {
    bool ret = libsbmlPINVOKE.Rule_isSetUnits(swigCPtr);
    return ret;
  }

  
/**
   * Sets the 'math' subelement of this Rule to an expression in text-string
   * form.
   *
   * This is equivalent to setMath(ASTNode math).  The provision of
   * using text-string formulas is retained for easier SBML Level&nbsp;1
   * compatibility.  The formula is converted to an ASTNode internally.
   *
   * @param formula a mathematical formula in text-string form.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   *
   * @note The attribute 'formula' is specific to SBML Level&nbsp;1; in
   * higher Levels of SBML, it has been replaced with a subelement named
   * 'math'.  However, libSBML provides a unified interface to the
   * underlying math expression and this method can be used for models
   * of all Levels of SBML.
   *
   * @see setMath(ASTNode math)
   */ public
 int setFormula(string formula) {
    int ret = libsbmlPINVOKE.Rule_setFormula(swigCPtr, formula);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the 'math' subelement of this Rule to a copy of the given
   * ASTNode.
   *
   * @param math the AST structure of the mathematical formula.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   *
   * @note The subelement 'math' is present in SBML Levels&nbsp;2
   * and&nbsp;3.  In SBML Level&nbsp;1, the equivalent construct is the
   * attribute named 'formula'.  LibSBML provides a unified interface to
   * the underlying math expression and this method can be used for models
   * of all Levels of SBML.
   *
   * @see setFormula(string formula)
   */ public new
 int setMath(ASTNode math) {
    int ret = libsbmlPINVOKE.Rule_setMath(swigCPtr, ASTNode.getCPtr(math));
    return ret;
  }

  
/**
   * Sets the 'variable' attribute value of this Rule object.
   *
   *
 * 
 * In SBML Level&nbsp;1, the different rule types each have a different
 * name for the attribute holding the reference to the object constituting
 * the left-hand side of the rule.  (E.g., for SBML Level&nbsp;1's
 * SpeciesConcentrationRule the attribute is 'species', for
 * CompartmentVolumeRule it is 'compartment', etc.)  In SBML Levels&nbsp;2
 * and&nbsp;3, the only two types of Rule objects with a left-hand side
 * object reference are AssignmentRule and RateRule, and both of them use the
 * same name for attribute: 'variable'.  In order to make it easier for
 * application developers to work with all Levels of SBML, libSBML uses a
 * uniform name for all such attributes, and it is 'variable', regardless of
 * whether Level&nbsp;1 rules or Level&nbsp;2&ndash;3 rules are being used.
 *
   * 
   * @param sid the identifier of a Compartment, Species or Parameter
   * elsewhere in the enclosing Model object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   */ public
 int setVariable(string sid) {
    int ret = libsbmlPINVOKE.Rule_setVariable(swigCPtr, sid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the units for this Rule.
   *
   * @param sname the identifier of the units.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   * @note The attribute 'units' exists on SBML Level&nbsp;1 ParameterRule
   * objects only.  It is not present in SBML Levels&nbsp;2 and&nbsp;3.
   */ public
 int setUnits(string sname) {
    int ret = libsbmlPINVOKE.Rule_setUnits(swigCPtr, sname);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Unsets the value of the 'variable' attribute of this Rule object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   * @see setVariable(string sid)
   * @see isSetVariable()
   * @see getVariable()
   */ public
 int unsetVariable() {
    int ret = libsbmlPINVOKE.Rule_unsetVariable(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the 'units' for this Rule.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   * @note The attribute 'units' exists on SBML Level&nbsp;1 ParameterRule
   * objects only.  It is not present in SBML Levels&nbsp;2 and&nbsp;3.
   */ public
 int unsetUnits() {
    int ret = libsbmlPINVOKE.Rule_unsetUnits(swigCPtr);
    return ret;
  }

  
/**
   * Calculates and returns a UnitDefinition that expresses the units of
   * measurement assumed for the 'math' expression of this Rule.
   *
   *
 * 
 * The units are calculated based on the mathematical expression in the
 * Rule and the model quantities referenced by <code>&lt;ci&gt;</code>
 * elements used within that expression.  The method
 * Rule::getDerivedUnitDefinition() returns the calculated units, to the
 * extent that libSBML can compute them.
 * 
   *
   *
 * @note The functionality that facilitates unit analysis depends on the
 * model as a whole.  Thus, in cases where the object has not been added to
 * a model or the model itself is incomplete, unit analysis is not possible
 * and this method will return @c null.
 *
 * 
   *
   *
 * @warning <span class='warning'>Note that it is possible the 'math'
 * expression in the Rule contains pure numbers or parameters with undeclared
 * units.  In those cases, it is not possible to calculate the units of the
 * overall expression without making assumptions.  LibSBML does not make
 * assumptions about the units, and Rule::getDerivedUnitDefinition() only
 * returns the units as far as it is able to determine them.  For example, in
 * an expression <em>X + Y</em>, if <em>X</em> has unambiguously-defined
 * units and <em>Y</em> does not, it will return the units of <em>X</em>.
 * <strong>It is important that callers also invoke the method</strong>
 * Rule::containsUndeclaredUnits() <strong>to determine whether this
 * situation holds</strong>.  Callers may wish to take suitable actions in
 * those scenarios.</span>
 *
   * 
   * @return a UnitDefinition that expresses the units of the math 
   * expression of this Rule, or @c null if one cannot be constructed.
   *
   * @see containsUndeclaredUnits()
   */ public
 UnitDefinition getDerivedUnitDefinition() {
    IntPtr cPtr = libsbmlPINVOKE.Rule_getDerivedUnitDefinition__SWIG_0(swigCPtr);
    UnitDefinition ret = (cPtr == IntPtr.Zero) ? null : new UnitDefinition(cPtr, false);
    return ret;
  }

  
/**
   * Predicate returning @c true if the math expression of this Rule contains
   * parameters/numbers with undeclared units.
   * 
   * @return @c true if the math expression of this Rule includes
   * parameters/numbers with undeclared units, @c false otherwise.
   *
   * @note A return value of @c true indicates that the UnitDefinition
   * returned by getDerivedUnitDefinition() may not accurately represent
   * the units of the expression.
   *
   * @see getDerivedUnitDefinition()
   */ public
 bool containsUndeclaredUnits() {
    bool ret = libsbmlPINVOKE.Rule_containsUndeclaredUnits__SWIG_0(swigCPtr);
    return ret;
  }

  
/**
   * Returns a code representing the type of rule this is.
   *
   * @return the rule type, which will be one of the following three possible
   * values:
   * @li @link libsbml#RULE_TYPE_RATE RULE_TYPE_RATE@endlink
   * @li @link libsbml#RULE_TYPE_SCALAR RULE_TYPE_SCALAR@endlink
   * @li @link libsbml#RULE_TYPE_INVALID RULE_TYPE_INVALID@endlink
   *
   * @note The attribute 'type' on Rule objects is present only in SBML
   * Level&nbsp;1.  In SBML Level&nbsp;2 and later, the type has been
   * replaced by subclassing the Rule object.
   */ public
 int getType() {
    int ret = libsbmlPINVOKE.Rule_getType(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Rule is an AlgebraicRule.
   * 
   * @return @c true if this Rule is an AlgebraicRule, @c false otherwise.
   */ public
 bool isAlgebraic() {
    bool ret = libsbmlPINVOKE.Rule_isAlgebraic(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Rule is an AssignmentRule.
   * 
   * @return @c true if this Rule is an AssignmentRule, @c false otherwise.
   */ public
 bool isAssignment() {
    bool ret = libsbmlPINVOKE.Rule_isAssignment(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Rule is an CompartmentVolumeRule
   * or equivalent.
   *
   * This libSBML method works for SBML Level&nbsp;1 models (where there is
   * such a thing as an explicit CompartmentVolumeRule), as well as other Levels of
   * SBML.  For Levels above Level&nbsp;1, this method checks the symbol
   * being affected by the rule, and returns @c true if the symbol is the
   * identifier of a Compartment object defined in the model.
   *
   * @return @c true if this Rule is a CompartmentVolumeRule, @c false
   * otherwise.
   */ public
 bool isCompartmentVolume() {
    bool ret = libsbmlPINVOKE.Rule_isCompartmentVolume(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Rule is an ParameterRule or
   * equivalent.
   *
   * This libSBML method works for SBML Level&nbsp;1 models (where there is
   * such a thing as an explicit ParameterRule), as well as other Levels of
   * SBML.  For Levels above Level&nbsp;1, this method checks the symbol
   * being affected by the rule, and returns @c true if the symbol is the
   * identifier of a Parameter object defined in the model.
   *
   * @return @c true if this Rule is a ParameterRule, @c false
   * otherwise.
   */ public
 bool isParameter() {
    bool ret = libsbmlPINVOKE.Rule_isParameter(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Rule is a RateRule (SBML
   * Levels&nbsp;2&ndash;3) or has a 'type' attribute value of @c 'rate'
   * (SBML Level&nbsp;1).
   *
   * @return @c true if this Rule is a RateRule (Level&nbsp;2) or has
   * type 'rate' (Level&nbsp;1), @c false otherwise.
   */ public
 bool isRate() {
    bool ret = libsbmlPINVOKE.Rule_isRate(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Rule is an AssignmentRule (SBML
   * Levels&nbsp;2&ndash;3) or has a 'type' attribute value of @c 'scalar'
   * (SBML Level&nbsp;1).
   *
   * @return @c true if this Rule is an AssignmentRule (Level&nbsp;2) or has
   * type 'scalar' (Level&nbsp;1), @c false otherwise.
   */ public
 bool isScalar() {
    bool ret = libsbmlPINVOKE.Rule_isScalar(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Rule is a SpeciesConcentrationRule
   * or equivalent.
   *
   * This libSBML method works for SBML Level&nbsp;1 models (where there is
   * such a thing as an explicit SpeciesConcentrationRule), as well as
   * other Levels of SBML.  For Levels above Level&nbsp;1, this method
   * checks the symbol being affected by the rule, and returns @c true if
   * the symbol is the identifier of a Species object defined in the model.
   *
   * @return @c true if this Rule is a SpeciesConcentrationRule, @c false
   * otherwise.
   */ public
 bool isSpeciesConcentration() {
    bool ret = libsbmlPINVOKE.Rule_isSpeciesConcentration(swigCPtr);
    return ret;
  }

  
/**
   * Returns the libSBML type code for this %SBML object.
   * 
   *
 * 
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters <code>SBML_</code>.
 * @if clike The set of possible type codes for core elements is defined in
 * the enumeration #SBMLTypeCode_t, and in addition, libSBML plug-ins for
 * SBML Level&nbsp;3 packages define their own extra enumerations of type
 * codes (e.g., #SBMLLayoutTypeCode_t for the Level&nbsp;3 Layout
 * package).@endif@if java In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.  @endif@if python In the Python language
 * interface for libSBML, the type codes are defined as static integer
 * constants in the interface class @link libsbml@endlink.@endif@if csharp In
 * the C# language interface for libSBML, the type codes are defined as
 * static integer constants in the interface class
 * @link libsbmlcs.libsbml@endlink.@endif  Note that different Level&nbsp;3
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the <code>getPackageName()</code>
 * method on the object.
 *
 *
   *
   * @return the SBML type code for this object, either
   * @link libsbml#SBML_ASSIGNMENT_RULE SBML_ASSIGNMENT_RULE@endlink,
   * @link libsbml#SBML_RATE_RULE SBML_RATE_RULE@endlink, or
   * @link libsbml#SBML_ALGEBRAIC_RULE SBML_ALGEBRAIC_RULE@endlink 
   * for %SBML Core.
   *
   *
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different libSBML plug-ins for SBML Level&nbsp;3.
 * packages,  To fully identify the correct code, <strong>it is necessary to
 * invoke both getTypeCode() and getPackageName()</strong>.</span>
 *
 *
   *
   * @see getElementName()
   * @see getPackageName()
   */ public new
 int getTypeCode() {
    int ret = libsbmlPINVOKE.Rule_getTypeCode(swigCPtr);
    return ret;
  }

  
/**
   * Returns the SBML Level&nbsp;1 type code for this Rule object.
   *
   * This method only applies to SBML Level&nbsp;1 model objects.  If this is
   * not an SBML Level&nbsp;1 rule object, this method will return
   * @link libsbml#SBML_UNKNOWN SBML_UNKNOWN@endlink.
   *
   * @return the SBML Level&nbsp;1 type code for this Rule (namely,
   * @link libsbml#SBML_COMPARTMENT_VOLUME_RULE SBML_COMPARTMENT_VOLUME_RULE@endlink,
   * @link libsbml#SBML_PARAMETER_RULE SBML_PARAMETER_RULE@endlink,
   * @link libsbml#SBML_SPECIES_CONCENTRATION_RULE SBML_SPECIES_CONCENTRATION_RULE@endlink, or
   * @link libsbml#SBML_UNKNOWN SBML_UNKNOWN@endlink).
   */ public
 int getL1TypeCode() {
    int ret = libsbmlPINVOKE.Rule_getL1TypeCode(swigCPtr);
    return ret;
  }

  
/**
   * Returns the XML element name of this object.
   *
   * The returned value can be any of a number of different strings,
   * depending on the SBML Level in use and the kind of Rule object this
   * is.  The rules as of libSBML version @htmlinclude libsbml-version.html
   * are the following:
   * <ul>
   * <li> (Level&nbsp;2 and&nbsp;3) RateRule: returns @c 'rateRule'
   * <li> (Level&nbsp;2 and&nbsp;3) AssignmentRule: returns @c 'assignmentRule' 
   * <li> (Level&nbsp;2 and&nbsp;3) AlgebraicRule: returns @c 'algebraicRule'
   * <li> (Level&nbsp;1 Version&nbsp;1) SpecieConcentrationRule: returns @c 'specieConcentrationRule'
   * <li> (Level&nbsp;1 Version&nbsp;2) SpeciesConcentrationRule: returns @c 'speciesConcentrationRule'
   * <li> (Level&nbsp;1) CompartmentVolumeRule: returns @c 'compartmentVolumeRule'
   * <li> (Level&nbsp;1) ParameterRule: returns @c 'parameterRule'
   * <li> Unknown rule type: returns @c 'unknownRule'
   * </ul>
   *
   * Beware that the last (@c 'unknownRule') is not a valid SBML element
   * name.
   * 
   * @return the name of this element.
   */ public new
 string getElementName() {
    string ret = libsbmlPINVOKE.Rule_getElementName(swigCPtr);
    return ret;
  }

  
/**
   * Sets the SBML Level&nbsp;1 type code for this Rule.
   *
   * @param type the SBML Level&nbsp;1 type code for this Rule. The allowable
   * values are @link libsbml#SBML_COMPARTMENT_VOLUME_RULE SBML_COMPARTMENT_VOLUME_RULE@endlink,
   * @link libsbml#SBML_PARAMETER_RULE SBML_PARAMETER_RULE@endlink, and
   * @link libsbml#SBML_SPECIES_CONCENTRATION_RULE SBML_SPECIES_CONCENTRATION_RULE@endlink.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * if given @p type value is not one of the above.
   */ public
 int setL1TypeCode(int type) {
    int ret = libsbmlPINVOKE.Rule_setL1TypeCode(swigCPtr, type);
    return ret;
  }

  
/**
   * Predicate returning @c true if all the required elements for this Rule
   * object have been set.
   *
   * The only required element for a Rule object is the 'math' subelement in
   * SBML Level&nbsp;2 and Level&nbsp;3 Version&nbsp;1.  In SBML Level&nbsp;3
   * Version&nbsp;2+, it is no longer required.
   *
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   */ public new
 bool hasRequiredElements() {
    bool ret = libsbmlPINVOKE.Rule_hasRequiredElements(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if all the required attributes for this Rule
   * object have been set.
   *
   * The required attributes for a Rule object depend on the type of Rule
   * it is.  For AssignmentRule and RateRule objects (and SBML
   * Level&nbsp;1's SpeciesConcentrationRule, CompartmentVolumeRule, and
   * ParameterRule objects), the required attribute is 'variable'; for
   * AlgebraicRule objects, there is no required attribute.
   *
   * @return @c true if the required attributes have been set, @c false
   * otherwise.
   */ public new
 bool hasRequiredAttributes() {
    bool ret = libsbmlPINVOKE.Rule_hasRequiredAttributes(swigCPtr);
    return ret;
  }

  
/**
   *
 * Replaces all uses of a given @c SIdRef type attribute value with another
 * value.
 *
 *
 * 

 * In SBML, object identifiers are of a data type called <code>SId</code>.
 * In SBML Level&nbsp;3, an explicit data type called <code>SIdRef</code> was
 * introduced for attribute values that refer to <code>SId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to an identifier', but the effective
 * data type was the same as <code>SIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>SIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 *
 *
 *
 * This method works by looking at all attributes and (if appropriate)
 * mathematical formulas in MathML content, comparing the referenced
 * identifiers to the value of @p oldid.  If any matches are found, the
 * matching values are replaced with @p newid.  The method does @em not
 * descend into child elements.
 *
 * @param oldid the old identifier.
 * @param newid the new identifier.
 *
 *
   */ public new
 void renameSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.Rule_renameSIdRefs(swigCPtr, oldid, newid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   *
 * Replaces all uses of a given @c UnitSIdRef type attribute value with
 * another value.
 *
 *
 * 
 * In SBML, unit definitions have identifiers of type <code>UnitSId</code>.  In
 * SBML Level&nbsp;3, an explicit data type called <code>UnitSIdRef</code> was
 * introduced for attribute values that refer to <code>UnitSId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to a unit identifier', but the effective
 * data type was the same as <code>UnitSIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>UnitSIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 *
 *
 *
 * This method works by looking at all unit identifier attribute values
 * (including, if appropriate, inside mathematical formulas), comparing the
 * referenced unit identifiers to the value of @p oldid.  If any matches
 * are found, the matching values are replaced with @p newid.  The method
 * does @em not descend into child elements.
 *
 * @param oldid the old identifier.
 * @param newid the new identifier.
 *
 *
   */ public new
 void renameUnitSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.Rule_renameUnitSIdRefs(swigCPtr, oldid, newid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Returns the value of the 'variable' attribute of this Rule (NOT the 'id').
   *
   * @note Because of the inconsistent behavior of this function with 
   * respect to assignments and rules, it is now recommended to
   * use the getIdAttribute() or the getVariable() function instead.
   *
   * The 'variable' attribute of a Rule indicates the element which
   * the results of the 'math' are to be applied.  An AlgebraicRule has
   * no 'variable', and will always return an empty string.
   *
   * @return the variable of this Rule.
   *
   * @see getIdAttribute()
   * @see setIdAttribute(string sid)
   * @see isSetIdAttribute()
   * @see unsetIdAttribute()
   * @see getVariable()
   */ public new
 string getId() {
    string ret = libsbmlPINVOKE.Rule_getId(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 void replaceSIDWithFunction(string id, ASTNode function) {
    libsbmlPINVOKE.Rule_replaceSIDWithFunction(swigCPtr, id, ASTNode.getCPtr(function));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public new
 void divideAssignmentsToSIdByFunction(string id, ASTNode function) {
    libsbmlPINVOKE.Rule_divideAssignmentsToSIdByFunction(swigCPtr, id, ASTNode.getCPtr(function));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public new
 void multiplyAssignmentsToSIdByFunction(string id, ASTNode function) {
    libsbmlPINVOKE.Rule_multiplyAssignmentsToSIdByFunction(swigCPtr, id, ASTNode.getCPtr(function));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

}

}
