/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's Species construct.
 * <p>
 * A <em>species</em> in SBML refers to a pool of entities that (a) are
 * considered indistinguishable from each other for the purposes of the
 * model, (b) participate in reactions, and (c) are located in a specific
 * <em>compartment</em>.  The SBML {@link Species} object class is intended to represent
 * these pools.
 * <p>
 * As with other major constructs in SBML, {@link Species} has a mandatory
 * attribute, 'id', used to give the species type an identifier in the
 * model.  The identifier must be a text string conforming to the identifer
 * syntax permitted in SBML.  {@link Species} also has an optional 'name'
 * attribute, of type <code>string.</code>  The 'id' and 'name' must be used
 * according to the guidelines described in the SBML specifications.
 * <p>
 * The required attribute 'compartment' is used to identify the compartment
 * in which the species is located.  The attribute's value must be the
 * identifier of an existing {@link Compartment} object.  It is important to note
 * that there is no default value for the 'compartment' attribute on
 * {@link Species}; every species in an SBML model must be assigned a compartment
 * <em>explicitly</em>.  (This also implies that every model with one or more
 * {@link Species} objects must define at least one {@link Compartment} object.)
 * <p>
 * <p>
 * <h2>The initial amount and concentration of a species</h2>
 * <p>
 * The optional attributes 'initialAmount' and 'initialConcentration', both
 * having a data type of <code>double</code>, can be used to set the <em>initial</em>
 * quantity of the species in the compartment where the species is located.
 * These attributes are mutually exclusive; i.e., <em>only one</em> can
 * have a value on any given instance of a {@link Species} object.  Missing
 * 'initialAmount' and 'initialConcentration' values implies that their
 * values either are unknown, or to be obtained from an external source, or
 * determined by an {@link InitialAssignment} or other SBML construct elsewhere in
 * the model.
 * <p>
 * A species' initial quantity in SBML is set by the 'initialAmount' or
 * 'initialConcentration' attribute exactly once.  If the 'constant'
 * attribute is <code>true</code>, then the value of the species' quantity is fixed
 * and cannot be changed except by an {@link InitialAssignment}.  These methods
 * differ in that the 'initialAmount' and 'initialConcentration' attributes
 * can only be used to set the species quantity to a literal floating-point
 * number, whereas the use of an {@link InitialAssignment} object allows the value
 * to be set using an arbitrary mathematical expression (which, thanks to
 * MathML's expressiveness, may evaluate to a rational number).  If the
 * species' 'constant' attribute is <code>false</code>, the species' quantity value
 * may be overridden by an {@link InitialAssignment} or changed by {@link AssignmentRule}
 * or {@link AlgebraicRule}, and in addition, for <em>t &gt; 0</em>, it may also be
 * changed by a {@link RateRule}, {@link Event} objects, and as a result of being a
 * reactant or product in one or more {@link Reaction} objects.  (However, some
 * constructs are mutually exclusive; see the SBML specifications for the
 * precise details.)  It is not an error to define 'initialAmount' or
 * 'initialConcentration' on a species and also redefine the value using an
 * {@link InitialAssignment}, but the 'initialAmount' or 'initialConcentration'
 * setting in that case is ignored.  The SBML specifications provide
 * additional information about the semantics of assignments, rules and
 * values for simulation time <em>t</em> &#8804; <em>0</em>.
 * <p>
 * SBML Level&nbsp;2 additionally stipulates that in cases where a species'
 * compartment has a 'spatialDimensions' value of <code>0</code> (zero), the species
 * cannot have a value for 'initialConcentration' because the concepts of
 * concentration and density break down when a container has zero
 * dimensions.
 * <p>
 * <h2>The units of a species' amount or concentration</h2>
 * <p>
 * When the attribute 'initialAmount' is set, the unit of measurement
 * associated with the value of 'initialAmount' is specified by the {@link Species}
 * attribute 'substanceUnits'.  When the 'initialConcentration' attribute
 * is set, the unit of measurement associated with this concentration value
 * is {<em>unit of amount</em>} divided by {<em>unit of size</em>}, where
 * the {<em>unit of amount</em>} is specified by the {@link Species}
 * 'substanceUnits' attribute, and the {<em>unit of size</em>} is specified
 * by the 'units' attribute of the {@link Compartment} object in which the species
 * is located.  Note that in either case, a unit of <em>amount</em> is
 * involved and determined by the 'substanceUnits' attribute.  Note
 * <strong>these two attributes alone do not determine the units of the
 * species when the species identifier appears in a mathematical
 * expression</strong>; <em>that</em> aspect is determined by the attribute
 * 'hasOnlySubstanceUnits' discussed below.
 * <p>
 * In SBML Level&nbsp;3, if the 'substanceUnits' attribute is not set on a
 * given {@link Species} object instance, then the unit of <em>amount</em> for that
 * species is inherited from the 'substanceUnits' attribute on the
 * enclosing {@link Model} object instance.  If that attribute on {@link Model} is not set
 * either, then the unit associated with the species' quantity is
 * undefined.
 * <p>
 * In SBML Level&nbsp;2, if the 'substanceUnits' attribute is not set on a
 * given {@link Species} object instance, then the unit of <em>amount</em> for that
 * species is taken from the predefined SBML unit identifier 
 * <code>'substance'.</code>  The value assigned to 'substanceUnits' must be chosen from
 * one of the following possibilities: one of the base unit identifiers
 * defined in SBML, the built-in unit identifier <code>'substance'</code>, or the
 * identifier of a new unit defined in the list of unit definitions in the
 * enclosing {@link Model} object.  The chosen units for 'substanceUnits' must be
 * be <code>'dimensionless'</code>, <code>'mole'</code>, <code>'item'</code>, <code>'kilogram'</code>, <code>'gram'</code>,
 * or units derived from these.
 * <p>
 * As noted at the beginning of this section, simply setting
 * 'initialAmount' or 'initialConcentration' alone does <em>not</em> determine
 * whether a species identifier represents an amount or a concentration
 * when it appears elsewhere in an SBML model.  The role of the attribute
 * 'hasOnlySubstanceUnits' is to indicate whether the units of the species,
 * when the species identifier appears in mathematical formulas, are
 * intended to be concentration or amount.  The attribute takes on a
 * boolean value.  In SBML Level&nbsp;3, the attribute has no default value
 * and must always be set in a model; in SBML Level&nbsp;2, it has a
 * default value of <code>false.</code>
 * <p>
 * The <em>units of the species</em> are used in the following ways:
 * <ul>
<p>
 * <li> When the species' identifier appears in a MathML formula, it
 * represents the species' quantity, and the unit of measurement associated
 * with the quantity is as described above.
 * <p>
 * <li> The 'math' elements of {@link AssignmentRule}, {@link InitialAssignment} and
 * {@link EventAssignment} objects referring to this species should all have the
 * same units as the unit of measurement associated with the species
 * quantity.
 * <p>
 * <li> In a {@link RateRule} object that defines the rate of change of the
 * species' quantity, the unit associated with the rule's 'math' element
 * should be equal to the unit of the species' quantity divided by the
 * model-wide unit of <em>time</em>; in other words, {<em>unit of species
 * quantity</em>}/{<em>unit of time</em>}.
 * <p>
 * </ul>
 * <p>
 * <p>
 * <h2>The 'constant' and 'boundaryCondition' attributes</h2>
 * <p>
 * The {@link Species} object class has two boolean attributes named 'constant' and
 * 'boundaryCondition', used to indicate whether and how the quantity of
 * that species can vary during a simulation.  In SBML Level&nbsp;2 they
 * are optional; in SBML Level&nbsp;3 they are mandatory.  The following
 * table shows how to interpret the combined values of these attributes.
 * <p>
 * <center>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
<caption class='top-caption'>Interpretation
of species' <code>constant</code> and <code>boundaryCondition</code>
attributes.</caption>
 <tr>
     <th align='left' valign='bottom'>
       <code>constant</code><br>value
     </th>
     <th align='left' valign='bottom'>
       <code>boundaryCondition</code><br>value
     </th>
     <th align='left' valign='bottom'>
       Can have<br>assignment<br>or rate rule?
     </th>
     <th align='left' valign='bottom'>
       Can be<br>reactant<br>or product?
     </th>
     <th align='left' valign='bottom'>
       {@link Species}' quantity<br>can be changed by
     </th>
 </tr>
 <tr>
     <td><code>true</code></td>
     <td><code>true</code></td>
     <td>no</td>
     <td>yes</td>
     <td>(never changes)</td>
 </tr>
 <tr>
     <td><code>false</code></td>
     <td><code>true</code></td>
     <td>yes</td>
     <td>yes</td>
     <td>rules and events</td>
 </tr>
 <tr>
     <td><code>true</code></td>
     <td><code>false</code></td>
     <td>no</td>
     <td>no</td>
     <td>(never changes)</td>
 </tr>
 <tr>
     <td><code>false</code></td>
     <td><code>false</code></td>
     <td>yes</td>
     <td>yes</td>
     <td>reactions <em>or</em> rules (but not both at the same time), and events</td>
 </tr>
</table>
</center>

 * <p>
 * By default, when a species is a product or reactant of one or more
 * reactions, its quantity is determined by those reactions.  In SBML, it
 * is possible to indicate that a given species' quantity is <em>not</em>
 * determined by the set of reactions even when that species occurs as a
 * product or reactant; i.e., the species is on the <em>boundary</em> of
 * the reaction system, and its quantity is not determined by the
 * reactions.  The boolean attribute 'boundaryCondition' can be used to
 * indicate this.  A value of <code>false</code> indicates that the species <em>is</em>
 * part of the reaction system.  In SBML Level&nbsp;2, the attribute has a
 * default value of <code>false</code>, while in SBML Level&nbsp;3, it has no
 * default.
 * <p>
 * The 'constant' attribute indicates whether the species' quantity can be
 * changed at all, regardless of whether by reactions, rules, or constructs
 * other than {@link InitialAssignment}.  A value of <code>false</code> indicates that the
 * species' quantity can be changed.  (This is also a common value because
 * the purpose of most simulations is precisely to calculate changes in
 * species quantities.)  In SBML Level&nbsp;2, the attribute has a default
 * value of <code>false</code>, while in SBML Level&nbsp;3, it has no default.  Note
 * that the initial quantity of a species can be set by an
 * {@link InitialAssignment} irrespective of the value of the 'constant' attribute.
 * <p>
 * In practice, a 'boundaryCondition' value of <code>true</code> means a differential
 * equation derived from the reaction definitions should not be generated
 * for the species.  However, the species' quantity may still be changed by
 * {@link AssignmentRule}, {@link RateRule}, {@link AlgebraicRule}, {@link Event}, and {@link InitialAssignment}
 * constructs if its 'constant' attribute is <code>false.</code>  Conversely, if the
 * species' 'constant' attribute is <code>true</code>, then its value cannot be
 * changed by anything except {@link InitialAssignment}.
 * <p>
 * A species having 'boundaryCondition'=<code>false</code> and 'constant'=<code>false</code>
 * can appear as a product and/or reactant of one or more reactions in the
 * model.  If the species is a reactant or product of a reaction, it must
 * <em>not</em> also appear as the target of any {@link AssignmentRule} or {@link RateRule}
 * object in the model.  If instead the species has 'boundaryCondition'=
 * <code>false</code> and 'constant'=<code>true</code>, then it cannot appear as a reactant or
 * product, or as the target of any {@link AssignmentRule}, {@link RateRule} or
 * {@link EventAssignment} object in the model.
 * <p>
 * <p>
 * <h2>The conversionFactor attribute in SBML Level&nbsp;3</h2>
 * <p>
 * In SBML Level&nbsp;3, {@link Species} has an additional optional attribute,
 * 'conversionFactor', that defines a conversion factor that applies to a
 * particular species.  The value must be the identifier of a {@link Parameter}
 * object instance defined in the model.  That {@link Parameter} object must be a
 * constant, meaning its 'constant' attribute must be set to <code>true.</code>
 * If a given {@link Species} object definition defines a value for its
 * 'conversionFactor' attribute, it takes precedence over any factor
 * defined by the {@link Model} object's 'conversionFactor' attribute.
 * <p>
 * The unit of measurement associated with a species' quantity can be
 * different from the unit of extent of reactions in the model.  SBML
 * Level&nbsp;3 avoids implicit unit conversions by providing an explicit
 * way to indicate any unit conversion that might be required.  The use of
 * a conversion factor in computing the effects of reactions on a species'
 * quantity is explained in detail in the SBML Level&nbsp;3 specification
 * document.  Because the value of the 'conversionFactor' attribute is the
 * identifier of a {@link Parameter} object, and because parameters can have units
 * attached to them, the transformation from reaction extent units to
 * species units can be completely specified using this approach.
 * <p>
 * Note that the unit conversion factor is <strong>only applied when
 * calculating the effect of a reaction on a species</strong>.  It is not
 * used in any rules or other SBML constructs that affect the species, and
 * it is also not used when the value of the species is referenced in a
 * mathematical expression.
 * <p>
 * <p>
 * <h2>The speciesType attribute in SBML Level&nbsp;2 Versions&nbsp;2&ndash;4</h2>
 * <p>
 * In SBML Level&nbsp;2 Versions&nbsp;2&ndash;4, each species in a model
 * may optionally be designated as belonging to a particular species type.
 * The optional attribute 'speciesType' is used to identify the species
 * type of the chemical entities that make up the pool represented by the
 * {@link Species} objects.  The attribute's value must be the identifier of an
 * existing {@link SpeciesType} object in the model.  If the 'speciesType'
 * attribute is not present on a particular species definition, it means
 * the pool contains chemical entities of a type unique to that pool; in
 * effect, a virtual species type is assumed for that species, and no other
 * species can belong to that species type.  The value of 'speciesType'
 * attributes on species have no effect on the numerical interpretation of
 * a model; simulators and other numerical analysis software may ignore
 * 'speciesType' attributes.
 * <p>
 * There can be only one species of a given species type in any given
 * compartment of a model.  More specifically, for all {@link Species} objects
 * having a value for the 'speciesType' attribute, the pair
 * <center>
 * ('speciesType' attribute value, 'compartment' attribute value)
 * </center>
 * <p>
 * must be unique across the set of all {@link Species} object in a model.
 * <p>
 * <p>
 * <h2>The spatialSizeUnits attribute in SBML Level&nbsp;2 Versions&nbsp;1&ndash;2</h2>
 * <p>
 * In versions of SBML Level&nbsp;2 before Version&nbsp;3, the class
 * {@link Species} included an attribute called 'spatialSizeUnits', which allowed
 * explicitly setting the units of size for initial concentration.  LibSBML
 * retains this attribute for compatibility with older definitions of
 * Level&nbsp;2, but its use is strongly discouraged because many software
 * tools do no properly interpret this unit declaration and it is
 * incompatible with all SBML specifications after Level&nbsp;2
 * Version&nbsp;3.
 * <p>
 * <p>
 * <h2>Additional considerations for interpreting the numerical value of a species</h2>
 * <p>
 * {@link Species} are unique in SBML in that they have a kind of duality: a
 * species identifier may stand for either substance amount (meaning, a
 * count of the number of individual entities) or a concentration or
 * density (meaning, amount divided by a compartment size).  The previous
 * sections explain the meaning of a species identifier when it is
 * referenced in a mathematical formula or in rules or other SBML
 * constructs; however, it remains to specify what happens to a species
 * when the compartment in which it is located changes in size.
 * <p>
 * When a species definition has a 'hasOnlySubstanceUnits' attribute value
 * of <code>false</code> and the size of the compartment in which the species is
 * located changes, the default in SBML is to assume that it is the
 * concentration that must be updated to account for the size change.  This
 * follows from the principle that, all other things held constant, if a
 * compartment simply changes in size, the size change does not in itself
 * cause an increase or decrease in the number of entities of any species
 * in that compartment.  In a sense, the default is that the <em>amount</em> of
 * a species is preserved across compartment size changes.  Upon such size
 * changes, the value of the concentration or density must be recalculated
 * from the simple relationship <em>concentration = amount / size</em> if
 * the value of the concentration is needed (for example, if the species
 * identifier appears in a mathematical formula or is otherwise referenced
 * in an SBML construct).  There is one exception: if the species' quantity
 * is determined by an {@link AssignmentRule}, {@link RateRule}, {@link AlgebraicRule}, or an
 * {@link EventAssignment} and the species has a 'hasOnlySubstanceUnits' attribute
 * value of <code>false</code>, it means that the <em>concentration</em> is assigned
 * by the rule or event; in that case, the <em>amount</em> must be
 * calculated when the compartment size changes.  (Events also require
 * additional care in this situation, because an event with multiple
 * assignments could conceivably reassign both a species quantity and a
 * compartment size simultaneously.  Please refer to the SBML
 * specifications for the details.)
 * <p>
 * Note that the above only matters if a species has a
 * 'hasOnlySubstanceUnits' attribute value of <code>false</code>, meaning that the
 * species identifier refers to a concentration wherever the identifier
 * appears in a mathematical formula.  If instead the attribute's value is
 * <code>true</code>, then the identifier of the species <em>always</em> stands for
 * an amount wherever it appears in a mathematical formula or is referenced
 * by an SBML construct.  In that case, there is never a question about
 * whether an assignment or event is meant to affect the amount or
 * concentration: it is always the amount.
 * <p>
 * A particularly confusing situation can occur when the species has
 * 'constant' attribute value of <code>true</code> in combination with a
 * 'hasOnlySubstanceUnits' attribute value of <code>false.</code>  Suppose this
 * species is given a value for 'initialConcentration'.  Does a 'constant'
 * value of <code>true</code> mean that the concentration is held constant if the
 * compartment size changes?  No; it is still the amount that is kept
 * constant across a compartment size change.  The fact that the species
 * was initialized using a concentration value is irrelevant.
 * <p>
 * <p>
 * <!-- leave this next break as-is to work around some doxygen bug -->
 */

public class Species extends SBase {
   private long swigCPtr;

   protected Species(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.Species_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(Species obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Species obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_Species(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
/**
   * Creates a new {@link Species} using the given SBML <code>level</code> and <code>version</code>
   * values.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link Species}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Species}
   * <p>
   * @throws SBMLConstructorException 
   * Thrown if the given <code>level</code> and <code>version</code> combination, or this kind
   * of SBML object, are either invalid or mismatched with respect to the
   * parent {@link SBMLDocument} object.
   * <p>
   * @note Upon the addition of a {@link Species} object to an {@link SBMLDocument} (e.g.,
   * using {@link Model#addSpecies(Species s)}), the SBML Level, SBML Version and XML
   * namespace of the document <em>override</em> the values used when creating
   * the {@link Species} object via this constructor.  This is necessary to ensure
   * that an SBML document is a consistent structure.  Nevertheless, the
   * ability to supply the values at the time of creation of a {@link Species} is
   * an important aid to producing valid SBML.  Knowledge of the intented
   * SBML Level and Version determine whether it is valid to assign a
   * particular value to an attribute, or whether it is valid to add an
   * object to an existing {@link SBMLDocument}.
   */ public
 Species(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Species__SWIG_0(level, version), true);
  }

  
/**
   * Creates a new {@link Species} using the given {@link SBMLNamespaces} object
   * <code>sbmlns</code>.
   * <p>
   * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and
   * (in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
   * A common approach to using this class constructor is to create an
   * {@link SBMLNamespaces} object somewhere in a program, once, then pass it to
   * object constructors such as this one when needed.
   * <p>
   * It is worth emphasizing that although this constructor does not take
   * an identifier argument, in SBML Level&nbsp;2 and beyond, the 'id'
   * (identifier) attribute of a {@link Species} is required to have a value.
   * Thus, callers are cautioned to assign a value after calling this
   * constructor.  Setting the identifier can be accomplished using the
   * method {@link Species#setId(String id)}.
   * <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   * <p>
   * @throws SBMLConstructorException 
   * Thrown if the given <code>level</code> and <code>version</code> combination, or this kind
   * of SBML object, are either invalid or mismatched with respect to the
   * parent {@link SBMLDocument} object.
   * <p>
   * @note Upon the addition of a {@link Species} object to an {@link SBMLDocument} (e.g.,
   * using {@link Model#addSpecies(Species s)}), the SBML XML namespace of the document 
   * <em>overrides</em> the value used when creating the {@link Species} object via this
   * constructor.  This is necessary to ensure that an SBML document is a
   * consistent structure.  Nevertheless, the ability to supply the values
   * at the time of creation of a {@link Species} is an important aid to producing
   * valid SBML.  Knowledge of the intented SBML Level and Version
   * determine whether it is valid to assign a particular value to an
   * attribute, or whether it is valid to add an object to an existing
   * {@link SBMLDocument}.
   */ public
 Species(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Species__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
/**
   * Copy constructor; creates a copy of this {@link Species} object.
   * <p>
   * @param orig the object to copy.
   * <p>
   * @throws SBMLConstructorException 
   * Thrown if the argument <code>orig</code> is <code>null.</code>
   */ public
 Species(Species orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Species__SWIG_2(Species.getCPtr(orig), orig), true);
  }

  
/**
   * Creates and returns a deep copy of this {@link Species} object.
   * <p>
   * @return a (deep) copy of this {@link Species} object.
   */ public
 Species cloneObject() {
    long cPtr = libsbmlJNI.Species_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new Species(cPtr, true);
  }

  
/**
   * Initializes the fields of this {@link Species} object to 'typical' defaults
   * values.
   * <p>
   * The SBML {@link Species} component has slightly different aspects and
   * default attribute values in different SBML Levels and Versions.
   * This method sets the values to certain common defaults, based
   * mostly on what they are in SBML Level&nbsp;2.  Specifically:
   * <ul>
   * <li> Sets 'boundaryCondition' to <code>false</code>
   * <li> Sets 'constant' to <code>false</code>
   * <li> sets 'hasOnlySubstanceUnits' to <code>false</code>
   * <li> (Applies to Level&nbsp;3 models only) Sets attribute 'substanceUnits' to <code>mole</code>
   * </ul>
   */ public
 void initDefaults() {
    libsbmlJNI.Species_initDefaults(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'id' attribute of this {@link Species} object.
   * <p>
   * @return the id of this {@link Species} object.
   */ public
 String getId() {
    return libsbmlJNI.Species_getId(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'name' attribute of this {@link Species} object.
   * <p>
   * @return the name of this {@link Species} object.
   */ public
 String getName() {
    return libsbmlJNI.Species_getName(swigCPtr, this);
  }

  
/**
   * Get the type of this {@link Species} object object.
   * <p>
   * @return the value of the 'speciesType' attribute of this
   * {@link Species} as a string.
   * <p>
   * @note The 'speciesType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   */ public
 String getSpeciesType() {
    return libsbmlJNI.Species_getSpeciesType(swigCPtr, this);
  }

  
/**
   * Get the compartment in which this species is located.
   * <p>
   * The compartment is designated by its identifier.
   * <p>
   * @return the value of the 'compartment' attribute of this {@link Species}
   * object, as a string.
   */ public
 String getCompartment() {
    return libsbmlJNI.Species_getCompartment(swigCPtr, this);
  }

  
/**
   * Get the value of the 'initialAmount' attribute.
   * <p>
   * @return the initialAmount of this {@link Species}, as a float-point number.
   */ public
 double getInitialAmount() {
    return libsbmlJNI.Species_getInitialAmount(swigCPtr, this);
  }

  
/**
   * Get the value of the 'initialConcentration' attribute.
   * <p>
   * @return the initialConcentration of this {@link Species},, as a float-point
   * number.
   * <p>
   * @note The attribute 'initialConcentration' is only available in SBML
   * Level&nbsp;2 and&nbsp;3.  It does not exist on {@link Species} in Level&nbsp;1.
   */ public
 double getInitialConcentration() {
    return libsbmlJNI.Species_getInitialConcentration(swigCPtr, this);
  }

  
/**
   * Get the value of the 'substanceUnits' attribute.
   * <p>
   * @return the value of the 'substanceUnits' attribute of this {@link Species},
   * as a string.  An empty string indicates that no units have been
   * assigned.
   * <p>
   * @note There is an important distinction to be made between <em>no units
assigned</em>, and assuming a value without units has any specific unit
such as <code>dimensionless</code>.  In SBML, default units are never
attributed to numbers, and numbers without units are not automatically
assumed to have the unit <code>dimensionless</code>.  Please consult the
relevant SBML specification document for a more in-depth explanation of
this topic and the SBML unit system.

   * <p>
   * @see #isSetSubstanceUnits()
   * @see #setSubstanceUnits(String sid)
   */ public
 String getSubstanceUnits() {
    return libsbmlJNI.Species_getSubstanceUnits(swigCPtr, this);
  }

  
/**
   * Get the value of the 'spatialSizeUnits' attribute.
   * <p>
   * @return the value of the 'spatialSizeUnits' attribute of this {@link Species}
   * object, as a string.
   * <p>
   * @warning In versions of SBML Level&nbsp;2 before Version&nbsp;3, the
   * class {@link Species} included an attribute called 'spatialSizeUnits', which
   * allowed explicitly setting the units of size for initial
   * concentration.  This attribute was removed in SBML Level&nbsp;2
   * Version&nbsp;3.  LibSBML retains this attribute for compatibility with
   * older definitions of Level&nbsp;2, but its use is strongly discouraged
   * because it is incompatible with Level&nbsp;2 Version&nbsp;3 and
   * Level&nbsp;2 Version&nbsp;4.
   */ public
 String getSpatialSizeUnits() {
    return libsbmlJNI.Species_getSpatialSizeUnits(swigCPtr, this);
  }

  
/**
   * Get the value of the 'units' attribute.
   * <p>
   * @return the units of this {@link Species} (L1 only).
   * <p>
   * @note The 'units' attribute is defined only in SBML Level&nbsp;1.  In
   * SBML Level&nbsp;2 and Level&nbsp;3, it has been replaced by a
   * combination of 'substanceUnits' and the units of the {@link Compartment}
   * object in which a species is located.  In SBML Level&nbsp;2
   * Versions&nbsp;1&ndash;2, an additional attribute 'spatialSizeUnits'
   * helps determine the units of the species quantity, but this attribute
   * was removed in later versions of SBML Level&nbsp;2.
   */ public
 String getUnits() {
    return libsbmlJNI.Species_getUnits(swigCPtr, this);
  }

  
/**
   * Get the value of the 'hasOnlySubstanceUnits' attribute.
   * <p>
   * @return <code>true</code> if this {@link Species}' 'hasOnlySubstanceUnits' attribute
   * value is nonzero, <code>false</code> otherwise.
   * <p>
   * @note The 'hasOnlySubstanceUnits' attribute does not exist in SBML
   * Level&nbsp;1.
   */ public
 boolean getHasOnlySubstanceUnits() {
    return libsbmlJNI.Species_getHasOnlySubstanceUnits(swigCPtr, this);
  }

  
/**
   * Get the value of the 'boundaryCondition' attribute.
   * <p>
   * @return <code>true</code> if this {@link Species}' 'boundaryCondition' attribute value
   * is nonzero, <code>false</code> otherwise.
   */ public
 boolean getBoundaryCondition() {
    return libsbmlJNI.Species_getBoundaryCondition(swigCPtr, this);
  }

  
/**
   * Get the value of the 'charge' attribute.
   * <p>
   * @return the charge of this {@link Species} object.
   * <p>
   * @note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the 'charge'
   * attribute on {@link Species} is deprecated and in SBML Level&nbsp;3 it does
   * not exist at all.  Its use strongly discouraged.  Its presence is
   * considered a misfeature in earlier definitions of SBML because its
   * implications for the mathematics of a model were never defined, and in
   * any case, no known modeling system ever used it.  Instead, models take
   * account of charge values directly in their definitions of species by
   * (for example) having separate species identities for the charged and
   * uncharged versions of the same species.  This allows the condition to
   * affect model mathematics directly.  LibSBML retains this method for
   * easier compatibility with SBML Level&nbsp;1.
   */ public
 int getCharge() {
    return libsbmlJNI.Species_getCharge(swigCPtr, this);
  }

  
/**
   * Get the value of the 'constant' attribute.
   * <p>
   * @return <code>true</code> if this {@link Species}'s 'constant' attribute value is
   * nonzero, <code>false</code> otherwise.
   * <p>
   * @note The attribute 'constant' is only available in SBML Levels&nbsp;2
   * and&nbsp;3.  It does not exist on {@link Species} in Level&nbsp;1.
   */ public
 boolean getConstant() {
    return libsbmlJNI.Species_getConstant(swigCPtr, this);
  }

  
/**
   * Get the value of the 'conversionFactor' attribute.
   * <p>
   * @return the conversionFactor of this {@link Species}, as a string.
   * <p>
   * @note The 'conversionFactor' attribute was introduced in SBML
   * Level&nbsp;3.  It does not exist on {@link Species} in SBML Levels&nbsp;1
   * and&nbsp;2.
   */ public
 String getConversionFactor() {
    return libsbmlJNI.Species_getConversionFactor(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Species} object's 'id' attribute is set.
   * <p>
   * @return <code>true</code> if the 'id' attribute of this {@link Species} is
   * set, <code>false</code> otherwise.
   */ public
 boolean isSetId() {
    return libsbmlJNI.Species_isSetId(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Species} object's 'name' attribute is set.
   * <p>
   * @return <code>true</code> if the 'name' attribute of this {@link Species} is
   * set, <code>false</code> otherwise.
   */ public
 boolean isSetName() {
    return libsbmlJNI.Species_isSetName(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this {@link Species} object's
   * 'speciesType' attribute is set.
   * <p>
   * @return <code>true</code> if the 'speciesType' attribute of this {@link Species} is
   * set, <code>false</code> otherwise.
   * <p>
   * @note The 'speciesType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   */ public
 boolean isSetSpeciesType() {
    return libsbmlJNI.Species_isSetSpeciesType(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Species} object's 'compartment' attribute is set.
   * <p>
   * @return <code>true</code> if the 'compartment' attribute of this {@link Species} is
   * set, <code>false</code> otherwise.
   */ public
 boolean isSetCompartment() {
    return libsbmlJNI.Species_isSetCompartment(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Species} object's 'initialAmount' attribute is set.
   * <p>
   * @return <code>true</code> if the 'initialAmount' attribute of this {@link Species} is
   * set, <code>false</code> otherwise.
   * <p>
   * @note In SBML Level&nbsp;1, {@link Species}' 'initialAmount' is required and
   * therefore <em>should always be set</em>.  (However, in Level&nbsp;1, the
   * attribute has no default value either, so this method will not return
   * <code>true</code> until a value has been assigned.)  In SBML Level&nbsp;2,
   * 'initialAmount' is optional and as such may or may not be set.
   */ public
 boolean isSetInitialAmount() {
    return libsbmlJNI.Species_isSetInitialAmount(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Species} object's 'initialConcentration' attribute is set.
   * <p>
   * @return <code>true</code> if the 'initialConcentration' attribute of this {@link Species} is
   * set, <code>false</code> otherwise.
   * <p>
   * @note The attribute 'initialConcentration' is only available in SBML
   * Level&nbsp;2 and&nbsp;3.  It does not exist on {@link Species} in Level&nbsp;1.
   */ public
 boolean isSetInitialConcentration() {
    return libsbmlJNI.Species_isSetInitialConcentration(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Species} object's 'substanceUnits' attribute is set.
   * <p>
   * @return <code>true</code> if the 'substanceUnits' attribute of this {@link Species} is
   * set, <code>false</code> otherwise.
   */ public
 boolean isSetSubstanceUnits() {
    return libsbmlJNI.Species_isSetSubstanceUnits(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Species} object's 'spatialSizeUnits' attribute is set.
   * <p>
   * @return <code>true</code> if the 'spatialSizeUnits' attribute of this {@link Species} is
   * set, <code>false</code> otherwise.
   * <p>
   * @warning In versions of SBML Level~2 before Version&nbsp;3, the class
   * {@link Species} included an attribute called 'spatialSizeUnits', which allowed
   * explicitly setting the units of size for initial concentration.  This
   * attribute was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML
   * retains this attribute for compatibility with older definitions of
   * Level&nbsp;2, but its use is strongly discouraged because it is
   * incompatible with Level&nbsp;2 Version&nbsp;3 and Level&nbsp;2 Version&nbsp;4.
   */ public
 boolean isSetSpatialSizeUnits() {
    return libsbmlJNI.Species_isSetSpatialSizeUnits(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if
   * this {@link Species} object's 'units' attribute is set.
   * <p>
   * @return <code>true</code> if the 'units' attribute of this {@link Species} is
   * set, <code>false</code> otherwise.
   */ public
 boolean isSetUnits() {
    return libsbmlJNI.Species_isSetUnits(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Species} object's 'charge' attribute is set.
   * <p>
   * @return <code>true</code> if the 'charge' attribute of this {@link Species} is
   * set, <code>false</code> otherwise.
   * <p>
   * @note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the 'charge'
   * attribute on {@link Species} in SBML is deprecated and in SBML Level&nbsp;3 it
   * does not exist at all.  Its use strongly discouraged.  Its presence is
   * considered a misfeature in earlier definitions of SBML because its
   * implications for the mathematics of a model were never defined, and in
   * any case, no known modeling system ever used it.  Instead, models take
   * account of charge values directly in their definitions of species by
   * (for example) having separate species identities for the charged and
   * uncharged versions of the same species.  This allows the condition to
   * affect model mathematics directly.  LibSBML retains this method for
   * easier compatibility with SBML Level&nbsp;1.
   */ public
 boolean isSetCharge() {
    return libsbmlJNI.Species_isSetCharge(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Species} object's 'conversionFactor' attribute is set.
   * <p>
   * @return <code>true</code> if the 'conversionFactor' attribute of this {@link Species} is
   * set, <code>false</code> otherwise.
   * <p>
   * @note The 'conversionFactor' attribute was introduced in SBML
   * Level&nbsp;3.  It does not exist on {@link Species} in SBML Levels&nbsp;1
   * and&nbsp;2.
   */ public
 boolean isSetConversionFactor() {
    return libsbmlJNI.Species_isSetConversionFactor(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Species} object's 'boundaryCondition' attribute is set.
   * <p>
   * @return <code>true</code> if the 'boundaryCondition' attribute of this {@link Species} is
   * set, <code>false</code> otherwise.
   */ public
 boolean isSetBoundaryCondition() {
    return libsbmlJNI.Species_isSetBoundaryCondition(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Species} object's 'hasOnlySubstanceUnits' attribute is set.
   * <p>
   * @return <code>true</code> if the 'hasOnlySubstanceUnits' attribute of this {@link Species} is
   * set, <code>false</code> otherwise.
   * <p>
   * @note The 'hasOnlySubstanceUnits' attribute does not exist in SBML
   * Level&nbsp;1.
   */ public
 boolean isSetHasOnlySubstanceUnits() {
    return libsbmlJNI.Species_isSetHasOnlySubstanceUnits(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Species} object's 'constant' attribute is set.
   * <p>
   * @return <code>true</code> if the 'constant' attribute of this {@link Species} is
   * set, <code>false</code> otherwise.
   * <p>
   * @note The attribute 'constant' is only available in SBML Levels&nbsp;2
   * and&nbsp;3.  It does not exist on {@link Species} in Level&nbsp;1.
   */ public
 boolean isSetConstant() {
    return libsbmlJNI.Species_isSetConstant(swigCPtr, this);
  }

  
/**
   * Sets the value of the 'id' attribute of this {@link Species} object.
   * <p>
   * The string <code>sid</code> is copied.  Note that SBML has strict requirements
   * for the syntax of identifiers.  The following is a summary of the definition of the SBML identifier type 
<code>SId</code>, which defines the permitted syntax of identifiers.  We
express the syntax using an extended form of BNF notation: 
<pre style='margin-left: 2em; border: none; font-weight: bold; font-size: 13px; color: black'>
letter .= 'a'..'z','A'..'Z'
digit  .= '0'..'9'
idChar .= letter | digit | '_'
SId    .= ( letter | '_' ) idChar*
</pre>
The characters <code>(</code> and <code>)</code> are used for grouping, the
character <code>*</code> 'zero or more times', and the character
<code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
determined by an exact character sequence match; i.e., comparisons must be
performed in a case-sensitive manner.  In addition, there are a few
conditions for the uniqueness of identifiers in an SBML model.  Please
consult the SBML specifications for the exact formulations.
<p>

   * <p>
   * @param sid the string to use as the identifier of this {@link Species}
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * </ul>
   */ public
 int setId(String sid) {
    return libsbmlJNI.Species_setId(swigCPtr, this, sid);
  }

  
/**
   * Sets the value of the 'name' attribute of this {@link Species} object.
   * <p>
   * The string in <code>name</code> is copied.
   * <p>
   * @param name the new name for the {@link Species}
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * </ul>
   */ public
 int setName(String name) {
    return libsbmlJNI.Species_setName(swigCPtr, this, name);
  }

  
/**
   * Sets the 'speciesType' attribute of this {@link Species} object.
   * <p>
   * @param sid the identifier of a {@link SpeciesType} object defined elsewhere
   * in this {@link Model}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * </ul>
   * <p>
   * @note The 'speciesType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   */ public
 int setSpeciesType(String sid) {
    return libsbmlJNI.Species_setSpeciesType(swigCPtr, this, sid);
  }

  
/**
   * Sets the 'compartment' attribute of this {@link Species} object.
   * <p>
   * @param sid the identifier of a {@link Compartment} object defined elsewhere
   * in this {@link Model}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * </ul>
   */ public
 int setCompartment(String sid) {
    return libsbmlJNI.Species_setCompartment(swigCPtr, this, sid);
  }

  
/**
   * Sets the 'initialAmount' attribute of this {@link Species} and marks the field
   * as set.
   * <p>
   * This method also unsets the 'initialConcentration' attribute.
   * <p>
   * @param value the value to which the 'initialAmount' attribute should
   * be set.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   */ public
 int setInitialAmount(double value) {
    return libsbmlJNI.Species_setInitialAmount(swigCPtr, this, value);
  }

  
/**
   * Sets the 'initialConcentration' attribute of this {@link Species} and marks
   * the field as set.
   * <p>
   * This method also unsets the 'initialAmount' attribute.
   * <p>
   * @param value the value to which the 'initialConcentration' attribute
   * should be set.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * </ul>
   * <p>
   * @note The attribute 'initialConcentration' is only available in SBML
   * Level&nbsp;2 and&nbsp;3.  It does not exist on {@link Species} in Level&nbsp;1.
   */ public
 int setInitialConcentration(double value) {
    return libsbmlJNI.Species_setInitialConcentration(swigCPtr, this, value);
  }

  
/**
   * Sets the 'substanceUnits' attribute of this {@link Species} object.
   * <p>
   * @param sid the identifier of the unit to use.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * </ul>
   */ public
 int setSubstanceUnits(String sid) {
    return libsbmlJNI.Species_setSubstanceUnits(swigCPtr, this, sid);
  }

  
/**
   * (SBML Level&nbsp;2 Versions&nbsp;1&ndash;2) Sets the 'spatialSizeUnits' attribute of this {@link Species} object.
   * <p>
   * @param sid the identifier of the unit to use.
   * <p>
   * @warning In versions of SBML Level~2 before Version&nbsp;3, the class
   * {@link Species} included an attribute called 'spatialSizeUnits', which allowed
   * explicitly setting the units of size for initial concentration.  This
   * attribute was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML
   * retains this attribute for compatibility with older definitions of
   * Level&nbsp;2, but its use is strongly discouraged because it is
   * incompatible with Level&nbsp;2 Version&nbsp;3 and Level&nbsp;2 Version&nbsp;4.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * </ul>
   */ public
 int setSpatialSizeUnits(String sid) {
    return libsbmlJNI.Species_setSpatialSizeUnits(swigCPtr, this, sid);
  }

  
/**
   * (SBML Level&nbsp;1 only) Sets the units of this {@link Species} object.
   * <p>
   * @param sname the identifier of the unit to use.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * </ul>
  */ public
 int setUnits(String sname) {
    return libsbmlJNI.Species_setUnits(swigCPtr, this, sname);
  }

  
/**
   * Sets the 'hasOnlySubstanceUnits' attribute of this {@link Species} object.
   * <p>
   * @param value boolean value for the 'hasOnlySubstanceUnits' attribute.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * </ul>
   * <p>
   * @note The 'hasOnlySubstanceUnits' attribute does not exist in SBML
   * Level&nbsp;1.
   */ public
 int setHasOnlySubstanceUnits(boolean value) {
    return libsbmlJNI.Species_setHasOnlySubstanceUnits(swigCPtr, this, value);
  }

  
/**
   * Sets the 'boundaryCondition' attribute of this {@link Species} object.
   * <p>
   * @param value boolean value for the 'boundaryCondition' attribute.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   */ public
 int setBoundaryCondition(boolean value) {
    return libsbmlJNI.Species_setBoundaryCondition(swigCPtr, this, value);
  }

  
/**
   * Sets the 'charge' attribute of this {@link Species} object.
   * <p>
   * @param value an integer to which to set the 'charge' to.
   * <p>
   * @note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the 'charge'
   * attribute on {@link Species} in SBML is deprecated and its use strongly
   * discouraged, and it does not exist in SBML Level&nbsp;3 at all.  Its
   * presence is considered a misfeature in earlier definitions of SBML
   * because its implications for the mathematics of a model were never
   * defined, and in any case, no known modeling system ever used it.
   * Instead, models take account of charge values directly in their
   * definitions of species by (for example) having separate species
   * identities for the charged and uncharged versions of the same species.
   * This allows the condition to affect model mathematics directly.
   * LibSBML retains this method for easier compatibility with SBML
   * Level&nbsp;1.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * </ul>
   */ public
 int setCharge(int value) {
    return libsbmlJNI.Species_setCharge(swigCPtr, this, value);
  }

  
/**
   * Sets the 'constant' attribute of this {@link Species} object.
   * <p>
   * @param value a boolean value for the 'constant' attribute
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * </ul>
   * <p>
   * @note The attribute 'constant' is only available in SBML Levels&nbsp;2
   * and&nbsp;3.  It does not exist on {@link Species} in Level&nbsp;1.
   */ public
 int setConstant(boolean value) {
    return libsbmlJNI.Species_setConstant(swigCPtr, this, value);
  }

  
/**
   * Sets the value of the 'conversionFactor' attribute of this {@link Species} object.
   * <p>
   * The string in <code>sid</code> is copied.
   * <p>
   * @param sid the new conversionFactor for the {@link Species}
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * </ul>
   * <p>
   * @note The 'conversionFactor' attribute was introduced in SBML
   * Level&nbsp;3.  It does not exist on {@link Species} in SBML Levels&nbsp;1
   * and&nbsp;2.
   */ public
 int setConversionFactor(String sid) {
    return libsbmlJNI.Species_setConversionFactor(swigCPtr, this, sid);
  }

  
/**
   * Unsets the value of the 'name' attribute of this {@link Species} object.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */ public
 int unsetName() {
    return libsbmlJNI.Species_unsetName(swigCPtr, this);
  }

  
/**
   * Unsets the 'speciesType' attribute value of this {@link Species} object.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * @note The attribute 'speciesType' is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   */ public
 int unsetSpeciesType() {
    return libsbmlJNI.Species_unsetSpeciesType(swigCPtr, this);
  }

  
/**
   * Unsets the 'initialAmount' attribute value of this {@link Species} object.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */ public
 int unsetInitialAmount() {
    return libsbmlJNI.Species_unsetInitialAmount(swigCPtr, this);
  }

  
/**
   * Unsets the 'initialConcentration' attribute value of this {@link Species} object.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * @note The attribute 'initialConcentration' is only available in SBML
   * Level&nbsp;2 and&nbsp;3.  It does not exist on {@link Species} in Level&nbsp;1.
   */ public
 int unsetInitialConcentration() {
    return libsbmlJNI.Species_unsetInitialConcentration(swigCPtr, this);
  }

  
/**
   * Unsets the 'substanceUnits' attribute value of this {@link Species} object.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */ public
 int unsetSubstanceUnits() {
    return libsbmlJNI.Species_unsetSubstanceUnits(swigCPtr, this);
  }

  
/**
   * Unsets the 'spatialSizeUnits' attribute value of this {@link Species} object.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * @warning In versions of SBML Level~2 before Version&nbsp;3, the class
   * {@link Species} included an attribute called 'spatialSizeUnits', which allowed
   * explicitly setting the units of size for initial concentration.  This
   * attribute was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML
   * retains this attribute for compatibility with older definitions of
   * Level&nbsp;2, but its use is strongly discouraged because it is
   * incompatible with Level&nbsp;2 Version&nbsp;3 and Level&nbsp;2 Version&nbsp;4.
   */ public
 int unsetSpatialSizeUnits() {
    return libsbmlJNI.Species_unsetSpatialSizeUnits(swigCPtr, this);
  }

  
/**
   * Unsets the 'units' attribute value of this {@link Species} object.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */ public
 int unsetUnits() {
    return libsbmlJNI.Species_unsetUnits(swigCPtr, this);
  }

  
/**
   * Unsets the 'charge' attribute
   * value of this {@link Species} object.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * @note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the 'charge'
   * attribute on {@link Species} in SBML is deprecated and its use strongly
   * discouraged, and it does not exist in SBML Level&nbsp;3 at all.  Its
   * presence is considered a misfeature in earlier definitions of SBML
   * because its implications for the mathematics of a model were never
   * defined, and in any case, no known modeling system ever used it.
   * Instead, models take account of charge values directly in their
   * definitions of species by (for example) having separate species
   * identities for the charged and uncharged versions of the same species.
   * This allows the condition to affect model mathematics directly.
   * LibSBML retains this method for easier compatibility with SBML
   * Level&nbsp;1.
   */ public
 int unsetCharge() {
    return libsbmlJNI.Species_unsetCharge(swigCPtr, this);
  }

  
/**
   * Unsets the 'conversionFactor' attribute value of this {@link Species} object.
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * @note The 'conversionFactor' attribute was introduced in SBML
   * Level&nbsp;3.  It does not exist on {@link Species} in SBML Levels&nbsp;1
   * and&nbsp;2.
   */ public
 int unsetConversionFactor() {
    return libsbmlJNI.Species_unsetConversionFactor(swigCPtr, this);
  }

  
/**
   * Constructs and returns a {@link UnitDefinition} that corresponds to the units
   * of this {@link Species}' amount or concentration.
   * <p>
   * {@link Species} in SBML have an attribute ('substanceUnits') for declaring the
   * units of measurement intended for the species' amount or concentration
   * (depending on which one applies).  In the absence of a value given for
   * 'substanceUnits', the units are taken from the enclosing {@link Model}'s
   * definition of <code>'substance'</code> or <code>'substance'</code>/<em>(size of the
   * compartment)</em> in which the species is located, or finally, if
   * these are not redefined by the {@link Model}, the relevant SBML default units
   * for those quantities.  Following that procedure, the method
   * {@link Species#getDerivedUnitDefinition()}
   * returns a {@link UnitDefinition} based on the
   * interpreted units of this species's amount or concentration.
   * <p>
   * Note that the functionality that facilitates unit analysis depends 
   * on the model as a whole.  Thus, in cases where the object has not 
   * been added to a model or the model itself is incomplete,
   * unit analysis is not possible and this method will return <code>null.</code>
   * <p>
   * Note also that unit declarations for {@link Species} are in terms of the 
   * <em>identifier</em> of a unit, but this method returns a {@link UnitDefinition} object,
   * not a unit identifier.  It does this by constructing an appropriate
   * {@link UnitDefinition}.  Callers may find this particularly useful when used
   * in conjunction with the helper methods on {@link UnitDefinition} for comparing
   * different {@link UnitDefinition} objects.
   * <p>
   * In SBML Level&nbsp;2 specifications prior to Version&nbsp;3, {@link Species}
   * includes an additional attribute named 'spatialSizeUnits', which
   * allows explicitly setting the units of size for initial concentration.
   * The {@link Species#getDerivedUnitDefinition()}
   * takes this into account for models
   * expressed in SBML Level&nbsp;2 Versions&nbsp;1 and&nbsp;2.
   * <p>
   * @return a {@link UnitDefinition} that expresses the units of this 
   * {@link Species}, or <code>null</code> if one cannot be constructed.
   * <p>
   * @see #getSubstanceUnits()
   */ public
 UnitDefinition getDerivedUnitDefinition() {
    long cPtr = libsbmlJNI.Species_getDerivedUnitDefinition__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, false);
  }

  
/**
   * Returns the libSBML type code for this SBML object.
   * <p>
   * LibSBML attaches an identifying code to every
   * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
   * other languages, the set of type codes is stored in an enumeration; in
   * the Java language interface for libSBML, the type codes are defined as
   * static integer constants in the interface class {@link
   * libsbmlConstants}.  The names of the type codes all begin with the
   * characters <code>SBML_.</code> 
   * <p>
   * @return the SBML type code for this object, or {@link  libsbmlConstants#SBML_UNKNOWN SBML_UNKNOWN} (default).
   * <p>
   * @see #getElementName()
   */ public
 int getTypeCode() {
    return libsbmlJNI.Species_getTypeCode(swigCPtr, this);
  }

  
/**
   * Returns the XML element name of this object, which for {@link Species}, is
   * always <code>'species'.</code>
   * <p>
   * @return the name of this element, i.e., <code>'species'.</code>
   */ public
 String getElementName() {
    return libsbmlJNI.Species_getElementName(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if
   * all the required attributes for this {@link Species} object
   * have been set.
   * <p>
   * @note The required attributes for a {@link Species} object are:
   * <ul>
   * <li> 'id' (or 'name' in SBML Level&nbsp;1)
   * <li> 'compartment'
   * <li> 'initialAmount' (required in SBML Level&nbsp;1 only; optional otherwise)
   * <li> 'hasOnlySubstanceUnits' (required in SBML Level&nbsp;3; optional in SBML Level&nbsp;2)
   * <li> 'boundaryCondition' (required in SBML Level&nbsp;3; optional in Levels&nbsp;1 and&nbsp;2)
   * <li> 'constant' (required in SBML Level&nbsp;3; optional in SBML Level&nbsp;2)
   * </ul>
   * <p>
   * @return a boolean value indicating whether all the required
   * attributes for this object have been defined.
   */ public
 boolean hasRequiredAttributes() {
    return libsbmlJNI.Species_hasRequiredAttributes(swigCPtr, this);
  }

  
/**
   * Renames all the SIdRef attributes on this element, including any found in MathML
   */ public
 void renameSIdRefs(String oldid, String newid) {
    libsbmlJNI.Species_renameSIdRefs(swigCPtr, this, oldid, newid);
  }

  
/**
   * Renames all the UnitSIdRef attributes on this element
   */ public
 void renameUnitSIdRefs(String oldid, String newid) {
    libsbmlJNI.Species_renameUnitSIdRefs(swigCPtr, this, oldid, newid);
  }

}
