/* Copyright (C) 2005 Red Hat, Inc. */

#ifndef _SEMANAGE_USER_RECORD_H_
#define _SEMANAGE_USER_RECORD_H_

#include <stddef.h>
#include <semanage/handle.h>

#ifndef _SEMANAGE_USER_DEFINED_
struct semanage_user;
struct semanage_user_key;
typedef struct semanage_user semanage_user_t;
typedef struct semanage_user_key semanage_user_key_t;
#define _SEMANAGE_USER_DEFINED_
#endif

/* Key */
extern int semanage_user_key_create(
	semanage_handle_t* handle,
	const char* name, 
	semanage_user_key_t** key);

extern int semanage_user_key_extract(
	semanage_handle_t* handle,
	semanage_user_t* user, 
	semanage_user_key_t** key);

extern void semanage_user_key_free(
	semanage_user_key_t* key);

extern int semanage_user_compare(
	semanage_user_t* user, 
	semanage_user_key_t* key);
	
/* Name */
extern const char* semanage_user_get_name(
	semanage_user_t* user);

extern int semanage_user_set_name(
	semanage_handle_t* handle,
	semanage_user_t* user, 
	const char* name);

/* MLS */
extern const char* semanage_user_get_mlslevel(
	semanage_user_t* user);

extern int semanage_user_set_mlslevel(
	semanage_handle_t* handle,
	semanage_user_t* user, 
	const char* mls_level);

extern const char* semanage_user_get_mlsrange(
	semanage_user_t* user);

extern int semanage_user_set_mlsrange(
	semanage_handle_t* handle,
	semanage_user_t* user, 
	const char* mls_range);

/* Role management */
extern int semanage_user_get_num_roles(
	semanage_user_t* user);

extern int semanage_user_add_role(
	semanage_handle_t* handle,
	semanage_user_t* user, 
	const char* role);

extern void semanage_user_del_role(
	semanage_user_t* user, 
	const char* role);

extern int semanage_user_has_role(
	semanage_user_t* user, 
	const char* role);

extern int semanage_user_get_roles(
	semanage_handle_t* handle,
	semanage_user_t* user,
	const char*** roles_arr, 
	size_t* num_roles);

extern int semanage_user_set_roles(
	semanage_handle_t* handle,
	semanage_user_t* user,
	const char** roles_arr,
	size_t num_roles);

/* Create/Clone/Destroy */
extern int semanage_user_create(
	semanage_handle_t* handle,
	semanage_user_t** user_ptr);

extern int semanage_user_clone(
	semanage_handle_t* handle,
	semanage_user_t* user, 
	semanage_user_t** user_ptr);

extern void semanage_user_free(
	semanage_user_t* user);
#endif
