/* Copyright (C) 2005 Red Hat, Inc. */

#include <sepol/boolean_record.h>

typedef sepol_bool_t semanage_bool_t;
typedef sepol_bool_key_t semanage_bool_key_t;

#define _SEMANAGE_BOOL_DEFINED_
#include "boolean_internal.h"

typedef semanage_bool_t record_t;
typedef semanage_bool_key_t record_key_t;
#define DBASE_RECORD_DEFINED

#include "handle.h"
#include "database.h"

/* Key */
int semanage_bool_key_create(
	semanage_handle_t* handle,
	const char* name, 
	semanage_bool_key_t** key) {

	return sepol_bool_key_create(handle->sepolh, name, key);
}

int semanage_bool_key_extract(
	semanage_handle_t* handle,
	semanage_bool_t* boolean, 
	semanage_bool_key_t** key) {

	return sepol_bool_key_extract(handle->sepolh, boolean, key);
}
hidden_def(semanage_bool_key_extract)

void semanage_bool_key_free(semanage_bool_key_t* key) {
	sepol_bool_key_free(key);
}
hidden_def(semanage_bool_key_free)

int semanage_bool_compare(
	semanage_bool_t* boolean, 
	semanage_bool_key_t* key) {

	return sepol_bool_compare(boolean, key);
}
hidden_def(semanage_bool_compare)
	
/* Name */
const char* semanage_bool_get_name(
	semanage_bool_t* boolean) {

	return sepol_bool_get_name(boolean);
}
hidden_def(semanage_bool_get_name)

int semanage_bool_set_name(
	semanage_handle_t* handle,
	semanage_bool_t* boolean, 
	const char* name) {

	return sepol_bool_set_name(handle->sepolh, boolean, name);
}
hidden_def(semanage_bool_set_name)

/* Value */
int semanage_bool_get_value(
	semanage_bool_t* boolean) {

	return sepol_bool_get_value(boolean);
}
hidden_def(semanage_bool_get_value)

void semanage_bool_set_value(
	semanage_bool_t* boolean, 
	int value) {

	sepol_bool_set_value(boolean, value);
}
hidden_def(semanage_bool_set_value)

/* Create/Clone/Destroy */
int semanage_bool_create(
	semanage_handle_t* handle,
	semanage_bool_t** bool_ptr) {

	return sepol_bool_create(handle->sepolh, bool_ptr);
}
hidden_def(semanage_bool_create)

int semanage_bool_clone(
	semanage_handle_t* handle,
	semanage_bool_t* boolean, 
	semanage_bool_t** bool_ptr) {

	return sepol_bool_clone(handle->sepolh, boolean, bool_ptr);
}
hidden_def(semanage_bool_clone)

void semanage_bool_free(
	semanage_bool_t* boolean) {

	sepol_bool_free(boolean);
}
hidden_def(semanage_bool_free)

/* Record base functions */
record_table_t SEMANAGE_BOOL_RTABLE = {
	.create      = semanage_bool_create,
	.key_extract = semanage_bool_key_extract,
	.key_free    = semanage_bool_key_free,
	.clone       = semanage_bool_clone,
	.compare     = semanage_bool_compare,
	.free        = semanage_bool_free,
};
